/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.gui;

import com.elluminate.gui.AccessibilityUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.swing.JComponent;

public class AccessibilityUtil {
    public void setComponentHelperInfo(JComponent item, String text) {
        AccessibilityUtils.setComponentHelperInfo(item, text);
    }

    public void copyAccessibleInfo(Accessible src, Accessible[] dest) {
        AccessibilityUtils.copyAccessibleInfo(src, dest);
    }

    public void copyAccessibleInfo(Accessible src, Accessible dest) {
        AccessibilityUtils.copyAccessibleInfo(src, dest);
    }

    public void initComponent(JComponent item) {
        AccessibilityUtils.initComponent(item);
    }

    public String getComponentInfo(JComponent item) {
        return AccessibilityUtils.getComponentInfo(item);
    }

    public void setAccessibleInfo(Object accessibleObj, String accessibleName, String accessibleDescription) {
        AccessibilityUtils.setAccessibleInfo(accessibleObj, accessibleName, accessibleDescription);
    }

    public void setAccessibleName(Object accessibleObj, String accessibleName) {
        this.setAccessibleName(new Object[]{accessibleObj}, accessibleName);
    }

    public void setAccessibleDescription(Object accessibleObj, String accessibleDescription) {
        this.setAccessibleDescription(new Object[]{accessibleObj}, accessibleDescription);
    }

    public void setAccessibleInfo(Object[] accessibleObj, String accessibleName, String accessibleDescription) {
        AccessibilityUtils.setAccessibleInfo(accessibleObj, accessibleName, accessibleDescription);
    }

    public void setAccessibleName(Object[] accessibleObj, String accessibleName) {
        AccessibilityUtils.setAccessibleName(accessibleObj, accessibleName);
    }

    public void setAccessibleDescription(Object[] accessibleObj, String accessibleDescription) {
        AccessibilityUtils.setAccessibleDescription(accessibleObj, accessibleDescription);
    }

    public Method resolveMethod(Class c, String name, Class[] argSigs) {
        return AccessibilityUtils.resolveMethod(c, name, argSigs);
    }

    public Method resolveMethod(Class c, String name) {
        return AccessibilityUtils.resolveMethod(c, name);
    }

    public Method resolveMethod(Object o, String name, Class[] argSigs) {
        return AccessibilityUtils.resolveMethod(o, name, argSigs);
    }

    public Method resolveMethod(Object o, String name) {
        return AccessibilityUtils.resolveMethod(o, name);
    }

    public Object invokeMethod(Object o, Method method, Object[] args) throws Exception {
        return AccessibilityUtils.invokeMethod(o, method, args);
    }

    public Object invokeMethod(Object o, Method method) throws Exception {
        return AccessibilityUtils.invokeMethod(o, method);
    }

    public void setAccessibleValues(Accessible accessibleObject, AccessibilityUtils.AccessibleValues values) {
        AccessibilityUtils.setAccessibleValues(accessibleObject, values);
    }

    public Accessible setLabelRelationship(Accessible label, Accessible target) {
        return AccessibilityUtils.setLabelRelationship(label, target);
    }

    public Accessible setMemberRelationship(Accessible group, Accessible member) {
        return AccessibilityUtils.setMemberRelationship(group, new Accessible[]{member});
    }

    public Accessible setMemberRelationship(Accessible group, Accessible[] members) {
        return this.setMemberRelationship(group, Arrays.asList(members));
    }

    public Accessible setMemberRelationship(Accessible group, Collection members) {
        for (Accessible a : members) {
            AccessibleContext ac = a.getAccessibleContext();
            if (ac == null) {
                throw new NullPointerException("AccessibleContext cannot be null on an Accessible object " + this.formatClassToken(a));
            }
            AccessibleRelationSet ars = ac.getAccessibleRelationSet();
            AccessibleRelation ar = new AccessibleRelation(AccessibleRelation.MEMBER_OF, group);
            ars.add(ar);
        }
        return group;
    }

    public String formatClassToken(Object o) {
        if (o == null) {
            return "null";
        }
        String name = o instanceof Component ? ((Component)o).getName() : "?";
        return o.getClass().getName() + ":" + Integer.toHexString(o.hashCode()).toUpperCase() + "-" + name;
    }
}

