/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.xml;

import java.util.regex.Pattern;
import org.jdom.Verifier;

public class XMLUtils {
    public static String escapeXMLUnicode(String orig) {
        if (orig == null) {
            return orig;
        }
        StringBuffer reply = new StringBuffer();
        for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            if (Verifier.isXMLCharacter((int)c)) {
                reply.append(c);
                continue;
            }
            reply.append("&#");
            reply.append(Integer.toString(c) + ";");
        }
        return reply.toString();
    }

    public static String unescapeXMLUnicode(String orig) {
        if (orig == null) {
            return orig;
        }
        StringBuffer buf = new StringBuffer();
        String separator = XMLUtils.chooseSeparator(orig);
        for (String part : orig.replaceAll("&#", separator + "&#").split(Pattern.quote(separator))) {
            int idx = part.indexOf(";");
            if (idx != -1) {
                String candidate = part.substring(2, idx);
                String remains = part.substring(idx + 1);
                int replaceValue = -1;
                try {
                    replaceValue = Integer.parseInt(candidate);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (replaceValue == -1) {
                    buf.append(part);
                    continue;
                }
                buf.append((char)replaceValue + remains);
                continue;
            }
            buf.append(part);
        }
        return buf.toString();
    }

    private static String chooseSeparator(String orig) {
        String[] potentials;
        for (String sep : potentials = new String[]{"^", "~", "#", "^~", "^#", "~#", "~^", "#^", "#~", "~~", "^^", "##"}) {
            if (orig.contains(sep)) continue;
            return sep;
        }
        throw new IllegalArgumentException("Could not find a separator to use with this document");
    }
}

