/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.CompatibleFont;
import com.elluminate.groupware.whiteboard.WhiteboardConfig;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.ToolColor;
import com.elluminate.groupware.whiteboard.attributes.ToolFont;
import com.elluminate.groupware.whiteboard.attributes.ToolText;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.WBClipboardInterface;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.tools.TextUIInterface;
import com.elluminate.groupware.whiteboard.tools.ToolDefinitions;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.gui.ModalDialog;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.net.VClassURI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

public class TextToolModel
extends AbstractToolModel
implements Cloneable {
    static final String WBD_NAME = "TextTool";
    static final String TEXT_UI_CLASS = "com.elluminate.groupware.whiteboard.module.ui.TextUI";
    protected ToolFont font = null;
    protected ToolText toolText = null;
    protected boolean sizeFontContext = false;
    protected float ascent = 0.0f;
    private boolean locationSet = false;
    private int stringIndx = 0;
    private boolean ascentMovesLocation = false;
    private boolean isURI = false;
    private String uri = "";
    private boolean testedURI = false;
    private String pasteRemainder = null;
    private int continuedResponse = 2;
    private boolean shiftDown = false;
    private boolean controlDown = false;
    private Color preUriColor = ToolDefinitions.COLOR_DEFAULT;
    private Point newLocation = null;
    private AttributedString composedTextString = null;
    private AttributedCharacterIterator composedText = null;
    private String exploreScreenName = null;
    private static final AttributedCharacterIterator.Attribute[] IM_ATTRIBUTES = new AttributedCharacterIterator.Attribute[]{TextAttribute.INPUT_METHOD_HIGHLIGHT};

    public TextToolModel(WhiteboardContext context) {
        this(context, WBD_NAME);
    }

    public TextToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.toolRect.setOptional(true);
        this.font = new ToolFont(context, "FONT", "Serif", 0, 18, false);
        this.toolText = new ToolText(context, "TEXT");
        this.stroke.setOptional(true);
        this.stroke.setPanelKey(null);
        this.font.setAlternateName("ToolFont");
        this.font.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_FONT));
        this.font.setPanelKey("textProperties");
        this.color.setAlternateName("textcolor");
        this.color.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_TEXTCOLOR));
        this.color.setPanelKey("textProperties");
        this.color.setQuickAttribute(true);
        this.font.setQuickAttribute(true);
        this.registerIfClass("TextToolModel");
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        this.addAttribute(this.font);
        this.addAttribute(this.toolText);
    }

    public TextToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"JDOM constructor", (Throwable)ex, (boolean)true);
        }
    }

    public TextToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"stream constructor", (Throwable)ex, (boolean)true);
        }
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        try {
            return (TextToolModel)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
            return new TextToolModel(this.context);
        }
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        StringBuffer toolText = new StringBuffer();
        TextToolModel newTool = null;
        TextToolModel oldTool = (TextToolModel)ancestor;
        try {
            newTool = (TextToolModel)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            newTool = new TextToolModel(this.context);
        }
        newTool.uiData = null;
        newTool.toolUI = null;
        newTool.getUI();
        newTool.pasteResponse(oldTool.pasteRemainder, toolText, 0);
        oldTool.pasteRemainder = null;
        newTool.setText(toolText.toString());
        newTool.ascentMovesLocation = false;
        if (oldTool.newLocation != null) {
            newTool.setLocation(oldTool.newLocation.x, oldTool.newLocation.y);
        } else {
            newTool.setLocation(oldTool.getLocation().getX(), oldTool.getLocation().getY() + (double)oldTool.getAscent());
        }
        newTool.setSize(0.0, oldTool.getSize().getHeight());
        newTool.setAscent(oldTool.getAscent(), false);
        newTool.locationSet = true;
        newTool.setCreating(true);
        newTool.setUIInvalid(true);
        newTool.evaluateBounds();
        newTool.repaintBounds();
        return newTool;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TextToolModel textToolModel = (TextToolModel)super.clone();
        textToolModel.font = (ToolFont)this.font.clone();
        textToolModel.toolText = (ToolText)this.toolText.clone();
        textToolModel.registerIfClass("TextToolModel");
        return textToolModel;
    }

    @Override
    public boolean createOnlyToScreen() {
        return false;
    }

    @Override
    public boolean canSizeTool() {
        return false;
    }

    @Override
    public boolean isInitialized() {
        return this.getCommittedText() != null && this.getCommittedText().length() > 0;
    }

    public boolean isURI() {
        if (!(this.isURI || this.testedURI || this.isCreating())) {
            try {
                VClassURI uri = new VClassURI(this.getDisplayText());
                this.setIsURI(uri.isHostValid());
                this.uri = uri.toString();
            }
            catch (Exception ex) {
                this.setIsURI(false);
            }
            this.testedURI = true;
        }
        return this.isURI;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public int creationMouseEvent(MouseEvent e) {
        int response = 0;
        switch (e.getID()) {
            case 501: {
                this.context.getController().endComposition();
                this.setUIInvalid(true);
                break;
            }
            case 502: {
                if (!this.locationSet) {
                    this.getUI();
                    this.repaintBounds();
                    this.ascentMovesLocation = (double)this.getAscent() == 0.0;
                    this.setLocation(e.getX(), (float)e.getY() - this.getAscent());
                    this.locationSet = true;
                    this.setCreating(true);
                    this.repaintBounds();
                    break;
                }
                if (!this.getVBounds().contains(e.getX(), e.getY())) {
                    response = 2;
                    this.newLocation = new Point(e.getX(), (int)((float)e.getY() - this.getAscent()));
                    break;
                }
                this.setTextCursor((int)((double)e.getX() - this.getLocation().getX()), (int)((double)e.getY() - this.getLocation().getY()));
                break;
            }
        }
        return response;
    }

    public void repaintBounds() {
        this.setUIInvalid(true);
        this.context.getController().repaint(this.getVBounds().x - 3, this.getVBounds().y - 2, this.getVBounds().width + 8, this.getVBounds().height + 6);
    }

    @Override
    public void notifyVisibleChange() {
        super.notifyVisibleChange();
        if (this.isConferenceNode() && this.context.getController() != null && this.context.getController().getScreen() == this.getScreenParent()) {
            this.repaintBounds();
        }
    }

    @Override
    public Cursor getCursor() {
        if (this.wantKeyboard) {
            return Cursor.getPredefinedCursor(2);
        }
        return null;
    }

    @Override
    public Cursor getBehaviourCursor(MouseEvent e) {
        if ((e == null || !e.isShiftDown() && !e.isControlDown()) && this.isURI() && !this.isEditing()) {
            return Cursor.getPredefinedCursor(12);
        }
        return null;
    }

    @Override
    public boolean wantsMouse(MouseEvent e) {
        if (e == null) {
            return this.isURI() && !this.shiftDown && !this.controlDown;
        }
        return this.isURI() && !e.isShiftDown() && !e.isControlDown();
    }

    public void startEditing() {
        super.setEditing(this.editing);
        this.setTextCursor(this.visibleBounds.width / 2, 0);
        if (this.context.getController() != null) {
            this.context.getController().setKeyboardTool(this);
        }
    }

    @Override
    public int receivedClick(MouseEvent e) {
        if (!this.isEditing() && this.isURI && !e.isControlDown() && !e.isShiftDown() && e.getID() == 502 && e.getClickCount() == 1) {
            return 0;
        }
        if (e.getClickCount() >= 2) {
            this.setTextCursor(e);
            e.consume();
            return 5;
        }
        return 0;
    }

    private void setTextCursor(MouseEvent e) {
        this.setTextCursor(e.getX(), e.getY());
        e.consume();
    }

    private void setTextCursor(int xOffset, int yOffset) {
        this.wantKeyboard = true;
        this.wantMouse = true;
        this.setCreating(true);
        this.setIsURI(false);
        this.testedURI = false;
        if (this.getCommittedText() != null) {
            this.stringIndx = ((TextUIInterface)((Object)this.getUI())).getTextIndex(this, xOffset, yOffset);
        }
        this.repaintBounds();
    }

    @Override
    public void mouseEvent(MouseEvent e, Component component) {
        this.shiftDown = e.isShiftDown();
        this.controlDown = e.isControlDown();
        if (this.isCreating() && this.getCommittedText() != null) {
            if (e.getID() == 502) {
                this.setTextCursor(e);
                e.consume();
            }
        } else if (!this.isEditing() && this.isURI && !e.isControlDown() && !e.isShiftDown() && e.getID() == 502 && e.getClickCount() == 1) {
            try {
                BrowserUtil.gotoURL((String)this.uri);
                e.consume();
                return;
            }
            catch (IOException ex1) {
                this.setIsURI(false);
            }
        } else if (e.getID() == 501 && !e.isShiftDown() && !e.isControlDown()) {
            e.consume();
        }
    }

    private void setIsURI(boolean isURI) {
        if (isURI != this.isURI) {
            if (isURI) {
                this.setSelectionRectangleColor(Color.blue);
                this.font.setUnderline(true);
                this.getFont().setUnderline(true);
                this.preUriColor = (Color)this.color.getColor();
                this.color.setColor(WhiteboardConfig.URI_COLOR.getRGB(), 255);
            } else {
                this.setSelectionRectangleColor(Color.black);
                this.font.setUnderline(false);
                this.getFont().setUnderline(false);
                this.color.setColor(this.preUriColor);
            }
            this.isURI = isURI;
            this.setUIInvalid(true);
            this.notifyVisibleChange();
        }
    }

    @Override
    public void quiesceTool() {
        if (this.context.getController() != null) {
            this.context.getController().endComposition();
        }
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.isCreating()) {
            this.endCreating();
            this.repaintBounds();
        }
    }

    @Override
    public int keyEvent(KeyEvent e, Component componeent) {
        this.setIsURI(false);
        this.testedURI = false;
        if (this.getCommittedText() != null && this.stringIndx <= this.getCommittedText().length() && this.creationKeyEvent(e, true) == 0) {
            this.repaintBounds();
            return 0;
        }
        this.endCreating();
        this.repaintBounds();
        return 4;
    }

    @Override
    public int creationKeyEvent(KeyEvent e) {
        return this.creationKeyEvent(e, false);
    }

    public int creationKeyEvent(KeyEvent e, boolean pasteSingleLine) {
        boolean consume = true;
        StringBuffer toolText = new StringBuffer(this.getCommittedText());
        int response = 0;
        this.repaintBounds();
        if (!this.locationSet) {
            return response;
        }
        WBClipboardInterface clipboard = this.context.getWBClipboard();
        this.setUIInvalid(true);
        switch (e.getID()) {
            case 400: {
                switch (e.getKeyChar()) {
                    case '\b': {
                        String localString = new String(toolText).substring(this.stringIndx, this.getCommittedText().length());
                        this.stringIndx = Math.max(this.stringIndx - 1, 0);
                        toolText.setLength(this.stringIndx);
                        toolText.append(localString);
                        break;
                    }
                    case '\u007f': {
                        break;
                    }
                    default: {
                        if ((e.getModifiers() & 0xE) != 0) break;
                        if (this.stringIndx >= toolText.length()) {
                            toolText.append(e.getKeyChar());
                            this.stringIndx = toolText.length();
                            break;
                        }
                        toolText.insert(this.stringIndx, e.getKeyChar());
                        ++this.stringIndx;
                    }
                }
                this.setText(toolText.toString());
                break;
            }
            case 401: {
                if ((e.getModifiers() & 8) != 0) break;
                switch (e.getKeyCode()) {
                    case 127: {
                        String localString = this.stringIndx < toolText.length() ? new String(toolText).substring(this.stringIndx + 1, toolText.length()) : "";
                        toolText.setLength(this.stringIndx);
                        toolText.append(localString);
                        break;
                    }
                    case 35: {
                        this.stringIndx = toolText.length();
                        break;
                    }
                    case 36: {
                        this.stringIndx = 0;
                        break;
                    }
                    case 39: {
                        this.stringIndx = Math.min(this.stringIndx + 1, toolText.length());
                        break;
                    }
                    case 37: {
                        this.stringIndx = Math.max(this.stringIndx - 1, 0);
                        break;
                    }
                    case 67: {
                        if (clipboard == null || (e.getModifiers() & 6) == 0) break;
                        clipboard.pasteTextToClipboard(toolText.toString());
                        break;
                    }
                    case 88: {
                        if (clipboard == null || (e.getModifiers() & 6) == 0) break;
                        clipboard.pasteTextToClipboard(toolText.toString());
                        toolText = new StringBuffer();
                        this.stringIndx = 0;
                        break;
                    }
                    case 86: {
                        if (clipboard == null || (e.getModifiers() & 6) == 0 || !clipboard.clipboardHasText()) break;
                        if (pasteSingleLine && clipboard.clipboardHasMultiLineText()) {
                            ModalDialog.showMessageDialog((Component)this.context.getDialogParentFrame(), (Object)I18N.getString((PropertiesEnum)StringsProperties.TEXTTOOLMODEL_CANNOTPASTE), (String)I18N.getString((PropertiesEnum)StringsProperties.TEXTTOOLMODEL_CANNOTPASTETITLE), (int)0);
                            response = 3;
                            break;
                        }
                        response = this.pasteResponse(clipboard.getTextFromClipboard(), toolText, this.stringIndx);
                        break;
                    }
                    default: {
                        consume = false;
                        if ((e.getModifiers() & 0xE) == 0) break;
                        return response;
                    }
                }
                this.setUIInvalid(true);
                this.setText(toolText.toString());
                break;
            }
            case 402: {
                int ch = e.getKeyCode();
                if (ch == 8 || ch == 8 || ch == 36 || ch == 35 || ch == 33 || ch == 34 || ch == 127) {
                    consume = true;
                    this.setText(toolText.toString());
                    break;
                }
                if (ch == 10 || ch == 13) {
                    response = 2;
                    this.endCreating();
                    break;
                }
            }
            default: {
                consume = false;
            }
        }
        this.repaintBounds();
        if (consume) {
            e.consume();
        }
        return response;
    }

    private int pasteResponse(String textToPaste, StringBuffer toolText, int stringIndx) {
        int response;
        int pasteResponse = 2;
        this.pasteRemainder = null;
        String suffix = "";
        if (textToPaste == null) {
            return 0;
        }
        if (stringIndx < 0 || stringIndx > toolText.length()) {
            stringIndx = toolText.length();
        }
        if (stringIndx < toolText.length() - 1 && toolText.length() > 0) {
            suffix = toolText.toString().substring(stringIndx);
            toolText.setLength(stringIndx);
            textToPaste = textToPaste + suffix;
        }
        if (textToPaste != null && textToPaste.length() > 0) {
            this.continuedResponse = 8;
            int newline = textToPaste.indexOf("\n");
            if (newline < 0) {
                toolText.append(textToPaste);
                pasteResponse = 0;
                this.stringIndx = toolText.length() - suffix.length();
            } else {
                toolText.append(textToPaste.substring(0, newline));
                if (newline < textToPaste.length()) {
                    this.pasteRemainder = textToPaste.substring(newline + 1);
                    if ("".equals(this.pasteRemainder)) {
                        this.pasteRemainder = null;
                    }
                }
                this.stringIndx = toolText.length();
            }
        } else {
            this.continuedResponse = 2;
            this.stringIndx = toolText.length();
        }
        int n = response = this.pasteRemainder == null || this.pasteRemainder.length() == 0 ? pasteResponse : 8;
        if (pasteResponse != 0) {
            this.endCreating();
        }
        return response;
    }

    @Override
    public int continuedResponse() {
        return this.continuedResponse;
    }

    @Override
    public void endCreating() {
        super.endCreating();
        this.wantKeyboard = false;
        this.wantMouse = false;
        this.setCreating(false);
        this.repaintBounds();
    }

    public int getStringIndx() {
        return this.stringIndx;
    }

    @Override
    public AbstractUI getUI() {
        if (this.toolUI == null && this.context.getController() != null) {
            this.toolUI = this.toolUIFactory(TEXT_UI_CLASS);
        }
        return this.toolUI;
    }

    @Override
    public Cursor getDrawingCursor() {
        return super.getCursor();
    }

    @Override
    public void delete() {
        this.font = null;
        this.toolText = null;
        super.delete();
    }

    @Override
    public String getDisplayName() {
        if (this.exploreScreenName == null) {
            this.exploreScreenName = I18N.getString((PropertiesEnum)StringsProperties.TEXTTOOL_EXPLORESCREENNAME);
        }
        if (this.getDisplayText() == null) {
            this.setDisplayName(this.exploreScreenName);
        } else {
            String str = this.exploreScreenName + ":" + this.getDisplayText();
            str = str.substring(0, Math.min(40, str.length()));
            this.setDisplayName(str);
        }
        return super.getDisplayName();
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.locationSet = true;
        this.sizeFontContext = true;
        return this;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        return super.streamToString(istr) + ", " + this.toolText.streamToString(istr);
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        super.elementToObject(element, progress);
        WBElement textElement = (WBElement)element.getChild("Text");
        if (textElement == null) {
            textElement = (WBElement)element.getChild("TEXT");
        }
        if (textElement != null) {
            if (textElement.getAttribute("X") != null) {
                try {
                    this.setLocation(textElement.getAttribute("X").getDoubleValue(), textElement.getAttribute("Y").getDoubleValue());
                }
                catch (Exception e) {
                    throw new Exception(this.getName() + " Invalid digits in X or Y: " + e.getMessage());
                }
            }
            this.evaluateBounds();
        } else {
            LogSupport.error((String)"Null Text in objectToElement.");
        }
        this.locationSet = true;
        return this;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement element = new WBElement(this.getName());
        super.objectToElement(element, progress);
        return element;
    }

    @Override
    public void render(Graphics g) {
        this.isURI();
        ((TextUIInterface)((Object)this.getUI())).draw(g, this);
        if (this.sizeFontContext) {
            this.evaluateBounds();
            this.sizeFontContext = false;
            this.notifyVisibleChange();
        }
    }

    @Override
    public ToolColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(Object color) {
        this.color.setColor(color);
        this.notifyVisibleChange();
    }

    public CompatibleFont getFont() {
        return this.font.getFont();
    }

    public String getDisplayText() {
        StringBuffer reply = new StringBuffer();
        if (this.toolText != null) {
            reply.append(this.toolText.getText());
        }
        if (this.composedText != null) {
            char c = this.composedText.first();
            while (c != '\uffff') {
                reply.append(c);
                c = this.composedText.next();
            }
        }
        return reply.toString();
    }

    public String getCommittedText() {
        return this.toolText == null ? null : this.toolText.getText();
    }

    public void setText(String text) {
        this.notifyVisibleChange();
        this.toolText.setText(text);
        this.setFontAttributes();
        this.notifySizingChange();
        this.testedURI = false;
    }

    private void setFontAttributes() {
    }

    @Override
    protected void evaluateBounds() {
        if (this.getBounds().width == 0 && this.getBounds().height == 0) {
            this.sizeFontContext = true;
        }
        if (this.context.getController() != null) {
            this.setBounds(((TextUIInterface)((Object)this.getUI())).evaluateBounds(this));
        }
        this.visibleBounds.x = Math.min(this.getBounds().x, this.getBounds().x + this.getBounds().width);
        this.visibleBounds.y = Math.min(this.getBounds().y, this.getBounds().y + this.getBounds().height);
        this.visibleBounds.width = Math.abs(this.getBounds().width);
        this.visibleBounds.height = Math.abs(this.getBounds().height);
    }

    public void setAscent(float ascent, boolean inUI) {
        this.ascent = ascent;
        if (this.ascentMovesLocation) {
            this.ascentMovesLocation = false;
            this.setUIInvalid(true);
            if (!inUI) {
                this.repaintBounds();
            }
            this.setLocation(this.getLocation().getX(), this.getLocation().getY() - (double)this.getAscent());
        }
        if (!inUI) {
            this.repaintBounds();
        }
    }

    public float getAscent() {
        return this.ascent;
    }

    @Override
    public int creationInputTextChanged(InputMethodEvent event) {
        StringBuffer committedText = new StringBuffer(this.toolText.getText());
        int response = 0;
        this.repaintBounds();
        if (!this.locationSet) {
            return response;
        }
        int committedCharacterCount = event.getCommittedCharacterCount();
        AttributedCharacterIterator text = event.getText();
        this.composedText = null;
        if (text != null) {
            int toCopy = committedCharacterCount;
            char c = text.first();
            while (toCopy-- > 0) {
                KeyEvent ke = new KeyEvent((Component)event.getSource(), 400, EventQueue.getMostRecentEventTime(), 0, 0, c);
                response = this.creationKeyEvent(ke);
                c = text.next();
            }
            if (text.getEndIndex() - (text.getBeginIndex() + committedCharacterCount) > 0) {
                this.composedTextString = new AttributedString(text, text.getBeginIndex() + committedCharacterCount, text.getEndIndex(), IM_ATTRIBUTES);
                this.composedTextString.addAttribute(TextAttribute.FONT, this.getFont());
                this.composedText = this.composedTextString.getIterator();
            }
        }
        this.stringIndx = this.getDisplayText().length();
        event.consume();
        this.setUIInvalid(true);
        this.repaintBounds();
        return response;
    }
}

