/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.ToolImageAlpha;
import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DDimension;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.AppSnapListener;
import com.elluminate.groupware.whiteboard.tools.ImageUIInterface;
import com.elluminate.groupware.whiteboard.tools.MarkableImage;
import com.elluminate.groupware.whiteboard.tools.PaletteImage;
import com.elluminate.groupware.whiteboard.tools.PaletteListener;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.ExternalDataBean;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import org.jdom.Attribute;

public class ImageToolModel
extends AbstractToolModel
implements Cloneable,
PaletteListener,
AppSnapListener {
    public static final String ACTION_FILE = "fromFile";
    public static final String ACTION_CLIP_ART = "fromClipArt";
    public static final String ACTION_SCREEN_CAPTURE = "fromScreenCapture";
    static final String WBD_NAME = "ImageTool";
    static final String IMAGE_UI_CLASS = "com.elluminate.groupware.whiteboard.module.ui.ImageUI";
    private static final I18n i18n = I18n.create((Object)new Object(){});
    private Image markerImage = i18n.getImage((PropertiesEnum)StringsProperties.IMAGETOOL_PLUSSIGN_ANNOTATION);
    protected ToolImageAlpha borderAlpha;
    protected WBImage image = null;

    public ImageToolModel(WhiteboardContext context) {
        this(context, WBD_NAME);
    }

    public ImageToolModel(WhiteboardContext context, String name) {
        super(context, name);
        this.toolNeedsInking = true;
        this.image = new WBImage(context);
        this.stroke.setPanelKey("imageProperties");
        this.stroke.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_IMAGEBORDER));
        this.stroke.setStroke(1.0f, 2, 2, 0.0f, null, 0.0f);
        this.color.setName("BorderColor");
        this.color.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_BORDERCOLOR));
        this.color.setPanelKey(null);
        this.borderAlpha = new ToolImageAlpha(context);
        this.borderAlpha.setDisplayName(I18N.getString((PropertiesEnum)StringsProperties.TOOL_BORDERTRANSPARENCY));
        this.borderAlpha.setPanelKey("imageProperties");
        this.hasFrame = false;
        this.registerIfClass("ImageToolModel");
    }

    public ImageToolModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"elementToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    public ImageToolModel(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"streamToObject constructor", (Throwable)ex, (boolean)true);
        }
    }

    public ImageToolModel(WhiteboardContext context, byte[] imageData, String fileName, String displayName, Rectangle area) {
        this(context);
        this.setTemplate(context);
        this.image.loadImage(imageData, fileName, displayName);
        this.setBounds(area);
        this.evaluateBounds();
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        ImageUIInterface ui = (ImageUIInterface)((Object)this.getUI());
        if (e == null) {
            try {
                return (ImageToolModel)this.clone(e.getActionCommand());
            }
            catch (Exception ex) {
                System.out.println("Unable to create a new ImageToolModel: " + ex);
                return null;
            }
        }
        String action = e.getActionCommand();
        WBImage image = action.equals(ACTION_SCREEN_CAPTURE) ? ui.postScreenCaptureDialog(this, screen) : (action.equals(ACTION_CLIP_ART) ? ui.postClipArtPalette(this, I18N.getString((PropertiesEnum)StringsProperties.IMAGETOOLMODEL_CLIPARTDIALOGTITLE), screen) : ui.postFileDialog(I18N.getString((PropertiesEnum)StringsProperties.IMAGETOOLMODEL_FILEDIALOGTITLE), I18N.getString((PropertiesEnum)StringsProperties.IMAGETOOLMODEL_FILEDIALOGBUTTON), screen));
        return this.getToolFromImage(image, e);
    }

    private ImageToolModel getToolFromImage(WBImage image, ActionEvent e) {
        ImageToolModel newTool = null;
        if (image != null && image.imageExists()) {
            try {
                if (image.isInBackground()) {
                    ActionUtilities.addBackgroundImage(image, this.context);
                    this.endCreating();
                    this.context.getController().setSelectMode();
                    return null;
                }
                newTool = (ImageToolModel)this.clone(e.getActionCommand());
                newTool.initialized = true;
                newTool.setImage(image);
            }
            catch (CloneNotSupportedException ex) {
                LogSupport.exception((Object)this, (String)"getToolFromImage", (Throwable)ex, (boolean)true);
                newTool = new ImageToolModel(this.context);
            }
            image.delete();
        }
        return newTool;
    }

    @Override
    public boolean isAsync(String action) {
        return ACTION_CLIP_ART.equals(action) || ACTION_SCREEN_CAPTURE.equals(action);
    }

    @Override
    public void captureImageProvided(WBImage image, ScreenModel screen) {
        if (this.asyncContext == null || this.asyncEvent == null) {
            throw new IllegalStateException("No async operation in progress");
        }
        if (image != null) {
            ActionEvent e = this.asyncEvent;
            ImageToolModel newTool = this.getToolFromImage(image, e);
            this.asyncContext.asyncToolFactoryCallback(screen, this.asyncEvent, newTool);
        }
    }

    @Override
    public void terminateCapture() {
        this.asyncContext = null;
        this.asyncEvent = null;
    }

    @Override
    public void paletteItemDragged() {
        Object oldStamp = this.context.getController().getStamp();
        MarkableImage oldMImage = (MarkableImage)oldStamp;
        if (oldMImage != null) {
            oldMImage.clearMark();
        }
        this.context.getController().setStamp(null);
    }

    @Override
    public void paletteItemSelected(WBImage image, boolean doubleClicked, Object stamp) {
        if (image != null && image.isInBackground() && doubleClicked) {
            if (image != null) {
                image.delete();
            }
            return;
        }
        ActionEvent e = this.asyncEvent;
        ImageToolModel newTool = this.getToolFromImage(image, e);
        if (newTool == null) {
            image.delete();
            return;
        }
        ScreenModel screen = this.context.getController().getScreen();
        Object oldStamp = this.context.getController().getStamp();
        boolean stampsMatch = stamp == oldStamp;
        boolean oldStampMode = this.context.getController().getStamp() != null;
        boolean newStampMode = stampsMatch ? oldStampMode ^ doubleClicked : doubleClicked;
        MarkableImage oldMImage = (MarkableImage)oldStamp;
        if (newTool != null && newStampMode) {
            newTool.setActionName("stamper");
            if (!stampsMatch) {
                this.context.getController().setStamp(stamp);
                if (oldMImage != null) {
                    oldMImage.clearMark();
                }
            }
            MarkableImage newMImage = (MarkableImage)stamp;
            newMImage.mark(this.markerImage);
        } else if (oldMImage != null) {
            oldMImage.clearMark();
            this.context.getController().setStamp(null);
        }
        this.asyncContext.asyncToolFactoryCallback(screen, this.asyncEvent, newTool);
    }

    @Override
    public void paletteClosed() {
        if (this.image != null) {
            this.image.delete();
        }
        this.endCreating();
        this.context.getController().setSelectMode();
        this.asyncContext = null;
        this.asyncEvent = null;
    }

    @Override
    public AbstractToolModel toolFactory(ExternalDataBean toolData, ScreenModel screen, WBNode container, boolean reciprocal) {
        ImageToolModel newTool = null;
        WBImage image = null;
        if (toolData.getData() instanceof File) {
            File imageFile = null;
            try {
                imageFile = (File)toolData.getData();
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"Incorrect data", (Throwable)ex, (boolean)true);
                return null;
            }
            image = ((ImageUIInterface)((Object)this.getUI())).loadImage(this.context, imageFile);
        } else if (toolData.getData() instanceof Image) {
            Image imageObject = null;
            try {
                imageObject = (Image)toolData.getData();
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"Incorrect data", (Throwable)ex, (boolean)true);
                return null;
            }
            image = ((ImageUIInterface)((Object)this.getUI())).loadImage(this.context, imageObject);
        } else if (toolData.getData() instanceof InputStream) {
            InputStream is = null;
            try {
                is = (InputStream)toolData.getData();
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"Incorrect data", (Throwable)ex, (boolean)true);
                return null;
            }
            image = ((ImageUIInterface)((Object)this.getUI())).loadImage(this.context, is);
        } else if (toolData.getData() instanceof PaletteImage) {
            PaletteImage paletteImage = null;
            String filename = null;
            try {
                paletteImage = (PaletteImage)toolData.getData();
                filename = FileSysUtils.replaceExtension((String)paletteImage.getImageName(), (String)"png");
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"Incorrect PaletteImage data", (Throwable)ex, (boolean)true);
                return null;
            }
            image = ((ImageUIInterface)((Object)this.getUI())).loadImage(this.context, paletteImage.getImage());
            image.setPaletteType(paletteImage.getPaletteType());
            image.setImageFilename(filename);
            image.setDisplayName(paletteImage.getImageDescription());
        }
        if (image != null && image.imageExists()) {
            try {
                if (image.isInBackground()) {
                    ActionUtilities.addBackgroundImage(image, this.context);
                } else {
                    newTool = (ImageToolModel)this.clone();
                    newTool.initialized = true;
                    newTool.setContentType(toolData.getContentType());
                    newTool.setImage(image);
                }
            }
            catch (CloneNotSupportedException ex) {
                LogSupport.exception((Object)this, (String)"toolFactory", (Throwable)ex, (boolean)true);
                newTool = new ImageToolModel(this.context);
            }
            image.delete();
            return newTool;
        }
        return null;
    }

    @Override
    public void quiesceTool() {
        this.toolComplete();
        this.context.getController().repaint(this);
    }

    @Override
    public void toolComplete() {
        ImageUIInterface imageUI = (ImageUIInterface)((Object)this.getUI());
        if (!this.isConferenceNode()) {
            this.initialized = false;
            this.delete();
        }
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        try {
            return (ImageToolModel)ancestor.clone();
        }
        catch (CloneNotSupportedException ex) {
            return this.toolFactory(screen, container, (ActionEvent)null, reciprocal);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return this.clone(this.getActionName());
    }

    public Object clone(String actionName) throws CloneNotSupportedException {
        ImageToolModel imageToolModel = (ImageToolModel)super.clone();
        imageToolModel.image = (WBImage)this.image.clone();
        imageToolModel.borderAlpha = (ToolImageAlpha)this.borderAlpha.clone();
        imageToolModel.setActionName(actionName);
        imageToolModel.registerIfClass("ImageToolModel");
        return imageToolModel;
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
        this.addAttribute(this.borderAlpha);
        this.addAttribute(this.image);
        this.setActionName(ACTION_CLIP_ART);
    }

    @Override
    public void setInConference(boolean inConference) {
        if (this.isConferenceNode() != inConference && this.image.getMediaData() != null) {
            this.context.getMediaCache().registerMediaScreenReference(this.getObjectID(), inConference, this.findScreenParent(), this.image.getMediaData().getMediaID());
        }
        super.setInConference(inConference);
    }

    @Override
    public boolean createOnlyToScreen() {
        return false;
    }

    @Override
    public boolean isInitialized() {
        return this.image != null && this.image.hasImage();
    }

    @Override
    public int creationMouseEvent(MouseEvent e) {
        int response = 0;
        this.context.getController().repaint(this);
        switch (e.getID()) {
            case 503: {
                this.setLocation(e.getX(), e.getY());
                break;
            }
            case 502: {
                boolean stampMode = this.context.getController().getStamp() != null;
                int n = response = e.isShiftDown() ? 2 : 1;
                if (!stampMode) break;
                response = 9;
                break;
            }
        }
        this.context.getController().repaint(this);
        return response;
    }

    @Override
    public int creationKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.notifyVisibleChange();
            return 3;
        }
        if (event.getID() == 402 && this.context.getController() != null) {
            this.context.getController().processNavKey(event);
        }
        return 0;
    }

    @Override
    public AbstractUI getUI() {
        if (this.toolUI == null) {
            this.toolUI = this.toolUIFactory(IMAGE_UI_CLASS);
        }
        return this.toolUI;
    }

    @Override
    public void delete() {
        if (this.image != null) {
            this.image.delete();
        }
        this.borderAlpha = null;
        this.image = null;
        super.delete();
    }

    @Override
    public String getDisplayName() {
        if (this.image == null || this.image.getDisplayName() == null || this.image.getImageFilename() == null) {
            this.setDisplayName("");
        } else {
            String fileName = this.image.getDisplayName();
            if (fileName == null) {
                fileName = this.image.getImageFilename();
            }
            boolean needEllipsis = fileName.length() > 29;
            int allocLength = Math.min(29, fileName.length());
            if (needEllipsis) {
                allocLength += 3;
            }
            StringBuffer displayName = new StringBuffer(allocLength);
            displayName.append(fileName.substring(0, Math.min(29, fileName.length())));
            if (fileName.length() > displayName.length()) {
                displayName.append("...");
            }
            this.setDisplayName(displayName.toString());
        }
        return super.getDisplayName();
    }

    @Override
    public void addMediaRequest(Short clientId) {
        if (this.image != null) {
            this.image.addMediaRequest(clientId);
        }
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer msg = new StringBuffer();
        msg.append(super.streamToString(istr));
        return msg.toString() + ", Border=" + this.hasFrame;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        return this;
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        super.elementToObject(element, progress);
        String borderString = element.getAttributeValue("Border");
        if (borderString != null && borderString.equalsIgnoreCase("true")) {
            this.setFrameVisible(true);
        }
        if (this.getImage() != null && this.getImage().getPaletteType() == WBImage.PaletteType.BACKGROUND) {
            this.setAsBackground(true);
        }
        return this;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement element = new WBElement(this.getName());
        super.objectToElement(element, progress);
        if (this.hasFrame) {
            element.setAttribute(new Attribute("Border", "true"));
        }
        return element;
    }

    @Override
    public void render(Graphics g) {
        ((ImageUIInterface)((Object)this.getUI())).draw(g, this);
        if (this.image != null) {
            this.image.imageRendered();
        }
    }

    public int getFillAlpha() {
        return this.color.getAlpha();
    }

    public void setFillAlpha(int alpha) {
        this.color.setAlpha(alpha);
        this.notifyVisibleChange();
    }

    public void setImage(WBImage image) {
        this.notifyVisibleChange();
        this.image.loadImage(image.getImageBytes(), image.getImageFilename(), image.getDisplayName());
        this.image.setPaletteType(image.getPaletteType());
        this.setSize(new DDimension(image.getSize()));
        this.notifySizingChange();
    }

    public void setSize() {
        this.notifyVisibleChange();
        this.setSize(new DDimension(this.image.getSize()));
        this.notifySizingChange();
    }

    public boolean isFrameVisible() {
        return this.hasFrame;
    }

    public void setFrameVisible(final boolean b) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                ImageToolModel.this.notifyVisibleChange();
                ImageToolModel.this.hasFrame = b;
                ImageToolModel.this.notifySizingChange();
            }
        });
    }

    public WBImage getImage() {
        return this.image;
    }

    public boolean hasImage() {
        return this.image != null ? this.image.hasImage() : false;
    }

    @Override
    public boolean isBackground() {
        boolean status = super.isBackground();
        if (!status && this.getImage() != null && (status = this.getImage().isInBackground())) {
            this.setAsBackground(status);
        }
        return status;
    }

    @Override
    public void setAsBackground(boolean nodeIsBackground) {
        super.setAsBackground(nodeIsBackground);
        if (this.image != null && nodeIsBackground) {
            this.image.setPaletteType(WBImage.PaletteType.BACKGROUND);
        }
    }
}

