/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.tools;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.WBImage;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.dataModel.ActionUtilities;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.AbstractUI;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.groupware.whiteboard.tools.ImageToolModel;
import com.elluminate.groupware.whiteboard.tools.StringsProperties;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class BackgroundTool
extends GroupToolModel
implements Cloneable {
    private static final String WBD_NAME = "Background";
    private static final String DISPLAY_NAME = "Background";
    static boolean hasSingleBackgroundImage = "true".equals(I18N.getString((PropertiesEnum)StringsProperties.SINGLEBACKGROUNDIMAGE));

    public static boolean hasSingleBackground() {
        return hasSingleBackgroundImage;
    }

    public BackgroundTool(WhiteboardContext context) {
        this(context, "Background");
    }

    public BackgroundTool(WhiteboardContext context, String name) {
        super(context, name);
        this.controllerPaneSelectable = false;
        this.setZOrder(-1);
        this.registerIfClass("BackgroundTool");
    }

    public BackgroundTool(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            this.elementToObject(element, update);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"elementToObject constructor", (Throwable)e, (boolean)true);
        }
    }

    public BackgroundTool(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"streamToObject constructor", (Throwable)e, (boolean)true);
        }
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, ActionEvent e, boolean reciprocal) {
        return this.toolFactory(screen, container, reciprocal, this);
    }

    @Override
    public AbstractToolModel toolFactory(ScreenModel screen, WBNode container, boolean reciprocal, AbstractToolModel ancestor) {
        if (reciprocal) {
            this.performReciprocalAction(screen, container);
        } else if (!screen.selectedToolListIsEmpty()) {
            ActionUtilities.groupSelectedToolsToBackground(screen, this.context);
        }
        return null;
    }

    private boolean performReciprocalAction(ScreenModel screen, WBNode container) {
        if (BackgroundTool.hasSingleBackground()) {
            BackgroundTool tool = ActionUtilities.getFirstBackground(screen);
            if (tool != null) {
                ActionUtilities.ungroupTools(new AbstractToolModel[]{tool}, screen, this.context);
            }
        } else if (!screen.selectedToolListIsEmpty()) {
            super.performReciprocalAction(container);
        }
        return true;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BackgroundTool backgroundTool = (BackgroundTool)super.clone();
        backgroundTool.registerIfClass("BackgroundTool");
        return backgroundTool;
    }

    @Override
    protected void registerAttributes() {
        super.registerAttributes();
    }

    @Override
    public boolean createOnlyToScreen() {
        return true;
    }

    @Override
    public boolean unselectOnCreation() {
        return false;
    }

    @Override
    public int creationMouseEvent(MouseEvent e) {
        return 3;
    }

    @Override
    public int creationKeyEvent(KeyEvent event) {
        if (event.getID() == 402 && this.context.getController() != null) {
            this.context.getController().processNavKey(event);
        }
        return 3;
    }

    @Override
    public AbstractUI getUI() {
        return null;
    }

    @Override
    public boolean hasReciprocalAction() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Background";
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        RegisteredTemplate backgroundTool = null;
        if (element.getAttribute("name") != null) {
            super.elementToObject(element, progress);
            ImageToolModel imageTool = new ImageToolModel(this.context);
            imageTool.setTemplate(this.context);
            this.context.getObjectManager().setObjectInMap(imageTool);
            WBImage image = imageTool.getImage();
            image.elementToObject(element, progress);
            if (image.getPaletteType() == WBImage.PaletteType.BACKGROUND) {
                this.setAsBackground(true);
            }
            imageTool.setLocation(new DPoint(0.0, 0.0));
            imageTool.setSize();
            imageTool.setFrameVisible(false);
            this.add(imageTool);
        } else {
            super.elementToObject(element, progress);
        }
        return backgroundTool;
    }

    @Override
    public boolean isBackground() {
        return true;
    }
}

