/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.dataModel.MediaFullException;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Locale;

public class WhiteboardModel
extends ScreenModel
implements Cloneable {
    public WhiteboardModel(WhiteboardContext context) {
        super(context, "Whiteboard Root");
        this.setName("Whiteboard");
        this.visibleACL.addAcceptEntry(ACLTerm.ALL_ENTRY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WhiteboardModel(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
        try {
            WBElement mediaElement = (WBElement)element.getChild("_MediaCache");
            if (mediaElement != null) {
                context.getMediaCache().elementToMediaCache(mediaElement, update);
                element.removeChild("_MediaCache");
            }
            this.elementToObject(element, update);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"WhiteboardModel", (Throwable)e, (boolean)true);
        }
        finally {
            context.getMediaCache().pruneUnreferenced();
        }
    }

    public WhiteboardModel(WhiteboardContext context, DataInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"WhiteboardModel", (Throwable)e, (boolean)true);
        }
    }

    public RegisteredTemplate streamToObject(DataInputStream istr) throws Exception {
        throw new Exception("WhiteboardModel should not be streamed out.");
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        super.elementToObject(element, progress);
        for (WBElement nextEl : element.getChildren()) {
            try {
                this.processElement(nextEl, this, progress);
            }
            catch (Exception e) {
                if (e instanceof MediaFullException) continue;
                LogSupport.exception((Object)this, (String)"elementToObject", (Throwable)e, (boolean)true);
            }
        }
        return this;
    }

    public String streamToString(DataInputStream istr) {
        throw new RuntimeException("WhiteboardModel should not be streamed in.");
    }

    public void objectToStream(DataOutputStream ostr) throws Exception {
        throw new Exception("WhiteboardModel should not be streamed in.");
    }

    public WBElement objectToElement(WBElement parent) throws Exception {
        throw new Exception("WhiteboardModel should not be sent to JDOM.");
    }

    private WBNode processElement(WBElement element, WBNode node, ProgressUpdate progress) throws Exception {
        RegisteredTemplate newNode;
        if (progress != null) {
            progress.setValue(element.getInstanceCount());
        }
        if ((newNode = this.context.getTemplateRegistry().templateFactory(element.getName().toLowerCase(Locale.ENGLISH), element, progress)) instanceof WhiteboardModel) {
            throw new Exception("Whiteboard element cannot be recursive.");
        }
        if (newNode != null && !(newNode instanceof WBNode)) {
            throw new RuntimeException("WhiteboardModel.processElement: new Element is not a WBNode: " + newNode);
        }
        if (node != null && newNode != null) {
            if (newNode instanceof ScreenModel && !(node instanceof WhiteboardModel)) {
                node.getParent().add((WBNode)newNode);
            } else {
                node.add((WBNode)newNode);
            }
        }
        WBElement[] elements = new WBElement[element.getChildren().size()];
        elements = element.getChildren().toArray(elements);
        for (int i = 0; i < elements.length; ++i) {
            this.processElement(elements[i], (WBNode)newNode, progress);
        }
        return (WBNode)newNode;
    }
}

