/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.dataModel.Validator;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;

public class TreeModelDebugger
implements TreeModelListener {
    String listenerTitle;

    public TreeModelDebugger(String listenerTitle) {
        this.listenerTitle = listenerTitle;
    }

    public void displayTreeModelEvent(String title, TreeModelEvent e) {
        if (!Validator.logging) {
            return;
        }
        try {
            int i;
            System.out.println("\nTreeModelEvent for tree: " + this.listenerTitle + ", Method: " + title);
            System.out.println("  Event: " + e.getSource().getClass().getName());
            if (e.getPath() == null) {
                System.out.println("   Path: null");
            } else {
                System.out.println("   Paths(" + e.getPath().length + "): ");
                for (i = 0; i < e.getPath().length; ++i) {
                    System.out.println("      " + e.getPath()[i]);
                }
            }
            System.out.print("   Child Indicies(" + e.getChildIndices().length + "): ");
            if (e.getChildIndices() == null) {
                System.out.print(" null");
            } else {
                for (i = 0; i < e.getChildIndices().length; ++i) {
                    System.out.print("       " + e.getChildIndices()[i]);
                }
            }
            if (e.getChildren() == null) {
                System.out.println("\n   Children: null");
            } else {
                System.out.println("\n   Children(" + e.getChildren().length + "): ");
                for (i = 0; i < e.getChildren().length; ++i) {
                    System.out.println("       " + e.getChildren()[i]);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("\n Exception decoding TreeModelEvent: " + ex.getMessage());
        }
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.displayTreeModelEvent("treeNodesChanged", e);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.displayTreeModelEvent("treeNodesInserted", e);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.displayTreeModelEvent("treeNodesRemoved", e);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.displayTreeModelEvent("treeStructureChanged", e);
    }
}

