/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.TemplateClassLoader;
import com.elluminate.groupware.whiteboard.dataModel.TemplateRegistrationEvent;
import com.elluminate.groupware.whiteboard.dataModel.TemplateRegistrationListener;
import com.elluminate.groupware.whiteboard.interfaces.AttributeList;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.groupware.whiteboard.interfaces.UniqueObjectID;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.util.Debug;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TooManyListenersException;

public class TemplateRegistry {
    private HashMap templateByNameMap;
    private HashMap templateByIDMap;
    private WhiteboardContext context;
    private ArrayList templateRegistrationListeners;
    private static Class[] contextSignature = null;
    private static Class[] elementSignature = null;
    private static Class[] streamSignature = null;
    private short templateID;
    private Object templateRegistryLock = new Object();

    public TemplateRegistry(WhiteboardContext context) {
        this.templateByNameMap = new HashMap();
        this.templateByIDMap = new HashMap();
        this.context = context;
        this.templateRegistrationListeners = new ArrayList();
        this.templateID = 1;
        if (contextSignature == null) {
            contextSignature = new Class[]{WhiteboardContext.class};
        }
        if (elementSignature == null) {
            elementSignature = new Class[]{WhiteboardContext.class, WBElement.class, ProgressUpdate.class};
        }
        if (streamSignature == null) {
            streamSignature = new Class[]{WhiteboardContext.class, WBInputStream.class};
        }
    }

    public void initialize() {
        TemplateRegistrationEvent tempRegEvent = new TemplateRegistrationEvent(this.context, false, "", ShortList.get((short)0), null);
        this.registerTemplate(tempRegEvent);
    }

    public RegisteredTemplate registerTemplate(RegisteredTemplate template) {
        return this.register(template, template.getName(), null);
    }

    public RegisteredTemplate registerTemplate(RegisteredTemplate template, String name) {
        return this.register(template, name, null);
    }

    public RegisteredTemplate registerTemplate(RegisteredTemplate template, String name, Short id) {
        return this.register(template, name, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTemplate(short id, String name, String className) {
        Constructor con = null;
        Short localID = id != 0 ? ShortList.get((short)id) : null;
        Debug.lockEnter((Object)this, (String)"loadTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        Object object = this.templateRegistryLock;
        synchronized (object) {
            TemplateClassLoader loader = new TemplateClassLoader();
            try {
                Class myClass = loader.loadClass(className, true);
                con = myClass.getConstructor(contextSignature);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"loadTemplate", (Throwable)ex, (boolean)true, (String)("Cannot find: " + name + ", classname: " + className + ", id=" + id));
            }
        }
        Debug.lockLeave((Object)this, (String)"loadTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object obj = con.newInstance(this.context);
            if (obj != null) {
                if (obj instanceof RegisteredTemplate) {
                    this.registerTemplate((RegisteredTemplate)obj, name, localID);
                } else {
                    LogSupport.error((String)("Class: " + className + " is not a RegisteredTemplate."));
                }
            }
        }
        catch (Exception cnf) {
            LogSupport.exception((Object)this, (String)"loadTemplate", (Throwable)cnf, (boolean)true, (String)("Cannot find: " + name + ", classname: " + className + ", id=" + id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemplate(String name) {
        Debug.lockEnter((Object)this, (String)"removeTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        Object object = this.templateRegistryLock;
        synchronized (object) {
            if (!this.templateByNameMap.containsKey(name)) {
                LogSupport.error((String)("TemplateRegistry: Attempt to remove non-existant template: " + name));
            } else {
                this.removeTemplateByEnvelope(this.getEnvelope(name));
            }
        }
        Debug.lockLeave((Object)this, (String)"removeTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemplate(Short id) {
        Debug.lockEnter((Object)this, (String)"removeTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        Object object = this.templateRegistryLock;
        synchronized (object) {
            if (!this.templateByIDMap.containsKey(id)) {
                LogSupport.error((String)("TemplateRegistry: Attempt to remove non-existant template #" + id));
            } else {
                this.removeTemplateByEnvelope(this.getEnvelope(id));
            }
        }
        Debug.lockLeave((Object)this, (String)"removeTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemplate(RegisteredTemplate temp) {
        Debug.lockEnter((Object)this, (String)"removeTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        Object object = this.templateRegistryLock;
        synchronized (object) {
            if (!this.templateByNameMap.containsKey(temp.getName())) {
                LogSupport.error((String)("TemplateRegistry: Attempt to remove non-existant template: " + temp.getName()));
            } else {
                this.removeTemplateByEnvelope(this.getEnvelope(temp.getName()));
            }
        }
        Debug.lockLeave((Object)this, (String)"removeTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
    }

    private void removeTemplateByEnvelope(RegisteredTemplateEnvelope env) {
        if (env == null) {
            LogSupport.error((String)"TemplateRegistry: attempt to remove non-existant template");
            return;
        }
        TemplateRegistrationEvent ore = new TemplateRegistrationEvent(this.context, false, env.getName(), env.getID(), env.getTemplate());
        if (this.templateByIDMap.remove(env.getID()) == null) {
            LogSupport.message((Object)this, (String)"removeTemplateByEnvelope", (String)("envelope not removed from templateByID: " + env));
        }
        if (this.templateByNameMap.remove(env.getName()) == null) {
            LogSupport.message((Object)this, (String)"removeTemplateByEnvelope", (String)("envelope not removed from templateByName: " + env));
        }
        this.fireTemplateRegistrationEvent(ore);
        env = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredTemplate getTemplate(String name) {
        Debug.lockEnter((Object)this, (String)"getTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                RegisteredTemplateEnvelope temp = this.getEnvelope(name);
                RegisteredTemplate registeredTemplate = temp == null ? null : temp.getTemplate();
                return registeredTemplate;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"getTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredTemplate getTemplate(Short id) {
        Debug.lockEnter((Object)this, (String)"getTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                RegisteredTemplateEnvelope temp = this.getEnvelope(id);
                RegisteredTemplate registeredTemplate = temp == null ? null : temp.getTemplate();
                return registeredTemplate;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"getTemplate", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Debug.lockEnter((Object)this, (String)"isEmpty", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                boolean bl = this.templateByNameMap.isEmpty();
                return bl;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"isEmpty", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Debug.lockEnter((Object)this, (String)"clear", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                this.templateByNameMap.clear();
                this.templateByIDMap.clear();
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"clear", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RegisteredTemplate template) {
        Debug.lockEnter((Object)this, (String)"contains", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                boolean bl = template != null && template.getName() != null ? this.templateByNameMap.containsKey(template.getName().toLowerCase(Locale.ENGLISH)) : false;
                return bl;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"contains", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String name) {
        Debug.lockEnter((Object)this, (String)"contains", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                boolean bl = name == null ? false : this.templateByNameMap.containsKey(name.toLowerCase(Locale.ENGLISH));
                return bl;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"contains", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Short id) {
        Debug.lockEnter((Object)this, (String)"contains", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                boolean bl = id == null ? false : this.templateByIDMap.containsKey(id);
                return bl;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"contains", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Debug.lockEnter((Object)this, (String)"size", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                int n = this.templateByNameMap.size();
                return n;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"size", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        }
    }

    private RegisteredTemplateEnvelope getEnvelope(String name) {
        return name == null ? null : (RegisteredTemplateEnvelope)this.templateByNameMap.get(name.toLowerCase(Locale.ENGLISH));
    }

    private RegisteredTemplateEnvelope getEnvelope(Short id) {
        return id == null ? null : (RegisteredTemplateEnvelope)this.templateByIDMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private RegisteredTemplate register(RegisteredTemplate template, String name, Short id) {
        RegisteredTemplateEnvelope envelope;
        block16: {
            RegisteredTemplate registeredTemplate;
            Debug.lockEnter((Object)this, (String)"register", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
            try {
                Object object = this.templateRegistryLock;
                // MONITORENTER : object
                if (!this.contains(name)) break block16;
                registeredTemplate = this.getTemplate(name);
                // MONITOREXIT : object
            }
            catch (Throwable throwable) {
                Debug.lockLeave((Object)this, (String)"register", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
                throw throwable;
            }
            Debug.lockLeave((Object)this, (String)"register", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
            return registeredTemplate;
        }
        if (name != null) {
            template.setName(name.toLowerCase(Locale.ENGLISH));
        }
        boolean defined = false;
        Short localID = id;
        if (id == null) {
            short s = this.templateID;
            this.templateID = (short)(s + 1);
            localID = ShortList.get((short)s);
            defined = true;
        }
        if (this.templateByIDMap.put(localID, envelope = new RegisteredTemplateEnvelope(template, template.getName(), localID)) != null) {
            LogSupport.error((String)("TemplateRegistry - duplicate registered id (" + localID + ") - Template: " + template));
            RegisteredTemplate registeredTemplate = null;
            // MONITOREXIT : object
            Debug.lockLeave((Object)this, (String)"register", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
            return registeredTemplate;
        }
        if (this.templateByNameMap.put(template.getName(), envelope) != null) {
            if (this.templateByIDMap.remove(localID) == null) {
                LogSupport.message((Object)this, (String)"register", (String)("localId not removed from templateByID: " + localID));
            }
            LogSupport.error((String)("TemplateRegistry - duplicate registered name (" + template.getName() + ") - Template: " + template));
            RegisteredTemplate registeredTemplate = null;
            // MONITOREXIT : object
            Debug.lockLeave((Object)this, (String)"register", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
            return registeredTemplate;
        }
        template.setContext(this.context);
        if (defined) {
            this.sendTemplateRegistration(true, template, localID);
        }
        if (template instanceof AttributeList) {
            List list = ((AttributeList)((Object)template)).getAttributeList();
            for (Object o : list) {
                if (!(o instanceof RegisteredTemplate)) continue;
                RegisteredTemplate rt = (RegisteredTemplate)o;
                this.registerTemplate(rt, rt.getName());
            }
        }
        RegisteredTemplate registeredTemplate = template;
        // MONITOREXIT : object
        Debug.lockLeave((Object)this, (String)"register", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        return registeredTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayRegisteredTemplates(short clientAddress) {
        Debug.lockEnter((Object)this, (String)"replayRegisteredTemplates", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        Object object = this.templateRegistryLock;
        synchronized (object) {
            TemplateRegistrationEvent tre = null;
            Set keys = this.templateByIDMap.keySet();
            for (Short id : keys) {
                RegisteredTemplate template = this.getTemplate(id);
                if (tre == null) {
                    tre = new TemplateRegistrationEvent(this.context, true, template.getName(), id, template);
                    continue;
                }
                tre.add(true, template.getName(), id, template);
            }
            if (tre != null) {
                this.sendTemplateRegistrationEvent(tre, clientAddress);
            } else {
                LogSupport.message((Object)this, (String)"replayRegisteredTemplates", (String)("Did not send to: " + clientAddress + ", " + tre));
            }
        }
        Debug.lockLeave((Object)this, (String)"replayRegisteredTemplates", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RegisteredTemplate templateLocator(DataInputStream istr) {
        RegisteredTemplate registeredTemplate;
        RegisteredTemplate template;
        Short id;
        Debug.lockEnter((Object)this, (String)"templateLocator", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                id = null;
                try {
                    id = ShortList.get((short)WBUtils.readShort(istr, "Temp reg locate id"));
                }
                catch (IOException ioe) {
                    LogSupport.error((Object)this, (String)"templateLocator", (String)(ioe.getMessage() + ", for templateId: " + id));
                    RegisteredTemplate registeredTemplate2 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 6] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    Debug.lockLeave((Object)this, (String)"templateLocator", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
                    return registeredTemplate2;
                }
                template = this.context.getTemplateRegistry().getTemplate(id);
                if (template != null) break block8;
            }
        }
        catch (Throwable throwable) {
            Debug.lockLeave((Object)this, (String)"templateLocator", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
            throw throwable;
        }
        {
            block8: {
                LogSupport.error((Object)this, (String)"templateLocator", (String)("Cannot locate unknown template - ID=" + id));
            }
            registeredTemplate = template;
        }
        Debug.lockLeave((Object)this, (String)"templateLocator", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        return registeredTemplate;
    }

    public RegisteredTemplate templateFactory(String name, WBElement element, ProgressUpdate update) {
        RegisteredTemplate template = this.templateLocator(name);
        if (!(template instanceof UniqueObjectID)) {
            return null;
        }
        RegisteredTemplate retObject = null;
        try {
            Constructor<?> con = template.getClass().getConstructor(elementSignature);
            retObject = (RegisteredTemplate)con.newInstance(new Object[]{this.context, element, update});
            retObject.setTemplate(template);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"templateFactory", (Throwable)e, (boolean)true);
        }
        return retObject;
    }

    public RegisteredTemplate templateFactory(DataInputStream istr) {
        RegisteredTemplate template = this.templateLocator(istr);
        RegisteredTemplate retObject = null;
        if (template != null) {
            try {
                Constructor<?> con = template.getClass().getConstructor(streamSignature);
                retObject = (RegisteredTemplate)con.newInstance(this.context, istr);
                retObject.setTemplate(template);
            }
            catch (Exception e) {
                LogSupport.exception((Object)this, (String)"templateFactory", (Throwable)e, (boolean)true, (String)(template.getName() + "(" + template.getRegisteredID() + ") does not have a StreamSignature"));
            }
        }
        return retObject;
    }

    public RegisteredTemplate templateFactory(String name) {
        RegisteredTemplate template = this.templateLocator(name);
        RegisteredTemplate retObject = null;
        try {
            Constructor<?> con = template.getClass().getConstructor(contextSignature);
            retObject = (RegisteredTemplate)con.newInstance(this.context);
            retObject.setTemplate(template);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"templateFactory", (Throwable)e, (boolean)true);
        }
        return retObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegisteredTemplate templateLocator(String name) {
        Debug.lockEnter((Object)this, (String)"templateLocator", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                RegisteredTemplate temp = this.context.getTemplateRegistry().getTemplate(name);
                if (temp == null) {
                    LogSupport.error((String)("TemplateLocator: Cannot locate unknown template - name=" + name));
                }
                RegisteredTemplate registeredTemplate = temp;
                return registeredTemplate;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"templateLocator", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTemplateRegistrationListener(TemplateRegistrationListener l) throws TooManyListenersException {
        Debug.lockEnter((Object)this, (String)"addTemplateRegistrationListener", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        Object object = this.templateRegistryLock;
        synchronized (object) {
            if (this.templateRegistrationListeners.contains(l)) {
                throw new TooManyListenersException("addTemplateRegistrationListener");
            }
            this.templateRegistrationListeners.add(l);
        }
        Debug.lockLeave((Object)this, (String)"addTemplateRegistrationListener", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTemplateRegistrationListener(TemplateRegistrationListener l) {
        Debug.lockEnter((Object)this, (String)"removeTemplateRegistrationListener", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        Object object = this.templateRegistryLock;
        synchronized (object) {
            this.templateRegistrationListeners.remove(l);
        }
        Debug.lockLeave((Object)this, (String)"removeTemplateRegistrationListener", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTemplateRegistration(boolean add, RegisteredTemplate temp, Short localID) {
        Debug.lockEnter((Object)this, (String)"sendTemplateRegistration", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        Object object = this.templateRegistryLock;
        synchronized (object) {
            TemplateRegistrationEvent tre = new TemplateRegistrationEvent(this.context, add, temp.getName(), localID, temp);
            this.fireTemplateRegistrationEvent(tre);
        }
        Debug.lockLeave((Object)this, (String)"sendTemplateRegistration", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
    }

    private void fireTemplateRegistrationEvent(TemplateRegistrationEvent tre) {
        if (this.context.getClientList() == null) {
            return;
        }
        short myAddress = this.context.getClientList().getMyAddress();
        if (this.context.isClient()) {
            this.sendTemplateRegistrationEvent(tre, (short)0);
        } else {
            for (ClientInfo clientInfo : this.context.getClientList()) {
                if (clientInfo.getAddress() == myAddress) continue;
                this.sendTemplateRegistrationEvent(tre, clientInfo.getAddress());
            }
        }
        Iterator itr = this.templateRegistrationListeners.iterator();
        while (itr.hasNext()) {
            ((TemplateRegistrationListener)itr.next()).onTemplateRegistration(tre);
        }
    }

    private void sendTemplateRegistrationEvent(TemplateRegistrationEvent tre, short clientAddress) {
        if (this.context.getDataProcessor() != null && this.context.isOnline()) {
            this.context.getDataProcessor().sendDirective((byte)1, (StreamableObject)tre, clientAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Debug.lockEnter((Object)this, (String)"toString", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        try {
            Object object = this.templateRegistryLock;
            synchronized (object) {
                StringBuffer buf = new StringBuffer();
                buf.append("TemplateRegistry: " + this.templateByIDMap.size() + " Elements (online=" + this.context.isOnline() + ")\n");
                Set keys = this.templateByIDMap.keySet();
                for (Short id : keys) {
                    RegisteredTemplateEnvelope temp = (RegisteredTemplateEnvelope)this.templateByIDMap.get(id);
                    buf.append("  " + id + "  " + temp.getName() + ", id: " + temp.getTemplate().getRegisteredID() + "\n");
                }
                String string = buf.toString();
                return string;
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"toString", (String)"templateRegistryLock", (Object)this.templateRegistryLock);
        }
    }

    public class RegisteredTemplateEnvelope {
        private RegisteredTemplate temp;
        private Short registeredID;
        private String registeredName;

        public RegisteredTemplateEnvelope(RegisteredTemplate template, String tempName, Short id) {
            this.temp = template;
            this.registeredName = tempName;
            this.registeredID = id;
            this.temp.setRegisteredID(id);
            this.temp.setName(tempName);
        }

        public String toString() {
            return "Envelope: registeredName: " + this.registeredName + ", id: " + this.registeredID + ", template: " + this.temp;
        }

        public RegisteredTemplate getTemplate() {
            return this.temp;
        }

        public Short getID() {
            return this.registeredID;
        }

        public String getName() {
            return this.registeredName;
        }

        public String getClassName() {
            return this.temp.getClass().getName();
        }
    }
}

