/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.interfaces.NeedContext;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.util.Locale;

public abstract class RegisteredTemplate
implements Cloneable,
NeedContext,
StreamableObject {
    public static final Short NULL_ORIGINATOR = ShortList.get((short)-32767);
    public static final Short BROADCAST_ADDRESS = ShortList.get((short)-2);
    Short originator = NULL_ORIGINATOR;
    protected RegisteredTemplate template = null;
    protected Short templateId = null;
    protected String templateName = null;
    protected WhiteboardContext context = null;

    public Object clone() throws CloneNotSupportedException {
        RegisteredTemplate registeredTemplate = (RegisteredTemplate)super.clone();
        registeredTemplate.setOriginator();
        return registeredTemplate;
    }

    public void delete() {
        this.templateId = null;
        this.templateName = null;
        this.template = null;
    }

    public Short getOriginator() {
        return this.originator;
    }

    public void setOriginator() {
        if (this.context != null && this.context.getClientList() != null) {
            this.setOriginator(this.context.getIDProcessor().getMyId());
        } else {
            this.setOriginator(null);
        }
    }

    public void setOriginator(Short originator) {
        this.originator = originator;
    }

    public String getName() {
        if (this.templateName != null) {
            return this.templateName;
        }
        return this.template == null ? null : this.template.getName();
    }

    public void setName(String name) {
        if (this.template != null) {
            throw new RuntimeException("Attempt to set name of derived RegisteredTemplate: " + this.template + " to: " + name);
        }
        this.templateName = name.toLowerCase(Locale.ENGLISH);
    }

    public Short getRegisteredID() {
        return this.template == null ? this.templateId : this.template.getRegisteredID();
    }

    public void setRegisteredID(Short id) {
        if (this.template != null) {
            throw new RuntimeException("Attempt to set id of derived RegisteredTemplate: " + this.template + " to: " + id);
        }
        this.templateId = id;
    }

    public RegisteredTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(RegisteredTemplate template) {
        this.template = template;
        this.templateName = null;
        this.templateId = null;
    }

    public void setTemplate(WhiteboardContext context) {
        RegisteredTemplate temp;
        if (this.template != null || context == null) {
            return;
        }
        if (this.context == null) {
            this.context = context;
        }
        if ((temp = context.getTemplateRegistry().getTemplate(this.getName())) != null && temp != this) {
            this.template = temp;
        }
    }

    public boolean canFactoryFromName() {
        return true;
    }

    @Override
    public WhiteboardContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(WhiteboardContext context) {
        RegisteredTemplate temp;
        this.context = context;
        if (this.template == null && context != null && (temp = context.getTemplateRegistry().getTemplate(this.getName())) != null && temp != this) {
            this.template = temp;
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        this.setOriginator(istr.getOriginatorId());
        return this;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        return "RegisteredID=" + this.getRegisteredID().longValue();
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        try {
            ostr.writeShort(this.getRegisteredID().shortValue());
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"objectToStream", (Throwable)ex, (boolean)true);
        }
    }

    public boolean validate() {
        boolean valid = true;
        if (this.context == null) {
            Validator.log(this.getClass().getName() + ": has a null WhiteboardContext.");
            valid = Validator.setValid(valid, false);
        }
        if (this.template == null && this.templateId != null) {
            Validator.log(this.getClass().getName() + ": has a null template reference and a null templateId.");
            valid = Validator.setValid(valid, false);
        }
        if (this.template == null && this.templateName != null) {
            Validator.log(this.getClass().getName() + ": has a null template reference and a null templateName.");
            valid = Validator.setValid(valid, false);
        }
        return valid;
    }
}

