/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.util.log.LogSupport;
import java.io.DataOutputStream;
import java.io.IOException;

public class ObjectUID {
    private int objectSequence;
    private short clientId;
    private Long uid = null;
    public static final int SEQUENCE_MASK = 0x3FFFFFFF;
    public static final short SEED_MASK = 16383;
    public static final short LOCAL_SEED = 0;
    public static final short UID_LENGTH = 3;

    public ObjectUID() {
    }

    public ObjectUID(int sequence, short clientId) {
        this.setSequence(sequence);
        this.setClientId(clientId);
    }

    public short getClientId() {
        return this.clientId;
    }

    public void setClientId(short clientId) {
        this.clientId = clientId;
        this.uid = null;
    }

    public int getSequenceId() {
        return this.objectSequence;
    }

    public void setSequence(int sequence) {
        this.objectSequence = sequence;
        this.uid = null;
    }

    public Long getUID() {
        if (this.uid == null) {
            this.uid = new Long(ObjectUID.encodeUID(this.clientId, this.objectSequence));
        }
        return this.uid;
    }

    public static int decodeSequence(long objectId) {
        return (int)(objectId & 0x3FFFFFFFL);
    }

    public static int decodeSequence(Long objectId) {
        if (objectId == null) {
            return -1;
        }
        return ObjectUID.decodeSequence((long)objectId);
    }

    public static short decodeClientId(long objectId) {
        if (objectId < 0L) {
            LogSupport.error((String)(" decodeSeed of negative id: " + objectId));
        }
        return (short)(objectId >> 32 & 0x3FFFL);
    }

    public static short decodeClientId(Long objectId) {
        if (objectId == null) {
            return -1;
        }
        return ObjectUID.decodeClientId((long)objectId);
    }

    public static long encodeUID(short clientId, int sequence) {
        return ((long)clientId << 32) + (0x3FFFFFFFL & (long)sequence);
    }

    public static Long objectUIDFromStream(WBInputStream istr) throws IOException {
        short address = -1;
        short clientId = WBUtils.readShort(istr, "ObjUID clientId from stream");
        int sequence = WBUtils.readInt(istr, "ObjUID sequence from stream");
        if (clientId == 0 && sequence == 0) {
            return null;
        }
        try {
            address = istr.getAddress() == null ? istr.getContext().getIDProcessor().getMyAddress().shortValue() : istr.getAddress().shortValue();
        }
        catch (Exception ex) {
            LogSupport.exception(ObjectUID.class, (String)"objectUIDFromStream", (Throwable)ex, (boolean)true, (String)"Cannot get address");
        }
        return new Long(ObjectUID.encodeUID(istr.getContext().getIDProcessor().conferenceToLocal(clientId, address), sequence));
    }

    public static Long longObjectUIDFromStream(WBInputStream istr) throws IOException {
        short address = -1;
        int clientId = WBUtils.readInt(istr, "ObjUID clientId from stream");
        int sequence = WBUtils.readInt(istr, "ObjUID sequence from stream");
        if (clientId == 0 && sequence == 0) {
            return null;
        }
        if ((clientId & Integer.MIN_VALUE) != 0) {
            long id = clientId;
            return new Long(id << 32 | (long)sequence & 0xFFFFFFFFL);
        }
        try {
            address = istr.getAddress() == null ? istr.getContext().getIDProcessor().getMyAddress().shortValue() : istr.getAddress().shortValue();
        }
        catch (Exception ex) {
            LogSupport.exception(ObjectUID.class, (String)"objectUIDFromStream", (Throwable)ex, (boolean)true, (String)"Cannot get address");
        }
        return new Long(ObjectUID.encodeUID(istr.getContext().getIDProcessor().conferenceToLocal((short)clientId, address), sequence));
    }

    public static void objectUIDToStream(Long uid, DataOutputStream ostr) throws IOException {
        if (uid == null) {
            ostr.writeShort(0);
            ostr.writeInt(0);
        } else {
            ostr.writeShort(ObjectUID.decodeClientId(uid));
            ostr.writeInt(ObjectUID.decodeSequence(uid));
        }
    }

    public static void longObjectUIDToStream(Long uid, DataOutputStream ostr) throws IOException {
        if (uid == null) {
            ostr.writeInt(0);
            ostr.writeInt(0);
        } else {
            ostr.writeInt(ObjectUID.decodeClientId(uid));
            ostr.writeInt(ObjectUID.decodeSequence(uid));
        }
    }

    public static boolean isMyNode(WBNode node) {
        return ObjectUID.decodeClientId(node.getObjectID()) == 0;
    }

    public static int objectUIDHash(Long uid) {
        long result = 0L;
        long localUID = uid;
        for (int i = 0; i < 8; ++i) {
            byte key = (byte)(localUID & 0xFFL);
            localUID >>>= 8;
            result += (long)key;
            result += result << 10;
            result ^= result >> 6;
        }
        result += result << 3;
        result ^= result >> 11;
        result += result << 15;
        return (int)(result & 0xFFFFFFFFFFFFFFFFL);
    }
}

