/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.attributes.ToolRectangle;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import java.awt.Rectangle;
import java.util.List;

public class GeometryUtils {
    static final double MINIMUM_COLLAPSE = 1.0;
    private static Rectangle enclosingNorm = new Rectangle();
    private static Rectangle enclosedNorm = new Rectangle();

    public static synchronized boolean contains(Rectangle enclosing, Rectangle enclosed) {
        enclosingNorm = GeometryUtils.normalRectangle(enclosing, enclosingNorm);
        enclosedNorm = GeometryUtils.normalRectangle(enclosed, enclosedNorm);
        int W = GeometryUtils.enclosedNorm.width;
        int H = GeometryUtils.enclosedNorm.height;
        int width = GeometryUtils.enclosingNorm.width;
        int height = GeometryUtils.enclosingNorm.height;
        if (width <= 0 || height <= 0 || W <= 0 || H <= 0) {
            return false;
        }
        int X = GeometryUtils.enclosedNorm.x;
        int Y = GeometryUtils.enclosedNorm.y;
        int x = GeometryUtils.enclosingNorm.x;
        int y = GeometryUtils.enclosingNorm.y;
        return X >= x && Y >= y && X + W <= x + width && Y + H <= y + height;
    }

    public static synchronized boolean intersects(Rectangle enclosing, Rectangle enclosed) {
        enclosingNorm = GeometryUtils.normalRectangle(enclosing, enclosingNorm);
        enclosedNorm = GeometryUtils.normalRectangle(enclosed, enclosedNorm);
        int x11 = GeometryUtils.enclosingNorm.x;
        int x12 = GeometryUtils.enclosingNorm.x + GeometryUtils.enclosingNorm.width;
        int x21 = GeometryUtils.enclosedNorm.x;
        int x22 = GeometryUtils.enclosedNorm.x + GeometryUtils.enclosedNorm.width;
        int y11 = GeometryUtils.enclosingNorm.y;
        int y12 = GeometryUtils.enclosingNorm.y + GeometryUtils.enclosingNorm.height;
        int y21 = GeometryUtils.enclosedNorm.y;
        int y22 = GeometryUtils.enclosedNorm.y + GeometryUtils.enclosedNorm.height;
        return x22 >= x11 && x12 >= x21 && y22 >= y11 && y12 >= y21;
    }

    public static Rectangle normalRectangle(Rectangle unNormal, Rectangle normal) {
        Rectangle result;
        Rectangle rectangle = result = normal == null ? new Rectangle() : normal;
        if (unNormal.width < 0) {
            result.x = unNormal.x + unNormal.width;
            result.width = -unNormal.width;
        } else {
            result.x = unNormal.x;
            result.width = unNormal.width;
        }
        if (unNormal.height < 0) {
            result.y = unNormal.y + unNormal.height;
            result.height = -unNormal.height;
        } else {
            result.y = unNormal.y;
            result.height = unNormal.height;
        }
        return result;
    }

    public static void setToolSetRect(List tools, ToolRectangle groupRect, Short originator, double x, double y, double w, double h) {
        double width = groupRect.getSize().getWidth();
        double height = groupRect.getSize().getHeight();
        if (Math.abs(width) < 1.0) {
            width = 1.0;
        }
        if (Math.abs(height) < 1.0) {
            height = 1.0;
        }
        for (int i = 0; i < tools.size(); ++i) {
            Object object = tools.get(i);
            if (!(object instanceof AbstractToolModel)) continue;
            AbstractToolModel tool = (AbstractToolModel)object;
            tool.setOriginator(originator);
            double scaleX = w / width;
            double scaleY = h / height;
            double offsetX = tool.getEditStartRect().getLocation().getX() - groupRect.getLocation().getX();
            double offsetY = tool.getEditStartRect().getLocation().getY() - groupRect.getLocation().getY();
            tool.setRect(x + offsetX * scaleX, y + offsetY * scaleY, tool.getEditStartRect().getSize().getWidth() * scaleX, tool.getEditStartRect().getSize().getHeight() * scaleY);
        }
    }
}

