/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.conference.ClientIdentification;
import com.elluminate.groupware.whiteboard.dataModel.DisplayModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.util.ShortList;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class DisplayNode
extends DefaultMutableTreeNode {
    private DisplayModel displayModel = null;

    public DisplayNode() {
        this(null);
    }

    public DisplayNode(Object userObject) {
        this(userObject, true);
    }

    public DisplayNode(Object userObject, boolean allowsChildren) {
        this.parent = null;
        this.allowsChildren = allowsChildren;
        this.userObject = userObject;
        if (userObject instanceof WBNode) {
            ((WBNode)userObject).setDisplayPeer(this);
        }
    }

    @Override
    public void setUserObject(Object userObject) {
        super.setUserObject(userObject);
    }

    @Override
    public void remove(MutableTreeNode treeNode) {
        DisplayNode node;
        super.remove(treeNode);
        if (treeNode instanceof DisplayNode && (node = (DisplayNode)treeNode).getUserObject() != null) {
            node.whiteboardPeer().setDisplayPeer(null);
            node.setUserObject(null);
        }
    }

    public WBNode whiteboardPeer() {
        if (this.getUserObject() instanceof WBNode) {
            return (WBNode)this.getUserObject();
        }
        return null;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public void setDisplayModel(DisplayModel displayModel) {
        this.displayModel = displayModel;
    }

    public DisplayModel getDisplayModel() {
        DisplayNode node = this;
        while (node.getParent() != null) {
            node = (DisplayNode)node.getParent();
        }
        return node.displayModel;
    }

    public boolean isOnline() {
        WBNode peer = this.whiteboardPeer();
        if (peer instanceof WBNode && peer instanceof AbstractToolModel) {
            AbstractToolModel tool = (AbstractToolModel)peer;
            if (tool.context.getClientList() != null && tool.getObjectID() != null) {
                Short clientId = ShortList.get((short)tool.context.getObjectManager().getClientId(tool.getObjectID()));
                return tool.context.getIDProcessor().isOnline(clientId);
            }
        }
        return false;
    }

    @Override
    public String toString() {
        WBNode peer = this.whiteboardPeer();
        if (peer instanceof WBNode) {
            if (peer instanceof AbstractToolModel) {
                String name;
                Short clientId;
                AbstractToolModel tool = (AbstractToolModel)peer;
                if (tool.context.getClientList() != null && tool.getObjectID() != null && !ClientIdentification.SERVER_ID.equals(clientId = ShortList.get((short)tool.context.getObjectManager().getClientId(tool.getObjectID()))) && (name = tool.context.getIDProcessor().getClientName(clientId)) != null) {
                    if (!tool.context.getIDProcessor().isOnline(clientId)) {
                        return "<" + name + "> " + tool.getDisplayName();
                    }
                    return "(" + name + ") " + tool.getDisplayName();
                }
                return tool.getDisplayName();
            }
            return peer.getDisplayName();
        }
        if (this.getUserObject() instanceof String) {
            return (String)this.getUserObject();
        }
        return this.getClass().getName();
    }

    public boolean validate() {
        boolean validToolTree = false;
        boolean valid = true;
        if (this.getUserObject() instanceof WBNode) {
            ScreenModel screen;
            if (this.whiteboardPeer() instanceof ScreenModel && (screen = (ScreenModel)this.whiteboardPeer()).getToolTreeModel() != null) {
                if (screen.getToolTreeModel().getRoot() == this) {
                    validToolTree = true;
                } else {
                    valid &= screen.getToolTreeModel().validate();
                }
            }
            if (this.whiteboardPeer().getDisplayPeer() != this && !validToolTree) {
                Validator.log(this.getClass().getName() + ": WBNode does not reference peer: " + WBUtils.objectName(this.whiteboardPeer()));
                valid &= Validator.setValid(valid, false);
            }
        } else if (!(this.getUserObject() instanceof String)) {
            Validator.log(this.getClass().getName() + ": WhiteboardPeer does not reference a String.");
            valid = Validator.setValid(valid, false);
        }
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            TreeNode obj = enumeration.nextElement();
            if (obj instanceof DisplayNode) {
                valid &= ((DisplayNode)obj).validate();
                continue;
            }
            Validator.log(this.getClass().getName() + ": child is not a DisplayNode: " + obj);
            valid = Validator.setValid(valid, false);
        }
        return valid;
    }
}

