/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.dataModel;

import java.awt.Point;

public class DPoint
implements Cloneable {
    private static final long EQUAL_ROUNDING = 1000L;
    private double x;
    private double y;
    private Point integerPoint = new Point();

    public DPoint() {
    }

    public DPoint(double dX, double dY) {
        this.setX(dX);
        this.setY(dY);
    }

    public DPoint(Point p) {
        this.setX(p.x);
        this.setY(p.y);
    }

    public Object clone() throws CloneNotSupportedException {
        DPoint dPoint = (DPoint)super.clone();
        dPoint.integerPoint = new Point(this.integerPoint);
        return dPoint;
    }

    public boolean equals(DPoint dp) {
        long x1 = (long)(dp.getX() * 1000.0);
        long y1 = (long)(dp.getY() * 1000.0);
        long x2 = (long)(this.getX() * 1000.0);
        long y2 = (long)(this.getY() * 1000.0);
        return x1 == x2 && y1 == y2;
    }

    public Point getIntLocation() {
        return this.integerPoint;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double trueX) {
        this.x = trueX;
        this.integerPoint.x = this.setInt(trueX);
    }

    public void setY(double trueY) {
        this.y = trueY;
        this.integerPoint.y = this.setInt(trueY);
    }

    public void moveLocation(double deltaX, double deltaY) {
        this.x += deltaX;
        this.y += deltaY;
        this.integerPoint.x = this.setInt(this.x);
        this.integerPoint.y = this.setInt(this.y);
    }

    private int setInt(double doubleIn) {
        if (doubleIn > 2.147483647E9) {
            return Integer.MAX_VALUE;
        }
        if (doubleIn < -2.147483648E9) {
            return Integer.MIN_VALUE;
        }
        return (int)Math.floor(doubleIn);
    }

    public void setLocation(DPoint dPoint) {
        this.setX(dPoint.getX());
        this.setY(dPoint.getY());
    }

    public String toString() {
        return "X, Y: " + this.x + ", " + this.y + " int: " + this.integerPoint;
    }
}

