/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.GroupwareDebug;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.DataBlock;
import com.elluminate.groupware.whiteboard.conference.QueueBuffer;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.interfaces.NeedContext;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.JinxConnectionException;
import com.elluminate.jinx.ProtocolBuffer;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.io.DataOutputStream;

public class WhiteboardDataProcessor
implements ChannelDataListener,
ConnectionListener {
    private ClientList clients = null;
    private Channel commandChannel = null;
    private WhiteboardContext context;
    private Channel dataChannel;
    private QueueBuffer dataQueue = null;

    public WhiteboardDataProcessor(WhiteboardContext con) {
        this.context = con;
        this.dataChannel = null;
    }

    public void setChannel(Channel chnl) {
        if (chnl == null) {
            this.dispose();
            return;
        }
        if (chnl.getName().equals("whiteboardCommand")) {
            this.commandChannel = chnl;
        } else if (chnl.getName().equals("whiteboardData")) {
            this.dataChannel = chnl;
            this.dataChannel.getConnection().addConnectionListener((ConnectionListener)this);
        } else {
            throw new RuntimeException("Unknown channel: " + chnl.getName());
        }
        if (this.dataQueue == null) {
            this.dataQueue = new QueueBuffer("WhiteboardDataProcessor Data Queue", new OnChannelData(), false, this.context.getController() != null);
        }
    }

    public Channel getCommandChannel() {
        return this.commandChannel;
    }

    public Channel getDataChannel() {
        return this.dataChannel;
    }

    public boolean areChannelsUp() {
        return this.commandChannel != null && this.commandChannel.isUp() && this.dataChannel != null && this.dataChannel.isUp();
    }

    public void dispose() {
        if (this.dataQueue != null) {
            this.dataQueue.dispose();
        }
    }

    public void setClients(ClientList clients) {
        this.clients = clients;
    }

    public void onChannelData(ChannelDataEvent e) {
        if (this.dataQueue != null) {
            this.dataQueue.addElement(e.clone(), e.getChannel().equals("whiteboardCommand"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processChannelData(ChannelDataEvent cde) {
        if (cde.getCommand() == 7) {
            this.context.getDataExporter().receiveData(cde);
        } else {
            WBInputStream wbInputStream = null;
            try {
                wbInputStream = WBInputStream.inputStreamFactory(this.context, cde);
                this.processInputStream(wbInputStream);
            }
            finally {
                try {
                    wbInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processInputStream(WBInputStream istr) {
        Debug.lockEnter((Object)this, (String)"WhiteboardDataProcessor.processInputStream", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            try {
                while (istr.available() > 0) {
                    RegisteredTemplate temp = this.context.getTemplateRegistry().templateLocator(istr);
                    if (temp == null) continue;
                    if (temp.getContext() == null) {
                        Thread.currentThread();
                        Thread.dumpStack();
                    }
                    if (temp instanceof AbstractCommContainer) {
                        ((AbstractCommContainer)temp).streamToObject(istr);
                        continue;
                    }
                    LogSupport.error((String)("DataProcessor: data class not a CommContainer: " + temp));
                }
            }
            catch (Exception ex) {
                StackTraceElement[] els = ex.getStackTrace();
                if (els != null && els.length > 0) {
                    LogSupport.exception((Object)this, (String)"WhiteboardDataProcessor read stream exception:", (Throwable)ex, (boolean)true, (String)els[0].toString());
                }
                LogSupport.exception((Object)this, (String)"WhiteboardDataProcessor read stream exception:", (Throwable)ex, (boolean)true);
            }
        }
        Debug.lockLeave((Object)this, (String)"WhiteboardDataProcessor.processInputStream", (String)"DataModel", (Object)this.context.getDataModel());
    }

    public void sendDirective(byte directive, StreamableObject payload) {
        short targets = this.context.isClient() ? (short)0 : -2;
        this.sendDirective(directive, payload, targets);
    }

    public void sendDirective(byte directive, StreamableObject payload, short[] targets) {
        ProtocolBuffer buffer;
        WBOutputStream ostr = null;
        try {
            buffer = ProtocolBuffer.getInstance();
            ostr = new WBOutputStream(buffer.addPayload(), this.context);
            if (payload instanceof NeedContext && ((NeedContext)((Object)payload)).getContext() == null) {
                Validator.logAlways("WhiteboardDataProcessor(processChannelData) finds object: " + payload + " needing a context, but with a NULL context");
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (payload instanceof StreamableObject) {
                payload.objectToStream(ostr);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"SendDirective", (Throwable)ex, (boolean)true);
            return;
        }
        if (ostr != null) {
            try {
                ostr.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (int i = 0; i < targets.length; ++i) {
            if (!this.context.isOnline()) {
                return;
            }
            if (this.context.getClientList() == null || targets[i] == this.context.getClientList().getMyAddress()) continue;
            ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)targets[i], (byte)directive, (ProtocolBuffer)buffer);
            this.fireChannelData(cde, this.commandChannel);
        }
        buffer.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDirective(byte directive, StreamableObject payload, short targets) {
        if (!this.context.isOnline()) {
            return;
        }
        if (this.context.getClientList() != null && targets == this.context.getClientList().getMyAddress()) {
            return;
        }
        ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)targets, (byte)directive);
        WBOutputStream ostr = null;
        try {
            ostr = new WBOutputStream(cde.write(), this.context);
            if (payload instanceof NeedContext && ((NeedContext)((Object)payload)).getContext() == null) {
                Validator.logAlways("WhiteboardDataProcessor(processChannelData) finds object: " + payload + " needing a context, but with a NULL context");
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (payload instanceof StreamableObject) {
                payload.objectToStream(ostr);
            }
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"SendDirective", (Throwable)ex, (boolean)true);
            return;
        }
        finally {
            if (ostr != null) {
                try {
                    ostr.close();
                }
                catch (Exception e) {}
            }
        }
        this.fireChannelData(cde, this.commandChannel);
    }

    public void sendDirective(byte directive) {
        this.sendDirective(directive, null);
    }

    public void sendDirective(byte directive, byte[] payload, short targets) {
        ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)targets, (byte)directive);
        try {
            DataOutputStream ostr = cde.write();
            ostr.write(payload);
            ostr.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"SendDirective", (Throwable)ex, (boolean)true);
            return;
        }
        this.fireChannelData(cde, this.commandChannel);
    }

    public void sendNegotiatedData(DataBlock dataBlock, short target) {
        if (!this.context.isOnline()) {
            return;
        }
        ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)target, (byte)7);
        try {
            DataOutputStream ostr = cde.write();
            dataBlock.objectToStream(ostr);
            ostr.close();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"SendDirective", (Throwable)ex, (boolean)true);
            return;
        }
        this.fireChannelData(cde, this.dataChannel);
    }

    protected void fireChannelData(ChannelDataEvent cde, Channel channel) {
        if (channel != null && channel.isUp()) {
            channel.onChannelData(cde);
        } else {
            cde.dispose();
        }
    }

    public int getDataChannelSpeed() {
        int speed = this.dataChannel.getConnection().getMaxXmitSpeed();
        if (speed < 0) {
            speed = Integer.MAX_VALUE;
        }
        return speed;
    }

    public void connectionStatusChanged(ConnectionEvent event) throws JinxConnectionException {
        if (event.getSource() == this.dataChannel.getConnection()) {
            this.context.getDataExporter().setChannelSpeed(event);
        }
    }

    public String getDataQueueStatistics() {
        if (this.dataQueue != null) {
            return this.dataQueue.toString();
        }
        return "DataQueue not initialized";
    }

    class ChannelDataChangeUI
    implements Runnable {
        private ChannelDataEvent cde;

        public ChannelDataChangeUI(ChannelDataEvent e) {
            this.cde = (ChannelDataEvent)e.clone();
        }

        @Override
        public void run() {
            WhiteboardDataProcessor.this.processChannelData(this.cde);
            this.cde.dispose();
        }
    }

    class OnChannelData
    implements Runnable {
        OnChannelData() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ChannelDataEvent e;
            if (WhiteboardDataProcessor.this.dataQueue == null) {
                return;
            }
            while ((e = (ChannelDataEvent)WhiteboardDataProcessor.this.dataQueue.getNextElement()) != null) {
                try {
                    Debug.lockEnter((Object)this, (String)"WhiteboardDataProcessor.onChannelData", (String)"DataModel", (Object)WhiteboardDataProcessor.this.context.getDataModel());
                    DataModel dataModel = WhiteboardDataProcessor.this.context.getDataModel();
                    synchronized (dataModel) {
                        if (GroupwareDebug.EVENTS.show()) {
                            LogSupport.message((Object)this, (String)"onChannelData", (String)e.toString());
                        }
                        WhiteboardDataProcessor.this.processChannelData(e);
                    }
                    Debug.lockLeave((Object)this, (String)"WhiteboardDataProcessor.onChannelData", (String)"DataModel", (Object)WhiteboardDataProcessor.this.context.getDataModel());
                }
                catch (Throwable t) {
                    LogSupport.exception((Object)WhiteboardDataProcessor.this, (String)"OnChannelData", (Throwable)t, (boolean)true);
                }
                finally {
                    e.dispose();
                }
            }
        }
    }
}

