/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.WhiteboardDebug;
import com.elluminate.groupware.whiteboard.conference.AcknowledgeDeletion;
import com.elluminate.groupware.whiteboard.conference.AttributeChange;
import com.elluminate.groupware.whiteboard.conference.DataBlock;
import com.elluminate.groupware.whiteboard.conference.DataCodec;
import com.elluminate.groupware.whiteboard.conference.DeleteUID;
import com.elluminate.groupware.whiteboard.conference.ItemData;
import com.elluminate.groupware.whiteboard.conference.ProxyReceipt;
import com.elluminate.groupware.whiteboard.conference.ProxyTransfer;
import com.elluminate.groupware.whiteboard.conference.RefCount;
import com.elluminate.groupware.whiteboard.conference.ScreenExportData;
import com.elluminate.groupware.whiteboard.conference.ViewedScreens;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.MediaData;
import com.elluminate.groupware.whiteboard.dataModel.MediaEvent;
import com.elluminate.groupware.whiteboard.dataModel.MediaID;
import com.elluminate.groupware.whiteboard.dataModel.MediaItem;
import com.elluminate.groupware.whiteboard.dataModel.MediaListener;
import com.elluminate.groupware.whiteboard.dataModel.ObjectIDs;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.ScreenModel;
import com.elluminate.groupware.whiteboard.dataModel.ScreenRoot;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.StreamableObject;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.groupware.whiteboard.tools.GroupToolModel;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.io.DataOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ParticipantData
implements MediaListener {
    private HashMap<Long, WBNode> containersToSend = new HashMap();
    private HashMap<ScreenModel, ScreenExportData> screensWithData = new HashMap();
    private LinkedList<DeleteUID> newDeletionsList = new LinkedList();
    private LinkedList<DeleteUID> pendingDeletionsList = new LinkedList();
    private HashMap pendingProxies = new HashMap();
    private LinkedList<ProxyReceipt> pendingProxyReceipts = new LinkedList();
    private DataCodec dataCodec = null;
    private Short clientId = null;
    private short clientAddress = (short)-32767;
    ScreenModel lastBestScreen = null;
    private HashMap<ScreenModel, LinkedList<MediaRef>> mediaByScreen = new HashMap();
    private HashMap<MediaID, HashSet<ScreenModel>> screenByMedia = new HashMap();
    private LinkedList<MediaRef> mediaToMove = new LinkedList();
    private HashSet<MediaRef> mediaToMoveSet = new HashSet();
    private HashMap<MediaID, RefCount> mediaSent = new HashMap();
    private HashMap<MediaID, RefCount> mediaBeingSent = new HashMap();
    private ScreenModel screenWithMedia = null;
    private byte currentStatus = (byte)5;
    private byte sentStatus = (byte)5;
    private int statusState = 0;
    private long redStatusTime = 0L;
    private long yellowStatusTime = 0L;
    private HashSet<ItemData> itemsInTransit = new HashSet();
    private HashSet<Long> inTransitScreenUIDs = new HashSet();
    private boolean transitEntriesValid = false;
    private Runnable pulseEndTrigger;
    private int timerDepth = 0;
    private boolean viewedScreenWithMedia = false;
    private WhiteboardContext context = null;

    public ParticipantData(WhiteboardContext context, Collection screensToSend, Collection toolsToSend, Collection proxySet, Short clientId) {
        this.context = context;
        this.clientId = context.getIDProcessor().clientOfId(clientId);
        this.pulseEndTrigger = new Runnable(){

            @Override
            public void run() {
                ParticipantData.this.timerDepth++;
                ParticipantData.this.noteStatusChange();
                ParticipantData.this.timerDepth--;
            }
        };
        this.initialize(screensToSend, toolsToSend, proxySet);
        context.getMediaCache().addMediaListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Collection screensToSend, Collection toolsToSend, Collection proxySet) {
        try {
            Debug.lockEnter((Object)this, (String)"ParticipantData.toString", (String)"DataModel", (Object)this.context.getDataModel());
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                if (screensToSend != null && !this.context.isPlayback()) {
                    for (ScreenModel screen : screensToSend) {
                        this.containersToSend.put(screen.getObjectID(), screen);
                    }
                }
                if (toolsToSend != null && !this.context.isPlayback()) {
                    for (AbstractToolModel tool : toolsToSend) {
                        if (!tool.isContainer()) continue;
                        this.containersToSend.put(tool.getObjectID(), tool);
                    }
                    for (AbstractToolModel tool : toolsToSend) {
                        boolean sendProxy = !this.containersToSend.containsKey(tool.getParent().getObjectID()) && !proxySet.contains(new ObjectIDs(tool.getObjectID(), tool.getRevision()));
                        this.getScreenExportData(tool, true).addTool(tool, sendProxy);
                    }
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"ParticipantData.toString", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMediaCounts() {
        try {
            Debug.lockEnter((Object)this, (String)"ParticipantData.toString", (String)"DataModel", (Object)this.context.getDataModel());
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                this.mediaBeingSent.clear();
                this.mediaSent.clear();
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"ParticipantData.toString", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    public void initializeMedia(HashMap mediaMap) {
        this.mediaSent = mediaMap;
        this.mediaBeingSent.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLine() {
        try {
            Debug.lockEnter((Object)this, (String)"ParticipantData.toString", (String)"DataModel", (Object)this.context.getDataModel());
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                try {
                    this.clientAddress = this.context.getIDProcessor().getClientAddress(this.clientId);
                }
                catch (Exception e) {
                    LogSupport.error((Object)this, (String)"onLine", (String)("Unknown clientAddress: " + this.clientAddress + " for clientId: " + this.clientId));
                }
                this.context.getACLManager().reEvaluateAllTerms();
                this.invalidateLastBest(null);
                this.currentStatus = (byte)5;
                this.sentStatus = (byte)5;
                this.statusState = 0;
                this.yellowStatusTime = 0L;
                this.redStatusTime = 0L;
                if (this.pulseEndTrigger != null) {
                    try {
                        this.context.getTimedExecution().removeRunnable((Object)this.pulseEndTrigger);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.transitEntriesValid = true;
                this.inTransitScreenUIDs.clear();
                this.itemsInTransit.clear();
                if (this.getDataCodec() != null) {
                    this.getDataCodec().onLine(true);
                }
            }
        }
        finally {
            Debug.lockLeave((Object)this, (String)"ParticipantData.toString", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offLine() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.getDataCodec() != null) {
                this.getDataCodec().onLine(false);
            }
            this.pendingDeletionsList.clear();
            this.newDeletionsList.clear();
            this.containersToSend.clear();
            this.screensWithData.clear();
            this.pendingProxies.clear();
            this.pendingProxyReceipts.clear();
            this.mediaToMove.clear();
            this.mediaToMoveSet.clear();
            this.mediaBeingSent.clear();
            this.screenByMedia.clear();
            this.mediaByScreen.clear();
            this.invalidateLastBest(null);
            this.transitEntriesValid = true;
            this.inTransitScreenUIDs.clear();
            this.itemsInTransit.clear();
        }
    }

    public boolean isOnline() {
        return this.getDataCodec() != null && this.getDataCodec().isOnline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeletion(WBNode node, boolean supressDelete) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.removeItem(node);
            if (WhiteboardDebug.DELETIONS.show()) {
                String name = this.context.getIDProcessor().getClientName(this.clientId);
                LogSupport.message((Object)this, (String)"addDeletion", (String)("Considering deletion: " + node + ", to: " + this.clientId + " " + name + " (originator=" + this.clientId.equals(node.getOriginator()) + "), suppress=" + supressDelete));
            }
            if (!(node instanceof GroupToolModel || supressDelete || this.clientId.equals(node.getOriginator()))) {
                if (!this.isOnline()) {
                    this.newDeletionsList.clear();
                } else {
                    try {
                        this.newDeletionsList.add(new DeleteUID(node, this.context));
                        if (WhiteboardDebug.DELETIONS.show()) {
                            LogSupport.message((Object)this, (String)"addDeletion", (String)("Deletion added for: " + node + ", to: " + this.clientId));
                        }
                    }
                    catch (Exception ex) {
                        LogSupport.exception((Object)this, (String)"addDeletion", (Throwable)ex, (boolean)true, (String)("adding deletion for: " + node));
                    }
                }
                this.noteStatusChange();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProxyReceipt(ProxyReceipt proxyReceipt) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.pendingProxyReceipts.add(proxyReceipt);
            this.dataCodec.doWork();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToMediaSent(MediaID mediaID, RefCount initialRefCount) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            RefCount refCount = this.mediaBeingSent.get(mediaID);
            if (refCount == null) {
                refCount = this.mediaSent.get(mediaID);
            }
            if (refCount == null) {
                refCount = initialRefCount != null ? initialRefCount : new RefCount();
                this.mediaSent.put(mediaID, refCount);
            } else {
                refCount.increment();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMedia(ScreenModel screen, MediaData mediaData) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            MediaRef ref;
            RefCount refCount;
            if (mediaData.getMediaID().getLength() < 0) {
                System.err.println("ParticipantData.578, addMedia: has bad MediaID: " + mediaData);
            }
            if ((refCount = this.mediaSent.get(mediaData.getMediaID())) != null) {
                refCount.increment();
                return;
            }
            MediaID mediaID = mediaData.getMediaID();
            refCount = this.mediaBeingSent.get(mediaID);
            if (refCount == null) {
                refCount = new RefCount();
                this.mediaBeingSent.put(mediaID, refCount);
            } else {
                refCount.increment();
            }
            HashSet<ScreenModel> screens = this.screenByMedia.get(mediaID);
            if (screens == null) {
                screens = new HashSet();
                this.screenByMedia.put(mediaID, screens);
            }
            screens.add(screen);
            LinkedList<MediaRef> mediaList = this.mediaByScreen.get(screen);
            if (mediaList == null) {
                mediaList = new LinkedList();
                this.mediaByScreen.put(screen, mediaList);
            }
            if (!mediaList.contains(ref = new MediaRef(this.context, mediaID))) {
                mediaList.add(ref);
            }
            Collections.sort(mediaList);
            if (!this.mediaToMoveSet.contains(ref)) {
                this.mediaToMove.add(ref);
                this.mediaToMoveSet.add(ref);
                Collections.sort(this.mediaToMove);
            }
            this.screenWithMedia = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mediaReceived(MediaData mediaData) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            MediaID mediaID = mediaData.getMediaID();
            this.mediaReceived(mediaID, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mediaReceived(MediaID mediaID, boolean forceSent, boolean zeroRefCount) {
        int count = 0;
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            RefCount refCount = this.mediaBeingSent.remove(mediaID);
            if (refCount != null || forceSent) {
                if (forceSent) {
                    if (!zeroRefCount) {
                        count = this.context.getMediaCache().getRefCount(mediaID);
                    }
                    refCount = new RefCount(count);
                }
                if (this.mediaSent.put(mediaID, refCount) != null && !forceSent) {
                    LogSupport.error((Object)this, (String)"mediaReceived", (String)("clientId: " + this.clientId + ", calls mediaReceived when mediaSent has ref: " + refCount));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMedia(MediaID mediaID) {
        boolean result = false;
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.context.getMediaCache().getMediaItem(mediaID) == null) {
                return false;
            }
            MediaRef mediaRef = new MediaRef(this.context, mediaID);
            try {
                HashSet<ScreenModel> screens = this.screenByMedia.get(mediaID);
                if (screens != null) {
                    for (ScreenModel screen : screens) {
                        LinkedList<MediaRef> mediaList = this.mediaByScreen.get(screen);
                        if (mediaList == null) continue;
                        result |= mediaList.remove(mediaRef);
                        if (!mediaList.isEmpty()) continue;
                        mediaList = null;
                        if (this.mediaByScreen.remove(screen) == null) {
                            LogSupport.message((Object)this, (String)"removeMedia", (String)("screen not removed from mediaByScreen: " + screen));
                            continue;
                        }
                        result = true;
                    }
                    result |= this.screenByMedia.remove(mediaID) != null;
                }
            }
            catch (Exception e) {
                LogSupport.exception((Object)this, (String)"removeMedia", (Throwable)e, (boolean)true, (String)("removing: " + mediaID));
            }
            if (mediaRef != null) {
                result |= this.mediaToMove.remove(mediaRef);
                this.mediaToMoveSet.remove(mediaRef);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onMedia(MediaEvent event) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (event.getEventType() == 2) {
                MediaData mediaData = event.getMediaItem().getMediaData();
                this.removeMedia(mediaData.getMediaID());
                this.mediaBeingSent.remove(mediaData.getMediaID());
                this.mediaSent.remove(mediaData.getMediaID());
            }
            return false;
        }
    }

    @Override
    public ScreenModel getMediaScreen() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushMediaSent(MediaID mediaID) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            RefCount refCount = this.mediaSent.get(mediaID);
            if (refCount != null) {
                if (refCount.decrement()) {
                    if (this.mediaSent.remove(mediaID) == null) {
                        LogSupport.message((Object)this, (String)"flushMediaSent", (String)("mediaId not removed from mediaSent: " + mediaID));
                    } else {
                        this.removeMedia(mediaID);
                    }
                }
                return;
            }
            refCount = this.mediaBeingSent.get(mediaID);
            if (refCount != null) {
                if (refCount.decrement()) {
                    if (this.mediaBeingSent.remove(mediaID) == null) {
                        LogSupport.message((Object)this, (String)"flushMediaSent", (String)("mediaId not removed from mediaSent: " + mediaID));
                    } else {
                        this.removeMedia(mediaID);
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<ScreenModel> getScreensForMedia(MediaID mediaID) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (mediaID != null && this.screenByMedia != null) {
                return this.screenByMedia.get(mediaID);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transitDataIsEmpty() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            return this.inTransitScreenUIDs.isEmpty();
        }
    }

    public byte getCurrentStatus() {
        return this.currentStatus;
    }

    public byte getSentStatus() {
        return this.sentStatus;
    }

    public void setSentStatus(byte sentStatus) {
        this.sentStatus = sentStatus;
    }

    public void updateCurrentStatus() {
        this.currentStatus = this.getStatusFlags(this.clientId);
    }

    public void clearStatus() {
        this.sentStatus = (byte)5;
        this.updateCurrentStatus();
    }

    public int getStatusState() {
        return this.statusState;
    }

    public void setStatusState(int statusState) {
        this.statusState = statusState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean proxiesComplete() {
        if (this.pendingProxies.isEmpty() && this.pendingProxyReceipts.isEmpty()) {
            return true;
        }
        int loopLimit = 0;
        ProxyTransfer proxyTransfer = null;
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            while (!this.pendingProxies.isEmpty()) {
                if (++loopLimit > 1000) {
                    LogSupport.message((Object)this, (String)"ProxiesComplete", (String)"ParticipantData.proxiesComplete: loop limit");
                    loopLimit = 0;
                    LogSupport.log((Object)this, (String)"proxiesComplete", (String)this.toString());
                    this.pendingProxies.clear();
                    return true;
                }
                Object[] sExports = this.pendingProxies.values().toArray();
                for (int sIndex = 0; sIndex < sExports.length; ++sIndex) {
                    Integer nodeIndex;
                    ScreenExportData sExport = (ScreenExportData)sExports[sIndex];
                    if (!sExport.getScreenProxies().isEmpty()) {
                        Iterator screenIter = sExport.getScreen().iterateScreens();
                        while (screenIter.hasNext()) {
                            WBNode proxyScreen = (WBNode)screenIter.next();
                            nodeIndex = sExport.getScreenProxyIndex(proxyScreen);
                            if (nodeIndex != null) {
                                nodeIndex = new Integer(proxyScreen.getIndex());
                            }
                            if (nodeIndex == null) continue;
                            if (proxyTransfer == null) {
                                proxyTransfer = new ProxyTransfer(this.context);
                            }
                            proxyTransfer.addScreen(proxyScreen, nodeIndex);
                            if (sExport.getScreenProxies().remove(proxyScreen) != null) continue;
                            LogSupport.message((Object)this, (String)"ProxiesComplete", (String)("ParticipantData.proxiesComplete did not contain screen proxy: " + proxyScreen));
                        }
                    }
                    if (!sExport.getToolProxies().isEmpty()) {
                        WBNode proxyTool;
                        Iterator toolIter = sExport.getScreen().iterateTools();
                        while (toolIter.hasNext() && !sExport.getToolProxies().isEmpty()) {
                            proxyTool = (WBNode)toolIter.next();
                            if (!(proxyTool.getParent() instanceof ScreenModel)) continue;
                            nodeIndex = sExport.getToolProxyIndex(proxyTool);
                            if (nodeIndex != null) {
                                nodeIndex = new Integer(proxyTool.getIndex());
                            }
                            if (nodeIndex == null) continue;
                            if (proxyTransfer == null) {
                                proxyTransfer = new ProxyTransfer(this.context);
                            }
                            proxyTransfer.addTool(proxyTool, nodeIndex);
                            if (sExport.getToolProxies().remove(proxyTool.getObjectID()) != null) continue;
                            LogSupport.message((Object)this, (String)"ProxiesComplete", (String)("ParticipantData.proxiesComplete did not contain tool proxy: " + proxyTool));
                        }
                        Object[] toolProxies = sExport.getToolProxies().keySet().toArray();
                        for (int index = 0; index < toolProxies.length; ++index) {
                            try {
                                WBNode tool = (WBNode)this.context.getObjectManager().getObjectFromMap((Long)toolProxies[index]);
                                if (tool.getParent() instanceof GroupToolModel) {
                                    GroupToolModel groupTool = (GroupToolModel)tool.getParent();
                                    if (this.isContainerSent(groupTool)) {
                                        Iterator groupIter = groupTool.iterateTools();
                                        while (groupIter.hasNext()) {
                                            proxyTool = (WBNode)groupIter.next();
                                            nodeIndex = sExport.getToolProxyIndex(proxyTool);
                                            if (nodeIndex != null) {
                                                nodeIndex = new Integer(proxyTool.getIndex());
                                            }
                                            if (nodeIndex == null) continue;
                                            if (proxyTransfer == null) {
                                                proxyTransfer = new ProxyTransfer(this.context);
                                            }
                                            proxyTransfer.addTool(proxyTool, nodeIndex);
                                            if (sExport.getToolProxies().remove(proxyTool.getObjectID()) != null) continue;
                                            LogSupport.message((Object)this, (String)"ProxiesComplete", (String)("ParticipantData.proxiesComplete did not contain group proxy: " + proxyTool));
                                        }
                                    } else {
                                        LogSupport.message((Object)this, (String)"proxiesComplete", (String)("toolProxy with containers to send false: " + tool.getParent()));
                                    }
                                    sExport.getToolProxies().remove(tool.getObjectID());
                                    continue;
                                }
                                LogSupport.message((Object)this, (String)"proxiesComplete", (String)("toolProxy with non-screen, non-group parent: " + tool.getParent()));
                                continue;
                            }
                            catch (Exception ex) {
                                LogSupport.exception((Object)this, (String)"proxiesComplete", (Throwable)ex, (boolean)true);
                                if (sExport.getToolProxies().remove(toolProxies[index]) != null) continue;
                                LogSupport.message((Object)this, (String)"proxiesComplete", (String)("tool not removed from toolProxies: " + toolProxies[index]));
                            }
                        }
                        if (!sExport.getScreenProxies().isEmpty()) {
                            LogSupport.message((Object)this, (String)"ProxiesComplete", (String)"ScreenProxies is not empty");
                            sExport.getScreenProxies().clear();
                        }
                        if (!sExport.getToolProxies().isEmpty()) {
                            LogSupport.message((Object)this, (String)"ProxiesComplete", (String)"ToolProxies is not empty");
                            sExport.getToolProxies().clear();
                        }
                        if (this.pendingProxies.remove(sExport.getScreen()) == null) {
                            LogSupport.message((Object)this, (String)"proxiesComplete", (String)("screen not removed from pendingProxies: " + sExport.getScreen()));
                        }
                    }
                    if (proxyTransfer != null) {
                        this.dataCodec.forceItemData(proxyTransfer, this.pendingProxies.isEmpty());
                        proxyTransfer = null;
                    }
                    sExport.cleanExportData();
                }
            }
            while (!this.pendingProxyReceipts.isEmpty()) {
                ProxyReceipt proxyReceipt = this.pendingProxyReceipts.removeFirst();
                this.dataCodec.forceItemData(proxyReceipt, this.pendingProxyReceipts.isEmpty());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deletionsComplete(DataBlock dataBlock) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.newDeletionsList.isEmpty()) {
                this.noteStatusChange();
                return true;
            }
            short entryCount = 0;
            if (dataBlock.isFull(20)) {
                return false;
            }
            DataBlock.DataBlockEntry entry = dataBlock.getDataBlockEntry();
            entry.putShort((short)-32767);
            int countIndex = entry.putShort((short)0);
            Iterator iter = this.newDeletionsList.iterator();
            while (iter.hasNext() && !dataBlock.isFull(8)) {
                DeleteUID dUID = (DeleteUID)iter.next();
                entry.putShort(ObjectUID.decodeClientId((long)dUID.getUID()));
                entry.putInt(ObjectUID.decodeSequence((long)dUID.getUID()));
                entryCount = (short)(entryCount + 1);
                iter.remove();
                this.pendingDeletionsList.add(dUID);
            }
            entry.putShort(entryCount, countIndex);
            return entryCount == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDeletions(WBOutputStream ostr) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            try {
                this.ressurectDeletions();
                ostr.writeShort(this.newDeletionsList.size());
                Iterator iter = this.newDeletionsList.iterator();
                while (iter.hasNext()) {
                    DeleteUID dUID = (DeleteUID)iter.next();
                    dUID.objectToStream(ostr);
                    iter.remove();
                    this.pendingDeletionsList.add(dUID);
                }
                this.newDeletionsList.clear();
            }
            catch (Exception e) {
                LogSupport.exception((Object)this, (String)"sendDeltions", (Throwable)e, (boolean)true);
            }
        }
    }

    public static void sendEmptyDeletions(DataOutputStream ostr) {
        try {
            ostr.writeShort(0);
        }
        catch (Exception ex) {
            LogSupport.exception(ParticipantData.class, (String)"sendEmptyDeletions", (Throwable)ex, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveDeletions(WBInputStream istr, boolean process) {
        DeleteUID dUID = null;
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.context.getDataExporter().blockCodecs();
            try {
                int deleteCount = WBUtils.readShort(istr, "ParticipantData.receiveDeletions reads delete count address(" + this.clientAddress() + ")");
                for (int i = 0; i < deleteCount; ++i) {
                    dUID = new DeleteUID(istr);
                    if (!process) continue;
                    Long uid = dUID.getUID();
                    WBNode node = (WBNode)this.context.getObjectManager().getObjectFromMap(uid);
                    if (node == null) continue;
                    node.setNodeReparenting(false);
                    node.setOriginator(istr.getOriginatorId());
                    if (node instanceof ScreenRoot) {
                        this.context.getDataModel().removeScreenGroup((ScreenRoot)node);
                    } else if (node.getParent() != null) {
                        node.getParent().remove(node);
                    } else if (WhiteboardDebug.DELETIONS.show()) {
                        LogSupport.message((Object)this, (String)"receiveDeletions", (String)("node: " + WBUtils.objectName(node) + ", with null boardParent."));
                    }
                    node.delete();
                }
                if (deleteCount > 0) {
                    this.context.getDataProcessor().sendDirective((byte)5, (StreamableObject)new AcknowledgeDeletion(this.context, dUID.getUID(), dUID.getRevision()), istr.getCde().getSourceAddress());
                }
            }
            catch (Exception e) {
                LogSupport.exception((Object)this, (String)"receiveDeletions", (Throwable)e, (boolean)true);
            }
            finally {
                this.context.getDataExporter().unblockCodecs();
            }
        }
    }

    public static void receiveEmptyDeletions(WBInputStream istr, boolean process) {
        DeleteUID dUID = null;
        try {
            int deleteCount = WBUtils.readShort(istr, "ParticipantData.receiveEmptyDeletions reads delete count");
            for (int i = 0; i < deleteCount; ++i) {
                dUID = new DeleteUID(istr);
            }
            if (deleteCount > 0) {
                istr.getContext().getDataProcessor().sendDirective((byte)5, (StreamableObject)new AcknowledgeDeletion(istr.getContext(), dUID.getUID(), dUID.getRevision()), istr.getCde().getSourceAddress());
            }
        }
        catch (Exception ex) {
            LogSupport.exception(ParticipantData.class, (String)"receiveEmptyDeletions", (Throwable)ex, (boolean)true);
        }
    }

    public static void receiveDeletionsString(WBInputStream istr, StringBuffer buf) {
        try {
            int deleteCount = WBUtils.readShort(istr, "ParticipantData.receiveDeletions reads delete count");
            for (int i = 0; i < deleteCount; ++i) {
                DeleteUID dUID = new DeleteUID(istr);
                Long uid = dUID.getUID();
                istr.getContext().getObjectManager().getObjectFromMap(uid);
                buf.append("\n  Delete: Rev: " + dUID.getRevision() + ", " + WBUtils.objectName(uid, istr.getContext()));
            }
        }
        catch (Exception ex) {
            LogSupport.exception(ParticipantData.class, (String)"receiveDeletionsString", (Throwable)ex, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeDeletion(Long uid, short revision) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Iterator iter = this.pendingDeletionsList.iterator();
            while (iter.hasNext()) {
                DeleteUID dUID = (DeleteUID)iter.next();
                iter.remove();
                if (dUID.getUID().longValue() != uid.longValue() || dUID.revision != revision) continue;
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ressurectDeletions() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.pendingDeletionsList.isEmpty()) {
                return;
            }
            for (DeleteUID dUID : this.pendingDeletionsList) {
                this.newDeletionsList.add(dUID);
            }
            this.pendingDeletionsList.clear();
        }
    }

    public DataCodec getDataCodec() {
        if (this.dataCodec == null) {
            this.dataCodec = new DataCodec(this, this.context);
        }
        return this.dataCodec;
    }

    public short getClientAddress() {
        return this.clientAddress;
    }

    public Short getClientId() {
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getStatusFlags(Short clientId) {
        byte result = 5;
        ScreenModel currentScreen = null;
        boolean addRunnable = false;
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Set screenUIDSet = this.context.getDataExporter().getViewedScreens().getScreensForClient(clientId);
            if (screenUIDSet != null) {
                for (Long currentScreenUID : screenUIDSet) {
                    result = (byte)(result | 4);
                    try {
                        currentScreen = (ScreenModel)this.context.getObjectManager().getObjectFromMap(currentScreenUID);
                        if (currentScreen != null && currentScreen instanceof ScreenRoot) {
                            currentScreen = ((ScreenRoot)currentScreen).getScreenDelegate();
                        }
                        if (!this.isScreenInTransit(currentScreen)) continue;
                        result = (byte)(result | 8);
                        this.redStatusTime = System.currentTimeMillis() + 250L;
                    }
                    catch (Exception ex) {}
                }
            }
            if (System.currentTimeMillis() < this.redStatusTime && this.timerDepth == 0) {
                result = (byte)(result | 0xC);
                addRunnable = true;
            }
            if ((result & 8) != 0) {
                // empty if block
            }
            result = (byte)(result | 1);
            if (!this.transitDataIsEmpty() || !this.newDeletionsList.isEmpty() || this.hasMoreWork()) {
                result = (byte)(result | 2);
                if (this.transitDataIsEmpty() || this.hasMoreWork() || !this.newDeletionsList.isEmpty()) {
                    result = (byte)(result | 3);
                }
                this.yellowStatusTime = System.currentTimeMillis() + 250L;
            }
            if (System.currentTimeMillis() < this.yellowStatusTime && this.timerDepth == 0) {
                result = (byte)(result | 3);
                addRunnable = true;
            }
            if (addRunnable) {
                long fireTime = 500L;
                fireTime = this.yellowStatusTime > this.redStatusTime ? (fireTime += this.yellowStatusTime) : (fireTime += this.redStatusTime);
                this.context.getTimedExecution().addRunnable(fireTime, (Object)this.pulseEndTrigger, this.pulseEndTrigger);
            }
            return result;
        }
    }

    public void noteDataInTransit(ItemData item) {
        if (item != null) {
            item.noteInTransitFor(this);
            this.itemsInTransit.add(item);
            this.invalidateTransitEntries();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doneDataInTransit(ItemData item) {
        boolean removed = this.itemsInTransit.isEmpty();
        if (item != null && !removed) {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                removed = this.itemsInTransit.remove(item);
                if (removed) {
                    this.invalidateTransitEntries();
                }
            }
        }
        return removed;
    }

    boolean isInTransit(ItemData item) {
        return this.itemsInTransit.contains(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateTransitEntries() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.transitEntriesValid = false;
            this.noteStatusChange();
        }
    }

    public ItemData getMediaItem(Long mediaID) {
        if (mediaID == null) {
            return null;
        }
        ItemData itemData2 = null;
        for (ItemData itemData2 : this.itemsInTransit) {
            if (!itemData2.getScreenUID().equals(mediaID)) continue;
            return itemData2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransitRefs() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.itemsInTransit.clear();
            this.inTransitScreenUIDs.clear();
        }
    }

    private void rebuildScreensInTransit() {
        HashSet<Long> newInTransitScreenUIDs = new HashSet<Long>();
        for (ItemData item : this.itemsInTransit) {
            Long uid = item.getScreenUID();
            if ((uid & Long.MIN_VALUE) == 0L) {
                newInTransitScreenUIDs.add(uid);
                continue;
            }
            HashSet screens = this.context.getMediaCache().getScreenUIDSet(uid);
            for (Long screenUID : screens) {
                newInTransitScreenUIDs.add(screenUID);
            }
        }
        this.inTransitScreenUIDs = newInTransitScreenUIDs;
        this.transitEntriesValid = true;
    }

    public boolean isScreenInTransit(ScreenModel screen) {
        return this.context.getDataExporter() == null ? false : this.isScreenInTransit(screen.getObjectID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isScreenInTransit(Long screenUID) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (!this.transitEntriesValid) {
                this.rebuildScreensInTransit();
            }
            return this.inTransitScreenUIDs.contains(screenUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteStatusChange() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (this.context.getStatus() != null) {
                this.updateCurrentStatus();
                this.context.getStatus().noteStatusChange(this.clientId);
            }
        }
    }

    public HashMap<Long, WBNode> getContainersToSend() {
        return this.containersToSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isContainerSent(WBNode container) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean isSent = !this.containersToSend.containsKey(container.getObjectID());
            return isSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMediaSent(MediaID mediaID) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean result = this.mediaSent.containsKey(mediaID);
            return result;
        }
    }

    public HashMap getScreensWithProxies() {
        return this.pendingProxies;
    }

    public ScreenExportData getScreenProxyData(WBNode screen) {
        return (ScreenExportData)this.pendingProxies.get(screen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScreensWithProxies(WBNode screen, ScreenExportData sExport) {
        if (screen instanceof ScreenModel) {
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                this.pendingProxies.put(screen, sExport);
            }
        } else {
            Thread.dumpStack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreenExportData getScreenExportData(WBNode node, boolean create) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ScreenModel screen;
            if (node instanceof ScreenModel) {
                screen = (ScreenModel)node;
            } else {
                if (node == null) {
                    System.out.println("ParticipantData.getScreenExportData: Null node");
                }
                screen = node.findScreenParent();
            }
            ScreenExportData screenExportData = this.screensWithData.get(screen);
            if (screenExportData == null && create) {
                screenExportData = new ScreenExportData(this.context, this, screen);
                this.screensWithData.put(screen, screenExportData);
                this.updateCurrentStatus();
            }
            return screenExportData;
        }
    }

    public boolean removeScreenExportData(ScreenModel screen) {
        boolean removed;
        boolean bl = removed = this.screensWithData.remove(screen) != null;
        if (removed) {
            // empty if block
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.context.getMediaCache().removeMediaListener(this);
            this.containersToSend.clear();
            this.screensWithData.clear();
            this.dataCodec.dispose();
            this.newDeletionsList.clear();
            this.pendingDeletionsList.clear();
            this.mediaToMove.clear();
            this.mediaToMoveSet.clear();
            this.pendingProxyReceipts.clear();
            if (this.screenByMedia != null) {
                this.screenByMedia.clear();
                this.mediaByScreen.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreWork() {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            return !this.containersToSend.isEmpty() || !this.screensWithData.isEmpty() || !this.newDeletionsList.isEmpty() || !this.mediaToMove.isEmpty() || !this.pendingProxyReceipts.isEmpty();
        }
    }

    public String hasMoreWorkString() {
        return "hasMoreWork: containersToSend.isEmpty: " + this.containersToSend.isEmpty() + ", screensWithData.isEmpty: " + this.screensWithData.isEmpty() + ", newDeletions.isEmpty: " + this.newDeletionsList.isEmpty() + ", mediaToMove.isEmpty: " + this.mediaToMove.isEmpty() + ", pendingProxyReceipts: " + this.pendingProxyReceipts.isEmpty() + "\n" + this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RegisteredTemplate getBestItem(DataBlock dataBlock) {
        RegisteredTemplate result = null;
        ScreenModel bestScreen = null;
        boolean haveData = false;
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            boolean hasContainer;
            if (this.lastBestScreen != null && !(haveData = this.screensWithData.containsKey(this.lastBestScreen)) && !this.containersToSend.containsKey(this.lastBestScreen)) {
                this.lastBestScreen = null;
            }
            if (this.screenWithMedia != null && !this.mediaByScreen.containsKey(this.screenWithMedia)) {
                this.screenWithMedia = null;
            }
            boolean hasWork = !this.screensWithData.isEmpty();
            boolean bl = hasContainer = !this.containersToSend.isEmpty();
            if (this.lastBestScreen != null) {
                bestScreen = this.lastBestScreen;
            } else {
                haveData = true;
                if (hasWork) {
                    bestScreen = this.getClientScreenWithData();
                }
            }
            if (bestScreen == null && (hasWork || hasContainer)) {
                this.viewedScreenWithMedia = false;
                if (hasWork) {
                    bestScreen = this.getClosestWorkScreen();
                }
                if (bestScreen == null && !this.viewedScreenWithMedia) {
                    if (hasContainer) {
                        bestScreen = this.getBestNoWorkScreen();
                    }
                    if (bestScreen == null) {
                        if (hasWork) {
                            bestScreen = this.getNextWorkScreen();
                        }
                        if (bestScreen == null) {
                            if (hasContainer) {
                                bestScreen = this.getNextNoWorkScreen();
                            }
                            haveData = false;
                        }
                    } else {
                        haveData = false;
                    }
                }
            }
            if (bestScreen != null) {
                if (haveData) {
                    ScreenExportData screenExportData = this.screensWithData.get(bestScreen);
                    if (screenExportData == null) {
                        LogSupport.message((Object)this, (String)"getBestItem", (String)this.toString());
                        throw new RuntimeException("ParticipantData.getBestItem address(" + this.clientAddress() + "): screen with data has no data: " + WBUtils.objectName(bestScreen));
                    }
                    RegisteredTemplate bestTemplate = screenExportData.getBestAttributeChange();
                    if (bestTemplate == null && (bestTemplate = screenExportData.getBestTool()) == null) {
                        LogSupport.message((Object)this, (String)"getBestItem", (String)("getBestItem: " + this.toString()));
                        screenExportData.cleanExportData();
                        throw new RuntimeException("Cannot find tool on screen with data: " + bestScreen);
                    }
                    result = this.makeAncestorLive(bestTemplate);
                } else {
                    result = this.makeAncestorLive(bestScreen);
                }
            } else {
                LinkedList<MediaRef> mediaList;
                MediaRef ref = null;
                if (this.screenWithMedia == null) {
                    this.screenWithMedia = this.getClosestMediaScreen();
                }
                if (this.screenWithMedia != null && (mediaList = this.mediaByScreen.get(this.screenWithMedia)) != null) {
                    ref = mediaList.getFirst();
                }
                if (ref == null) {
                    if (!this.mediaToMove.isEmpty()) {
                        ref = this.mediaToMove.getFirst();
                    } else {
                        LogSupport.message((Object)this, (String)"getBestItem", (String)("Ran out of work:\n" + this.toString()));
                    }
                }
                try {
                    if (ref.getMediaID().getLength() > 0) {
                        MediaItem mediaItem = ref.getItem();
                        result = mediaItem.getMediaData();
                    } else {
                        this.removeMedia(ref.getMediaID());
                    }
                }
                catch (Exception e) {
                    LogSupport.message((Object)this, (String)"getBestItem", (String)("ParticipantData.getBestItem, exception in getting MediaItem data: " + e.getMessage() + "\n" + this.toString()));
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateLastBest(RegisteredTemplate item) {
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (item == null) {
                this.lastBestScreen = null;
                this.screenWithMedia = null;
            } else {
                if (this.lastBestScreen == item) {
                    this.lastBestScreen = null;
                }
                if (this.screenWithMedia == item) {
                    this.screenWithMedia = null;
                }
            }
        }
    }

    private ScreenModel getClientScreenWithData() {
        ScreenModel screen = null;
        Set clientsScreens = this.context.getDataExporter().getClientsScreens(this.clientId);
        if (clientsScreens == null) {
            return null;
        }
        for (Long screenUID : clientsScreens) {
            try {
                screen = (ScreenModel)this.context.getObjectManager().getObjectFromMap(screenUID);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (screen == null || !this.screensWithData.containsKey(screen)) continue;
            return screen;
        }
        return null;
    }

    private ScreenModel getClosestWorkScreen() {
        ScreenModel bestScreen = null;
        float bestSpan = Float.MAX_VALUE;
        Iterator iter = this.context.getDataExporter().getViewedScreens().getViewedScreens().iterator();
        while (iter.hasNext()) {
            ViewedScreens.ScreenViewerList screenList = (ViewedScreens.ScreenViewerList)iter.next();
            ScreenModel screen = screenList.getScreen();
            if (screen != null && screen.getParent() != null) {
                WBNode object;
                int prevIndex;
                if (this.screensWithData.containsKey(screen)) {
                    return screen;
                }
                if (this.context.getController() == null) {
                    // empty if block
                }
                int myIndex = screen.getIndex();
                float screenWeight = screenList.size();
                float prevSpan = Float.MAX_VALUE;
                float postSpan = Float.MAX_VALUE;
                int postIndex = myIndex + 1;
                WBNode siblingParent = screen.getParent();
                for (prevIndex = myIndex - 1; prevIndex >= 0 && prevIndex >= myIndex - 1; --prevIndex) {
                    object = siblingParent.getChildAt(prevIndex);
                    if (this.mediaByScreen != null && this.mediaByScreen.containsKey(object)) {
                        this.viewedScreenWithMedia |= true;
                    }
                    if (!this.screensWithData.containsKey(object)) continue;
                    prevSpan = (float)(myIndex - prevIndex) * 3.0f / screenWeight;
                    break;
                }
                while (postIndex < siblingParent.getChildCount() && postIndex <= myIndex + 3) {
                    object = siblingParent.getChildAt(postIndex);
                    if (this.mediaByScreen != null && this.mediaByScreen.containsKey(object)) {
                        this.viewedScreenWithMedia |= true;
                    }
                    if (this.screensWithData.containsKey(object)) {
                        postSpan = (float)(postIndex - myIndex) * 1.0f / screenWeight;
                        break;
                    }
                    ++postIndex;
                }
                if (prevSpan < postSpan) {
                    if (!(prevSpan < bestSpan)) continue;
                    object = siblingParent.getChildAt(prevIndex);
                    if (object instanceof ScreenModel) {
                        bestSpan = prevSpan;
                        bestScreen = (ScreenModel)object;
                        continue;
                    }
                    LogSupport.message((Object)this, (String)"getClosestWorkScreen", (String)("getClosestWorkScreen sees prev: " + object));
                    continue;
                }
                if (!(postSpan < bestSpan)) continue;
                object = siblingParent.getChildAt(postIndex);
                if (object instanceof ScreenModel) {
                    bestSpan = postSpan;
                    bestScreen = (ScreenModel)object;
                    continue;
                }
                LogSupport.message((Object)this, (String)"getClosestWorkScreen", (String)("getClosestWorkScreen sees next: " + object));
                continue;
            }
            if (screen == null || screen.getParent() != null) continue;
            LogSupport.message((Object)this, (String)"getClosestWorkScreen", (String)("null parent for viewed Screen: " + screen));
            iter.remove();
        }
        return bestScreen;
    }

    private ScreenModel getClosestMediaScreen() {
        ScreenModel bestScreen = null;
        float bestSpan = Float.MAX_VALUE;
        if (this.screenWithMedia != null || this.mediaByScreen == null || this.mediaByScreen.isEmpty()) {
            return null;
        }
        for (ViewedScreens.ScreenViewerList screenList : this.context.getDataExporter().getViewedScreens().getViewedScreens()) {
            WBNode object;
            int prevIndex;
            ScreenModel screen = screenList.getScreen();
            if (screen == null || screen.getParent() == null) continue;
            if (this.mediaByScreen.containsKey(screen)) {
                return screen;
            }
            if (this.context.getController() == null) {
                // empty if block
            }
            int myIndex = screen.getIndex();
            float screenWeight = screenList.size();
            float prevSpan = Float.MAX_VALUE;
            float postSpan = Float.MAX_VALUE;
            int postIndex = myIndex + 1;
            WBNode siblingParent = screen.getParent();
            for (prevIndex = myIndex - 1; prevIndex >= 0 && prevIndex >= myIndex - 1; --prevIndex) {
                object = siblingParent.getChildAt(prevIndex);
                if (!this.mediaByScreen.containsKey(object)) continue;
                prevSpan = (float)(myIndex - prevIndex) * 3.0f / screenWeight;
                break;
            }
            while (postIndex < siblingParent.getChildCount() && postIndex <= myIndex + 3) {
                object = siblingParent.getChildAt(postIndex);
                if (this.mediaByScreen.containsKey(object)) {
                    postSpan = (float)(postIndex - myIndex) * 1.0f / screenWeight;
                    break;
                }
                ++postIndex;
            }
            if (prevSpan < postSpan) {
                if (!(prevSpan < bestSpan)) continue;
                bestSpan = prevSpan;
                bestScreen = (ScreenModel)siblingParent.getChildAt(prevIndex);
                continue;
            }
            if (!(postSpan < bestSpan)) continue;
            bestSpan = postSpan;
            bestScreen = (ScreenModel)siblingParent.getChildAt(postIndex);
        }
        return bestScreen;
    }

    private ScreenModel getBestNoWorkScreen() {
        ScreenModel screen = null;
        Iterator iter = this.context.getDataExporter().getViewedScreens().viewedScreenListIterator();
        while (iter.hasNext()) {
            screen = (ScreenModel)iter.next();
            if (screen == null || this.isContainerSent(screen)) continue;
            return screen;
        }
        return null;
    }

    private ScreenModel getNextWorkScreen() {
        ScreenModel screen2 = null;
        ScreenModel bestScreen = null;
        int bestScreenIndex = Integer.MAX_VALUE;
        for (ScreenModel screen2 : this.screensWithData.keySet()) {
            int index;
            if (screen2 == null || (index = screen2.getIndex()) < 0 || index >= bestScreenIndex) continue;
            bestScreenIndex = index;
            bestScreen = screen2;
        }
        return bestScreen;
    }

    private ScreenModel getNextNoWorkScreen() {
        WBNode container2 = null;
        ScreenModel bestScreen = null;
        int bestScreenIndex = Integer.MAX_VALUE;
        for (WBNode container2 : this.containersToSend.values()) {
            int index;
            if (!(container2 instanceof ScreenModel) || (index = container2.getIndex()) < 0 || index >= bestScreenIndex) continue;
            bestScreenIndex = index;
            bestScreen = (ScreenModel)container2;
        }
        return bestScreen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeItem(RegisteredTemplate item) {
        ScreenModel screen = null;
        boolean result = false;
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            block23: {
                try {
                    if (item instanceof AttributeChange) {
                        AttributeChange attributeChange = (AttributeChange)item;
                        if (attributeChange == null || attributeChange.getParent() == null || attributeChange.getParent().getParent() == null) {
                            LogSupport.message((Object)this, (String)"removeItem", (String)this.toString());
                            return false;
                        }
                        Object mapObject = this.context.getObjectManager().getObjectFromMap(attributeChange.getToolUID());
                        if (mapObject instanceof AbstractToolModel) {
                            screen = ((AbstractToolModel)mapObject).findScreenParent();
                        } else if (mapObject instanceof ScreenModel) {
                            screen = (ScreenModel)mapObject;
                        } else {
                            LogSupport.message((Object)this, (String)"ProxiesComplete", (String)("ParticipantData.removeItem address(" + this.clientAddress() + "): " + "attribute parent is not tool or screen: " + WBUtils.objectName(item)));
                        }
                        ScreenExportData screenExportData = this.screensWithData.get(screen);
                        if (screenExportData != null) {
                            result = screenExportData.removeAttributeChange(attributeChange);
                            screenExportData.cleanExportData();
                            if (!screenExportData.hasWork()) {
                                this.removeScreenExportData(screen);
                                this.updateCurrentStatus();
                            }
                        }
                        break block23;
                    }
                    if (item instanceof WBNode) {
                        WBNode wbNode = (WBNode)item;
                        if (wbNode instanceof ScreenModel) {
                            ScreenExportData screenExportData = this.screensWithData.get(wbNode);
                            if (screenExportData != null) {
                                result = screenExportData.removeAttributes(wbNode);
                                screenExportData.cleanExportData();
                            }
                        } else if (wbNode.isTool()) {
                            screen = wbNode.findScreenParent();
                            ScreenExportData screenExportData = this.screensWithData.get(screen);
                            if (screenExportData != null) {
                                result = screenExportData.removeTool(wbNode);
                                screenExportData.cleanExportData();
                            }
                        } else if (wbNode instanceof AbstractToolModel) {
                            LogSupport.message((Object)this, (String)"removeitem", (String)("tool item is not classified as a tool" + wbNode));
                        }
                        if (wbNode.isContainer()) {
                            this.containersToSend.remove(wbNode.getObjectID());
                        }
                        break block23;
                    }
                    if (item instanceof MediaData) {
                        this.mediaReceived((MediaData)item);
                        result = this.removeMedia(((MediaData)item).getMediaID());
                        break block23;
                    }
                    throw new RuntimeException("ParticipantData.removeItem address(" + this.clientAddress() + ") to be removed is: " + item.getClass().getName());
                }
                catch (Exception e) {
                    LogSupport.exception((Object)this, (String)"removeItem", (Throwable)e, (boolean)true);
                }
            }
            this.invalidateLastBest(item);
            return result;
        }
    }

    private RegisteredTemplate makeAncestorLive(RegisteredTemplate template) {
        RegisteredTemplate result = null;
        if (template == null) {
            LogSupport.message((Object)this, (String)"makeAncestorLive", (String)("Supplied template is null.ParticipantData:\n" + this.toString()));
            throw new RuntimeException("Null template supplied to makeAncestorLive");
        }
        if (template instanceof WBNode) {
            WBNode node = (WBNode)template;
            while (!(node instanceof ScreenRoot) && node.getParent() != null && !this.isContainerSent(node.getParent())) {
                node = node.getParent();
            }
            result = node;
        } else if (template instanceof AttributeChange) {
            result = template;
            WBNode node = (WBNode)this.makeAncestorLive(((AttributeChange)template).getParent());
            if (!this.isContainerSent(node)) {
                result = node;
            }
        }
        return result;
    }

    private Short clientAddress() {
        return this.context.getIDProcessor().getClientAddress(this.clientId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        Debug.lockEnter((Object)this, (String)"ParticipantData.toString", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Iterator iter2;
            buf.append("\nParticipantData address(" + this.clientAddress() + ") - Containers To Send (" + this.containersToSend.size() + "):\n");
            Collection<Object> wbNodes = this.containersToSend.values();
            Iterator<Object> iter = wbNodes.iterator();
            while (iter.hasNext()) {
                buf.append("    " + iter.next());
            }
            buf.append("\nParticipantData - Screens With Data(" + this.screensWithData.size() + "):\n");
            wbNodes = this.screensWithData.values();
            iter = wbNodes.iterator();
            while (iter.hasNext()) {
                buf.append("\n    " + (ScreenExportData)iter.next());
            }
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append("\nnewDeletionsList(" + this.newDeletionsList.size() + "):\n");
            Iterator newDeletionsListIter = this.newDeletionsList.iterator();
            while (iter.hasNext()) {
                DeleteUID dUID = (DeleteUID)newDeletionsListIter.next();
                buf.append(dUID + "\n");
            }
            buf.append("\nParticipantData - Media to Move List(" + this.mediaToMove.size() + "):\n");
            iter = this.mediaToMove.iterator();
            while (iter.hasNext()) {
                buf.append("  Media: " + (MediaRef)iter.next());
            }
            buf.append("\nParticipantData - Media to Move Set(" + this.mediaToMoveSet.size() + "):\n");
            iter = this.mediaToMoveSet.iterator();
            while (iter.hasNext()) {
                buf.append("  Media: " + (MediaRef)iter.next());
            }
            if (this.screenByMedia != null) {
                buf.append("\nParticipantData - screens by media(" + this.screenByMedia.size() + "):\n");
                for (Map.Entry entry : this.screenByMedia.entrySet()) {
                    HashSet screens = (HashSet)entry.getValue();
                    buf.append("   Media: " + (MediaID)entry.getKey() + "\n");
                    iter2 = screens.iterator();
                    while (iter2.hasNext()) {
                        buf.append("      Screen: " + (ScreenModel)iter2.next());
                    }
                }
            } else {
                buf.append("\nParticipantData - screens by media - EMPTY\n");
            }
            if (this.screenByMedia != null) {
                buf.append("\nParticipantData - media by screen(" + this.mediaByScreen.size() + "):\n");
                for (Map.Entry entry : this.mediaByScreen.entrySet()) {
                    LinkedList medias = (LinkedList)entry.getValue();
                    buf.append("   Screen: " + (ScreenModel)entry.getKey());
                    iter2 = medias.iterator();
                    while (iter2.hasNext()) {
                        buf.append("      Media: " + (MediaRef)iter2.next());
                    }
                }
            } else {
                buf.append("\nParticipantData - media by screen - EMPTY\n");
            }
            buf.append("\nParticipantData - media sent(" + this.mediaSent.size() + "):\n");
            for (Map.Entry entry : this.mediaSent.entrySet()) {
                buf.append("  MediaSent: " + (MediaID)entry.getKey() + ", has refCount: " + entry.getValue() + "\n");
            }
            buf.append("\nParticipantData - Media Being Sent(" + this.mediaBeingSent.size() + "):\n");
            for (Map.Entry entry : this.mediaBeingSent.entrySet()) {
                buf.append("  MediaBeingSent: " + (MediaID)entry.getKey() + ", has refCount: " + entry.getValue() + "\n");
            }
            buf.append("\nParticipantdata = pendingProxies(" + this.pendingProxies.size() + "):\n");
            iter = this.pendingProxies.entrySet().iterator();
            while (iter.hasNext()) {
                buf.append("   Proxy: " + iter.next() + "\n");
            }
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append("\nParticipantdata = pendingProxyReceipts(" + this.pendingProxyReceipts.size() + "):\n");
            iter = this.pendingProxyReceipts.iterator();
            while (iter.hasNext()) {
                buf.append("   ProxyReceipt: " + iter.next() + "\n");
            }
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append("\nParticipantData - ItemsInTransit(" + this.itemsInTransit.size() + ")\n");
            for (ItemData itemData : this.itemsInTransit) {
                buf.append("  " + itemData + "\n" + itemData.getConstructorStackTrace());
            }
            buf.append("\nParticipantData - InTransitScreenUIDs(" + this.inTransitScreenUIDs.size() + ")\n");
            int lineLimit = 0;
            iter = this.inTransitScreenUIDs.iterator();
            while (iter.hasNext()) {
                Long screenUID = (Long)iter.next();
                buf.append(WBUtils.uniqueLongID(screenUID));
                if (iter.hasNext() || lineLimit < 12) {
                    buf.append(", ");
                    ++lineLimit;
                    continue;
                }
                buf.append("\n");
                lineLimit = 0;
            }
            buf.append("\n");
        }
        Debug.lockLeave((Object)this, (String)"ParticipantData.toString", (String)"DataModel", (Object)this.context.getDataModel());
        return buf.toString();
    }

    public boolean validate(Short participantId) {
        WBNode wbNode;
        boolean valid = true;
        for (Map.Entry<Long, WBNode> containersToSendEntry : this.containersToSend.entrySet()) {
            Long objectUID = containersToSendEntry.getKey();
            wbNode = containersToSendEntry.getValue();
            try {
                RegisteredTemplate template = (RegisteredTemplate)this.context.getObjectManager().getObjectFromMap(objectUID);
                if (template == null) {
                    Validator.log("Validate containersToSend(" + participantId + "): null template for Container: " + WBUtils.objectName(wbNode));
                    valid = Validator.setValid(valid, false);
                    continue;
                }
                if (template != wbNode) {
                    Validator.log("Validate containersToSend(" + participantId + "): key reference does not equal value's Container: " + WBUtils.objectName(wbNode));
                    valid = Validator.setValid(valid, false);
                    continue;
                }
                valid &= wbNode.validate();
            }
            catch (Exception e) {
                Validator.log("Exception(" + participantId + "): " + e.getMessage() + "while evaluation ObjectID of Screen in ScreensToSend.");
                valid = Validator.setValid(valid, false);
            }
        }
        for (Map.Entry<ScreenModel, ScreenExportData> screensWithDataEntry : this.screensWithData.entrySet()) {
            wbNode = screensWithDataEntry.getKey();
            ScreenExportData screenExportData = screensWithDataEntry.getValue();
            if (screenExportData == null) {
                Validator.log("Validate ScreensWithData(" + participantId + "): null ScreenExportData for Screen: " + WBUtils.objectName(screensWithDataEntry.getValue()));
                valid = Validator.setValid(valid, false);
                continue;
            }
            valid &= screenExportData.validate(participantId, (ScreenModel)wbNode);
        }
        for (Map.Entry<ScreenModel, LinkedList<MediaRef>> mediaByScreenEntry : this.mediaByScreen.entrySet()) {
            for (MediaRef mediaRef : mediaByScreenEntry.getValue()) {
                HashSet<ScreenModel> screenByMediaEntry;
                if (this.context.getMediaCache().getMediaItem(mediaRef.getMediaID()) == null) {
                    Validator.log("Validate mediaByScreen(" + participantId + "): MediaRef has no entry in the cache for MediaRef: " + mediaRef);
                    valid = Validator.setValid(valid, false);
                }
                if ((screenByMediaEntry = this.screenByMedia.get(mediaRef.getMediaID())) == null) {
                    Validator.log("Validate mediaByScreen(" + participantId + "): null screenByMedia entry for MediaRef: " + mediaRef);
                    valid = Validator.setValid(valid, false);
                    continue;
                }
                if (screenByMediaEntry.contains(mediaByScreenEntry.getKey())) continue;
                Validator.log("Validate mediaByScreen(" + participantId + "): screenByMedia: (" + mediaByScreenEntry.getKey() + "), has no entry for MediaRef: " + mediaRef);
                valid = Validator.setValid(valid, false);
            }
        }
        return valid;
    }

    class MediaRef
    implements Comparable {
        private MediaItem item;
        private MediaID mediaID;

        public MediaRef(WhiteboardContext context, MediaID mediaID) {
            this.mediaID = mediaID;
            this.item = context.getMediaCache().getMediaItem(mediaID);
            if (this.item == null) {
                LogSupport.message((Object)this, (String)"MediaRef", (String)("ParticipantData: MediaId: " + mediaID + ", cannot be found in cache: " + context.getMediaCache()));
            }
        }

        public boolean equals(Object object) {
            if (object instanceof MediaRef) {
                if (this.item == null) {
                    return false;
                }
                return this.mediaID.equals(((MediaRef)object).getMediaID());
            }
            return false;
        }

        public int compareTo(Object object) {
            if (object instanceof MediaRef) {
                return this.weightedLength() - ((MediaRef)object).weightedLength();
            }
            throw new ClassCastException("Cannot cast: " + object + ", to MediaRef.");
        }

        public int hashCode() {
            return this.mediaID.hashCode();
        }

        int weightedLength() {
            return this.item != null ? this.mediaID.getLength() / (this.item.getRefCount() + 1) : Integer.MAX_VALUE;
        }

        MediaID getMediaID() {
            return this.mediaID;
        }

        public boolean inCache() {
            return this.item != null;
        }

        public MediaItem getItem() {
            return this.item;
        }

        public String toString() {
            if (this.item == null) {
                return this.mediaID.toString();
            }
            return this.item.toString();
        }
    }
}

