/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.conference.ItemCacheEntry;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import java.util.HashMap;

public class ItemCache {
    private static final boolean DEBUG = false;
    private HashMap cacheMap = new HashMap();

    public byte[] getBuffer(RegisteredTemplate node, short revision) {
        NodeKey nodeKey = new NodeKey(node, revision);
        ItemCacheEntry entry = (ItemCacheEntry)this.cacheMap.get(nodeKey);
        return entry instanceof ItemCacheEntry ? entry.getBuffer() : null;
    }

    public byte[] refBuffer(RegisteredTemplate node, short revision) {
        NodeKey nodeKey = new NodeKey(node, revision);
        ItemCacheEntry entry = (ItemCacheEntry)this.cacheMap.get(nodeKey);
        if (entry instanceof ItemCacheEntry) {
            entry.incrementRefCount();
            return entry.getBuffer();
        }
        return null;
    }

    public int putBuffer(RegisteredTemplate node, byte[] buffer) {
        NodeKey nodeKey = new NodeKey(node);
        ItemCacheEntry entry = (ItemCacheEntry)this.cacheMap.get(nodeKey);
        if (entry == null) {
            entry = new ItemCacheEntry(buffer);
            this.cacheMap.put(nodeKey, entry);
        }
        return entry.getRefCount();
    }

    public int disposeBuffer(RegisteredTemplate node, short revision) {
        NodeKey nodeKey = new NodeKey(node, revision);
        ItemCacheEntry entry = (ItemCacheEntry)this.cacheMap.get(nodeKey);
        if (entry == null) {
            return 0;
        }
        if (entry.decrementRefCount() == 0) {
            this.cacheMap.remove(nodeKey);
        }
        return entry.getRefCount();
    }

    public int getBufferRef(RegisteredTemplate node, short revision) {
        NodeKey nodeKey = new NodeKey(node, revision);
        ItemCacheEntry entry = (ItemCacheEntry)this.cacheMap.get(nodeKey);
        if (entry == null) {
            return -1;
        }
        return entry.getRefCount();
    }

    class NodeKey {
        RegisteredTemplate node;
        int hash;
        int revision = 0;

        public NodeKey(RegisteredTemplate node) {
            this.node = node;
            if (node instanceof WBNode) {
                this.revision = ((WBNode)node).getRevision();
            }
            this.hash = node.hashCode() ^ this.revision;
        }

        public NodeKey(RegisteredTemplate node, short revision) {
            this.node = node;
            this.hash = node.hashCode() ^ revision;
        }

        public boolean equals(Object object) {
            if (!(object instanceof NodeKey)) {
                return false;
            }
            NodeKey objKey = (NodeKey)object;
            if (!this.node.equals(objKey.node)) {
                return false;
            }
            if (objKey.node instanceof WBNode) {
                return ((WBNode)objKey.node).getRevision() == this.revision;
            }
            return true;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "NodeKey: " + this.node + ", hash: " + this.hash + ", revision: " + this.revision;
        }
    }
}

