/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.conference;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.comm.AbstractCommContainer;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.ObjectUID;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.AttributeList;
import com.elluminate.groupware.whiteboard.tools.AbstractToolModel;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.util.HashSet;
import java.util.Iterator;

public class AttributeChange
extends AbstractCommContainer {
    private HashSet attributes = null;
    private Long toolUID;
    private WBNode parent = null;
    private short mergeCount = 0;

    public AttributeChange(WhiteboardContext context) {
        this(context, (Long)null);
    }

    public AttributeChange(WhiteboardContext context, Long toolUID) {
        super(context, "_AttributeChange");
        this.toolUID = toolUID;
    }

    public AttributeChange(WhiteboardContext context, WBInputStream istr) {
        this(context);
        try {
            this.streamToObject(istr);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"streamToObject constructor", (Throwable)e, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAttribute(AbstractAttribute attribute) {
        if (this.attributes == null) {
            this.attributes = new HashSet();
        }
        HashSet hashSet = this.attributes;
        synchronized (hashSet) {
            if (!this.attributes.contains(attribute)) {
                this.attributes.add(attribute);
            } else {
                this.mergeCount = (short)(this.mergeCount + 1);
            }
            if (this.parent == null) {
                this.parent = attribute.getParent();
            } else if (this.parent != attribute.getParent()) {
                throw new RuntimeException("Attributechange: attributes with different parents.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAttribute(AbstractAttribute attribute) {
        if (this.isEmpty()) {
            return false;
        }
        HashSet hashSet = this.attributes;
        synchronized (hashSet) {
            boolean removed = this.attributes.remove(attribute);
            if (removed && this.attributes.isEmpty()) {
                this.attributes = null;
            }
            return removed;
        }
    }

    public boolean isEmpty() {
        return this.attributes == null || this.attributes.isEmpty();
    }

    public WBNode getParent() {
        return this.parent;
    }

    public Long getToolUID() {
        return this.toolUID;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        try {
            super.streamToObject(istr);
            int entries = WBUtils.readByte(istr, "AttributeChange EntryCount");
            short mergeCount = WBUtils.readShort(istr, "AttributeChange mergeCount");
            Long objectUID = ObjectUID.objectUIDFromStream(istr);
            RegisteredTemplate uidObject = (RegisteredTemplate)this.context.getObjectManager().getObjectFromMap(objectUID);
            if (uidObject instanceof WBNode && ((WBNode)uidObject).isDeleted()) {
                LogSupport.error((Object)this, (String)"streamToObject", (String)("AttributeChange for deleted WBNode: " + uidObject));
                return null;
            }
            if (uidObject instanceof WBNode && mergeCount > 0) {
                ((WBNode)uidObject).setRevision((short)(((WBNode)uidObject).getRevision() + mergeCount));
            }
            if (uidObject instanceof AttributeList) {
                Short attributeId;
                AbstractAttribute attribute;
                if (uidObject instanceof AbstractToolModel && ((AbstractToolModel)uidObject).isSelected()) {
                    AbstractToolModel tool = (AbstractToolModel)uidObject;
                    tool.getScreenParent().deSelectTool(tool);
                }
                AttributeList attributeList = (AttributeList)((Object)uidObject);
                for (int entry = 0; entry < entries && (attribute = attributeList.getAttribute(attributeId = ShortList.get((short)WBUtils.readShort(istr, "AttributeChange RegID")))) != null; ++entry) {
                    if (uidObject instanceof AbstractToolModel && attribute.isVisible()) {
                        ((AbstractToolModel)uidObject).notifySizingChange();
                    }
                    attribute.streamToObject(istr);
                    Short modifiedById = ShortList.get((short)WBUtils.readClientId(istr, "AttributeChange reads attribute modifiedById field"));
                    if (!this.context.isClient()) {
                        modifiedById = istr.getOriginatorId();
                    }
                    attribute.setModifiedById(modifiedById);
                    this.context.fireAttributeChange(attribute);
                }
            } else if (objectUID != null && uidObject != null) {
                LogSupport.error((String)("AttributeChange streamin: Object: " + uidObject + " is not an AttributeList Object." + ", could not find objectUID: " + objectUID));
            }
        }
        catch (Exception ioe) {
            LogSupport.exception((Object)this, (String)"streamToObject", (Throwable)ioe, (boolean)true);
        }
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        try {
            if (this.parent == null || this.isEmpty()) {
                return;
            }
            if (this.parent.isDeleted() || this.parent.getParent() == null || this.parent.getObjectID() == null) {
                LogSupport.error((Object)this, (String)"objectToStream", (String)("AttributeChange called to emit attributes for a deleted node: " + this.parent));
                return;
            }
            super.objectToStream(ostr);
            ostr.writeByte(this.attributes.size());
            ostr.writeShort(this.mergeCount);
            if (this.toolUID == null) {
                Thread.dumpStack();
            }
            ObjectUID.objectUIDToStream(this.toolUID, ostr);
            for (AbstractAttribute attribute : this.attributes) {
                ostr.writeShort(attribute.getRegisteredID().shortValue());
                attribute.objectToStream(ostr);
                ostr.writeShort(attribute.getModfiedById().shortValue());
            }
        }
        catch (Exception ioe) {
            LogSupport.exception((Object)this, (String)"objectToStream", (Throwable)ioe, (boolean)true);
        }
    }

    @Override
    public String streamToString(WBInputStream istr) {
        StringBuffer buf = new StringBuffer(super.streamToString(istr));
        try {
            int entries = WBUtils.readByte(istr, "AttributeChange EntryCount");
            short mergeCount = WBUtils.readShort(istr, "AttributeChange mergeCount");
            Long objectUID = ObjectUID.objectUIDFromStream(istr);
            RegisteredTemplate uidObject = (RegisteredTemplate)this.context.getObjectManager().getObjectFromMap(objectUID);
            if (uidObject instanceof AttributeList) {
                AttributeList attributeList = (AttributeList)((Object)uidObject);
                for (int entry = 0; entry < entries; ++entry) {
                    Short attributeId = ShortList.get((short)WBUtils.readShort(istr, "AttributeChange RegID"));
                    AbstractAttribute attribute = attributeList.getAttribute(attributeId);
                    buf.append("AttributeChange: " + uidObject.getName() + "." + attribute.getName() + ", mergeCount=" + mergeCount + "\n  ");
                    buf.append(attribute.streamToString(istr));
                    buf.append("\n  Modified by: " + WBUtils.readClientId(istr, "AttributeChange reads attribute modifiedById field"));
                }
            } else {
                Thread.dumpStack();
                LogSupport.error((String)("AttributeChange streaminToString: Object: " + uidObject + " is not an AttributeList Object." + ", could not find objectUID: " + objectUID));
            }
        }
        catch (Exception ioe) {
            LogSupport.exception((Object)this, (String)"streamToString", (Throwable)ioe, (boolean)true);
            buf.append("\n  Exception: " + ioe.getMessage());
        }
        return buf.toString();
    }

    public String toString() {
        AbstractAttribute attribute = null;
        StringBuffer buf = new StringBuffer();
        buf.append("AttributeChange for: " + this.getParent() + "\n");
        if (this.attributes != null) {
            Iterator iter = this.attributes.iterator();
            while (iter.hasNext()) {
                try {
                    attribute = (AbstractAttribute)iter.next();
                    buf.append(attribute.toString() + "\n");
                }
                catch (Exception ex) {
                    buf.append("Exception processing: " + (attribute != null && attribute.getName() != null ? attribute.getName() : " null attribute name"));
                    Thread.dumpStack();
                }
            }
        } else {
            buf.append("Null attributeList\n");
        }
        return buf.toString();
    }
}

