/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes.subattributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleSubAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;

public class SmileySubAttribute
extends StyleSubAttribute {
    static final String toolName = "SmileySubAttribute";
    private String pattern = "";

    public SmileySubAttribute(WhiteboardContext context) {
        this(context, toolName);
    }

    public SmileySubAttribute(WhiteboardContext context, String name) {
        super(context, name);
    }

    public SmileySubAttribute(WhiteboardContext context, String name, int id) {
        super(context, name, id);
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof SmileySubAttribute) {
            super.merge(newAttribute);
            this.setAttributeNotificationSuppression();
            SmileySubAttribute newSubAttr = (SmileySubAttribute)newAttribute;
            this.setPattern(newSubAttr.getPattern());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        String pattern = WBUtils.readUTF(istr, "SmileySubAttribute pattern");
        this.setPattern(pattern);
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            String pattern = WBUtils.readUTF(istr, "SmileySubAttribute pattern");
            return this.getName() + ": Smiley pattern=" + pattern;
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeUTF(this.getPattern());
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        super.elementToObject(element, progress);
        this.pattern = "";
        String patternString = element.getAttributeValue("pattern");
        if (patternString != null && !patternString.equals("")) {
            this.pattern = patternString;
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement tf = new WBElement(this.getName());
        super.objectToElement(parent, tf, progress);
        if (this.pattern != "") {
            tf.setAttribute(new Attribute("pattern", this.pattern));
        }
        parent.addContent((Content)tf);
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, WBElement tf, ProgressUpdate progress) throws Exception {
        super.objectToElement(parent, tf, progress);
        if (this.pattern != "") {
            tf.setAttribute(new Attribute("pattern", this.pattern));
        }
        return null;
    }
}

