/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes.subattributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.StyleSubAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;

public class ColorSubAttribute
extends StyleSubAttribute {
    static final String toolName = "ColorSubAttribute";
    int alpha = 255;
    long rgba = 0xFF000000L;

    public ColorSubAttribute(WhiteboardContext context) {
        super(context, toolName);
    }

    public ColorSubAttribute(WhiteboardContext context, String name) {
        super(context, name);
    }

    public ColorSubAttribute(WhiteboardContext context, String name, int id) {
        super(context, name, id);
    }

    public ColorSubAttribute(WhiteboardContext context, String name, int id, long rgba, int alpha) {
        super(context, name, id);
        this.rgba = rgba;
        this.alpha = alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha & 0xFF;
    }

    public void setRgba(long rgba) {
        this.rgba = rgba & 0xFFFFFFL | (long)this.alpha << 24;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public long getRgba() {
        return this.rgba;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ColorSubAttribute) {
            super.merge(newAttribute);
            this.setAttributeNotificationSuppression();
            ColorSubAttribute newSubAttr = (ColorSubAttribute)newAttribute;
            this.setRgba(newSubAttr.getRgba());
            this.setAlpha(newSubAttr.getAlpha());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        int alpha = WBUtils.readInt(istr, "ColorSubAttribute alpha");
        long rgba = WBUtils.readInt(istr, "ColorSubAttribute rgb");
        this.setRgba(rgba);
        this.setAlpha(alpha);
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            int alpha = WBUtils.readInt(istr, "ColorSubAttribute alpha string");
            int rgb = WBUtils.readInt(istr, "ColorSubAttribute rgb string");
            return this.getName() + ": RGB=" + Integer.toHexString(rgb) + ", Alpha=" + Integer.toHexString(alpha);
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeInt(this.alpha);
        ostr.writeInt((int)(this.rgba & 0xFFFFFFL));
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        super.elementToObject(element, progress);
        this.alpha = 255;
        this.rgba = 0xFF000000L;
        String rgbaString = element.getAttributeValue("rgba");
        try {
            if (rgbaString != null && !rgbaString.equals("")) {
                this.rgba = Long.valueOf(rgbaString);
            }
        }
        catch (Exception e) {
            throw new Exception(this.getName() + ": Invalid long value for rgba: " + rgbaString);
        }
        String alphaString = element.getAttributeValue("alpha");
        try {
            if (alphaString != null && !alphaString.equals("")) {
                this.alpha = Integer.valueOf(alphaString);
            }
        }
        catch (Exception e) {
            throw new Exception(this.getName() + ": Invalid integer value for alpha: " + alphaString);
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement tf = new WBElement(this.getName());
        super.objectToElement(parent, tf, progress);
        if (this.rgba != 0L) {
            tf.setAttribute(new Attribute("rgba", Long.toString(this.rgba)));
        }
        if (this.alpha != 255) {
            tf.setAttribute(new Attribute("alpha", Integer.toString(this.alpha)));
        }
        parent.addContent((Content)tf);
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, WBElement tf, ProgressUpdate progress) throws Exception {
        super.objectToElement(parent, tf, progress);
        if (this.rgba != 0L) {
            tf.setAttribute(new Attribute("rgba", Long.toString(this.rgba)));
        }
        if (this.alpha != 255) {
            tf.setAttribute(new Attribute("alpha", Integer.toString(this.alpha)));
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + ", rgb: " + this.rgba + ", alpha: " + this.alpha;
    }
}

