/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.DDimension;
import com.elluminate.groupware.whiteboard.dataModel.DPoint;
import com.elluminate.groupware.whiteboard.dataModel.GeometryUtils;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.util.log.LogSupport;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.IOException;

public class ToolRectangle
extends AbstractAttribute
implements Cloneable {
    public static final byte NORMAL = 0;
    public static final byte H_FLIP = 1;
    public static final byte V_FLIP = 2;
    public static final byte HV_FLIP = 3;
    private DPoint dPoint = new DPoint();
    private DDimension dDim = new DDimension();
    private Rectangle rect = new Rectangle();
    private boolean evaluateNormal = true;
    private boolean evaluateNormalLocation = true;
    private boolean evaluateNormalSize = true;
    private DPoint normalLocation = null;
    private DDimension normalSize = null;
    private Rectangle normalRectangle = null;
    private DPoint centroid = new DPoint();
    boolean evaluateCentroid = true;
    private byte orientation = 0;

    public ToolRectangle(WhiteboardContext context, boolean optional) {
        super(context, "ToolRect");
        this.setOptional(optional);
    }

    public ToolRectangle(WhiteboardContext context) {
        this(context, false);
    }

    public ToolRectangle(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public ToolRectangle(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ToolRectangle rectangle = (ToolRectangle)super.clone();
        rectangle.normalLocation = null;
        rectangle.normalSize = null;
        rectangle.normalRectangle = null;
        rectangle.evaluateNormal = true;
        rectangle.evaluateCentroid = true;
        rectangle.evaluateNormalLocation = true;
        rectangle.evaluateNormalSize = true;
        rectangle.centroid = (DPoint)this.centroid.clone();
        rectangle.rect = new Rectangle(this.rect);
        rectangle.dPoint = (DPoint)this.dPoint.clone();
        rectangle.dDim = (DDimension)this.dDim.clone();
        return rectangle;
    }

    @Override
    public void delete() {
        super.delete();
    }

    @Override
    public boolean usesHeader() {
        return true;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ToolRectangle) {
            this.setAttributeNotificationSuppression();
            ToolRectangle newRectangle = (ToolRectangle)newAttribute;
            this.evaluateNormal = true;
            this.evaluateCentroid = true;
            this.evaluateNormalLocation = true;
            this.evaluateNormalSize = true;
            this.setLocation(newRectangle.getLocation());
            this.setSize(newRectangle.getSize());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    public DPoint getLocation() {
        return this.dPoint;
    }

    public void setLocation(double x, double y) {
        this.setLocation(x, y, true);
    }

    public void setLocation(double x, double y, boolean notify) {
        if (x != this.dPoint.getX() || y != this.dPoint.getY() || notify) {
            this.setAttributeChanged();
            if (notify) {
                this.notifyVisibleChange();
            }
            this.dPoint.setX(x);
            this.dPoint.setY(y);
            this.rect.setLocation(this.dPoint.getIntLocation());
            this.evaluateNormal = true;
            this.evaluateNormalLocation = true;
            this.evaluateCentroid = true;
            if (this.isAttributeChanged() && notify) {
                this.notifySizingChange();
                this.notifyAttributeChange();
            }
        }
    }

    public void setLocation(DPoint dP) {
        this.setLocation(dP.getX(), dP.getY());
    }

    public void setLocation(DPoint dP, boolean notify) {
        this.setLocation(dP.getX(), dP.getY(), notify);
    }

    public DDimension getSize() {
        return this.dDim;
    }

    public void setSize(double width, double height) {
        this.setSize(width, height, true);
    }

    public void setSize(double width, double height, boolean notify) {
        if (width != this.dDim.getWidth() || height != this.dDim.getHeight() || notify) {
            this.setAttributeChanged();
            if (notify) {
                this.notifyVisibleChange();
            }
            this.dDim.setWidth(width);
            this.dDim.setHeight(height);
            this.rect.setSize(this.dDim.getIntSize());
            this.evaluateNormal = true;
            this.evaluateNormalSize = true;
            this.evaluateCentroid = true;
            this.orientation = 0;
            this.orientation = (byte)(this.orientation | (width < 0.0 ? (byte)1 : 0));
            this.orientation = (byte)(this.orientation | (height < 0.0 ? 2 : 0));
            if (this.isAttributeChanged() && notify) {
                this.notifySizingChange();
                this.notifyAttributeChange();
            }
        }
    }

    public void setSize(DDimension dD) {
        this.setSize(dD.getWidth(), dD.getHeight());
    }

    public void setSize(DDimension dD, boolean notify) {
        this.setSize(dD.getWidth(), dD.getHeight(), notify);
    }

    public Rectangle getBounds() {
        return this.rect;
    }

    public Rectangle getNormalBounds() {
        if (this.evaluateNormal) {
            this.normalRectangle = GeometryUtils.normalRectangle(this.rect, this.normalRectangle);
            this.evaluateNormal = false;
        }
        return this.normalRectangle;
    }

    public DPoint getNormalLocation() {
        if (this.evaluateNormalLocation) {
            double y;
            double x = this.dDim.getWidth() < 0.0 ? this.dPoint.getX() + this.dDim.getWidth() : this.dPoint.getX();
            double d = y = this.dDim.getHeight() < 0.0 ? this.dPoint.getY() + this.dDim.getHeight() : this.dPoint.getY();
            if (this.normalLocation == null) {
                this.normalLocation = new DPoint(x, y);
            } else {
                this.normalLocation.setX(x);
                this.normalLocation.setY(y);
            }
            this.evaluateNormalLocation = false;
        }
        return this.normalLocation;
    }

    public DDimension getNormalSize() {
        if (this.evaluateNormalSize) {
            if (this.normalSize == null) {
                this.normalSize = new DDimension(Math.abs(this.dDim.getWidth()), Math.abs(this.dDim.getHeight()));
            } else {
                this.normalSize.setWidth(Math.abs(this.dDim.getWidth()));
                this.normalSize.setHeight(Math.abs(this.dDim.getHeight()));
            }
            this.evaluateNormalSize = false;
        }
        return this.normalSize;
    }

    public void setBounds(Rectangle rectangle) {
        this.evaluateNormal = true;
        this.evaluateCentroid = true;
        this.evaluateNormalLocation = true;
        this.evaluateNormalSize = true;
        this.dDim = new DDimension(rectangle.getSize());
        this.dPoint = new DPoint(rectangle.getLocation());
        this.rect.setBounds(rectangle);
        this.setAttributeChanged();
    }

    public DPoint getCentroid() {
        if (this.evaluateCentroid) {
            this.centroid.setX(this.dPoint.getX() + this.dDim.getWidth() / 2.0);
            this.centroid.setY(this.dPoint.getY() + this.dDim.getHeight() / 2.0);
            this.evaluateCentroid = false;
        }
        return this.centroid;
    }

    public byte getOrientation() {
        return this.orientation;
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.evaluateNormal = true;
        this.evaluateCentroid = true;
        this.evaluateNormalLocation = true;
        this.evaluateNormalSize = true;
        float x = WBUtils.readFloat(istr, "ToolRectangle point x");
        float y = WBUtils.readFloat(istr, "ToolRectangle point y");
        this.setLocation(new DPoint(x, y), false);
        float w = WBUtils.readFloat(istr, "ToolRectangle dimension width");
        float h = WBUtils.readFloat(istr, "ToolRectangle dimension height");
        this.setSize(new DDimension(w, h));
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeFloat((float)this.dPoint.getX());
        ostr.writeFloat((float)this.dPoint.getY());
        ostr.writeFloat((float)this.dDim.getWidth());
        ostr.writeFloat((float)this.dDim.getHeight());
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            return this.getName() + " (" + istr.readFloat() + ", " + istr.readFloat() + ", " + istr.readFloat() + ", " + istr.readFloat() + ")";
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        this.evaluateNormal = true;
        this.evaluateCentroid = true;
        this.evaluateNormalLocation = true;
        this.evaluateNormalSize = true;
        if (element.getAttribute("rect") != null) {
            try {
                char[] rectChars = element.getAttributeValue("rect").toCharArray();
                int type = 0;
                double accumulator = 0.0;
                double divisor = 1.0;
                double divisorMult = 1.0;
                double sign = 1.0;
                double x = 0.0;
                double y = 0.0;
                double width = 0.0;
                double height = 0.0;
                block20: for (int index = 0; index < rectChars.length; ++index) {
                    char c = rectChars[index];
                    switch (c) {
                        default: {
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            accumulator = accumulator * 10.0 + (double)(c - 48);
                            divisor *= divisorMult;
                            break;
                        }
                        case '.': {
                            divisorMult = 10.0;
                            break;
                        }
                        case ',': {
                            ++type;
                            accumulator = 0.0;
                            divisor = 1.0;
                            divisorMult = 1.0;
                            sign = 1.0;
                            break;
                        }
                        case '-': {
                            sign = -1.0;
                        }
                    }
                    switch (type) {
                        case 0: {
                            x = accumulator / divisor * sign;
                            continue block20;
                        }
                        case 1: {
                            y = accumulator / divisor * sign;
                            continue block20;
                        }
                        case 2: {
                            width = accumulator / divisor * sign;
                            continue block20;
                        }
                        case 3: {
                            height = accumulator / divisor * sign;
                            continue block20;
                        }
                    }
                }
                this.setLocation(x, y, false);
                this.setSize(width, height, false);
            }
            catch (Exception e) {
                throw new Exception(this.getName() + " Invalid digits in rect: " + e.getMessage());
            }
        }
        WBElement cElement = (WBElement)element.getChild("COORDINATES");
        if (cElement != null) {
            if (cElement.getAttribute("X1") != null) {
                try {
                    double x1 = cElement.getAttribute("X1").getDoubleValue();
                    double y1 = cElement.getAttribute("Y1").getDoubleValue();
                    double x2 = cElement.getAttribute("X2").getDoubleValue();
                    double y2 = cElement.getAttribute("Y2").getDoubleValue();
                    this.setLocation(x1, y1, false);
                    this.setSize(x2 - x1, y2 - y1, false);
                }
                catch (Exception e) {
                    throw new Exception(this.getName() + " Invalid Coordinates X1/Y1, X2/Y2 values: " + e.getMessage());
                }
            }
            try {
                this.setLocation(cElement.getAttribute("X").getDoubleValue(), cElement.getAttribute("Y").getDoubleValue(), false);
            }
            catch (Exception e) {
                throw new Exception(this.getName() + " Invalid digits in X or Y: " + e.getMessage());
            }
            try {
                this.setSize(cElement.getAttribute("W").getDoubleValue(), cElement.getAttribute("H").getDoubleValue(), false);
            }
            catch (Exception e) {
                throw new Exception(this.getName() + " Invalid digits in bw or bh: " + e.getMessage());
            }
        }
        if (!this.isOptional()) {
            LogSupport.error((String)("Tool: " + this.getParent().getName() + " has no ToolRectangle, at line: " + element.getInstanceCount()));
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        parent.setAttribute("rect", this.toRectString());
        return null;
    }

    private String toRectString() {
        StringBuffer retString = new StringBuffer(32);
        try {
            retString.append(ToolRectangle.doubleToString(this.dPoint.getX()));
            retString.append(",");
            retString.append(ToolRectangle.doubleToString(this.dPoint.getY()));
            retString.append(",");
            retString.append(ToolRectangle.doubleToString(this.dDim.getWidth()));
            retString.append(",");
            retString.append(ToolRectangle.doubleToString(this.dDim.getHeight()));
        }
        catch (Exception ex) {
            retString.append("Exception: " + ex.getMessage());
        }
        return retString.toString();
    }

    public static String doubleToString(double val) {
        char[] value = Double.toString(val).toCharArray();
        int lastZero = 0;
        for (lastZero = value.length - 1; lastZero > 1 && value[lastZero] == '0'; --lastZero) {
        }
        if (value[lastZero] == '.') {
            --lastZero;
        }
        return new String(value, 0, lastZero + 1);
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.toRectString() + ")";
    }
}

