/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.CompatibleFont;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttributeMap;
import com.elluminate.groupware.whiteboard.attributes.ToolFontInterface;
import com.elluminate.groupware.whiteboard.attributes.subattributes.AbstractSubAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.FontSubAttribute;
import com.elluminate.groupware.whiteboard.tools.TextEditorToolModel;

public class ToolFontList
extends AbstractAttributeMap
implements ToolFontInterface {
    private static final String toolName = "FONTLIST";
    private int fontSize = 14;
    private int fontStyle = 0;
    private boolean fontUnderline = false;
    private String fontName = "Serif";

    public ToolFontList(WhiteboardContext context) {
        super(context, toolName);
        this.editorUIName = "com.elluminate.groupware.whiteboard.module.ui.attributeEditors.ToolFontEditorUI";
    }

    @Override
    public void setFont(CompatibleFont font) {
        if (this.parent == null) {
            return;
        }
        TextEditorToolModel tool = (TextEditorToolModel)this.parent;
        if (tool.isIgnoreAttrChange() || !tool.isUiComponentActive()) {
            return;
        }
        this.fontSize = font.getSize();
        this.fontStyle = font.getStyle();
        this.fontName = font.getFamily();
        this.fontUnderline = font.isUnderline();
        this.setAttribute(font);
        ((TextEditorToolModel)this.parent).setFont(font);
    }

    @Override
    public void setAttribute(Object attributeKey) {
        if (attributeKey instanceof CompatibleFont && !this.attributeMap.containsKey(attributeKey)) {
            CompatibleFont font = (CompatibleFont)attributeKey;
            FontSubAttribute sa = (FontSubAttribute)this.attributeFactory();
            sa.setSaId(this.getNextId());
            sa.setFontName(font.getFamily());
            sa.setFontSize(font.getSize());
            sa.setFontStyle(font.getStyle());
            sa.setUnderline(font.isUnderline());
            this.attributeMap.put(attributeKey, sa);
            this.getAttributeIdMap().put(new Integer(sa.getSaId()), sa);
            this.notifyVisibleChange();
            this.setAttributeChanged();
            this.notifySizingChange();
            this.notifyAttributeChange();
        }
    }

    @Override
    public AbstractSubAttribute getAttribute(Object attributeKey) {
        return (FontSubAttribute)this.attributeMap.get(attributeKey);
    }

    @Override
    public Object attributeKeyFactory(AbstractSubAttribute sa) {
        if (sa instanceof FontSubAttribute) {
            FontSubAttribute fsa = (FontSubAttribute)sa;
            CompatibleFont font = new CompatibleFont(fsa.getFontName(), fsa.getFontStyle(), fsa.getFontSize(), fsa.isUnderline());
            return font;
        }
        return null;
    }

    @Override
    public AbstractSubAttribute attributeFactory() {
        return new FontSubAttribute(this.context);
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public void setUnderline(boolean fontUnderline) {
        this.fontUnderline = fontUnderline;
    }

    @Override
    public CompatibleFont getFont() {
        return new CompatibleFont(this.fontName, this.fontStyle, this.fontSize, this.fontUnderline);
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public int getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public boolean isUnderline() {
        return this.fontUnderline;
    }
}

