/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.JDOMTransferrable;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.io.DataInputStream;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;

public class ToolComponent
extends AbstractAttribute
implements Cloneable,
JDOMTransferrable {
    private static final String toolName = "ComponentProperties";
    private int scrollAdjustment = 0;

    public ToolComponent(WhiteboardContext context) {
        this(context, toolName);
    }

    public ToolComponent(WhiteboardContext context, String name) {
        super(context, name);
    }

    public ToolComponent(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public ToolComponent(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ToolComponent doc = (ToolComponent)super.clone();
        return doc;
    }

    @Override
    public void delete() {
        super.delete();
    }

    public void setScrollAdjustment(int scrollAdjustment) {
        if (this.scrollAdjustment != scrollAdjustment) {
            this.notifyVisibleChange();
            this.scrollAdjustment = scrollAdjustment;
            this.setAttributeChanged();
            this.notifySizingChange();
            this.notifyAttributeChange();
        }
    }

    public int getScrollAdjustment() {
        return this.scrollAdjustment;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ToolComponent) {
            this.setAttributeNotificationSuppression();
            ToolComponent newDoc = (ToolComponent)newAttribute;
            this.setScrollAdjustment(newDoc.getScrollAdjustment());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        int adjustment = WBUtils.readInt(istr, "ToolComponent adjustment");
        this.notifyVisibleChange();
        this.setScrollAdjustment(adjustment);
        this.notifySizingChange();
        this.notifyAttributeChange();
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            int adjustment = WBUtils.readInt(istr, "ToolComponent adjustment");
            return this.getName() + ": ToolComponent adjustment value=" + Integer.toHexString(adjustment);
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeInt(this.getScrollAdjustment());
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        this.scrollAdjustment = 0;
        String adjustmentString = element.getAttributeValue("adjustment");
        try {
            if (adjustmentString != null && !adjustmentString.equals("")) {
                this.scrollAdjustment = Integer.valueOf(adjustmentString);
                this.notifyVisibleChange();
                this.notifySizingChange();
                this.notifyAttributeChange();
            }
        }
        catch (Exception e) {
            throw new Exception(this.getName() + ": Invalid integer value for adjustment: " + adjustmentString);
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        WBElement tf = new WBElement(this.getName());
        if (this.scrollAdjustment != 0) {
            tf.setAttribute(new Attribute("adjustment", Integer.toString(this.scrollAdjustment)));
        }
        parent.addContent((Content)tf);
        return null;
    }
}

