/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttributeMap;
import com.elluminate.groupware.whiteboard.attributes.ToolColorInterface;
import com.elluminate.groupware.whiteboard.attributes.subattributes.AbstractSubAttribute;
import com.elluminate.groupware.whiteboard.attributes.subattributes.ColorSubAttribute;
import com.elluminate.groupware.whiteboard.tools.TextEditorToolModel;
import com.elluminate.groupware.whiteboard.tools.ToolDefinitions;
import java.awt.Color;

public class ToolColorList
extends AbstractAttributeMap
implements ToolColorInterface {
    private static final String toolName = "COLORLIST";
    private Color activeColor = null;
    private int activeAlpha = 255;

    public ToolColorList(WhiteboardContext context) {
        super(context, toolName);
        this.editorUIName = "com.elluminate.groupware.whiteboard.module.ui.attributeEditors.QuickColorPanel";
    }

    public void setAlpha(int activeAlpha) {
        this.activeAlpha = activeAlpha;
    }

    @Override
    public void setColor(Object rgbaObject, int alpha) {
        if (this.parent == null) {
            return;
        }
        TextEditorToolModel tool = (TextEditorToolModel)this.parent;
        if (tool.isIgnoreAttrChange() || !tool.isUiComponentActive()) {
            return;
        }
        this.activeColor = (Color)rgbaObject;
        this.activeAlpha = alpha;
        this.setAttribute(this.activeColor);
        ((TextEditorToolModel)this.parent).setColor(rgbaObject, alpha);
    }

    @Override
    public void setColor(int red, int green, int blue, int alpha) {
    }

    @Override
    public void setColor(long rgba, int alpha) {
    }

    @Override
    public Object getColor() {
        if (this.activeColor == null) {
            this.activeColor = ToolDefinitions.COLOR_DEFAULT;
        }
        return this.activeColor;
    }

    @Override
    public int getAlpha() {
        return this.activeAlpha;
    }

    @Override
    public void setAttribute(Object attributeKey) {
        if (attributeKey instanceof Color && !this.attributeMap.containsKey(attributeKey)) {
            Color color = (Color)attributeKey;
            ColorSubAttribute sa = (ColorSubAttribute)this.attributeFactory();
            sa.setSaId(this.getNextId());
            sa.setRgba(color.getRGB());
            sa.setAlpha(color.getAlpha());
            this.attributeMap.put(attributeKey, sa);
            this.getAttributeIdMap().put(new Integer(sa.getSaId()), sa);
            this.notifyVisibleChange();
            this.setAttributeChanged();
            this.notifySizingChange();
            this.notifyAttributeChange();
        }
    }

    @Override
    public AbstractSubAttribute getAttribute(Object attributeKey) {
        return (ColorSubAttribute)this.attributeMap.get(attributeKey);
    }

    @Override
    public Object attributeKeyFactory(AbstractSubAttribute sa) {
        if (sa instanceof ColorSubAttribute) {
            ColorSubAttribute fsa = (ColorSubAttribute)sa;
            Color color = new Color((int)fsa.getRgba());
            return color;
        }
        return null;
    }

    @Override
    public AbstractSubAttribute attributeFactory() {
        return new ColorSubAttribute(this.context);
    }

    public void setActiveColor(Color activeColor) {
        this.activeColor = activeColor;
    }
}

