/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.attributes.ToolColorInterface;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.IOException;
import org.jdom.Attribute;
import org.jdom.Content;

public class ToolColor
extends AbstractAttribute
implements Cloneable,
ToolColorInterface {
    Object color = null;
    static final String toolName = "ToolColor";
    static final int DEFAULT_ALPHA = 255;
    int red = 0;
    int green = 0;
    int blue = 0;
    int alpha = 255;
    long rgba = 0xFF000000L;
    private ToolColor masterColor = this;

    public ToolColor(WhiteboardContext context) {
        this(context, toolName);
    }

    public ToolColor(WhiteboardContext context, String name) {
        super(context, name);
        this.editorUIName = "com.elluminate.groupware.whiteboard.module.ui.attributeEditors.ToolColorEditorUI";
    }

    public ToolColor(WhiteboardContext context, int red, int green, int blue) {
        this(context, red, green, blue, 255);
    }

    public ToolColor(WhiteboardContext context, int rgb) {
        this(context);
        this.setColor(rgb, 255);
    }

    public ToolColor(WhiteboardContext context, int red, int green, int blue, int alpha) {
        this(context);
        this.setColor(red, green, blue, alpha);
    }

    public ToolColor(WhiteboardContext context, WBElement element, ProgressUpdate update) {
        this(context);
    }

    public ToolColor(WhiteboardContext context, DataInputStream istr) {
        this(context);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ToolColor color = (ToolColor)super.clone();
        color.color = null;
        color.masterColor = color;
        return color;
    }

    @Override
    public void delete() {
        super.delete();
    }

    public ToolColor getMasterColor() {
        return this.masterColor;
    }

    public void setMasterColor(ToolColor masterColor) {
        this.masterColor = masterColor;
        this.setSuppressUI(masterColor != this);
    }

    @Override
    public Object getColor() {
        if (this.masterColor.color != null) {
            return this.masterColor.color;
        }
        this.masterColor.color = new Color((int)this.masterColor.rgba, true);
        return this.masterColor.color;
    }

    @Override
    public void setColor(int red, int green, int blue, int alpha) {
        this.red = red & 0xFF;
        this.green = green & 0xFF;
        this.blue = blue & 0xFF;
        this.alpha = alpha & 0xFF;
        this.rgba = ((long)this.alpha << 24) + ((long)this.red << 16) + ((long)this.green << 8) + (long)this.blue;
        this.color = null;
        this.setAttributeChanged();
        this.notifyVisibleChange();
        this.notifyAttributeChange();
    }

    @Override
    public void setColor(long rgba, int alpha) {
        boolean colorChanged;
        boolean alphaChanged = this.alpha != (alpha & 0xFF);
        boolean bl = colorChanged = (this.rgba & 0xFFFFFFL) != (rgba & 0xFFFFFFL);
        if (alphaChanged) {
            this.notifyVisibleChange();
        }
        this.alpha = alpha & 0xFF;
        this.rgba = rgba & 0xFFFFFFL | (long)this.alpha << 24;
        this.red = (int)(rgba >> 16) & 0xFF;
        this.green = (int)(rgba >> 8) & 0xFF;
        this.blue = (int)rgba & 0xFF;
        this.color = null;
        if (alphaChanged || colorChanged) {
            this.color = null;
            this.notifySizingChange();
            this.notifyAttributeChange();
        }
    }

    public void setColor(Object rgbaObject) {
        this.setColor(rgbaObject, 255);
    }

    @Override
    public void setColor(Object rgbaObject, int alpha) {
        boolean alphaChanged;
        boolean bl = alphaChanged = this.alpha != (alpha & 0xFF);
        if (alphaChanged) {
            this.notifyVisibleChange();
        }
        this.alpha = alpha & 0xFF;
        long oldRGBA = this.rgba;
        long newRGBA = rgbaObject instanceof Color ? (long)((Color)rgbaObject).getRGB() : (long)Color.black.getRGB();
        this.rgba = newRGBA & 0xFFFFFFL | (long)this.alpha << 24;
        this.red = (int)(this.rgba >> 16) & 0xFF;
        this.green = (int)(this.rgba >> 8) & 0xFF;
        this.blue = (int)this.rgba & 0xFF;
        this.color = null;
        if (this.rgba != oldRGBA) {
            this.setAttributeChanged();
            this.notifySizingChange();
            this.notifyAttributeChange();
        }
    }

    @Override
    public int getAlpha() {
        return this.masterColor.alpha;
    }

    public void setAlpha(int alpha) {
        this.setColor(this.rgba, alpha);
    }

    public boolean equalColor(Object colorObject) {
        boolean result = false;
        if (colorObject instanceof Color) {
            result = ((long)((Color)colorObject).getRGB() & 0xFFFFFFL) == (this.masterColor.rgba & 0xFFFFFFL) && ((Color)colorObject).getAlpha() == this.masterColor.alpha;
        }
        return result;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
        if (newAttribute instanceof ToolColor) {
            this.setAttributeNotificationSuppression();
            ToolColor newColor = (ToolColor)newAttribute;
            this.setColor(newColor.getColor(), newColor.getAlpha());
            this.clearAttributeNotificationSuppression(true);
        }
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        int alpha = WBUtils.readInt(istr, "ToolColor alpha");
        long rgba = WBUtils.readInt(istr, "ToolColor rgb");
        this.setColor(rgba, alpha);
        return null;
    }

    @Override
    public String streamToString(WBInputStream istr) {
        try {
            int alpha = WBUtils.readInt(istr, "ToolColor alpha string");
            int rgb = WBUtils.readInt(istr, "ToolColor rgb string");
            return this.getName() + ": RGB=" + Integer.toHexString(rgb) + ", Alpha=" + Integer.toHexString(alpha);
        }
        catch (IOException ioe) {
            return this.getName() + " IOException: " + ioe.getMessage();
        }
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeInt(this.masterColor.alpha);
        ostr.writeInt((int)(this.masterColor.rgba & 0xFFFFFFL));
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) {
        String alphaString;
        long rgb = 0L;
        int alpha = 255;
        String rgbString = element.getAttributeValue("RGB");
        if (rgbString != null && !rgbString.equals("")) {
            try {
                rgb = Integer.parseInt(rgbString);
            }
            catch (Exception e) {
                rgb = this.hexToInt(rgbString);
            }
        }
        if ((alphaString = element.getAttributeValue("ALPHA")) != null && !alphaString.equals("")) {
            try {
                alpha = Integer.parseInt(alphaString);
            }
            catch (Exception e) {
                alpha = this.hexToInt(alphaString);
            }
        }
        this.setColor(rgb, alpha);
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) {
        WBElement tc = new WBElement(this.getName());
        int rgb = (int)(this.rgba & 0xFFFFFFL);
        if (rgb != 0) {
            tc.setAttribute(new Attribute("RGB", Integer.toString(rgb)));
        }
        if (this.alpha != 255) {
            tc.setAttribute(new Attribute("ALPHA", Integer.toString(this.alpha)));
        }
        parent.addContent((Content)tc);
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.rgba + ", alpha: " + this.alpha + ")";
    }

    public int hexToInt(String hString) {
        int result = 0;
        block17: for (int i = 0; i < hString.length(); ++i) {
            char c = hString.charAt(i);
            result <<= 4;
            switch (c) {
                default: {
                    continue block17;
                }
                case '1': {
                    result |= 1;
                    continue block17;
                }
                case '2': {
                    result |= 2;
                    continue block17;
                }
                case '3': {
                    result |= 3;
                    continue block17;
                }
                case '4': {
                    result |= 4;
                    continue block17;
                }
                case '5': {
                    result |= 5;
                    continue block17;
                }
                case '6': {
                    result |= 6;
                    continue block17;
                }
                case '7': {
                    result |= 7;
                    continue block17;
                }
                case '8': {
                    result |= 8;
                    continue block17;
                }
                case '9': {
                    result |= 9;
                    continue block17;
                }
                case 'A': 
                case 'a': {
                    result |= 0xA;
                    continue block17;
                }
                case 'B': 
                case 'b': {
                    result |= 0xB;
                    continue block17;
                }
                case 'C': 
                case 'c': {
                    result |= 0xC;
                    continue block17;
                }
                case 'D': 
                case 'd': {
                    result |= 0xD;
                    continue block17;
                }
                case 'E': 
                case 'e': {
                    result |= 0xE;
                    continue block17;
                }
                case 'F': 
                case 'f': {
                    result |= 0xF;
                }
            }
        }
        return result;
    }
}

