/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.attributes;

import com.elluminate.groupware.imps.notes.NotesAPI;
import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.attributes.AbstractAttribute;
import com.elluminate.groupware.whiteboard.conference.WBInputStream;
import com.elluminate.groupware.whiteboard.conference.WBOutputStream;
import com.elluminate.groupware.whiteboard.dataModel.RegisteredTemplate;
import com.elluminate.groupware.whiteboard.interfaces.ProgressUpdate;
import com.elluminate.groupware.whiteboard.xml.WBElement;
import com.elluminate.groupware.whiteboard.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jdom.Attribute;
import org.jdom.Content;

public class PresentersNote
extends AbstractAttribute
implements Cloneable {
    private static final String ATTR_NAME = "notes";
    private static final String SLIDE_NAME = "slidename";
    private List<String> notes = new ArrayList<String>();
    private String slideName = "";
    private static ExecutorService noteDeliveryThreadPool = null;
    private static final int PRESENTERS_NOTE_EXEC_POOL_SIZE = 3;

    public PresentersNote(WhiteboardContext context) {
        super(context, "PresentersNote");
        if (noteDeliveryThreadPool == null && context.getController() != null) {
            noteDeliveryThreadPool = Executors.newFixedThreadPool(3);
        }
        this.setOptional(true);
    }

    public void setPresenterNotes(List<String> notes) {
        if (notes != null) {
            this.notes = notes;
        }
    }

    public List<String> getPresentersNotes() {
        return this.notes;
    }

    public void setSlideName(String slideName) {
        this.slideName = slideName == null ? "" : slideName;
    }

    public String getSlideName() {
        return this.slideName;
    }

    @Override
    public void merge(AbstractAttribute newAttribute) {
    }

    @Override
    public RegisteredTemplate elementToObject(WBElement element, ProgressUpdate progress) throws Exception {
        try {
            this.slideName = element.getAttributeValue(SLIDE_NAME);
            this.notes = this.decode(element.getAttributeValue(ATTR_NAME));
            if (this.notes.size() > 0) {
                if (this.notes.size() == 1 && this.notes.get(0).equals("")) {
                    this.notes = new ArrayList<String>();
                } else {
                    this.submitToNotesEditor();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public WBElement objectToElement(WBElement parent, ProgressUpdate progress) throws Exception {
        WBElement notesElement = new WBElement(this.getName());
        notesElement.setAttribute(new Attribute(SLIDE_NAME, this.slideName));
        notesElement.setAttribute(new Attribute(ATTR_NAME, this.encode(this.notes)));
        parent.addContent((Content)notesElement);
        return null;
    }

    @Override
    public void objectToStream(WBOutputStream ostr) throws Exception {
        super.objectToStream(ostr);
        ostr.writeUTF(this.slideName);
        ostr.writeUTF(this.encode(this.notes));
    }

    @Override
    public RegisteredTemplate streamToObject(WBInputStream istr) throws Exception {
        super.streamToObject(istr);
        this.slideName = WBUtils.readUTF(istr, "PresentersNote slideName");
        this.notes = this.decode(WBUtils.readUTF(istr, "PresentersNote note"));
        if (this.notes.size() > 0) {
            if (this.notes.size() == 1 && this.notes.get(0).equals("")) {
                this.notes = new ArrayList<String>();
            } else {
                this.submitToNotesEditor();
            }
        }
        this.notifyAttributeChange();
        return null;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private String encode(List<String> notes) {
        String reply = "";
        for (String note : notes) {
            reply = reply + note;
            if (notes.indexOf(note) == notes.size() - 1) continue;
            reply = reply + "|";
        }
        return XMLUtils.escapeXMLUnicode(reply);
    }

    private List<String> decode(String escapedNotes) {
        if (escapedNotes == null) {
            return new ArrayList<String>();
        }
        String notes = XMLUtils.unescapeXMLUnicode(escapedNotes);
        return Arrays.asList(notes.split("\\|"));
    }

    public void submitToNotesEditor() {
        if (noteDeliveryThreadPool != null) {
            noteDeliveryThreadPool.execute(new SubmitToNotesEditorRunnable());
        }
    }

    private class SubmitToNotesEditorRunnable
    implements Runnable {
        SubmitToNotesEditorRunnable() {
        }

        @Override
        public void run() {
            NotesAPI notesAPI = (NotesAPI)PresentersNote.this.getContext().getImps().findBest(NotesAPI.class);
            if (notesAPI != null) {
                String noteBundle = "";
                for (String note : PresentersNote.this.notes) {
                    if (note == null || note.equalsIgnoreCase("")) continue;
                    noteBundle = noteBundle + (PresentersNote.this.notes.indexOf(note) != 0 ? "\n" + note : note);
                }
                if (!noteBundle.equals("")) {
                    notesAPI.addNote(PresentersNote.this.slideName, noteBundle, null, -1L, false);
                }
            }
        }
    }
}

