/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.whiteboard.acl;

import com.elluminate.groupware.whiteboard.AccessibleChangeListener;
import com.elluminate.groupware.whiteboard.WBUtils;
import com.elluminate.groupware.whiteboard.WhiteboardContext;
import com.elluminate.groupware.whiteboard.acl.ACLEntry;
import com.elluminate.groupware.whiteboard.acl.ACLTerm;
import com.elluminate.groupware.whiteboard.dataModel.DataModel;
import com.elluminate.groupware.whiteboard.dataModel.Validator;
import com.elluminate.groupware.whiteboard.dataModel.WBNode;
import com.elluminate.groupware.whiteboard.interfaces.ACLList;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientGroupEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.util.Debug;
import com.elluminate.util.log.LogSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ACLManager
implements AccessibleChangeListener {
    WhiteboardContext context;
    HashMap termCache = new HashMap();
    HashSet evaluateClientsSet = new HashSet();
    static int aclSequenceNumber = 1;

    public ACLManager(WhiteboardContext context) {
        this.context = context;
        context.addAccessibleChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ACLEntry add(ACLEntry aclEntry, ACLTerm aclTerm) {
        ACLEntry result = null;
        Debug.lockEnter((Object)this, (String)"ACLManager.add", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ACLMapEntry mapEntry = (ACLMapEntry)this.termCache.get(aclEntry.getEntry());
            if (mapEntry == null) {
                mapEntry = new ACLMapEntry(aclEntry);
                aclEntry.setClientId(this.context.getObjectManager().getClientId());
                aclEntry.setSequence(aclSequenceNumber++);
                this.termCache.put(aclEntry.getEntry(), mapEntry);
            }
            mapEntry.addReference(aclTerm);
            result = mapEntry.getACLEntry();
        }
        Debug.lockLeave((Object)this, (String)"ACLManager.add", (String)"DataModel", (Object)this.context.getDataModel());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ACLEntry aclEntry, ACLTerm aclTerm) {
        Debug.lockEnter((Object)this, (String)"ACLManager.remove", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            ACLMapEntry mapEntry = (ACLMapEntry)this.termCache.get(aclEntry.getEntry());
            if (mapEntry != null) {
                mapEntry.removeReference(aclTerm);
            }
            aclTerm.reEvaluateTerm(null);
        }
        Debug.lockLeave((Object)this, (String)"ACLManager.remove", (String)"DataModel", (Object)this.context.getDataModel());
    }

    public void termEvaluatesClients(ACLTerm masterACLTerm) {
        if (!this.evaluateClientsSet.contains(masterACLTerm)) {
            this.evaluateClientsSet.add(masterACLTerm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTerm(ACLTerm aclTerm) {
        Debug.lockEnter((Object)this, (String)"ACLManager.removeTerm", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            Iterator iter = this.termCache.values().iterator();
            while (iter.hasNext()) {
                ACLMapEntry aclMapEntry = (ACLMapEntry)iter.next();
                Iterator termIterator = aclMapEntry.aclTermIterator();
                while (termIterator.hasNext()) {
                    if (!aclTerm.equals(termIterator.next())) continue;
                    termIterator.remove();
                }
                if (!aclMapEntry.isEmpty()) continue;
                iter.remove();
            }
        }
        Debug.lockLeave((Object)this, (String)"ACLManager.removeTerm", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(ClientEvent e) {
        Debug.lockEnter((Object)this, (String)"ACLManager.addClient", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.notifyTermsOfClientChange(e.getName());
        }
        Debug.lockLeave((Object)this, (String)"ACLManager.addClient", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClient(short clientAddress) {
        ClientInfo clientInfo;
        if (this.context.getClientList() != null && (clientInfo = this.context.getClientList().get(clientAddress)) != null) {
            String name = clientInfo.getName();
            Debug.lockEnter((Object)this, (String)"ACLManager.addClient", (String)"DataModel", (Object)this.context.getDataModel());
            DataModel dataModel = this.context.getDataModel();
            synchronized (dataModel) {
                this.notifyTermsOfClientChange(name);
            }
            Debug.lockLeave((Object)this, (String)"ACLManager.addClient", (String)"DataModel", (Object)this.context.getDataModel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(ClientEvent e) {
        Debug.lockEnter((Object)this, (String)"ACLManager.removeClient", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.notifyTermsOfClientChange(e.getName());
        }
        Debug.lockLeave((Object)this, (String)"ACLManager.removeClient", (String)"DataModel", (Object)this.context.getDataModel());
    }

    public void notifyTermsOfClientChange(String participantName) {
        HashSet<ACLTerm> termSet = new HashSet<ACLTerm>();
        for (ACLMapEntry aclMapEntry : this.termCache.values()) {
            ACLEntry aclEntry = aclMapEntry.getACLEntry();
            if ((!aclEntry.isParticipantSpecific() || !aclEntry.participant.equals(participantName)) && aclEntry.isParticipantSpecific()) continue;
            Iterator termIterator = aclMapEntry.aclTermIterator();
            while (termIterator.hasNext()) {
                ACLTerm aclTerm = (ACLTerm)termIterator.next();
                if (termSet.contains(aclTerm)) continue;
                termSet.add(aclTerm);
            }
        }
        this.notifyTerms(termSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroup(ClientGroupEvent e) {
        Debug.lockEnter((Object)this, (String)"ACLManager.addGroup", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            this.notifyTermsOfGroupChange(e.getGroup().getName());
        }
        Debug.lockLeave((Object)this, (String)"ACLManager.addGroup", (String)"DataModel", (Object)this.context.getDataModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeGroup(ClientGroupEvent e) {
        Debug.lockEnter((Object)this, (String)"ACLManager.changeGroup", (String)"DataModel", (Object)this.context.getDataModel());
        String oldGroupName = "";
        String newGroupName = "";
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (e.getPreviousGroup() != null) {
                newGroupName = e.getPreviousGroup().getName();
            }
            this.notifyTermsOfGroupChange(newGroupName);
            if (e.getGroup() != null) {
                newGroupName = e.getGroup().getName();
            }
            this.notifyTermsOfGroupChange(newGroupName);
        }
        Debug.lockLeave((Object)this, (String)"ACLManager.changeGroup", (String)"DataModel", (Object)this.context.getDataModel());
        this.changeRole(ACLEntry.GROUP_CREATOR_ROLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGroup(ClientGroupEvent e) {
        String groupName = "";
        Debug.lockEnter((Object)this, (String)"ACLManager.removeGroup", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (e.getGroup() != null) {
                groupName = e.getGroup().getName();
            }
            this.notifyTermsOfGroupChange(groupName);
        }
        Debug.lockLeave((Object)this, (String)"ACLManager.removeGroup", (String)"DataModel", (Object)this.context.getDataModel());
    }

    public void notifyTermsOfGroupChange(String groupName) {
        HashSet<ACLTerm> termSet = new HashSet<ACLTerm>();
        for (ACLMapEntry aclMapEntry : this.termCache.values()) {
            ACLEntry aclEntry = aclMapEntry.getACLEntry();
            if ((!aclEntry.isGroupSpecific() || !aclEntry.group.equals(groupName)) && aclEntry.isGroupSpecific()) continue;
            Iterator termIterator = aclMapEntry.aclTermIterator();
            while (termIterator.hasNext()) {
                ACLTerm aclTerm = (ACLTerm)termIterator.next();
                if (termSet.contains(aclTerm)) continue;
                termSet.add(aclTerm);
            }
        }
        this.notifyTerms(termSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeRole(Short role) {
        Debug.lockEnter((Object)this, (String)"ACLManager.changeRole", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            if (role >= 0 && role < ACLEntry.ROLE_NAMES.length) {
                this.notifyTermsOfRoleChange(ACLEntry.ROLE_NAMES[role + 1]);
            }
        }
        Debug.lockLeave((Object)this, (String)"ACLManager.changeRole", (String)"DataModel", (Object)this.context.getDataModel());
    }

    @Override
    public void onAccessibleChange(boolean accessible) {
        this.changeRole(ACLEntry.ACCESSIBLE);
    }

    public void notifyTermsOfRoleChange(String roleName) {
        HashSet<ACLTerm> termSet = new HashSet<ACLTerm>();
        for (ACLMapEntry aclMapEntry : this.termCache.values()) {
            ACLEntry aclEntry = aclMapEntry.getACLEntry();
            if ((!aclEntry.isRoleSpecific() || !aclEntry.role.equals(roleName)) && aclEntry.isRoleSpecific()) continue;
            Iterator termIterator = aclMapEntry.aclTermIterator();
            while (termIterator.hasNext()) {
                ACLTerm aclTerm = (ACLTerm)termIterator.next();
                if (termSet.contains(aclTerm)) continue;
                termSet.add(aclTerm);
            }
        }
        this.notifyTerms(termSet);
    }

    public void reEvaluateAllTerms() {
        HashSet<ACLTerm> termSet = new HashSet<ACLTerm>();
        for (ACLMapEntry aclMapEntry : this.termCache.values()) {
            ACLEntry aclEntry = aclMapEntry.getACLEntry();
            Iterator termIterator = aclMapEntry.aclTermIterator();
            while (termIterator.hasNext()) {
                ACLTerm aclTerm = (ACLTerm)termIterator.next();
                if (termSet.contains(aclTerm)) continue;
                termSet.add(aclTerm);
            }
        }
        this.notifyTerms(termSet);
    }

    private void notifyTerms(HashSet notifySet) {
        ACLTerm[] notifyObjects = new ACLTerm[]{};
        if (!this.evaluateClientsSet.isEmpty()) {
            this.evaluateClientsSet.addAll(notifySet);
            notifyObjects = this.evaluateClientsSet.toArray(notifyObjects);
        } else {
            notifyObjects = notifySet.toArray(notifyObjects);
        }
        for (int i = 0; i < notifyObjects.length; ++i) {
            notifyObjects[i].reEvaluateTerm(Boolean.FALSE);
        }
        if (!this.evaluateClientsSet.isEmpty()) {
            this.evaluateClientsSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer result = new StringBuffer();
        Debug.lockEnter((Object)this, (String)"ACLManager.toString", (String)"DataModel", (Object)this.context.getDataModel());
        DataModel dataModel = this.context.getDataModel();
        synchronized (dataModel) {
            result.append("ACLManager holds " + this.termCache.size() + " entries.\n");
            Set keys = this.termCache.keySet();
            for (String key : keys) {
                result.append("  ACLEntry: '" + key + "'  ");
                ACLMapEntry mapEntry = (ACLMapEntry)this.termCache.get(key);
                Iterator termIter = mapEntry.aclTermIterator();
                while (termIter.hasNext()) {
                    ACLTerm term = (ACLTerm)termIter.next();
                    result.append(term + " ");
                }
                result.append("\n\n");
            }
        }
        Debug.lockLeave((Object)this, (String)"ACLManager.toString", (String)"DataModel", (Object)this.context.getDataModel());
        return result.toString();
    }

    public static boolean validate(ACLList parent, ACLTerm[] terms) {
        boolean valid = true;
        for (int i = 0; i < terms.length; ++i) {
            ACLTerm term = terms[i];
            if (term.getParent() != parent) {
                Validator.logAlways("ACLTerm: " + term.getName() + ", child of: " + WBUtils.objectName(parent) + ", has null parent.");
                valid = false;
            }
            if (!(parent instanceof WBNode)) continue;
            valid &= ACLManager.validateACLChildren(parent, ((WBNode)parent).iterateScreens(), term);
        }
        return valid;
    }

    private static boolean validateACLChildren(ACLList parent, Iterator iter, ACLTerm aclTerm) {
        boolean valid = true;
        while (iter.hasNext()) {
            ACLList aclList = (ACLList)iter.next();
            ACLTerm childACLTerm = aclList.getACLTerm(aclTerm.getName());
            if (childACLTerm == null) {
                LogSupport.message((Object)parent, (String)"validateACLChildren", (String)("term: '" + aclTerm.getName() + "', finds parent: " + WBUtils.objectName(parent) + ", with child screen: " + WBUtils.objectName(aclList) + ", without term."));
                valid = Validator.setValid(valid, false);
            } else {
                valid &= aclTerm.validate(aclList);
            }
            if (!(aclList instanceof WBNode)) continue;
            valid &= ACLManager.validateACLChildren(aclList, ((WBNode)aclList).iterateScreens(), aclTerm);
        }
        return valid;
    }

    public class ACLMapEntry {
        ArrayList refs = WhiteboardContext.EMPTY_ARRAYLIST;
        ACLEntry aclEntry;

        public ACLMapEntry(ACLEntry aclEntry) {
            this.aclEntry = aclEntry;
        }

        public void addReference(ACLTerm aclTerm) {
            if (this.refs == WhiteboardContext.EMPTY_ARRAYLIST) {
                this.refs = new ArrayList();
            }
            if (!this.refs.contains(aclTerm)) {
                this.refs.add(aclTerm);
            }
        }

        public void removeReference(ACLTerm aclTerm) {
            if (this.refs == WhiteboardContext.EMPTY_ARRAYLIST) {
                return;
            }
            this.refs.remove(aclTerm);
            if (this.refs.size() == 0) {
                this.refs = WhiteboardContext.EMPTY_ARRAYLIST;
            }
        }

        public Iterator aclTermIterator() {
            return this.refs.iterator();
        }

        public ACLEntry getACLEntry() {
            return this.aclEntry;
        }

        public boolean isEmpty() {
            return this.refs.isEmpty();
        }
    }
}

