/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.telephony.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.framework.session.CRSession;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.groupware.imps.module.AudioAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.telephony.TelephonyFlags;
import com.elluminate.groupware.telephony.TelephonyMessage;
import com.elluminate.groupware.telephony.TelephonyProtocol;
import com.elluminate.groupware.telephony.module.ConfigureTeleconferenceCmd;
import com.elluminate.groupware.telephony.module.ConnectTeleconferenceCmd;
import com.elluminate.groupware.telephony.module.ConnectionDialogs;
import com.elluminate.groupware.telephony.module.DisconnectTeleconferenceCmd;
import com.elluminate.groupware.telephony.module.StringsProperties;
import com.elluminate.groupware.telephony.module.TeleconferenceSetupDialog;
import com.elluminate.groupware.telephony.module.TelephonyConnectionController;
import com.elluminate.groupware.telephony.module.TelephonyStateMachine;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.ProgressDialog;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ConferenceName;
import com.elluminate.jinx.JinxChannelException;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.JinxServerProps;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.Debug;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StateMachine;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;

@Singleton
public class TelephonyModule
extends AbstractClientModule
implements ModulePublisherInfo,
ActionListener,
ChannelListener,
PropertyChangeListener,
ChannelDataListener,
ActionFeatureListener {
    private static final Map<String, String> propMap = new TreeMap<String, String>();
    private static final Map<String, String> revMap = new TreeMap<String, String>();
    private SwingRunner swingRunner;
    private static I18n i18n;
    public static final String MODULE_NAME = "telephony";
    private Frame parent = null;
    private Client client = null;
    private ClientList clients = null;
    private Channel channel = null;
    private TelephonyIMPS telImps = null;
    private TimeMonitor tMonitor = new TimeMonitor();
    private ChairProtocol chairProtocol;
    private Imps imps;
    private TelephonyConnectionController controller = null;
    private TelephonyStateMachine stateMachine = new TelephonyStateMachine();
    private ProgressDialog connectionProgressDialog = null;
    private ConnectionDialogs connectionDialogs = new ConnectionDialogs();
    private TeleconferenceSetupDialog setupDialog = null;
    private boolean isOriginator = false;
    private StateMachine.StateMachineEventListener idleConnectStateListener;
    private StateMachine.StateMachineStateListener idleRemoteDisconnectListener;
    private StateMachine.StateMachineStateListener idleStateListener;
    private StateMachine.StateMachineStateListener connectProgressConnectSucceedListener;
    private StateMachine.StateMachineStateListener connectProgressFailedListener;
    private StateMachine.StateMachineEventListener disconnectQueryConnectionStatusListener;
    private ClientProvider clientProvider;
    private ActionFeature setupMenuFeature;
    private FeatureBroker broker;
    private ActionFeature connectMenuFeature;
    private ActionFeature announceMenuFeature;
    private ActionFeature volUpToMenuFeature;
    private ActionFeature volUpFromMenuFeature;
    private ActionFeature volDownToMenuFeature;
    private ActionFeature volDownFromMenuFeature;
    private ConferencingEngine confEngine;
    private Provider<ConfigureTeleconferenceCmd> confTelCmdProvider;
    private Provider<ConnectTeleconferenceCmd> connectTelCmdProvider;
    private Provider<DisconnectTeleconferenceCmd> discTelCmdProvider;
    private CRSession session;
    public static final short UNDEFINED_BRIDGE_PARTICIPANT_ID = -1;
    private short bridgeParticipantId = (short)-1;

    private static void bindProperties(String apiProp, String protoProp) {
        propMap.put(apiProp, protoProp);
        revMap.put(protoProp, apiProp);
    }

    public TelephonyModule() {
        this.setStateTracing();
        this.createStateListeners();
    }

    @Inject
    protected void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    public void initSwingRunner(SwingRunner swingRunner) {
        this.swingRunner = swingRunner;
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initConferencingEngine(ConferencingEngine ce) {
        this.confEngine = ce;
    }

    @Inject
    public void initPauseCmdProvider(Provider<ConfigureTeleconferenceCmd> cmd) {
        this.confTelCmdProvider = cmd;
    }

    @Inject
    public void initConnecTelCmdProvider(Provider<ConnectTeleconferenceCmd> cmd) {
        this.connectTelCmdProvider = cmd;
    }

    @Inject
    public void initDiscTelCmdProvider(Provider<DisconnectTeleconferenceCmd> cmd) {
        this.discTelCmdProvider = cmd;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    @Inject
    protected void initChairProtocol(ChairProtocol proto) {
        this.chairProtocol = proto;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_TITLE);
    }

    public Icon getModuleIcon() {
        return i18n.getIcon("TelephonyModule.icon");
    }

    int getProtocolState() {
        if (this.clients == null) {
            return 1;
        }
        return this.clients.getProperty("Telephony.connectionState", 1);
    }

    boolean isSessionTeleconferencingAvailable() {
        return this.telImps != null && this.telImps.isEnabled();
    }

    void setUpSessionTeleconference(String participantPhone, String participantPIN, String moderatorPhone, String moderatorPIN, String sessionPhone, String sessionSIP, String sessionPIN) {
        if (this.clients == null) {
            return;
        }
        this.clients.setProperty("Telephony.participantTelephone", participantPhone);
        this.clients.setProperty("Telephony.moderatorTelephone", moderatorPhone);
        this.clients.setProperty("Telephony.sessionTelephone", sessionPhone);
        this.clients.setProperty("Telephony.sessionPIN", sessionPIN);
        this.clients.setProperty("Telephony.participantPIN", participantPIN);
        this.clients.setProperty("Telephony.moderatorPIN", moderatorPIN);
        this.clients.setProperty("Telephony.sessionSIP", sessionSIP);
    }

    boolean isSessionTeleconferenceSetUp() {
        if (this.clients == null) {
            return false;
        }
        String tel = this.clients.getProperty("Telephony.sessionTelephone", "");
        String sip = this.clients.getProperty("Telephony.sessionSIP", "");
        return tel != null && !"".equals(tel) || sip != null && !"".equals(sip);
    }

    public void updateUI() {
        boolean showUI;
        if (this.clients == null) {
            return;
        }
        boolean amChair = this.chairProtocol.amChair(this.clients);
        boolean isLive = this.client != null && !this.client.isPlayback();
        boolean isEnabled = this.telImps == null ? false : this.telImps.isEnabled();
        boolean isConnected = this.telImps == null ? false : this.telImps.isConnected();
        int state = this.getProtocolState();
        boolean isSetUp = this.isSessionTeleconferenceSetUp();
        boolean isDisconnected = state == 1;
        String sessionTitleLabel = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.Session");
        boolean bl = showUI = isEnabled && amChair && isLive;
        if (TelephonyFlags.UPDATE_UI.show()) {
            LogSupport.message((Object)this, (String)"updateUI", (String)("chair=" + amChair + " isLive=" + isLive + " isEnabled=" + isEnabled + " isConnected=" + isConnected + " isDisconnected=" + isDisconnected + " isSetUp=" + isSetUp + " showUI=" + showUI));
        }
        this.setupMenuFeature.setEnabled(showUI);
        this.connectMenuFeature.setEnabled(showUI && (!isDisconnected || isSetUp));
        this.announceMenuFeature.setEnabled(showUI && isConnected);
        this.volUpToMenuFeature.setEnabled(showUI && isConnected);
        this.volDownToMenuFeature.setEnabled(showUI && isConnected);
        this.volUpFromMenuFeature.setEnabled(showUI && isConnected);
        this.volDownFromMenuFeature.setEnabled(showUI && isConnected);
        this.connectMenuFeature.setName(!isDisconnected ? i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_DISCONNECTMENUITEM, new Object[]{sessionTitleLabel}) : i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_CONNECTMENUITEM, new Object[]{sessionTitleLabel}));
        this.announceMenuFeature.setName(i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_ANNOUNCEMENUITEM, new Object[]{sessionTitleLabel}));
        if (this.telImps.getTelephonyMode() != 2) {
            this.broker.setFeaturePublished((Feature)this.setupMenuFeature, showUI);
            this.broker.setFeaturePublished((Feature)this.connectMenuFeature, showUI);
        }
        this.broker.setFeaturePublished((Feature)this.announceMenuFeature, showUI);
        this.broker.setFeaturePublished((Feature)this.volUpToMenuFeature, showUI);
        this.broker.setFeaturePublished((Feature)this.volUpFromMenuFeature, showUI);
        this.broker.setFeaturePublished((Feature)this.volDownToMenuFeature, showUI);
        this.broker.setFeaturePublished((Feature)this.volDownFromMenuFeature, showUI);
    }

    public void actionPerformed(ActionFeatureEvent ev) {
        AudioAPI audioAPI;
        Object src = ev.getSource();
        if (src == this.setupMenuFeature) {
            this.doSetUp();
        } else if (src == this.connectMenuFeature) {
            this.doToggleConnect();
        } else if (src == this.announceMenuFeature) {
            this.sendAnnounce();
        } else if (src == this.volUpToMenuFeature) {
            TelephonyMessage msg = TelephonyMessage.createOutVolumeUpMsg();
            this.sendMessageToService(msg);
        } else if (src == this.volDownToMenuFeature) {
            TelephonyMessage msg = TelephonyMessage.createOutVolumeDownMsg();
            this.sendMessageToService(msg);
        } else if (src == this.volUpFromMenuFeature) {
            AudioAPI audioAPI2;
            if (this.telImps.isEnabled() && this.telImps.isConnected() && (audioAPI2 = (AudioAPI)this.imps.findBest(AudioAPI.class)) != null && this.bridgeParticipantId != -1) {
                audioAPI2.volumeInc(this.bridgeParticipantId);
            }
        } else if (src == this.volDownFromMenuFeature && this.telImps.isEnabled() && this.telImps.isConnected() && (audioAPI = (AudioAPI)this.imps.findBest(AudioAPI.class)) != null && this.bridgeParticipantId != -1) {
            audioAPI.volumeDec(this.bridgeParticipantId);
        }
    }

    void doSetUp() {
        if (this.controller == null) {
            this.controller = new TelephonyConnectionController(){

                @Override
                public void connect() {
                    TelephonyModule.this.sendConnect();
                }

                @Override
                public void disconnect() {
                    TelephonyModule.this.sendDisconnect();
                }
            };
        }
        if (this.setupDialog != null) {
            this.setupDialog.setVisible(false);
        }
        String title = i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_TITLE);
        this.setupDialog = new TeleconferenceSetupDialog(this.parent, title, this.clientProvider.get(), this.controller, this, this.imps);
        this.setupDialog.show();
    }

    void queryAndDisconnect() {
        if (this.connectionDialogs.showConfirmDisconnectDialog(this.parent, this.clients)) {
            this.disconnect();
        }
    }

    void disconnect() {
        this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_UI_DISCONNECT, null);
        this.sendDisconnect();
    }

    boolean isDisconnected() {
        return this.getProtocolState() == 1;
    }

    private void doToggleConnect() {
        if (this.isDisconnected()) {
            this.sendConnect();
        } else {
            this.queryAndDisconnect();
        }
    }

    public void channelStateChanged(ChannelEvent event) {
        switch (event.getState()) {
            case 1: {
                break;
            }
            case 2: {
                this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_PERMISSION_LOST, null);
            }
        }
        this.updateUI();
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        String propName = ev.getPropertyName();
        Object newVal = ev.getNewValue();
        if (propName.equals("chair.role")) {
            boolean isChair;
            boolean bl = isChair = newVal == null ? false : (Boolean)newVal;
            if (this.clients.getPropertyOwner(ev.getSource()) == this.clients.getMyAddress() && !isChair) {
                this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_PERMISSION_LOST, null);
                if (this.setupDialog != null) {
                    this.setupDialog.setVisible(false);
                    this.setupDialog = null;
                }
            }
        } else if (!propName.startsWith("Telephony.")) {
            return;
        }
        if (propName.equals("Telephony.connectionState") && newVal instanceof Integer && (Integer)newVal == 1) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TelephonyModule.this.connectionDialogs.hideConfigDisconnectDialog();
                }
            });
        }
        this.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void setupUI() {
        this.createFeatures();
    }

    public void cleanupUI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMessageToService(TelephonyMessage msg) {
        ChannelDataEvent ev = null;
        boolean result = true;
        try {
            ev = msg.createEventRec((Object)this, (short)0);
            this.channel.onChannelData(ev);
            ev = null;
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendMessageToService", (Throwable)ex, (boolean)true);
            result = false;
        }
        finally {
            if (ev != null) {
                try {
                    ev.dispose();
                }
                catch (Throwable ignored) {}
            }
        }
        return result;
    }

    void sendConnect() {
        this.isOriginator = true;
        TelephonyMessage msg = TelephonyMessage.createConnectMsg();
        this.sendMessageToService(msg);
    }

    void sendDisconnect() {
        this.isOriginator = false;
        TelephonyMessage msg = TelephonyMessage.createDisconnectMsg();
        this.sendMessageToService(msg);
    }

    void sendCancelConnect() {
        this.isOriginator = false;
        TelephonyMessage msg = TelephonyMessage.createCancelConnectMsg();
        this.sendMessageToService(msg);
    }

    void sendAnnounce() {
        TelephonyMessage msg = TelephonyMessage.createAnnounceMsg();
        this.sendMessageToService(msg);
    }

    void sendAcceptConnection() {
        TelephonyMessage msg = TelephonyMessage.createAcceptConnectionMsg();
        this.sendMessageToService(msg);
    }

    void sendRejectConnection() {
        TelephonyMessage msg = TelephonyMessage.createRejectConnectionMsg();
        this.sendMessageToService(msg);
    }

    void sendReconnect() {
        this.isOriginator = true;
        TelephonyMessage msg = TelephonyMessage.createReconnectMsg();
        this.sendMessageToService(msg);
    }

    private void createOrUpdateConnectionStatusDialog(StateMachine.StateMachineEvent ev) {
        I18nMessage reason;
        this.connectionDialogs.hideConnectionFailedDialog();
        if (this.connectionProgressDialog == null) {
            String title = i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_PROGRESSTITLE);
            String initNote = i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_PROGRESSINITIALIZING);
            String telOrSip = this.clients.getProperty("Telephony.sessionTelephone", (String)null);
            if (telOrSip == null || telOrSip.equals("")) {
                telOrSip = this.clients.getProperty("Telephony.sessionSIP", "");
            }
            String msg = i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_PROGRESSMESSAGE, new Object[]{telOrSip});
            this.connectionProgressDialog = new ProgressDialog((Component)this.parent, (Object)msg, title, initNote, 1, 4, true);
            this.connectionProgressDialog.addCancelListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TelephonyModule.this.sendCancelConnect();
                    TelephonyModule.this.isOriginator = false;
                }
            });
            this.connectionProgressDialog.show();
        }
        if (this.connectionProgressDialog == null) {
            return;
        }
        Object data = ev.getData();
        if (data != null && data instanceof I18nMessage && (reason = (I18nMessage)data) != null) {
            this.connectionProgressDialog.setNote(reason.toString());
        }
    }

    private void processProgressToConfirmState() {
        if (this.connectionProgressDialog != null) {
            this.connectionProgressDialog.setVisible(false);
            this.connectionProgressDialog = null;
        }
        if (this.isOriginator) {
            boolean result = this.connectionDialogs.showConnectionConfirmationDialog(this.parent, this.clients, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TelephonyModule.this.sendAnnounce();
                }
            });
            if (result) {
                this.sendAcceptConnection();
                this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_UI_OK, null);
            } else {
                this.sendRejectConnection();
                this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_UI_DISCONNECT, null);
            }
            this.isOriginator = false;
        }
    }

    private void processRemoteDisconnectEvent() {
        if (this.connectionProgressDialog != null) {
            this.connectionProgressDialog.setVisible(false);
            this.connectionProgressDialog = null;
        }
        this.isOriginator = false;
        this.connectionDialogs.hideConnectionConfirmationDialog();
        String reason = "";
        boolean result = false;
        if (this.telImps.getTelephonyMode() != 2) {
            result = this.connectionDialogs.showRemoteDisconnectDialog(this.parent, this.clients, reason);
        }
        if (result) {
            this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_UI_RECONNECT, null);
            this.sendReconnect();
        } else {
            this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_UI_CANCEL_QUERY, null);
        }
    }

    private void processStateChangeToIdle() {
        if (this.connectionProgressDialog != null) {
            this.connectionProgressDialog.setVisible(false);
            this.connectionProgressDialog = null;
        }
        this.isOriginator = false;
        this.connectionDialogs.hideAllDialogs();
    }

    private void processConnectFailed(StateMachine.StateMachineEvent ev) {
        TelephonyMessage msg;
        if (this.connectionProgressDialog != null) {
            this.connectionProgressDialog.setVisible(false);
            this.connectionProgressDialog = null;
        }
        boolean showMsg = true;
        Object data = ev.getData();
        String failedReason = "";
        if (data != null && data instanceof TelephonyMessage && (msg = (TelephonyMessage)data).getCommand() == 10) {
            short origin = msg.getOriginator();
            short myAddr = -32767;
            if (this.clients != null) {
                myAddr = this.clients.getMyAddress();
            }
            if (myAddr != -32767 && myAddr == origin) {
                showMsg = false;
            } else {
                I18nMessage reason = msg.getReason();
                if (reason != null) {
                    failedReason = reason.toString();
                }
            }
        }
        boolean result = false;
        if (showMsg) {
            result = this.connectionDialogs.showConnectionFailedDialog(this.parent, this.clients, failedReason, "");
        }
        if (result) {
            this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_UI_CANCEL, null);
            this.doSetUp();
        } else {
            this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_UI_CANCEL, null);
        }
    }

    private void processDisconnectQueryConnectionStatusMsg() {
        this.connectionDialogs.hideRemoteDisconnectDialog();
    }

    private void createStateListeners() {
        this.idleConnectStateListener = new StateMachine.StateMachineEventListener(){

            public void eventFired(StateMachine.StateMachineEvent ev) {
                final StateMachine.StateMachineEvent event = ev;
                TelephonyModule.this.swingRunner.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TelephonyModule.this.createOrUpdateConnectionStatusDialog(event);
                    }
                });
            }
        };
        this.idleRemoteDisconnectListener = new StateMachine.StateMachineStateListener(){

            public void stateEntered(StateMachine.StateMachineEvent ev) {
                StateMachine.StateMachineEvent event = ev;
                if (ev.getDestinationState().equals(TelephonyStateMachine.STATE_DISCONNECT_QUERY)) {
                    TelephonyModule.this.swingRunner.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TelephonyModule.this.processRemoteDisconnectEvent();
                        }
                    });
                }
            }

            public void stateExited(StateMachine.StateMachineEvent ev) {
            }
        };
        this.idleStateListener = new StateMachine.StateMachineStateListener(){

            public void stateEntered(StateMachine.StateMachineEvent ev) {
                if (ev.getDestinationState().equals(TelephonyStateMachine.STATE_IDLE)) {
                    TelephonyModule.this.swingRunner.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TelephonyModule.this.processStateChangeToIdle();
                        }
                    });
                }
            }

            public void stateExited(StateMachine.StateMachineEvent ev) {
            }
        };
        this.connectProgressConnectSucceedListener = new StateMachine.StateMachineStateListener(){

            public void stateEntered(StateMachine.StateMachineEvent ev) {
                if (ev.getDestinationState().equals(TelephonyStateMachine.STATE_CONNECTION_CONFIRM)) {
                    TelephonyModule.this.swingRunner.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TelephonyModule.this.processProgressToConfirmState();
                        }
                    });
                }
            }

            public void stateExited(StateMachine.StateMachineEvent ev) {
            }
        };
        this.connectProgressFailedListener = new StateMachine.StateMachineStateListener(){

            public void stateEntered(StateMachine.StateMachineEvent ev) {
                if (ev.getDestinationState().equals(TelephonyStateMachine.STATE_CONNECT_FAILED)) {
                    final StateMachine.StateMachineEvent event = ev;
                    TelephonyModule.this.swingRunner.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TelephonyModule.this.processConnectFailed(event);
                        }
                    });
                }
            }

            public void stateExited(StateMachine.StateMachineEvent ev) {
            }
        };
        this.disconnectQueryConnectionStatusListener = new StateMachine.StateMachineEventListener(){

            public void eventFired(StateMachine.StateMachineEvent ev) {
                TelephonyModule.this.swingRunner.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TelephonyModule.this.processDisconnectQueryConnectionStatusMsg();
                    }
                });
            }
        };
    }

    private void registerStateListeners() {
        this.stateMachine.addEventListener(TelephonyStateMachine.STATE_IDLE, TelephonyStateMachine.EVENT_CONNECT_ACK_SUCCESS, this.idleConnectStateListener);
        this.stateMachine.addEventListener(TelephonyStateMachine.STATE_IDLE, TelephonyStateMachine.EVENT_CONNECTION_STATUS, this.idleConnectStateListener);
        this.stateMachine.addStateListener(TelephonyStateMachine.STATE_IDLE, this.idleStateListener);
        this.stateMachine.addEventListener(TelephonyStateMachine.STATE_CONNECTION_PROGRESS, TelephonyStateMachine.EVENT_CONNECTION_STATUS, this.idleConnectStateListener);
        this.stateMachine.addStateListener(TelephonyStateMachine.STATE_CONNECTION_CONFIRM, this.connectProgressConnectSucceedListener);
        this.stateMachine.addStateListener(TelephonyStateMachine.STATE_CONNECT_FAILED, this.connectProgressFailedListener);
        this.stateMachine.addEventListener(TelephonyStateMachine.STATE_CONNECT_FAILED, TelephonyStateMachine.EVENT_CONNECT_ACK_SUCCESS, this.idleConnectStateListener);
        this.stateMachine.addEventListener(TelephonyStateMachine.STATE_CONNECT_FAILED, TelephonyStateMachine.EVENT_CONNECTION_STATUS, this.idleConnectStateListener);
        this.stateMachine.addStateListener(TelephonyStateMachine.STATE_DISCONNECT_QUERY, this.idleRemoteDisconnectListener);
        this.stateMachine.addEventListener(TelephonyStateMachine.STATE_DISCONNECT_QUERY, TelephonyStateMachine.EVENT_CONNECTION_STATUS, this.disconnectQueryConnectionStatusListener);
    }

    private void removeStateListeners() {
        this.stateMachine.removeEventListener(TelephonyStateMachine.STATE_IDLE, TelephonyStateMachine.EVENT_CONNECT_ACK_SUCCESS, this.idleConnectStateListener);
        this.stateMachine.removeEventListener(TelephonyStateMachine.STATE_IDLE, TelephonyStateMachine.EVENT_CONNECTION_STATUS, this.idleConnectStateListener);
        this.stateMachine.removeStateListener(TelephonyStateMachine.STATE_DISCONNECT_QUERY, this.idleRemoteDisconnectListener);
        this.stateMachine.removeStateListener(TelephonyStateMachine.STATE_IDLE, this.idleStateListener);
        this.stateMachine.removeEventListener(TelephonyStateMachine.STATE_CONNECTION_PROGRESS, TelephonyStateMachine.EVENT_CONNECTION_STATUS, this.idleConnectStateListener);
        this.stateMachine.removeStateListener(TelephonyStateMachine.STATE_CONNECTION_CONFIRM, this.connectProgressConnectSucceedListener);
        this.stateMachine.removeStateListener(TelephonyStateMachine.STATE_CONNECT_FAILED, this.connectProgressFailedListener);
        this.stateMachine.removeEventListener(TelephonyStateMachine.STATE_CONNECT_FAILED, TelephonyStateMachine.EVENT_CONNECT_ACK_SUCCESS, this.idleConnectStateListener);
        this.stateMachine.removeEventListener(TelephonyStateMachine.STATE_CONNECT_FAILED, TelephonyStateMachine.EVENT_CONNECTION_STATUS, this.idleConnectStateListener);
    }

    public void onChannelData(ChannelDataEvent event) {
        try {
            TelephonyMessage msg = new TelephonyMessage(event);
            if (TelephonyFlags.MESSAGE_DECODE.show()) {
                LogSupport.message((Object)this, (String)"onChannelData", (String)("Message received " + msg));
            }
            switch (msg.getCommand()) {
                case 2: {
                    if (msg.getAccept()) {
                        this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_CONNECT_ACK_SUCCESS, msg.getReason());
                        break;
                    }
                    this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_CONNECTION_FAILED, null);
                    break;
                }
                case 9: {
                    this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_CONNECTION_SUCCEEDED, null);
                    break;
                }
                case 5: {
                    this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_REMOTE_DISCONNECT, null);
                    break;
                }
                case 10: {
                    this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_CONNECTION_FAILED, msg);
                    break;
                }
                case 8: {
                    I18nMessage reason = msg.getReason();
                    this.setProgress(msg.getStatus());
                    switch (msg.getStatus()) {
                        case 1: {
                            reason = i18n.getMessage((PropertiesEnum)StringsProperties.TELEPHONYMODULE_PROGRESSINITIALIZING);
                            break;
                        }
                        case 2: {
                            reason = i18n.getMessage((PropertiesEnum)StringsProperties.TELEPHONYMODULE_PROGRESSCALLING);
                            break;
                        }
                        case 3: {
                            reason = i18n.getMessage((PropertiesEnum)StringsProperties.TELEPHONYMODULE_PROGRESSAUTHENTICATING);
                            break;
                        }
                        case 4: {
                            reason = i18n.getMessage((PropertiesEnum)StringsProperties.TELEPHONYMODULE_PROGRESSCONNECTED);
                        }
                    }
                    this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_CONNECTION_STATUS, reason);
                    break;
                }
                case 4: {
                    this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_DISCONNECT_ACK, null);
                    break;
                }
                case 11: {
                    this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_ACCEPT_CONNECTION, null);
                    break;
                }
                case 12: {
                    this.stateMachine.applyEvent(TelephonyStateMachine.EVENT_REJECT_CONNECTION, null);
                    break;
                }
                case 1: 
                case 3: 
                case 6: 
                case 7: 
                case 13: 
                case 14: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    break;
                }
                default: {
                    LogSupport.error((Object)this, (String)"", (String)("Invalid command: " + msg));
                    return;
                }
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)t, (boolean)true, (String)("Error processing event: " + event));
        }
    }

    private void setProgress(int status) {
        try {
            if (this.connectionProgressDialog != null) {
                this.connectionProgressDialog.setProgress(status);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setStateTracing() {
        this.stateMachine.setTracing(TelephonyFlags.CLIENT_STATE_TRACE.show());
        TelephonyFlags.CLIENT_STATE_TRACE.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TelephonyModule.this.stateMachine.setTracing(TelephonyFlags.CLIENT_STATE_TRACE.show());
            }
        });
    }

    public void start() {
        this.confEngine.registerCommand(this.confTelCmdProvider);
        this.confEngine.registerCommand(this.connectTelCmdProvider);
        this.confEngine.registerCommand(this.discTelCmdProvider);
    }

    public void attach() {
        this.client = this.clientProvider.get();
        this.clients = this.client.getClientList();
        this.telImps = new TelephonyIMPS();
        this.imps.provideAPI(TelephonyAPI.class, (ImpsAPI)this.telImps);
        try {
            this.channel = this.client.acquireChannel(MODULE_NAME, (byte)2, (ChannelListener)this, (ChannelDataListener)this);
            this.channel.setProtocol((JinxProtocol)new TelephonyProtocol());
        }
        catch (JinxChannelException cx) {
            LogSupport.exception((Object)this, (String)"configure", (Throwable)cx, (boolean)true);
            return;
        }
        this.clients.addPropertyChangeListener((PropertyChangeListener)this.telImps);
        this.clients.addClientPropertyChangeListener((PropertyChangeListener)this.telImps);
        this.clients.addPropertyChangeListener((PropertyChangeListener)this.tMonitor);
        this.clients.addPropertyChangeListener((PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Telephony.connectionState", (PropertyChangeListener)this);
        this.clients.addClientPropertyChangeListener("chair.role", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener((byte)0, (PropertyChangeListener)new TelephonyAnnotationProvider());
        this.registerStateListeners();
    }

    public void detach() {
        if (this.clients != null) {
            this.clients.removePropertyChangeListener((PropertyChangeListener)this);
            this.clients.removePropertyChangeListener((PropertyChangeListener)this.tMonitor);
            this.clients.removeClientPropertyChangeListener((PropertyChangeListener)this.telImps);
            this.clients.removePropertyChangeListener((PropertyChangeListener)this.telImps);
            this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
            this.clients.removePropertyChangeListener("Telephony.connectionState", (PropertyChangeListener)this);
            this.clients = null;
            this.client = null;
            this.removeStateListeners();
        }
    }

    public void stop() {
    }

    private void createFeatures() {
        this.setupMenuFeature = this.broker.createActionFeature((Object)this, "/telephony/setupMenu", i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_SETUPMENUITEM), null);
        this.setupMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.connectMenuFeature = this.broker.createActionFeature((Object)this, "/telephony/connectMenu", null, null);
        this.connectMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.announceMenuFeature = this.broker.createActionFeature((Object)this, "/telephony/announceMenu", null, null);
        this.announceMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.volUpToMenuFeature = this.broker.createActionFeature((Object)this, "/telephony/volUpToMenu", i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_VOLUMEUPTOMENUITEM), null);
        this.volUpToMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.volUpFromMenuFeature = this.broker.createActionFeature((Object)this, "/telephony/volUpFromMenu", i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_VOLUMEUPFROMMENUITEM), null);
        this.volUpFromMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.volDownToMenuFeature = this.broker.createActionFeature((Object)this, "/telephony/volDownToMenu", i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_VOLUMEDOWNTOMENUITEM), null);
        this.volDownToMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.volDownFromMenuFeature = this.broker.createActionFeature((Object)this, "/telephony/volDownFromMenu", i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_VOLUMEDOWNFROMMENUITEM), null);
        this.volDownFromMenuFeature.addActionFeatureListener((ActionFeatureListener)this);
        this.session.registerAnnotation("TelephonyActivityAnnotation", (Object)0);
    }

    static {
        TelephonyModule.bindProperties("TelephonyAPI.mode", "Telephony.mode");
        TelephonyModule.bindProperties("TelephonyAPI.connected", "Telephony.connectionState");
        TelephonyModule.bindProperties("TelephonyAPI.accruedTime", "Telephony.accruedTime");
        TelephonyModule.bindProperties("TelephonyAPI.timeLimit", "Telephony.timeLimit");
        TelephonyModule.bindProperties("TelephonyAPI.audioMode", "Telephony.audioMode");
        TelephonyModule.bindProperties("TelephonyAPI.participantTelephone", "Telephony.participantTelephone");
        TelephonyModule.bindProperties("TelephonyAPI.participantPIN", "Telephony.participantPIN");
        TelephonyModule.bindProperties("TelephonyAPI.moderatorTelephone", "Telephony.moderatorTelephone");
        TelephonyModule.bindProperties("TelephonyAPI.moderatorPIN", "Telephony.moderatorPIN");
        i18n = I18n.create(TelephonyModule.class);
    }

    private class TelephonyAnnotationProvider
    implements PropertyChangeListener {
        private TelephonyAnnotationProvider() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (TelephonyModule.this.clients == null) {
                return;
            }
            String propertyName = evt.getPropertyName();
            short ownerId = TelephonyModule.this.clients.getPropertyOwner(evt.getSource());
            ClientInfo ci = TelephonyModule.this.clients.get(ownerId);
            if (ci == null) {
                return;
            }
            if (propertyName.equals("Telephony.audioMode")) {
                int mode = ci.getProperty("Telephony.audioMode", 1);
                if (mode == 3) {
                    ImageIcon telIcon = i18n.getIcon((PropertiesEnum)StringsProperties.TELEPHONYMODULE_BRIDGE_ICON);
                    TelephonyModule.this.session.setAnnotationValue(ownerId, "ProfilePictureAnnotation", (Object)telIcon.getImage());
                }
                if (mode == 2 || mode == 3) {
                    TelephonyModule.this.session.setAnnotationValue(ownerId, "TelephonyActivityAnnotation", (Object)1);
                    TelephonyModule.this.session.setAnnotationValue(ownerId, "AudioActivityAnnotation", (Object)0);
                } else {
                    TelephonyModule.this.session.setAnnotationValue(ownerId, "TelephonyActivityAnnotation", (Object)0);
                }
                if (mode == 3) {
                    TelephonyModule.this.bridgeParticipantId = ownerId;
                } else if (mode != 2 && ownerId == TelephonyModule.this.bridgeParticipantId) {
                    TelephonyModule.this.bridgeParticipantId = (short)-1;
                }
            }
        }
    }

    private class TelephonyIMPS
    implements TelephonyAPI,
    PropertyChangeListener {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private Integer savedAudioMode = null;
        private Object savedSession = null;

        private TelephonyIMPS() {
        }

        public String getProvider() {
            return TelephonyModule.MODULE_NAME;
        }

        public byte getTier() {
            return 32;
        }

        public int getTelephonyMode() {
            if (TelephonyModule.this.clients == null) {
                return 0;
            }
            return TelephonyModule.this.clients.getProperty("Telephony.mode", 0);
        }

        public boolean isEnabled() {
            return this.getTelephonyMode() != 0;
        }

        public boolean isConnected() {
            try {
                return (Boolean)this.getProperty("TelephonyAPI.connected");
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public boolean isBridge(short clientAddr) {
            return this.getAudioMode(clientAddr) == 3;
        }

        public int getAudioMode(short clientAddr) {
            if (TelephonyModule.this.clients == null) {
                return 0;
            }
            ClientInfo ci = TelephonyModule.this.clients.get(clientAddr);
            if (ci == null) {
                return 0;
            }
            Object val = ci.getProperty("Telephony.audioMode");
            if (val == null) {
                return 0;
            }
            int iVal = ((Number)val).intValue();
            return iVal;
        }

        public void setAudioMode(int myAudioMode) {
            if (myAudioMode != 1 && myAudioMode != 2) {
                throw new IllegalArgumentException("Invalid audio mode: " + myAudioMode);
            }
            if (TelephonyModule.this.clients == null) {
                throw new IllegalStateException("No client list");
            }
            ClientInfo ci = TelephonyModule.this.clients.getMyClient();
            if (ci == null) {
                throw new IllegalStateException("Failed to locate own client info");
            }
            ci.setProperty("Telephony.audioMode", myAudioMode);
        }

        public String getParticipantTelephone() {
            Object val = this.getProperty("TelephonyAPI.participantTelephone");
            if (val == null) {
                return "";
            }
            return String.valueOf(val);
        }

        public String getParticipantPIN() {
            Object val = this.getProperty("TelephonyAPI.participantPIN");
            if (val == null) {
                return "";
            }
            int n = this.getTelephonyMode();
            TelephonyModule.this.telImps;
            if (n == 2) {
                return this.formatPIN(String.valueOf(val));
            }
            return String.valueOf(val);
        }

        public String getModeratorTelephone() {
            Object val = this.getProperty("TelephonyAPI.moderatorTelephone");
            if (val == null) {
                return "";
            }
            return String.valueOf(val);
        }

        public String getModeratorPIN() {
            Object val = this.getProperty("TelephonyAPI.moderatorPIN");
            if (val == null) {
                return "";
            }
            int n = this.getTelephonyMode();
            TelephonyModule.this.telImps;
            if (n == 2) {
                return this.formatPIN(String.valueOf(val));
            }
            return String.valueOf(val);
        }

        public String formatPIN(String pin) {
            int i;
            int SPACE = 3;
            if (pin.length() <= SPACE) {
                return pin;
            }
            String spin = pin.substring(0, i);
            for (i = pin.length() % SPACE; i < pin.length(); i += 3) {
                spin = spin + " ";
                spin = spin + pin.substring(i, i + SPACE);
            }
            return spin;
        }

        public Object getProperty(String prop) {
            if (("TelephonyAPI.moderatorTelephone".equals(prop) || "TelephonyAPI.moderatorPIN".equals(prop)) && !TelephonyModule.this.chairProtocol.amChair(TelephonyModule.this.clients)) {
                return null;
            }
            String key = (String)propMap.get(prop);
            if (key == null) {
                return null;
            }
            if (TelephonyModule.this.clients == null) {
                return null;
            }
            Object val = TelephonyModule.this.clients.getProperty(key);
            if (val == null) {
                return null;
            }
            if ("TelephonyAPI.connected".equals(prop)) {
                val = this.convertConnectState(val);
            }
            return val;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            if (l == null) {
                return;
            }
            this.pcs.addPropertyChangeListener(l);
        }

        public void addPropertyChangeListener(String prop, PropertyChangeListener l) {
            if (l == null) {
                return;
            }
            if (prop == null) {
                return;
            }
            this.pcs.addPropertyChangeListener(prop, l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            if (l == null) {
                return;
            }
            this.pcs.removePropertyChangeListener(l);
        }

        public void removePropertyChangeListener(String prop, PropertyChangeListener l) {
            if (l == null) {
                return;
            }
            if (prop == null) {
                return;
            }
            this.pcs.removePropertyChangeListener(prop, l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String propName = ev.getPropertyName();
            Object oldVal = ev.getOldValue();
            Object newVal = ev.getNewValue();
            if (propName == null) {
                return;
            }
            if (!propName.startsWith("Telephony.")) {
                return;
            }
            String apiName = (String)revMap.get(propName);
            if (apiName == null) {
                if (TelephonyFlags.PROPERTY_CHANGE.show()) {
                    LogSupport.message((Object)this, (String)"propertyChange", (String)("Ignoring change to " + propName + ": " + oldVal + " => " + newVal));
                }
                return;
            }
            if (TelephonyFlags.PROPERTY_CHANGE.show()) {
                LogSupport.message((Object)this, (String)"propertyChange", (String)(propName + " / " + apiName + ": " + oldVal + " => " + newVal));
            }
            if ("Telephony.connectionState".equals(propName)) {
                oldVal = this.convertConnectState(oldVal);
                newVal = this.convertConnectState(newVal);
            }
            if (this.pcs.hasListeners(apiName)) {
                PropertyChangeEvent apiEvent = new PropertyChangeEvent(ev.getSource(), apiName, oldVal, newVal);
                this.pcs.firePropertyChange(apiEvent);
            }
            if (TelephonyModule.this.clients != null && propName.equals("Telephony.audioMode")) {
                short addr = TelephonyModule.this.clients.getPropertyOwner(ev.getSource());
                ConferenceName curSession = TelephonyModule.this.clients.getConnection().getConferenceName();
                if (addr == TelephonyModule.this.clients.getMyAddress()) {
                    if (newVal == null) {
                        this.savedAudioMode = (Integer)oldVal;
                        this.savedSession = curSession;
                    } else if (oldVal == null && this.savedAudioMode != null && !this.savedAudioMode.equals(newVal) && this.isEqualTo(this.savedSession, curSession)) {
                        TelephonyModule.this.clients.getMyClient().setProperty("Telephony.audioMode", this.savedAudioMode.intValue());
                        this.savedAudioMode = null;
                        this.savedSession = null;
                    } else {
                        this.savedAudioMode = null;
                        this.savedSession = null;
                    }
                }
            }
        }

        private boolean isEqualTo(Object a, Object b) {
            if (a == b) {
                return true;
            }
            if (a == null) {
                return false;
            }
            return a.equals(b);
        }

        private Boolean convertConnectState(Object state) {
            Boolean result = null;
            if (state != null) {
                try {
                    int iVal = ((Number)state).intValue();
                    result = iVal == 3 ? Boolean.TRUE : Boolean.FALSE;
                }
                catch (Throwable t) {
                    result = null;
                    LogSupport.message((Object)this, (String)"convertConnectState", (String)("Connection state property value typed as " + state.getClass().getName() + "\n" + Debug.getStackTrace((Throwable)t)));
                }
            }
            return result;
        }
    }

    private class TimeMonitor
    implements PropertyChangeListener {
        private int accrued = 0;
        private int limit = -1;
        private int grace = 5;
        private boolean warned = false;

        private TimeMonitor() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            String propName = ev.getPropertyName();
            Object newVal = ev.getNewValue();
            if ("Telephony.accruedTime".equals(propName)) {
                this.accrued = newVal == null ? 0 : ((Number)newVal).intValue();
            } else if ("Telephony.timeLimit".equals(propName)) {
                this.limit = newVal == null ? -1 : ((Number)newVal).intValue();
                this.warned = false;
            } else if ("Telephony.timeLimitGrace".equals(propName)) {
                this.grace = newVal == null ? 5 : ((Number)newVal).intValue();
                this.warned = false;
            }
            if (this.limit < 1) {
                return;
            }
            if (!TelephonyModule.this.telImps.isConnected()) {
                return;
            }
            if (!TelephonyModule.this.chairProtocol.amChair(TelephonyModule.this.clients)) {
                return;
            }
            if (this.accrued > this.limit - this.grace && !this.warned) {
                this.warned = true;
                int timeLeft = this.limit - this.accrued;
                String msg = i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_TIMEWARNINGMSG, new Object[]{new Integer(timeLeft)});
                String title = i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYMODULE_TIMEWARNINGTITLE, new Object[]{new Integer(Math.max(0, this.limit - this.accrued))});
                ModalDialog.showMessageDialogAsync((int)120, (Component)TelephonyModule.this.parent, (Object)msg, (String)title, (int)2);
            }
        }
    }
}

