/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.telephony.module;

import com.elluminate.groupware.telephony.module.StringsProperties;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.JinxServerProps;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class ConnectionDialogs {
    protected static final I18n i18n = I18n.create(ConnectionDialogs.class);
    private static Icon telIcon = i18n.getIcon("ConnectionDialogs.dialogTelephoneIcon");
    public static final int RESULT_YES = 1;
    public static final int RESULT_NO = 0;
    static final String INDENT = "&nbsp;&nbsp;&nbsp;";
    ConnectionDialog dlgConfirmDisconnect;
    ConnectionDialog dlgRemoteDisconnect;
    ConnectionDialog dlgConnectFailed;
    ConnectionDialog dlgConnectConfirm;
    private final int CONNECTION_FAILED_TIMEOUT = 30000;
    LightweightTimer connFailedTimer = new LightweightTimer(2, new Runnable(){

        @Override
        public void run() {
            ConnectionDialogs.this.hideConnectionFailedDialog();
        }
    });

    private static JTextPane getContent(String msg, String arg0, String arg1, String arg2) {
        JTextPane content = new JTextPane();
        content.setContentType("text/html");
        content.setText(i18n.getStringLegacy(msg, new Object[]{arg0, arg1, arg2}));
        content.setEditable(false);
        content.setBackground(UIManager.getColor("Label.background"));
        content.setFocusable(false);
        content.setBorder(BorderFactory.createEmptyBorder(12, 6, 12, 64));
        return content;
    }

    void hideAllDialogs() {
        this.hideConnectionConfirmationDialog();
        this.hideConnectionFailedDialog();
        this.hideConfigDisconnectDialog();
        this.hideRemoteDisconnectDialog();
    }

    void hideRemoteDisconnectDialog() {
        try {
            if (this.dlgRemoteDisconnect != null) {
                this.dlgRemoteDisconnect.setVisible(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void hideConfigDisconnectDialog() {
        try {
            if (this.dlgConfirmDisconnect != null) {
                this.dlgConfirmDisconnect.setVisible(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    boolean showConnectionConfirmationDialog(Component parent, ClientList clients, ActionListener reannounceListener) {
        int result = 0;
        String sessionLabel = JinxServerProps.get((PropertyAccessAPI)clients, (String)"Label.session");
        this.dlgConnectConfirm = new ConnectionDialog(parent, "ConnectionDialogs.confirmConnect", sessionLabel, null, null);
        JButton reannounce = new JButton(i18n.getString((PropertiesEnum)StringsProperties.CONNECTIONDIALOGS_CONFIRMCONNECTREANNOUNCE));
        this.dlgConnectConfirm.addAlternateActionButton(reannounce);
        reannounce.addActionListener(reannounceListener);
        this.dlgConnectConfirm.setDefaultResult(1);
        this.dlgConnectConfirm.show();
        if (this.dlgConnectConfirm != null) {
            result = this.dlgConnectConfirm.getResult();
            this.dlgConnectConfirm.dispose();
        }
        this.dlgConnectConfirm = null;
        return result == 1;
    }

    void hideConnectionConfirmationDialog() {
        try {
            if (this.dlgConnectConfirm != null) {
                this.dlgConnectConfirm.setVisible(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    boolean showConnectionFailedDialog(Component parent, ClientList clients, String failedReason, String detailedReason) {
        int result = 0;
        String phone = clients.getProperty("Telephony.sessionTelephone", "");
        if (phone == null || phone.equals("")) {
            phone = clients.getProperty("Telephony.sessionSIP", "");
        }
        this.dlgConnectFailed = new ConnectionDialog(parent, "ConnectionDialogs.connectionFailed", phone, failedReason, ConnectionDialogs.getMultilineHtml(detailedReason, INDENT));
        this.dlgConnectFailed.setDefaultResult(0);
        this.connFailedTimer.scheduleIn(30000L);
        this.dlgConnectFailed.show();
        this.connFailedTimer.cancel();
        if (this.dlgConnectFailed != null) {
            result = this.dlgConnectFailed.getResult();
            this.dlgConnectFailed.dispose();
        }
        this.dlgConnectFailed = null;
        return result == 1;
    }

    void hideConnectionFailedDialog() {
        try {
            if (this.dlgConnectFailed != null) {
                this.dlgConnectFailed.setVisible(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    boolean showRemoteDisconnectDialog(Component parent, ClientList clients, String disconnectReason) {
        String sessionLabel = JinxServerProps.get((PropertyAccessAPI)clients, (String)"Label.session");
        String participantsLabel = JinxServerProps.get((PropertyAccessAPI)clients, (String)"Label.Participants");
        this.dlgRemoteDisconnect = new ConnectionDialog(parent, "ConnectionDialogs.sessionDisconnect", ConnectionDialogs.getMultilineHtml(disconnectReason, INDENT), sessionLabel, participantsLabel);
        this.dlgRemoteDisconnect.setDefaultResult(0);
        this.dlgRemoteDisconnect.show();
        int result = this.dlgRemoteDisconnect.getResult();
        this.dlgRemoteDisconnect.dispose();
        this.dlgRemoteDisconnect = null;
        return result == 1;
    }

    boolean showConfirmDisconnectDialog(Component parent, ClientList clients) {
        String sessionLabel = JinxServerProps.get((PropertyAccessAPI)clients, (String)"Label.session");
        this.dlgConfirmDisconnect = new ConnectionDialog(parent, "ConnectionDialogs.confirmDisconnect", sessionLabel, null, null);
        this.dlgConfirmDisconnect.setDefaultResult(0);
        this.dlgConfirmDisconnect.show();
        int result = this.dlgConfirmDisconnect.getResult();
        this.dlgConfirmDisconnect.dispose();
        this.dlgConfirmDisconnect = null;
        return result == 1;
    }

    private static String getMultilineHtml(String msg, String prefix) {
        if (msg == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        StringTokenizer parser = new StringTokenizer(msg, "\n");
        while (parser.hasMoreTokens()) {
            String line = parser.nextToken();
            buf.append(prefix);
            buf.append(line);
            buf.append("<br>");
        }
        return buf.toString();
    }

    static /* synthetic */ Icon access$000() {
        return telIcon;
    }

    static class ConnectionDialog
    extends EasyDialog
    implements ActionListener {
        private BorderLayout layout = new BorderLayout();
        private JPanel panel = new JPanel(this.layout);
        private JLabel img = new JLabel(ConnectionDialogs.access$000());
        private JButton yes;
        private JButton no;
        private int result = 0;

        private ConnectionDialog(Component parent, String prefix, String arg0, String arg1, String arg2) {
            super(parent, i18n.getStringLegacy(prefix + "Title"), true);
            this.panel.add((Component)this.img, "West");
            this.panel.add((Component)ConnectionDialogs.getContent(prefix + "Msg", arg0, arg1, arg2), "Center");
            this.no = this.makeButton(i18n.getStringLegacy(prefix + "No"));
            this.yes = this.makeButton(i18n.getStringLegacy(prefix + "Yes"));
            this.setContent(this.panel);
            this.addCancelButton(this.no);
            this.addActionButton(this.yes, true);
            this.no.addActionListener(this);
            this.yes.addActionListener(this);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    ConnectionDialog.this.setVisible(false);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.yes) {
                this.result = 1;
                this.setVisible(false);
            } else if (e.getSource() == this.no) {
                this.result = 0;
                this.setVisible(false);
            }
        }

        public int getResult() {
            return this.result;
        }

        void setDefaultResult(int theResult) {
            this.result = theResult;
        }
    }
}

