/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.telephony.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.ConnectTeleconferenceCommand;
import com.elluminate.groupware.telephony.module.StringsProperties;
import com.elluminate.groupware.telephony.module.TelephonyModule;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;

public class ConnectTeleconferenceCmd
extends AbstractCommand
implements ConnectTeleconferenceCommand {
    private I18n i18n = I18n.create((Object)((Object)this));
    private TelephonyModule module;

    @Inject
    public void initTelephonyModule(TelephonyModule module) {
        this.module = module;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (!this.module.isSessionTeleconferencingAvailable()) {
            throw new CommandContextException("Telephony is not available", this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCECMD_BADCONTEXTTELEPHONYNOTAVAILABLE));
        }
        if (!this.module.isSessionTeleconferenceSetUp()) {
            throw new CommandContextException("Teleconference is not configured", this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCECMD_BADCONTEXTNOTCONFIGURED));
        }
        if (!this.module.isDisconnected()) {
            throw new CommandContextException("Teleconference is already connected", this.i18n.getString((PropertiesEnum)StringsProperties.CONNECTTELECONFERENCECMD_BADCONTEXTALREADYCONNECTED));
        }
        this.module.sendConnect();
    }
}

