/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.contentcapture;

import com.elluminate.contentcapture.CaptureAudioEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ContentCaptureIOPacketUtils {
    public static final String[] CMD_NAMES = new String[]{"ADD_FEED", "REMOVE_FEED", "SUBSCRIBE_FEED", "UNSUBSCRIBE_FEED", "REQUEST_ACK_PACKET", "ACK_PACKET", "TITLE_TEXT", "TEXT_DATA", "IMAGE_DATA", "AUDIO_DATA", "SET_IMAGE_SIZE", "SET_FEED_VISIBLE", "SET_BANDWIDTH", "REQUEST_REPAINT", "DUPLICATE_TILES", "RE_SUBSCRIBE_FEED", "CONDITION_FEED", "FEED_ACTIVITY", "FEED_ACTIVITY_ACK", "MONITOR_FEED", "RECEIVE_FEED", "AUDIO_GRANT", "AUDIO_REVOKE", "ADD_PARTICIPANT", "REMOVE_PARTICIPANT", "CREATE_GROUP", "DELETE_GROUP", "RENAME_GROUP", "ADD_MODULE", "SESSION_NAME", "SESSION_CONTROL", "INDEX_MARK"};
    public static final String[] SESSON_CONTROL_NAMES = new String[]{"Start Recording", "Stop Recording"};
    public static final short NO_ADDRESS = -1;
    public static final short JOIN_ADDRESS = -2;
    private static final int PACKET_LENGTH_INDEX = 0;
    private static final int PACKET_COMMAND_INDEX = 2;
    private static final int HEADER_LENGTH = 3;
    private static final int HEADER_OFFSET = 2;
    private static final int BYTE_LENGTH = 1;
    private static final int SHORT_LENGTH = 2;
    private static final int INT_LENGTH = 4;
    private static final int LONG_LENGTH = 8;
    public static final int DUPLICATE_DEFINITION_HEADER_LENGTH = 7;
    public static final int DUPLICATE_DEFINITION_ENTRY_LENGTH = 2;
    public static final byte AUDIO_UI_PANEL = 1;
    public static final byte EMBEDDED_UI_PANEL = 2;
    public static final byte FRAMED_UI_PANEL = 3;
    public static final byte MESSAGING_UI_PANEL = 4;
    public static final byte PARTICIPANT_INFO_PANEL = 5;
    public static final byte AUDIO_LAYER = 10;
    public static final byte WHITEBOARD_LAYER = 20;
    public static final byte APP_SHARE_LAYER = 30;
    public static final byte PARTICIPANT_INFO_LAYER = 50;
    public static final byte DIRECT_MESSAGING_LAYER = 60;
    public static final byte VIDEO_LAYER = 70;
    public static final byte SET_REPAINT_STRATEGY = 0;
    public static final byte SET_ENCODING = 1;
    public static final byte LOSSY_ENCODING = 0;
    public static final byte LOSSLESS_ENCODING = 1;
    public static final String APP_SHARE = "App Share";
    public static final String AUDIO = "Audio";
    public static final String CAPTION = "Caption";
    public static final String CHAT = "Chat";
    public static final String VIDEO = "Video";
    public static final String WHITEBOARD = "Whiteboard";
    public static final byte ADD_FEED = 0;
    public static final byte REMOVE_FEED = 1;
    public static final byte SUBSCRIBE_FEED = 2;
    public static final byte UNSUBSCRIBE_FEED = 3;
    public static final byte REQUEST_ACK_PACKET = 4;
    public static final byte ACK_PACKET = 5;
    public static final byte TITLE_TEXT = 6;
    public static final byte TEXT_DATA = 7;
    public static final byte IMAGE_DATA = 8;
    public static final byte AUDIO_DATA = 9;
    public static final byte SET_IMAGE_SIZE = 10;
    public static final byte SET_FEED_VISIBLE = 11;
    public static final byte SET_BANDWIDTH = 12;
    public static final byte REQUEST_REPAINT = 13;
    public static final byte DUPLICATE_TILES = 14;
    public static final byte RE_SUBSCRIBE_FEED = 15;
    public static final byte CONDITION_FEED = 16;
    public static final byte FEED_ACTIVITY = 17;
    public static final byte FEED_ACTIVITY_ACK = 18;
    public static final byte MONITOR_FEED = 19;
    public static final byte RECEIVE_FEED = 20;
    public static final byte AUDIO_GRANT = 21;
    public static final byte AUDIO_REVOKE = 22;
    public static final byte ADD_PARTICIPANT = 23;
    public static final byte REMOVE_PARTICIPANT = 24;
    public static final byte CREATE_GROUP = 25;
    public static final byte DELETE_GROUP = 26;
    public static final byte RENAME_GROUP = 27;
    public static final byte ADD_MODULE = 28;
    public static final byte SESSION_NAME = 29;
    public static final byte SESSION_RECORD = 30;
    public static final byte INDEX_MARK = 31;
    public static final byte SESSION_CONTROL_START_RECORDING = 0;
    public static final byte SESSION_CONTROL_STOP_RECORDING = 1;
    public static final byte IMAGE_FEED = 0;
    public static final byte AUDIO_FEED = 1;
    public static final byte TEXT_IO_FEED = 2;
    public static final byte TEXT_O_FEED = 3;
    public static final byte PARTICIPANT_FEED = 4;
    public static final String[] FEED_NAMES = new String[]{"Image", "Audio", "Text", "Participant"};

    public static byte[] encodeAddFeed(String feedName, byte feedType, short feedIndex, short moduleIndex, byte[] iconBytes, byte panelMode, byte layer) {
        return ContentCaptureIOPacketUtils.encodeAddRemoveFeed(feedName, feedType, (byte)0, feedIndex, moduleIndex, iconBytes, panelMode, layer);
    }

    public static byte[] encodeRemoveFeed(String feedName, byte feedType, short feedIndex, byte panelMode, byte layer) {
        return ContentCaptureIOPacketUtils.encodeAddRemoveFeed(feedName, feedType, (byte)1, feedIndex, (short)0, null, panelMode, layer);
    }

    private static byte[] encodeAddRemoveFeed(String feedName, byte feedType, byte command, short feedIndex, short moduleIndex, byte[] iconBytes, byte panelMode, byte layer) {
        int len = iconBytes == null ? 0 : iconBytes.length;
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader(command, 12 + len + feedName.length());
        ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
        ContentCaptureIOPacketUtils.encodeShort(result, 5, moduleIndex);
        result[7] = feedType;
        result[8] = panelMode;
        result[9] = layer;
        int index = ContentCaptureIOPacketUtils.encodeShort(result, 10, (short)len);
        if (len > 0) {
            System.arraycopy(iconBytes, 0, result, index, len);
            index += len;
        }
        byte[] nameBytes = new byte[feedName.length()];
        nameBytes = feedName.getBytes();
        System.arraycopy(nameBytes, 0, result, index, nameBytes.length);
        return result;
    }

    public static byte[] encodeConditionFeed(short feedIndex, byte[] conditionData) {
        int len = conditionData == null ? 0 : conditionData.length;
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)16, 7 + len);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
        int index = ContentCaptureIOPacketUtils.encodeShort(result, 5, (short)len);
        if (len > 0) {
            System.arraycopy(conditionData, 0, result, index, len);
            index += len;
        }
        return result;
    }

    public static short getFeedIndexFromConditionFeed(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static String getFeedNameFromAdd(byte[] packet) {
        int index = 12 + ContentCaptureIOPacketUtils.decodeShort(packet, 8) - 2;
        return new String(packet, index, packet.length - index);
    }

    public static short getFeedIndexFromAdd(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static short getModuleIndexFromFeedAdd(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 3);
    }

    public static byte getFeedTypeFromAdd(byte[] packet) {
        return packet[5];
    }

    public static byte getFeedPanelModeFromAdd(byte[] packet) {
        return packet[6];
    }

    public static byte getFeedLayerFromAdd(byte[] packet) {
        return packet[7];
    }

    public static byte[] getFeedIconFromAdd(byte[] packet) {
        short len = ContentCaptureIOPacketUtils.decodeShort(packet, 8);
        byte[] result = new byte[len];
        if (len > 0) {
            System.arraycopy(packet, 10, result, 0, len);
        }
        return result;
    }

    public static byte[] getConditionFeed(byte[] packet) {
        short len = ContentCaptureIOPacketUtils.decodeShort(packet, 3);
        byte[] result = new byte[len];
        if (len > 0) {
            System.arraycopy(packet, 5, result, 0, len);
        }
        return result;
    }

    public static byte[] encodeFeedActivity(short feedIndex) {
        return ContentCaptureIOPacketUtils.encodeFeedActivityIndex((byte)17, feedIndex);
    }

    private static byte[] encodeFeedActivityIndex(byte code, short feedIndex) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader(code, 5);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
        return result;
    }

    public static short getActivityFeedIndex(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 0);
    }

    public static byte[] encodeFeedActivityAck(short feedIndex) {
        return ContentCaptureIOPacketUtils.encodeFeedActivityIndex((byte)18, feedIndex);
    }

    public static byte[] encodeFeedMonitor(short feedIndex) {
        return ContentCaptureIOPacketUtils.encodeFeedActivityIndex((byte)19, feedIndex);
    }

    public static byte[] encodeReceiveFeed(short feedIndex) {
        return ContentCaptureIOPacketUtils.encodeFeedActivityIndex((byte)20, feedIndex);
    }

    public static byte[] encodeAddModule(String moduleName, short moduleIndex) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)28, 5 + moduleName.length());
        int index = ContentCaptureIOPacketUtils.encodeShort(result, 3, moduleIndex);
        byte[] nameBytes = new byte[moduleName.length()];
        nameBytes = moduleName.getBytes();
        System.arraycopy(nameBytes, 0, result, 5, nameBytes.length);
        return result;
    }

    public static String getModuleNameFromAdd(byte[] packet) {
        return new String(packet, 3, packet.length - 3);
    }

    public static short getModuleIndexFromAdd(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static byte[] encodeSubscribeFeed(String feedName) {
        return ContentCaptureIOPacketUtils.encodeSubscribeUnsubscribeFeed(feedName, (byte)2);
    }

    public static byte[] encodeReSubscribeFeed(String feedName) {
        return ContentCaptureIOPacketUtils.encodeSubscribeUnsubscribeFeed(feedName, (byte)15);
    }

    public static byte[] encodeUnsubscribeFeed(String feedName) {
        return ContentCaptureIOPacketUtils.encodeSubscribeUnsubscribeFeed(feedName, (byte)3);
    }

    public static String getFeedNameFromSubscription(byte[] packet) {
        return new String(packet, 1, packet.length - 1);
    }

    private static byte[] encodeSubscribeUnsubscribeFeed(String feedName, byte command) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader(command, 3 + feedName.length());
        byte[] nameBytes = new byte[feedName.length()];
        nameBytes = feedName.getBytes();
        System.arraycopy(nameBytes, 0, result, 3, nameBytes.length);
        return result;
    }

    public static byte[] encodeRequestAck(int number) {
        return ContentCaptureIOPacketUtils.encodeRequestAcknowledgeAck(number, (byte)4);
    }

    public static byte[] encodeAcknowledgeAck(int number) {
        return ContentCaptureIOPacketUtils.encodeRequestAcknowledgeAck(number, (byte)5);
    }

    private static byte[] encodeRequestAcknowledgeAck(int number, byte command) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader(command, 7);
        ContentCaptureIOPacketUtils.encodeInt(result, 3, number);
        return result;
    }

    public static int getAckNumber(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeInt(packet, 1);
    }

    public static byte[] encodeVisibleSetting(short feedIndex, boolean visible, long time) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)11, 14);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
        result[5] = (byte)(visible ? 1 : 0);
        ContentCaptureIOPacketUtils.encodeLong(result, 6, time);
        return result;
    }

    public static short getVisibleFeedIndex(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static boolean getVisibleState(byte[] packet) {
        return packet[3] == 1;
    }

    public static long getVisibleTime(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeLong(packet, 4);
    }

    public static byte[] encodeRequestRepaint(short feedIndex, long time) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)13, 13);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
        ContentCaptureIOPacketUtils.encodeLong(result, 5, time);
        return result;
    }

    public static short getRepaintFeedIndex(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static long getRepaintTime(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeLong(packet, 3);
    }

    public static byte[] encodeBandwidthSetting(int bandwidth) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)12, 7);
        ContentCaptureIOPacketUtils.encodeInt(result, 3, bandwidth);
        return result;
    }

    public static int getBandwidth(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeInt(packet, 1);
    }

    public static byte[] encodeDuplicateTileDefinition(short feedIndex, Integer tileNumber, Vector duplicates, long time) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)14, 15 + 2 * duplicates.size());
        ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
        ContentCaptureIOPacketUtils.encodeLong(result, 5, time);
        int index = ContentCaptureIOPacketUtils.encodeShort(result, 13, tileNumber.shortValue());
        Enumeration e = duplicates.elements();
        while (e.hasMoreElements()) {
            Integer dupTileNumber = (Integer)e.nextElement();
            index = ContentCaptureIOPacketUtils.encodeShort(result, index, dupTileNumber.shortValue());
        }
        return result;
    }

    public static short[] getDuplicateTiles(byte[] packet) {
        int tileCount = (packet.length - 10) / 2;
        short[] tileNumbers = new short[tileCount];
        boolean tileIndex = false;
        int index = 11;
        for (int i = 0; i < tileCount; ++i) {
            tileNumbers[i] = ContentCaptureIOPacketUtils.decodeShort(packet, index);
            index += 2;
        }
        return tileNumbers;
    }

    public static short getDuplicateTilesFeedIndex(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static long getDuplicateTilesTime(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeLong(packet, 3);
    }

    public static byte[] encodeTextData(String text, short feedIndex, long time, short author) {
        return ContentCaptureIOPacketUtils.encodeTextualData(text, (byte)7, feedIndex, time, author);
    }

    public static byte[] encodeTitleData(String title, short feedIndex, long time) {
        return ContentCaptureIOPacketUtils.encodeTextualData(title, (byte)6, feedIndex, time, (short)-1);
    }

    private static byte[] encodeTextualData(String text, byte command, short feedIndex, long time, short author) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader(command, 15 + text.length() * 2);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
        ContentCaptureIOPacketUtils.encodeLong(result, 5, time);
        ContentCaptureIOPacketUtils.encodeShort(result, 13, author);
        ContentCaptureIOPacketUtils.encodeUTFString(result, 15, text);
        return result;
    }

    public static short getAuthor(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 11);
    }

    public static String getText(byte[] packet) {
        int stringLength = (packet.length - 13) / 2;
        int packetIndex = 13;
        return ContentCaptureIOPacketUtils.decodeUTFString(packet, packetIndex, stringLength);
    }

    public static short getTextFeedIndex(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static long getTextTime(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeLong(packet, 3);
    }

    public static byte[] encodeCaptureAudioEvent(CaptureAudioEvent audioEvent, short feedIndex) {
        byte[] result;
        if (audioEvent.isGrant() || audioEvent.isRevoke()) {
            byte command = audioEvent.isGrant() ? (byte)21 : 22;
            result = ContentCaptureIOPacketUtils.encodeHeader(command, 15);
            ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
            ContentCaptureIOPacketUtils.encodeShort(result, 5, audioEvent.getTalkerAddress());
            ContentCaptureIOPacketUtils.encodeLong(result, 7, audioEvent.getTime());
        } else {
            byte[] audioData = audioEvent.getEcelpData();
            result = ContentCaptureIOPacketUtils.encodeHeader((byte)9, 15 + audioData.length);
            ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
            ContentCaptureIOPacketUtils.encodeShort(result, 5, audioEvent.getTalkerAddress());
            ContentCaptureIOPacketUtils.encodeLong(result, 7, audioEvent.getTime());
            System.arraycopy(audioData, 0, result, 15, audioData.length);
        }
        return result;
    }

    public static byte[] getAudioData(byte[] packet) {
        byte[] audioData = new byte[packet.length - 13];
        System.arraycopy(packet, 13, audioData, 0, audioData.length);
        return audioData;
    }

    public static short getAudioFeedIndex(byte[] packet) {
        short index = ContentCaptureIOPacketUtils.decodeShort(packet, 1);
        return index;
    }

    public static short getAudioTalker(byte[] packet) {
        short talkerAddress = ContentCaptureIOPacketUtils.decodeShort(packet, 3);
        return talkerAddress;
    }

    public static long getAudioTime(byte[] packet) {
        long time = ContentCaptureIOPacketUtils.decodeLong(packet, 5);
        return time;
    }

    public static byte[] encodeImageData(byte[] imageData, int tileNumber, short feedIndex, long time) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)8, 15 + imageData.length);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
        ContentCaptureIOPacketUtils.encodeShort(result, 5, (short)tileNumber);
        ContentCaptureIOPacketUtils.encodeLong(result, 7, time);
        System.arraycopy(imageData, 0, result, 15, imageData.length);
        return result;
    }

    public static byte[] getImageData(byte[] packet) {
        byte[] image = new byte[packet.length - 13];
        System.arraycopy(packet, 13, image, 0, image.length);
        return image;
    }

    public static short getImageFeedIndex(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static short getImageTileNumber(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 3);
    }

    public static long getImageTime(byte[] packet) {
        long time = ContentCaptureIOPacketUtils.decodeLong(packet, 5);
        return time;
    }

    public static byte[] encodeSetImageSize(int width, int height, short feedIndex, long time) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)10, 17);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, feedIndex);
        ContentCaptureIOPacketUtils.encodeShort(result, 5, (short)width);
        ContentCaptureIOPacketUtils.encodeShort(result, 7, (short)height);
        ContentCaptureIOPacketUtils.encodeLong(result, 9, time);
        return result;
    }

    public static short getImageSetFeedIndex(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static short getImageWidth(byte[] packet) {
        short width = ContentCaptureIOPacketUtils.decodeShort(packet, 3);
        return width;
    }

    public static short getImageHeight(byte[] packet) {
        short height = ContentCaptureIOPacketUtils.decodeShort(packet, 5);
        return height;
    }

    public static long getImageSizeTime(byte[] packet) {
        long time = ContentCaptureIOPacketUtils.decodeLong(packet, 7);
        return time;
    }

    public static byte[] encodeAddParticipant(String aName, short address, short groupId, String aDispName, long time) {
        String name = aName != null ? aName : "";
        String dispName = aDispName != null ? aDispName : "";
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)23, 17 + name.length() * 2 + dispName.length() * 2);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, address);
        ContentCaptureIOPacketUtils.encodeLong(result, 5, time);
        ContentCaptureIOPacketUtils.encodeShort(result, 13, groupId);
        ContentCaptureIOPacketUtils.encodeShort(result, 15, (short)name.length());
        int index = ContentCaptureIOPacketUtils.encodeUTFString(result, 17, name);
        ContentCaptureIOPacketUtils.encodeUTFString(result, index, dispName);
        return result;
    }

    public static byte[] encodeRemoveParticipant(short address, long time) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)24, 13);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, address);
        ContentCaptureIOPacketUtils.encodeLong(result, 5, time);
        return result;
    }

    public static String getParticipantName(byte[] packet) {
        if (packet.length > 16) {
            short stringLength = ContentCaptureIOPacketUtils.decodeShort(packet, 13);
            int packetIndex = 15;
            return ContentCaptureIOPacketUtils.decodeUTFString(packet, packetIndex, stringLength);
        }
        return "";
    }

    public static short getParticipantAddress(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static short getParticipantGroup(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 11);
    }

    public static String getParticipantDisplayName(byte[] packet) {
        int packetIndex = 15 + ContentCaptureIOPacketUtils.decodeShort(packet, 13) * 2;
        if (packet.length >= packetIndex) {
            int stringLength = (packet.length - packetIndex) / 2;
            return ContentCaptureIOPacketUtils.decodeUTFString(packet, packetIndex, stringLength);
        }
        return "";
    }

    public static long getParticipantTime(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeLong(packet, 3);
    }

    public static byte[] encodeCreateGroup(String aGroupName, short groupId, long time) {
        String groupName = aGroupName != null ? aGroupName : "";
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)25, 15 + groupName.length() * 2);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, groupId);
        ContentCaptureIOPacketUtils.encodeLong(result, 5, time);
        ContentCaptureIOPacketUtils.encodeShort(result, 13, (short)groupName.length());
        ContentCaptureIOPacketUtils.encodeUTFString(result, 15, groupName);
        return result;
    }

    public static byte[] encodeDeleteGroup(short groupId, long time) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)26, 13);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, groupId);
        ContentCaptureIOPacketUtils.encodeLong(result, 5, time);
        return result;
    }

    public static byte[] encodeRenameGroup(String aGroupName, short groupId, String aPrevGroupName, short prevGroupId, long time) {
        String groupName = aGroupName != null ? aGroupName : "";
        String prevGroupName = aPrevGroupName != null ? aPrevGroupName : "";
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)27, 15 + groupName.length() * 2 + prevGroupName.length() * 2);
        ContentCaptureIOPacketUtils.encodeShort(result, 3, groupId);
        ContentCaptureIOPacketUtils.encodeLong(result, 5, time);
        ContentCaptureIOPacketUtils.encodeShort(result, 9, prevGroupId);
        ContentCaptureIOPacketUtils.encodeShort(result, 13, (short)groupName.length());
        int index = ContentCaptureIOPacketUtils.encodeUTFString(result, 15, groupName);
        ContentCaptureIOPacketUtils.encodeUTFString(result, index, prevGroupName);
        return result;
    }

    public static short getGroupId(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 1);
    }

    public static String getGroupName(byte[] packet) {
        short groupNameLength = ContentCaptureIOPacketUtils.decodeShort(packet, 11);
        if (groupNameLength > 0) {
            short stringLength = groupNameLength;
            int packetIndex = 13;
            return ContentCaptureIOPacketUtils.decodeUTFString(packet, packetIndex, stringLength);
        }
        return "";
    }

    public static long getGroupTime(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeLong(packet, 3);
    }

    public static short getPrevGroupId(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeShort(packet, 7);
    }

    public static String getPrevGroupName(byte[] packet) {
        short groupNameLength = ContentCaptureIOPacketUtils.decodeShort(packet, 11);
        int prevGroupIndex = groupNameLength + 15;
        int stringLength = (packet.length - (prevGroupIndex - 2)) / 2;
        int packetIndex = groupNameLength + 15;
        return ContentCaptureIOPacketUtils.decodeUTFString(packet, packetIndex, stringLength);
    }

    public static byte[] encodeSessionName(String sessionName, long time) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)29, 11 + sessionName.length() * 2);
        int index = ContentCaptureIOPacketUtils.encodeLong(result, 3, time);
        index = ContentCaptureIOPacketUtils.encodeUTFString(result, index, sessionName);
        return result;
    }

    public static String getNameFromSessionName(byte[] packet) {
        int stringIndex = 9;
        int modNameLength = (packet.length - stringIndex) / 2;
        return ContentCaptureIOPacketUtils.decodeUTFString(packet, stringIndex, modNameLength);
    }

    public static long getTimeFromSessionName(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeLong(packet, 1);
    }

    public static byte[] encodeSessionRecord(byte sessionRecordType, long time) {
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)30, 12);
        int index = ContentCaptureIOPacketUtils.encodeLong(result, 3, time);
        result[index++] = sessionRecordType;
        return result;
    }

    public static byte getSessionRecordType(byte[] packet) {
        return packet[9];
    }

    public static long getTimeFromSessionRecord(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeLong(packet, 1);
    }

    public static byte[] encodeIndexMark(String modName, String kind, String detail, long time) {
        String aModName = modName != null ? modName : "";
        String aKind = kind != null ? kind : "";
        String aDetail = detail != null ? detail : "";
        byte[] result = ContentCaptureIOPacketUtils.encodeHeader((byte)31, 17 + (modName.length() + kind.length() + detail.length()) * 2);
        ContentCaptureIOPacketUtils.encodeLong(result, 3, time);
        ContentCaptureIOPacketUtils.encodeShort(result, 11, (short)modName.length());
        ContentCaptureIOPacketUtils.encodeShort(result, 13, (short)kind.length());
        ContentCaptureIOPacketUtils.encodeShort(result, 15, (short)detail.length());
        int index = ContentCaptureIOPacketUtils.encodeUTFString(result, 17, modName);
        index = ContentCaptureIOPacketUtils.encodeUTFString(result, index, kind);
        ContentCaptureIOPacketUtils.encodeUTFString(result, index, detail);
        return result;
    }

    public static String getIndexModName(byte[] packet) {
        short modNameLength = ContentCaptureIOPacketUtils.decodeShort(packet, 9);
        if (modNameLength > 0) {
            short stringLength = modNameLength;
            int packetIndex = 15;
            return ContentCaptureIOPacketUtils.decodeUTFString(packet, packetIndex, stringLength);
        }
        return "";
    }

    public static String getIndexKind(byte[] packet) {
        short modNameLength = ContentCaptureIOPacketUtils.decodeShort(packet, 9);
        short kindLength = ContentCaptureIOPacketUtils.decodeShort(packet, 11);
        int packetIndex = modNameLength * 2 + 17 - 2;
        return ContentCaptureIOPacketUtils.decodeUTFString(packet, packetIndex, kindLength);
    }

    public static String getIndexDetail(byte[] packet) {
        short modNameLength = ContentCaptureIOPacketUtils.decodeShort(packet, 9);
        short kindLength = ContentCaptureIOPacketUtils.decodeShort(packet, 11);
        short detailLength = ContentCaptureIOPacketUtils.decodeShort(packet, 13);
        int packetIndex = (modNameLength + kindLength) * 2 + 17 - 2;
        return ContentCaptureIOPacketUtils.decodeUTFString(packet, packetIndex, detailLength);
    }

    public static long getIndexTime(byte[] packet) {
        return ContentCaptureIOPacketUtils.decodeLong(packet, 1);
    }

    public static byte[] getPacket(DataInputStream inStream) throws IOException {
        byte[] result = new byte[]{};
        short packetLength = inStream.readShort();
        if (packetLength > 2) {
            try {
                result = new byte[packetLength - 2];
                inStream.readFully(result);
            }
            catch (Exception e) {
                System.err.println("packetLength: " + packetLength);
            }
        } else {
            System.err.println("ContentCaptureIOPacketUtils.getPacket - length: " + packetLength);
        }
        return result;
    }

    public static byte getPacketCommand(byte[] buffer) {
        return buffer[0];
    }

    private static byte[] encodeHeader(byte command, int length) {
        byte[] result = new byte[length];
        ContentCaptureIOPacketUtils.encodeShort(result, 0, (short)length);
        result[2] = command;
        return result;
    }

    private static int encodeShort(byte[] buffer, int index, short value) {
        buffer[index++] = (byte)(value >> 8);
        buffer[index++] = (byte)(value & 0xFF);
        return index;
    }

    private static short decodeShort(byte[] buffer, int index) {
        return (short)(buffer[index++] << 8 | 0xFF & buffer[index++]);
    }

    private static int encodeInt(byte[] buffer, int index, int value) {
        buffer[index++] = (byte)(value >> 24);
        buffer[index++] = (byte)(value >> 16);
        buffer[index++] = (byte)(value >> 8);
        buffer[index++] = (byte)value;
        return index;
    }

    private static int decodeInt(byte[] buffer, int index) {
        int result = 0;
        for (int i = 0; i < 4; ++i) {
            result = result << 8 | buffer[index++] & 0xFF;
        }
        return result;
    }

    private static int encodeLong(byte[] buffer, int index, long value) {
        buffer[index++] = (byte)(value >> 56);
        buffer[index++] = (byte)(value >> 48);
        buffer[index++] = (byte)(value >> 40);
        buffer[index++] = (byte)(value >> 32);
        buffer[index++] = (byte)(value >> 24);
        buffer[index++] = (byte)(value >> 16);
        buffer[index++] = (byte)(value >> 8);
        buffer[index++] = (byte)value;
        return index;
    }

    private static long decodeLong(byte[] buffer, int index) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result = result << 8 | (long)(buffer[index++] & 0xFF);
        }
        return result;
    }

    private static int encodeUTFString(byte[] buffer, int index, String str) {
        for (int charIndex = 0; charIndex < str.length(); ++charIndex) {
            char c = str.charAt(charIndex);
            buffer[index++] = (byte)(0xFF & c >> 8);
            buffer[index++] = (byte)(0xFF & c);
        }
        return index;
    }

    private static String decodeUTFString(byte[] buffer, int index, int length) {
        StringBuffer str = new StringBuffer(length);
        for (int charIndex = 0; charIndex < length; ++charIndex) {
            char c = (char)(0xFF00 & buffer[index++] << 8 | 0xFF & buffer[index++]);
            str.append(c);
        }
        return str.toString();
    }
}

