/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare;

import com.elluminate.groupware.appshare.AppShareMessage;
import com.elluminate.groupware.appshare.AppShareResponder;
import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import com.elluminate.util.ShortList;
import java.io.DataInputStream;

public final class AppShareProtocol
extends JinxProtocolAdapter {
    public static final int DFT_WINDOW_SIZE_MSEC = 750;
    public static final int MAX_WINDOW_SIZE = 32768;
    public static final int MIN_WINDOW_SIZE = 2048;
    public static final int MULTI_CMD = 1;
    public static final int START_CMD = 2;
    public static final int START_ACK_CMD = 3;
    public static final int STOP_CMD = 4;
    public static final int FRONT_CMD = 5;
    public static final int FLUSH_CMD = 6;
    public static final int FLUSH_ACK_CMD = 7;
    public static final int AOI_MOVE_CMD = 8;
    public static final int AOI_REMOVE_CMD = 9;
    public static final int AOI_ADD_CMD = 10;
    public static final int SCREEN_DATA_CMD = 11;
    public static final int DATA_ACK_CMD = 12;
    public static final int CURSOR_CMD = 13;
    public static final int CONTROL_GRANT_CMD = 14;
    public static final int CONTROL_RELEASE_CMD = 15;
    public static final int CONTROL_REVOKE_CMD = 16;
    public static final int MOUSE_MOVE_CMD = 17;
    public static final int MOUSE_DOWN_CMD = 18;
    public static final int MOUSE_UP_CMD = 19;
    public static final int MOUSE_CLICK_CMD = 20;
    public static final int MOUSE_DRAG_CMD = 21;
    public static final int KEY_CMD = 22;
    public static final int SUBSCRIBE_CMD = 23;
    public static final int STATUS_CMD = 24;
    public static final int WINDOW_CHANGE_CMD = 25;
    public static final int CACHE_CHANGE_CMD = 26;
    public static final int CHANGE_ACK_CMD = 27;
    public static final int REMOTE_QUERY_CMD = 28;
    public static final int REMOTE_START_CMD = 29;
    public static final int REMOTE_REPLY_CMD = 30;
    public static final int REMOTE_AUTH = 31;
    public static final int SCROLL_WHEEL_CMD = 32;
    public static final int REFRESH_CMD = 33;
    public static final int RESOLUTION_CHANGE_CMD = 34;
    private static final String[] COMMANDS = new String[]{"Multi-command", "Start", "Start Acknowlege", "Stop", "Front", "Flush", "FlushAck", "Move AOI", "Remove AOI", "Add AOI", "Screen Data", "Data Acknowlege", "Cursor", "Grant Control", "Release Control", "Revoke Control", "Mouse Move", "Mouse Button Down", "Mouse Button Up", "Mouse Click", "Mouse Drag", "Keyboard I/O", "Subscribe", "Status", "Window Change", "Cache Change", "Change Acknowlege", "Remote Query", "Remote Start", "Remote Reply", "Remote Authorization", "Scroll Wheel", "Refresh", "Resolution Change"};
    public static final int MAX_ACK_LENGTH = 65535;
    public static final int REMOTE_START_DESKTOP = 1;
    public static final int REMOTE_START_REGION = 2;
    public static final int REMOTE_START_APP = 3;
    public static final int REMOTE_START_CONTROL = 4;
    public static final int REMOTE_START_STOP = 5;
    public static final String[] REMOTE_START_MODES = new String[]{"Desktop", "Region", "Application", "Control", "Stop"};
    public static final int REMOTE_START_FIT_AREA_FLAG = 1;
    public static final int REMOTE_START_HIDE_MENU_FLAG = 2;
    public static final int REMOTE_START_PASSWORD_FLAG = 32768;
    public static final int REMOTE_START_ADMIN_MASK = 32768;
    public static final int REMOTE_START_OPS_MASK = 3;
    public static final int REMOTE_START_VALID_MASK = 32771;
    public static final int REMOTE_REPLY_OK = 1;
    public static final int REMOTE_REPLY_START_FAILED = 101;
    public static final int REMOTE_REPLY_START_REFUSED = 102;
    public static final int REMOTE_REPLY_CONTROL_FAILED = 103;
    public static final int REMOTE_REPLY_CONTROL_REFUSED = 104;
    public static final int REMOTE_REPLY_PASSWORD_REQUIRED = 105;
    public static final int REMOTE_REPLY_DATA_PASSWORD_SEED_KEY = 1;
    public static final int REMOTE_REPLY_DATA_START_MODE_KEY = 2;
    public static final int VAL_TYPE_BOOL = 1;
    public static final int VAL_TYPE_BYTE = 2;
    public static final int VAL_TYPE_SHORT = 3;
    public static final int VAL_TYPE_INT = 4;
    public static final int VAL_TYPE_LONG = 5;
    public static final int VAL_TYPE_FLOAT = 6;
    public static final int VAL_TYPE_DOUBLE = 7;
    public static final int VAL_TYPE_STRING = 8;
    public static final int VAL_TYPE_UNKNOWN = -1;
    public static final int UP_TO_DATE_STATUS = 1;
    public static final int TILES_BEHIND_STATUS = 2;
    public static final Integer UP_TO_DATE_CODE = new Integer(1);
    public static final Integer TILES_BEHIND_CODE = new Integer(2);
    public static final String UP_TO_DATE_PROP = "AppSharing.upToDate";
    public static final String TILES_BEHIND_PROP = "AppSharing.tilesBehind";
    public static final String HOST_UP_TO_DATE_PROP = "AppSharing.hostUpToDate";
    public static final byte UP_TO_DATE_OK = 1;
    public static final byte UP_TO_DATE_CLOSE = 2;
    public static final byte UP_TO_DATE_NOT = 3;
    public static final Byte UP_TO_DATE_OK_BYTE = Bytes.get((byte)1);
    public static final Byte UP_TO_DATE_CLOSE_BYTE = Bytes.get((byte)2);
    public static final Byte UP_TO_DATE_NOT_BYTE = Bytes.get((byte)3);
    private static final String[] STATUS_NAMES = new String[]{"Up-To-Date", "Tiles-Behind"};
    private static final int[] STATUS_TYPES = new int[]{2, 4};
    private static final String[] STATUS_PROPS = new String[]{"AppSharing.upToDate", "AppSharing.tilesBehind"};
    private static final boolean[] STATUS_ASSOCIATIVE = new boolean[]{true, true};
    public static final String ACCESS_PROPERTY = "AppShare.access";
    public static final String HOST_PROPERTY = "AppShare.host";
    public static final String CONTROL_PROPERTY = "AppShare.control";
    public static final String ENABLED_PROPERTY = "AppShare.enabled";
    public static final String CHANNEL = "AppSharing";
    public static final byte PRIORITY = 2;
    public static final String MODULE_NAME = "ApplicationSharing";

    public AppShareProtocol() {
        this(false, true);
    }

    public AppShareProtocol(boolean defaultAccess, boolean supervised) {
        this.defineProperty(ACCESS_PROPERTY, (byte)0, new Boolean(defaultAccess));
        this.defineProperty(HOST_PROPERTY, (byte)0, Boolean.FALSE);
        this.defineProperty(CONTROL_PROPERTY, (byte)0, Boolean.FALSE);
        this.defineProperty(ENABLED_PROPERTY, (byte)1, Boolean.TRUE);
        this.defineChannel(CHANNEL, (byte)2);
    }

    public String commandToString(byte cmd) {
        return AppShareProtocol.getCommandString(cmd);
    }

    public static String getCommandString(byte cmd) {
        if (cmd >= 1 && cmd <= COMMANDS.length) {
            return COMMANDS[cmd - 1];
        }
        return "Invalid AppShareProtocol command - " + cmd;
    }

    public static String getStatusString(int code) {
        if (AppShareProtocol.isValidStatus(code)) {
            return STATUS_NAMES[code - 1];
        }
        return "Unknown AppShare Status Code - " + code;
    }

    public static int getStatusType(int code) {
        if (AppShareProtocol.isValidStatus(code)) {
            return STATUS_TYPES[code - 1];
        }
        return -1;
    }

    public static boolean isPluralStatus(int code) {
        if (AppShareProtocol.isValidStatus(code)) {
            return STATUS_ASSOCIATIVE[code - 1];
        }
        return false;
    }

    public static boolean isValidStatus(int code) {
        return code >= 1 && code <= STATUS_NAMES.length;
    }

    public static String getStatusProperty(int code) {
        if (AppShareProtocol.isValidStatus(code)) {
            return STATUS_PROPS[code - 1];
        }
        return null;
    }

    public static int getWindowSize(int connectSpeed) {
        int result = connectSpeed * 750 / 8000;
        if (result > 32768) {
            result = 32768;
        }
        if (result < 2048) {
            result = 2048;
        }
        return result;
    }

    public String messageToString(byte cmd, DataInputStream strm) {
        return AppShareMessage.construct(cmd, strm, null).toString();
    }

    public ProtocolResponder getResponder() {
        return new AppShareResponder();
    }

    public static final class UpToDateRequest
    extends AppShareMessage.Subscribe.Request {
        public UpToDateRequest(short levelOK, short levelClose) {
            super(1);
            this.addArg(ShortList.get((short)levelOK));
            this.addArg(ShortList.get((short)levelClose));
        }
    }
}

