/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.AppShareMessageHandler;
import com.elluminate.groupware.appshare.AppShareProtocol;
import com.elluminate.jinx.Bytes;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public abstract class AppShareMessage {
    private static final byte DEFAULT_URGENCY = -1;
    private byte cmdCode = 0;
    protected AppShareMessageHandler handler = null;
    private short sender = (short)-32767;
    private boolean logMetric = false;
    private String operation = "";
    private static Byte[] allBytes = new Byte[256];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppShareMessage construct(ChannelDataEvent ev, AppShareMessageHandler mh) {
        DataInputStream s = null;
        AppShareMessage result = null;
        try {
            s = ev.read();
            result = AppShareMessage.construct(ev.getCommand(), s, mh);
            if (result != null) {
                result.setSender(ev.getSourceAddress());
            }
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Throwable t) {}
            }
        }
        return result;
    }

    public static AppShareMessage construct(byte cmd, DataInputStream strm, AppShareMessageHandler mh) {
        AppShareMessage result = null;
        switch (cmd) {
            case 1: {
                result = new Multiple();
                break;
            }
            case 2: {
                result = new Start();
                break;
            }
            case 3: {
                result = new StartAck();
                break;
            }
            case 4: {
                result = new Stop();
                break;
            }
            case 5: {
                result = new Front();
                break;
            }
            case 6: {
                result = new Flush();
                break;
            }
            case 7: {
                result = new FlushAck();
                break;
            }
            case 8: {
                result = new AOIMove();
                break;
            }
            case 9: {
                result = new AOIRemove();
                break;
            }
            case 10: {
                result = new AOIAdd();
                break;
            }
            case 11: {
                result = new ScreenData();
                break;
            }
            case 12: {
                result = new ScreenDataAck();
                break;
            }
            case 13: {
                result = new Cursor();
                break;
            }
            case 14: {
                result = new Control();
                break;
            }
            case 15: {
                result = new Release();
                break;
            }
            case 16: {
                result = new Revoke();
                break;
            }
            case 17: {
                result = new MouseMove();
                break;
            }
            case 18: {
                result = new MouseDown();
                break;
            }
            case 19: {
                result = new MouseUp();
                break;
            }
            case 20: {
                result = new MouseClick();
                break;
            }
            case 21: {
                result = new MouseDrag();
                break;
            }
            case 22: {
                result = new Key();
                break;
            }
            case 23: {
                result = new Subscribe();
                break;
            }
            case 24: {
                result = new Status();
                break;
            }
            case 25: {
                result = new WindowChange();
                break;
            }
            case 26: {
                result = new CacheChange();
                break;
            }
            case 27: {
                result = new ChangeAck();
                break;
            }
            case 29: {
                result = new RemoteStart();
                break;
            }
            case 30: {
                result = new RemoteReply();
                break;
            }
            case 32: {
                result = new ScrollWheel();
                break;
            }
            case 33: {
                result = new Refresh();
                break;
            }
            default: {
                throw new RuntimeException("Invalid AppShare command: " + cmd);
            }
        }
        try {
            result.parse(strm);
        }
        catch (IOException ex) {
            LogSupport.exception(AppShareMessage.class, (String)"construct", (Throwable)ex, (boolean)true, (String)"I/O error parsing message.");
            result = null;
        }
        if (result != null) {
            result.setHandler(mh);
        }
        return result;
    }

    protected AppShareMessage(int cmd, boolean logMetric, String operation) {
        this.cmdCode = (byte)cmd;
        this.logMetric = logMetric;
        this.operation = operation;
    }

    public byte getCommand() {
        return this.cmdCode;
    }

    public short getSender() {
        return this.sender;
    }

    protected void setSender(short whom) {
        this.sender = whom;
    }

    public int getWindowLength() {
        return 0;
    }

    protected ChannelDataEvent createEventRec(Object src, short to) {
        ChannelDataEvent ev = ChannelDataEvent.getInstance((Object)src, (short)to, (byte)this.getCommand());
        DataOutputStream strm = ev.write();
        if (strm == null) {
            throw new RuntimeException("Could not obtain byte stream from ChannelDataEvent.");
        }
        try {
            this.encode(strm);
            strm.close();
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"initEventRec", (Throwable)ex, (boolean)true);
            try {
                strm.close();
            }
            catch (IOException t) {
                // empty catch block
            }
            throw new RuntimeException("I/O error on byte stream:\n" + ex.toString());
        }
        return ev;
    }

    public void send(short to) {
        this.send(to, this.handler, (byte)-1);
    }

    public void send(short to, byte urgency) {
        this.send(to, this.handler, urgency);
    }

    public void send(short to, AppShareMessageHandler mh) {
        this.send(to, mh, (byte)-1);
    }

    public void send(short to, AppShareMessageHandler mh, byte urgency) {
        ChannelDataEvent ev = this.createEventRec(mh, to);
        mh.sendMessage(ev, urgency, this, to);
    }

    public AppShareMessageHandler getHandler() {
        return this.handler;
    }

    public void setHandler(AppShareMessageHandler h) {
        this.handler = h;
    }

    public abstract void dispatch();

    public void parse(DataInputStream strm) throws IOException {
    }

    public void encode(DataOutputStream strm) throws IOException {
    }

    public String toString() {
        return "AppShareMessage@" + this.hashCode() + (this.sender != -32767 ? " from=" + this.sender : "") + " handler=" + this.handler + " " + AppShareProtocol.getCommandString(this.cmdCode);
    }

    protected static void parseUInt12Pair(DataInputStream strm, short[] result) throws IOException {
        byte b1 = strm.readByte();
        byte b2 = strm.readByte();
        byte b3 = strm.readByte();
        result[0] = (short)(((short)b1 & 0xFF) << 4 | b2 >> 4 & 0xF);
        result[1] = (short)(((short)b2 & 0xF) << 8 | (short)b3 & 0xFF);
    }

    protected static void encodeUInt12Pair(DataOutputStream strm, short v1, short v2) throws IOException {
        byte b1 = (byte)(v1 >> 4 & 0xFF);
        byte b2 = (byte)((v1 & 0xF) << 4 | v2 >> 8 & 0xF);
        byte b3 = (byte)(v2 & 0xFF);
        strm.writeByte(b1);
        strm.writeByte(b2);
        strm.writeByte(b3);
    }

    private static String encodeHexBytes(byte[] data) {
        if (data == null) {
            return "" + data;
        }
        StringBuffer result = new StringBuffer(data.length * 3 + 3);
        result.append("{ ");
        for (int ix = 0; ix < data.length; ++ix) {
            if ((data[ix] & 0xFF) < 16) {
                result.append(" 0" + Integer.toHexString(data[ix] & 0xF));
                continue;
            }
            result.append(" " + Integer.toHexString(data[ix] & 0xFF));
        }
        result.append(" }");
        return result.toString();
    }

    private static final Byte makeByte(byte val) {
        int idx = val & 0xFF;
        if (allBytes[idx] == null) {
            AppShareMessage.allBytes[idx] = Bytes.get((byte)val);
        }
        return allBytes[idx];
    }

    public boolean isLogMetric() {
        return this.logMetric;
    }

    public String getOperation() {
        return this.operation;
    }

    public static final class AOIAdd
    extends AppShareMessage {
        private byte id = 0;
        private short x = 0;
        private short y = 0;
        private short w = 0;
        private short h = 0;

        public AOIAdd() {
            super(10, false, "");
        }

        public AOIAdd(byte anID, int posX, int posY, int width, int height) {
            super(10, false, "");
            if (posX < 0 || posX > 4095) {
                throw new IllegalArgumentException("AOI X coordinate outside range 0..4095: " + posX);
            }
            if (posY < 0 || posY > 4095) {
                throw new IllegalArgumentException("AOI Y coordinate outside range 0..4095: " + posY);
            }
            if (width < 0 || width > 4095) {
                throw new IllegalArgumentException("AOI width width outside range 0..4095: " + width);
            }
            if (height < 0 || height > 4095) {
                throw new IllegalArgumentException("AOI height outside range 0..4095: " + height);
            }
            this.id = anID;
            this.x = (short)posX;
            this.y = (short)posY;
            this.w = (short)width;
            this.h = (short)height;
        }

        public AoiInfo getInfo() {
            AoiInfo i = new AoiInfo(this.id);
            i.x = this.x;
            i.y = this.y;
            i.w = this.w;
            i.h = this.h;
            return i;
        }

        public byte getID() {
            return this.id;
        }

        public Point getPos() {
            return new Point(this.x, this.y);
        }

        public short getX() {
            return this.x;
        }

        public short getY() {
            return this.y;
        }

        public Dimension getDim() {
            return new Dimension(this.w, this.h);
        }

        public short getWidth() {
            return this.w;
        }

        public short getHeight() {
            return this.h;
        }

        public void setPos(short newX, short newY) {
            this.x = newX;
            this.y = newY;
        }

        public void setDim(short width, short height) {
            this.w = width;
            this.h = height;
        }

        @Override
        public int getWindowLength() {
            return 9;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            short[] pair = new short[2];
            this.id = 0;
            this.h = 0;
            this.w = 0;
            this.y = 0;
            this.x = 0;
            this.id = strm.readByte();
            AppShareMessage.parseUInt12Pair(strm, pair);
            this.x = pair[0];
            this.y = pair[1];
            AppShareMessage.parseUInt12Pair(strm, pair);
            this.w = pair[0];
            this.h = pair[1];
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeByte(this.id);
            AppShareMessage.encodeUInt12Pair(strm, this.x, this.y);
            AppShareMessage.encodeUInt12Pair(strm, this.w, this.h);
        }

        @Override
        public void dispatch() {
            this.handler.handleAOIAdd(this);
        }

        @Override
        public String toString() {
            return super.toString() + " ID=" + this.id + " Pos=" + this.x + "," + this.y + " Dim=" + this.w + "x" + this.h;
        }
    }

    public static final class AOIMove
    extends AppShareMessage {
        private byte id = 0;
        private short x = 0;
        private short y = 0;
        private short w = 0;
        private short h = 0;

        public AOIMove() {
            super(8, false, "");
        }

        public AOIMove(byte anID, int anX, int aY, int aWidth, int aHeight) {
            super(8, false, "");
            if (anX < 0 || anX > 4095) {
                throw new IllegalArgumentException("X coordinate outside range 0..4095: " + anX);
            }
            if (aY < 0 || aY > 4095) {
                throw new IllegalArgumentException("Y coordinate outside range 0..4095: " + aY);
            }
            if (aWidth < 0 || aWidth > 4095 - anX) {
                throw new IllegalArgumentException("Width outside range 0.." + (4095 - anX) + ": " + aWidth);
            }
            if (aHeight < 0 || aHeight > 4095 - aY) {
                throw new IllegalArgumentException("Height outside range 0.." + (4095 - aY) + ": " + aHeight);
            }
            this.id = anID;
            this.x = (short)anX;
            this.y = (short)aY;
            this.w = (short)aWidth;
            this.h = (short)aHeight;
        }

        public AoiInfo getInfo() {
            AoiInfo i = new AoiInfo(this.id);
            i.x = this.x;
            i.y = this.y;
            i.w = this.w;
            i.h = this.h;
            return i;
        }

        public byte getID() {
            return this.id;
        }

        public Point getPos() {
            return new Point(this.x, this.y);
        }

        public short getX() {
            return this.x;
        }

        public short getY() {
            return this.y;
        }

        public Dimension getSize() {
            return new Dimension(this.w, this.h);
        }

        public short getWidth() {
            return this.w;
        }

        public short getHeight() {
            return this.h;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x, this.y, this.w, this.h);
        }

        @Override
        public int getWindowLength() {
            return 9;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            short[] pair = new short[2];
            this.id = 0;
            this.h = 0;
            this.w = 0;
            this.y = 0;
            this.x = 0;
            this.id = strm.readByte();
            AppShareMessage.parseUInt12Pair(strm, pair);
            this.x = pair[0];
            this.y = pair[1];
            AppShareMessage.parseUInt12Pair(strm, pair);
            this.w = pair[0];
            this.h = pair[1];
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeByte(this.id);
            AppShareMessage.encodeUInt12Pair(strm, this.x, this.y);
            AppShareMessage.encodeUInt12Pair(strm, this.w, this.h);
        }

        @Override
        public void dispatch() {
            this.handler.handleAOIMove(this);
        }

        @Override
        public String toString() {
            return super.toString() + " ID=" + this.id + " Pos=" + this.x + "," + this.y + " Size=" + this.w + "x" + this.h;
        }
    }

    public static final class AOIRemove
    extends AppShareMessage {
        private byte id = 0;

        public AOIRemove() {
            super(9, false, "");
        }

        public AOIRemove(byte anID) {
            super(9, false, "");
            this.id = anID;
        }

        public byte getID() {
            return this.id;
        }

        @Override
        public int getWindowLength() {
            return 1;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.id = 0;
            this.id = strm.readByte();
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeByte(this.id);
        }

        @Override
        public void dispatch() {
            this.handler.handleAOIRemove(this);
        }

        @Override
        public String toString() {
            return super.toString() + " ID=" + this.id;
        }
    }

    public static final class AoiInfo {
        public byte id;
        public short x;
        public short y;
        public short w;
        public short h;

        public AoiInfo(byte anID) {
            this.id = anID;
            this.h = 0;
            this.w = 0;
            this.y = 0;
            this.x = 0;
        }

        public Rectangle getBounds() {
            return new Rectangle(this.x, this.y, this.w, this.h);
        }

        public String toString() {
            return "{ " + this.id + ": " + this.x + "," + this.y + " " + this.w + "x" + this.h + " }";
        }
    }

    public static final class CacheChange
    extends AppShareMessage {
        private int cacheSize = 0;

        public CacheChange() {
            super(26, false, "");
        }

        public CacheChange(int cacheSz) {
            super(26, false, "");
            if (cacheSz < 0 || cacheSz > 65535) {
                throw new IllegalArgumentException("Window size outside range 0..65535: " + cacheSz);
            }
            this.cacheSize = cacheSz;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.cacheSize = strm.readUnsignedShort();
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeShort(this.cacheSize);
        }

        @Override
        public void dispatch() {
            this.handler.handleCacheChange(this);
        }

        @Override
        public String toString() {
            return super.toString() + " cacheSize=" + this.cacheSize;
        }
    }

    public static final class ChangeAck
    extends AppShareMessage {
        private int changeRef = 0;
        private int confirmSize = 0;

        public ChangeAck() {
            super(27, false, "");
        }

        public ChangeAck(int ref, int siz) {
            super(27, false, "");
            if (ref < 0 || ref > 255) {
                throw new IllegalArgumentException("Change reference outside range 0..255: " + ref);
            }
            if (siz < 0 || siz > 65535) {
                throw new IllegalArgumentException("Confirmation size outside range 0..65535: " + siz);
            }
            this.changeRef = ref;
            this.confirmSize = siz;
        }

        public int getReference() {
            return this.changeRef;
        }

        public int getConfirmSize() {
            return this.confirmSize;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.changeRef = strm.readUnsignedByte();
            this.confirmSize = strm.readUnsignedShort();
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeByte(this.changeRef);
            strm.writeShort(this.confirmSize);
        }

        @Override
        public void dispatch() {
            this.handler.handleChangeAck(this);
        }

        @Override
        public String toString() {
            return super.toString() + " changeRef=" + AppShareProtocol.getCommandString((byte)this.changeRef) + " confirmSize=" + this.confirmSize;
        }
    }

    public static final class Control
    extends AppShareMessage {
        private short userID = 0;

        public Control() {
            super(14, true, "control");
        }

        public Control(short toUser) {
            super(14, true, "control");
            this.userID = toUser;
        }

        public short getUser() {
            return this.userID;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.userID = 0;
            this.userID = strm.readShort();
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeShort(this.userID);
        }

        @Override
        public void dispatch() {
            this.handler.handleControl(this);
        }

        @Override
        public String toString() {
            return super.toString() + " User=" + this.userID;
        }
    }

    public static final class Cursor
    extends AppShareMessage {
        public static final byte PIXMAP_16 = 1;
        public static final byte PIXMAP_32 = 2;
        private short x = (short)-1;
        private short y = (short)-1;
        private short id = (short)-1;
        private short width = (short)-1;
        private short height = (short)-1;
        private byte mode = 0;
        private short hotX = (short)-1;
        private short hotY = (short)-1;
        private byte[] data = null;

        public Cursor() {
            super(13, false, "");
        }

        public Cursor(short cursorX, short cursorY) {
            super(13, false, "");
            if (cursorX < 0 || cursorX > 4095) {
                throw new IllegalArgumentException("X coordinate outside range 0..4095: " + cursorX);
            }
            if (cursorY < 0 || cursorY > 4095) {
                throw new IllegalArgumentException("Y coordinate outside range 0..4095: " + cursorY);
            }
            this.x = cursorX;
            this.y = cursorY;
        }

        public Cursor(Point cursorPos) {
            this((short)cursorPos.x, (short)cursorPos.y);
        }

        public Cursor(short cursorX, short cursorY, short anID) {
            this(cursorX, cursorY);
            if (anID < 0 || anID > 255) {
                throw new IllegalArgumentException("Cursor ID outside range 0..255: " + anID);
            }
            this.id = anID;
        }

        public Cursor(Point cursorPos, short anID) {
            this((short)cursorPos.x, (short)cursorPos.y, anID);
        }

        public Cursor(short cursorX, short cursorY, short anID, int w, int h, int m, int hotSpotX, int hotSpotY, byte[] cursorImg) {
            this(cursorX, cursorY, anID);
            this.setImageData(w, h, m, hotSpotX, hotSpotY, cursorImg);
        }

        public Cursor(Point cursorPos, short anID, int w, int h, int m, int hotSpotX, int hotSpotY, byte[] cursorImg) {
            this((short)cursorPos.x, (short)cursorPos.y, anID);
            this.setImageData(w, h, m, hotSpotX, hotSpotY, cursorImg);
        }

        public Cursor(short cursorX, short cursorY, short anID, int w, int h, int hotSpotX, int hotSpotY, short[] cursorImg) {
            this(cursorX, cursorY, anID);
            this.setImageData(w, h, hotSpotX, hotSpotY, cursorImg);
        }

        public Cursor(Point cursorPos, short anID, int w, int h, int hotSpotX, int hotSpotY, short[] cursorImg) {
            this((short)cursorPos.x, (short)cursorPos.y, anID);
            this.setImageData(w, h, hotSpotX, hotSpotY, cursorImg);
        }

        public Cursor(short cursorX, short cursorY, short anID, int w, int h, int hotSpotX, int hotSpotY, int[] cursorImg) {
            this(cursorX, cursorY, anID);
            this.setImageData(w, h, hotSpotX, hotSpotY, cursorImg);
        }

        public Cursor(Point cursorPos, short anID, int w, int h, int hotSpotX, int hotSpotY, int[] cursorImg) {
            this((short)cursorPos.x, (short)cursorPos.y, anID);
            this.setImageData(w, h, hotSpotX, hotSpotY, cursorImg);
        }

        public Point getPos() {
            return new Point(this.x, this.y);
        }

        public short getX() {
            return this.x;
        }

        public short getY() {
            return this.y;
        }

        public boolean hasID() {
            return this.id >= 0 && this.id < 256;
        }

        public short getID() {
            return this.id;
        }

        public boolean hasImage() {
            return this.data != null;
        }

        public Dimension getDim() {
            return new Dimension(this.width, this.height);
        }

        public short getWidth() {
            return this.width;
        }

        public short getHeight() {
            return this.height;
        }

        public byte getMode() {
            return this.mode;
        }

        public Point getHotSpot() {
            return new Point(this.hotX, this.hotY);
        }

        public short getHotSpotX() {
            return this.hotX;
        }

        public short getHotSpotY() {
            return this.hotY;
        }

        public byte[] getImageData() {
            return this.data;
        }

        public short[] getImageDataShort() {
            if (this.mode != 1) {
                throw new RuntimeException("Incompatible pixel encoding");
            }
            short[] result = new short[this.data.length / 2];
            try {
                ByteArrayInputStream bistrm = new ByteArrayInputStream(this.data);
                DataInputStream strm = new DataInputStream(bistrm);
                for (int ix = 0; ix < result.length; ++ix) {
                    result[ix] = strm.readShort();
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"getImageDataShort", (Throwable)ex, (boolean)true);
                return null;
            }
            return result;
        }

        public int[] getImageDataInt() {
            if (this.mode != 2) {
                throw new RuntimeException("Incompatible pixel encoding");
            }
            int[] result = new int[this.data.length / 4];
            try {
                ByteArrayInputStream bistrm = new ByteArrayInputStream(this.data);
                DataInputStream strm = new DataInputStream(bistrm);
                for (int ix = 0; ix < result.length; ++ix) {
                    result[ix] = strm.readInt();
                }
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"getImageDataShort", (Throwable)ex, (boolean)true);
                return null;
            }
            return result;
        }

        @Override
        public int getWindowLength() {
            return 3 + (this.hasID() ? 1 : 0) + (this.hasImage() ? this.data.length : 0);
        }

        public void setImageData(int w, int h, int m, int hotSpotX, int hotSpotY, byte[] cursorImg) {
            if (w < 1 || w > 256) {
                throw new IllegalArgumentException("Cursor width outside range 1..256: " + w);
            }
            if (h < 1 || h > 256) {
                throw new IllegalArgumentException("Cursor height outside range 1..256: " + h);
            }
            if (m < 0 || m > 255) {
                throw new IllegalArgumentException("Cursor mode invalid: " + m);
            }
            if (hotSpotX < 0 || hotSpotX > 255) {
                throw new IllegalArgumentException("Hot spot X outside range 0..255: " + hotSpotX);
            }
            if (hotSpotY < 0 || hotSpotY > 255) {
                throw new IllegalArgumentException("Hot spot Y outside range 0..255: " + hotSpotY);
            }
            this.width = (short)w;
            this.height = (short)h;
            this.mode = (byte)m;
            this.hotX = (short)hotSpotX;
            this.hotY = (short)hotSpotY;
            this.data = cursorImg;
        }

        public void setImageData(int w, int h, int hotSpotX, int hotSpotY, short[] cursorImg) {
            if (w < 1 || w > 256) {
                throw new IllegalArgumentException("Cursor width outside range 1..256: " + w);
            }
            if (h < 1 || h > 256) {
                throw new IllegalArgumentException("Cursor height outside range 1..256: " + h);
            }
            if (hotSpotX < 0 || hotSpotX > 255) {
                throw new IllegalArgumentException("Hot spot X outside range 0..255: " + hotSpotX);
            }
            if (hotSpotY < 0 || hotSpotY > 255) {
                throw new IllegalArgumentException("Hot spot Y outside range 0..255: " + hotSpotY);
            }
            this.width = (short)w;
            this.height = (short)h;
            this.mode = 1;
            this.hotX = (short)hotSpotX;
            this.hotY = (short)hotSpotY;
            try {
                ByteArrayOutputStream bostrm = new ByteArrayOutputStream(cursorImg.length * 2);
                DataOutputStream strm = new DataOutputStream(bostrm);
                for (int ix = 0; ix < cursorImg.length; ++ix) {
                    strm.writeShort(cursorImg[ix]);
                }
                strm.flush();
                this.data = bostrm.toByteArray();
            }
            catch (IOException ex) {
                this.data = null;
                throw new RuntimeException("I/O error storing cursor image shorts to byte array: " + ex);
            }
        }

        public void setImageData(int w, int h, int hotSpotX, int hotSpotY, int[] cursorImg) {
            if (w < 1 || w > 256) {
                throw new IllegalArgumentException("Cursor width outside range 1..256: " + w);
            }
            if (h < 1 || h > 256) {
                throw new IllegalArgumentException("Cursor height outside range 1..256: " + h);
            }
            if (hotSpotX < 0 || hotSpotX > 255) {
                throw new IllegalArgumentException("Hot spot X outside range 0..255: " + hotSpotX);
            }
            if (hotSpotY < 0 || hotSpotY > 255) {
                throw new IllegalArgumentException("Hot spot Y outside range 0..255: " + hotSpotY);
            }
            this.width = (short)w;
            this.height = (short)h;
            this.mode = (byte)2;
            this.hotX = (short)hotSpotX;
            this.hotY = (short)hotSpotY;
            try {
                ByteArrayOutputStream bostrm = new ByteArrayOutputStream(cursorImg.length * 4);
                DataOutputStream strm = new DataOutputStream(bostrm);
                for (int ix = 0; ix < cursorImg.length; ++ix) {
                    strm.writeInt(cursorImg[ix]);
                }
                strm.flush();
                this.data = bostrm.toByteArray();
            }
            catch (IOException ex) {
                this.data = null;
                throw new RuntimeException("I/O error storing cursor image shorts to byte array: " + ex);
            }
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            short[] pair = new short[2];
            this.y = (short)-1;
            this.x = (short)-1;
            this.id = (short)-1;
            this.data = null;
            this.height = (short)-1;
            this.width = (short)-1;
            AppShareMessage.parseUInt12Pair(strm, pair);
            this.x = pair[0];
            this.y = pair[1];
            if (strm.available() == 0) {
                return;
            }
            this.id = (short)strm.readUnsignedByte();
            if (strm.available() == 0) {
                return;
            }
            this.width = (short)(strm.readUnsignedByte() + 1);
            this.height = (short)(strm.readUnsignedByte() + 1);
            this.mode = strm.readByte();
            this.hotX = (short)strm.readUnsignedByte();
            this.hotY = (short)strm.readUnsignedByte();
            this.data = new byte[strm.available()];
            strm.readFully(this.data);
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            AppShareMessage.encodeUInt12Pair(strm, this.x, this.y);
            if (this.hasID()) {
                strm.writeByte(this.id);
            }
            if (this.hasImage() && this.width >= 0 && this.height >= 0 && this.data.length > 0) {
                strm.writeByte(this.width - 1);
                strm.writeByte(this.height - 1);
                strm.writeByte(this.mode);
                strm.writeByte(this.hotX);
                strm.writeByte(this.hotY);
                strm.write(this.data, 0, this.data.length);
            }
        }

        @Override
        public void dispatch() {
            this.handler.handleCursor(this);
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer(80);
            result.append(super.toString() + " Pos=" + this.x + "," + this.y);
            if (this.hasID()) {
                result.append(" ID=" + this.id);
            }
            if (this.hasImage()) {
                result.append(" Dim=" + this.width + "x" + this.height);
                result.append(" Mode=" + this.mode);
                result.append(" HotSpot=" + this.hotX + "," + this.hotY);
                if (AppShareDebug.VERBOSE.show()) {
                    result.append(" Data=" + AppShareMessage.encodeHexBytes(this.data));
                } else {
                    result.append(" Data=" + this.data.length + " bytes");
                }
            }
            return result.toString();
        }
    }

    public static final class Flush
    extends AppShareMessage {
        public Flush() {
            super(6, false, "");
        }

        @Override
        public void dispatch() {
            this.handler.handleFlush(this);
        }
    }

    public static final class FlushAck
    extends AppShareMessage {
        public FlushAck() {
            super(7, false, "");
        }

        @Override
        public void dispatch() {
            this.handler.handleFlushAck(this);
        }
    }

    public static final class Front
    extends AppShareMessage {
        private boolean visible = true;

        public Front() {
            super(5, false, "");
        }

        public Front(boolean vis) {
            super(5, false, "");
            this.visible = vis;
        }

        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.visible = true;
            if (strm.available() > 0) {
                this.visible = strm.readBoolean();
            }
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeBoolean(this.visible);
        }

        @Override
        public void dispatch() {
            this.handler.handleFront(this);
        }
    }

    public static final class Key
    extends AppShareMessage {
        private int keycode = 0;
        private char glyph = (char)65535;
        private boolean keyDown = false;

        public Key() {
            super(22, false, "");
        }

        public Key(int aKeyCode, char aGlyph, boolean aKeyDown) {
            super(22, false, "");
            if (aKeyCode < 0 || aKeyCode > 65535) {
                throw new IllegalArgumentException("KeyCode outside range 0..65535: " + aKeyCode);
            }
            this.keycode = aKeyCode;
            this.glyph = aGlyph;
            this.keyDown = aKeyDown;
        }

        public int getKeyCode() {
            return this.keycode;
        }

        public char getGlyph() {
            return this.glyph;
        }

        public boolean isDown() {
            return this.keyDown;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.keycode = 0;
            this.glyph = (char)65535;
            this.keyDown = false;
            this.keycode = strm.readUnsignedShort();
            this.glyph = (char)strm.readUnsignedShort();
            this.keyDown = strm.readBoolean();
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeShort((short)(this.keycode & 0xFFFF));
            strm.writeShort((short)this.glyph);
            strm.writeBoolean(this.keyDown);
        }

        @Override
        public void dispatch() {
            this.handler.handleKey(this);
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer(48);
            result.append(super.toString() + " Code=" + this.keycode);
            result.append(" Glyph=" + Integer.toHexString(this.glyph & 0xFFFF));
            if (this.glyph != '\u0000') {
                result.append("='" + this.glyph + "'");
            }
            result.append(" Down=" + this.keyDown);
            return result.toString();
        }
    }

    public static abstract class Mouse
    extends AppShareMessage {
        protected short x = 0;
        protected short y = 0;
        protected short x1 = 0;
        protected short y1 = 0;
        protected int buttonNumber = 0;
        protected boolean shiftDown = false;
        protected boolean altDown = false;
        protected boolean controlDown = false;
        protected boolean metaDown = false;
        protected static final byte SHIFT_MASK = 4;
        protected static final byte CONTROL_MASK = 8;
        protected static final byte ALT_MASK = 16;
        protected static final byte META_MASK = 32;

        protected Mouse(int cmd) {
            super(cmd, false, "");
        }

        protected Mouse(int cmd, int posX, int posY) {
            super(cmd, false, "");
            if (posX < 0 || posX > 4095) {
                throw new IllegalArgumentException("X coordinate outside range 0..4095: " + posX);
            }
            if (posY < 0 || posY > 4095) {
                throw new IllegalArgumentException("Y coordinate outside range 0..4095: " + posY);
            }
            this.x = (short)posX;
            this.y = (short)posY;
        }

        protected Mouse(int cmd, int posX, int posY, int whichBtn, boolean shift, boolean alt, boolean control, boolean meta) {
            this(cmd, posX, posY);
            this.buttonNumber = whichBtn;
            this.shiftDown = shift;
            this.altDown = alt;
            this.controlDown = control;
            this.metaDown = meta;
        }

        public Point getPos() {
            return new Point(this.x, this.y);
        }

        public short getX() {
            return this.x;
        }

        public short getY() {
            return this.y;
        }

        public int getButton() {
            return this.buttonNumber;
        }

        public boolean isShift() {
            return this.shiftDown;
        }

        public boolean isAlt() {
            return this.altDown;
        }

        public boolean isControl() {
            return this.controlDown;
        }

        public boolean isMeta() {
            return this.metaDown;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            short[] pair = new short[2];
            this.y = 0;
            this.x = 0;
            AppShareMessage.parseUInt12Pair(strm, pair);
            this.x = pair[0];
            this.y = pair[1];
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            AppShareMessage.encodeUInt12Pair(strm, this.x, this.y);
        }

        protected void parseModifiers(byte info) {
            this.shiftDown = (info & 4) != 0;
            this.altDown = (info & 0x10) != 0;
            this.controlDown = (info & 8) != 0;
            this.metaDown = (info & 0x20) != 0;
        }

        protected byte encodeModifiers() {
            byte info = 0;
            if (this.shiftDown) {
                info = (byte)(info | 4);
            }
            if (this.altDown) {
                info = (byte)(info | 0x10);
            }
            if (this.controlDown) {
                info = (byte)(info | 8);
            }
            if (this.metaDown) {
                info = (byte)(info | 0x20);
            }
            return info;
        }

        protected void parseButton(byte info) {
            this.buttonNumber = info & 3;
        }

        protected byte encodeButton() {
            return (byte)(this.buttonNumber & 3);
        }

        @Override
        public String toString() {
            return super.toString() + " Pos=" + this.x + "," + this.y;
        }

        protected String buttonToString() {
            return " Btn=" + this.buttonNumber;
        }

        protected String modifiersToString() {
            StringBuffer result = new StringBuffer(24);
            if (this.shiftDown) {
                result.append(" Shift");
            }
            if (this.altDown) {
                result.append(" Alt");
            }
            if (this.controlDown) {
                result.append(" Control");
            }
            if (this.metaDown) {
                result.append(" Meta");
            }
            return result.toString();
        }
    }

    public static final class MouseClick
    extends Mouse {
        private int clickCount = 0;

        public MouseClick() {
            super(20);
        }

        public MouseClick(int whichBtn, int numClicks, boolean shift, boolean alt, boolean control, boolean meta, int posX, int posY) {
            super(20, posX, posY, whichBtn, shift, alt, control, meta);
            this.clickCount = numClicks;
        }

        int getCount() {
            return this.clickCount;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.buttonNumber = 0;
            this.metaDown = false;
            this.controlDown = false;
            this.altDown = false;
            this.shiftDown = false;
            this.y = 0;
            this.x = 0;
            byte info = strm.readByte();
            this.parseButton(info);
            this.parseModifiers(info);
            this.clickCount = (info >> 6 & 3) + 1;
            super.parse(strm);
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            byte info = this.encodeButton();
            info = (byte)(info | this.encodeModifiers());
            info = (byte)(info | (byte)(this.clickCount - 1 & 3) << 6);
            strm.writeByte(info);
            super.encode(strm);
        }

        @Override
        public void dispatch() {
            this.handler.handleMouseClick(this);
        }

        @Override
        public String toString() {
            return super.toString() + this.buttonToString() + this.modifiersToString() + " Count=" + this.clickCount;
        }
    }

    public static final class MouseDown
    extends Mouse {
        public MouseDown() {
            super(18);
        }

        public MouseDown(int whichBtn, boolean shift, boolean alt, boolean control, boolean meta, int posX, int posY) {
            super(18, posX, posY, whichBtn, shift, alt, control, meta);
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.buttonNumber = 0;
            this.metaDown = false;
            this.controlDown = false;
            this.altDown = false;
            this.shiftDown = false;
            this.y = 0;
            this.x = 0;
            byte info = strm.readByte();
            this.parseButton(info);
            this.parseModifiers(info);
            super.parse(strm);
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            byte info = this.encodeButton();
            info = (byte)(info | this.encodeModifiers());
            strm.writeByte(info);
            super.encode(strm);
        }

        @Override
        public void dispatch() {
            this.handler.handleMouseDown(this);
        }

        @Override
        public String toString() {
            return super.toString() + this.buttonToString() + this.modifiersToString();
        }
    }

    public static final class MouseDrag
    extends Mouse {
        private short x1 = 0;
        private short y1 = 0;

        public MouseDrag() {
            super(21);
        }

        public MouseDrag(int whichBtn, boolean shift, boolean alt, boolean control, boolean meta, int startX, int startY, int endX, int endY) {
            super(21, startX, startY, whichBtn, shift, alt, control, meta);
            if (endX < 0 || endX > 4095) {
                throw new IllegalArgumentException("X coordinate outside range 0..4095: " + endX);
            }
            if (endY < 0 || endY > 4095) {
                throw new IllegalArgumentException("Y coordinate outside range 0..4095: " + endY);
            }
            this.x1 = (short)endX;
            this.y1 = (short)endY;
        }

        public Point getEndPos() {
            return new Point(this.x1, this.y1);
        }

        public short getEndX() {
            return this.x1;
        }

        public short getEndY() {
            return this.y1;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            short[] pair = new short[2];
            this.buttonNumber = 0;
            this.metaDown = false;
            this.controlDown = false;
            this.altDown = false;
            this.shiftDown = false;
            this.y = 0;
            this.x = 0;
            this.y1 = 0;
            this.x1 = 0;
            byte info = strm.readByte();
            this.parseButton(info);
            this.parseModifiers(info);
            super.parse(strm);
            AppShareMessage.parseUInt12Pair(strm, pair);
            this.x1 = pair[0];
            this.y1 = pair[1];
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            byte info = this.encodeButton();
            info = (byte)(info | this.encodeModifiers());
            strm.writeByte(info);
            super.encode(strm);
            AppShareMessage.encodeUInt12Pair(strm, this.x1, this.y1);
        }

        @Override
        public void dispatch() {
            this.handler.handleMouseDrag(this);
        }

        @Override
        public String toString() {
            return super.toString() + " Dest=" + this.x1 + "," + this.y1 + this.buttonToString() + this.modifiersToString();
        }
    }

    public static final class MouseMove
    extends Mouse {
        public MouseMove() {
            super(17);
        }

        public MouseMove(int posX, int posY) {
            super(17, posX, posY);
        }

        @Override
        public void dispatch() {
            this.handler.handleMouseMove(this);
        }
    }

    public static final class MouseUp
    extends Mouse {
        public MouseUp() {
            super(19);
        }

        public MouseUp(int whichBtn, boolean shift, boolean alt, boolean control, boolean meta, int posX, int posY) {
            super(19, posX, posY, whichBtn, shift, alt, control, meta);
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.buttonNumber = 0;
            this.metaDown = false;
            this.controlDown = false;
            this.altDown = false;
            this.shiftDown = false;
            this.y = 0;
            this.x = 0;
            byte info = strm.readByte();
            this.parseButton(info);
            this.parseModifiers(info);
            super.parse(strm);
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            byte info = this.encodeButton();
            info = (byte)(info | this.encodeModifiers());
            strm.writeByte(info);
            super.encode(strm);
        }

        @Override
        public void dispatch() {
            this.handler.handleMouseUp(this);
        }

        @Override
        public String toString() {
            return super.toString() + this.buttonToString() + this.modifiersToString();
        }
    }

    public static final class Multiple
    extends AppShareMessage {
        private ArrayList messages = new ArrayList();

        public Multiple() {
            super(1, false, "");
        }

        public int getCount() {
            return this.messages.size();
        }

        public AppShareMessage getMessage(int ix) {
            return (AppShareMessage)this.messages.get(ix);
        }

        public void addMessage(AppShareMessage msg) {
            this.messages.add(msg);
        }

        @Override
        protected void setSender(short whom) {
            super.setSender(whom);
            for (AppShareMessage msg : this.messages) {
                msg.setSender(whom);
            }
        }

        @Override
        public void setHandler(AppShareMessageHandler mh) {
            super.setHandler(mh);
            for (AppShareMessage msg : this.messages) {
                msg.setHandler(mh);
            }
        }

        @Override
        public int getWindowLength() {
            int result = super.getWindowLength();
            for (AppShareMessage msg : this.messages) {
                result += msg.getWindowLength() + 2;
            }
            return result;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.messages = new ArrayList();
            while (strm.available() > 0) {
                byte cmdCode = strm.readByte();
                int dataLen = strm.readUnsignedByte();
                byte[] data = new byte[dataLen];
                strm.readFully(data);
                DataInputStream dataStrm = new DataInputStream(new ByteArrayInputStream(data));
                AppShareMessage msg = AppShareMessage.construct(cmdCode, dataStrm, this.handler);
                if (msg == null) continue;
                this.messages.add(msg);
            }
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            Iterator it = this.messages.iterator();
            int count = 0;
            while (it.hasNext()) {
                AppShareMessage msg = (AppShareMessage)it.next();
                strm.writeByte(msg.getCommand());
                ByteArrayOutputStream substrm = new ByteArrayOutputStream(128);
                msg.encode(new DataOutputStream(substrm));
                if (substrm.size() > 255) {
                    throw new RuntimeException("MultiMessage component length overflow on element " + count + " (length = " + substrm.size() + "):\n" + msg.toString());
                }
                strm.writeByte(substrm.size());
                substrm.writeTo(strm);
                ++count;
            }
        }

        @Override
        public void dispatch() {
            for (AppShareMessage msg : this.messages) {
                msg.dispatch();
            }
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer(this.messages.size() * 32);
            Iterator it = this.messages.iterator();
            int count = 0;
            result.append(super.toString());
            result.append(" [");
            while (it.hasNext()) {
                AppShareMessage msg = (AppShareMessage)it.next();
                if (count > 0) {
                    result.append(", ");
                }
                result.append("{" + msg.toString() + "}");
                ++count;
            }
            result.append("]");
            return result.toString();
        }
    }

    public static final class Refresh
    extends AppShareMessage {
        public Refresh() {
            super(33, false, "");
        }

        @Override
        public void dispatch() {
            this.handler.handleRefresh(this);
        }
    }

    public static final class Release
    extends AppShareMessage {
        public Release() {
            super(15, true, "release");
        }

        @Override
        public void dispatch() {
            this.handler.handleRelease(this);
        }
    }

    public static final class RemoteReply
    extends AppShareMessage {
        int reqCode = 0;
        int respCode = 0;
        I18nMessage msg = null;
        ArrayList info = null;

        public RemoteReply() {
            super(30, false, "");
        }

        public RemoteReply(int request, int response, I18nMessage message) {
            this();
            if (request < 0 || request > 255) {
                throw new IllegalArgumentException("Request code outside range 0 .. 255: " + request);
            }
            if (response < 0 || response > 255) {
                throw new IllegalArgumentException("Response code outside range 0 .. 255: " + response);
            }
            this.reqCode = (byte)request;
            this.respCode = (byte)response;
            this.msg = message;
            if (this.msg == null) {
                this.msg = new I18nMessage(null, "");
            }
        }

        public void addInfo(int code, byte[] data) {
            if (code < 0 || code > 255) {
                throw new IllegalArgumentException("Data code outside range 0 .. 255: " + code);
            }
            if (data == null) {
                throw new IllegalArgumentException("Data value for " + code + " is null");
            }
            if (data.length > 65535) {
                throw new IllegalArgumentException("Data value for " + code + " exceeds max length (65535): " + data.length);
            }
            if (this.info == null) {
                this.info = new ArrayList();
            }
            this.info.add(new InfoRec(code, data));
        }

        public void addInfo(int code, byte datum) {
            if (code < 0 || code > 255) {
                throw new IllegalArgumentException("Data code outside range 0 .. 255: " + code);
            }
            if (this.info == null) {
                this.info = new ArrayList();
            }
            this.info.add(new InfoRec(code, datum));
        }

        public int getRequest() {
            return this.reqCode;
        }

        public int getResponse() {
            return this.respCode;
        }

        public String getMessage() {
            return this.msg.toString();
        }

        public boolean hasInfo() {
            return this.info != null && this.info.size() > 0;
        }

        public boolean hasInfo(int key) {
            return this.getInfo(key) != null;
        }

        public byte[] getInfo(int key) {
            if (this.info == null) {
                return null;
            }
            for (InfoRec cur : this.info) {
                if (cur.code != key) continue;
                return cur.value;
            }
            return null;
        }

        public int getInfoInt(int key, int dft) {
            byte[] data = this.getInfo(key);
            if (data == null) {
                return dft;
            }
            int nBytes = data.length;
            if (nBytes > 4) {
                nBytes = 4;
            }
            int result = 0;
            for (int ix = 0; ix < nBytes; ++ix) {
                result = result << 8 | data[ix] & 0xFF;
            }
            return result;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.respCode = 0;
            this.reqCode = 0;
            this.msg = null;
            this.info = null;
            this.reqCode = strm.readUnsignedByte();
            this.respCode = strm.readUnsignedByte();
            this.msg = I18nMessage.read((DataInputStream)strm);
            while (strm.available() > 0) {
                int code = strm.readUnsignedByte();
                int len = strm.readUnsignedShort();
                byte[] value = new byte[len];
                strm.readFully(value);
                if (this.info == null) {
                    this.info = new ArrayList();
                }
                this.info.add(new InfoRec(code, value));
            }
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            if (this.msg == null) {
                this.msg = new I18nMessage(null, "");
            }
            strm.writeByte(this.reqCode);
            strm.writeByte(this.respCode);
            this.msg.write(strm);
            if (this.info != null) {
                for (InfoRec cur : this.info) {
                    strm.writeByte(cur.code);
                    strm.writeShort(cur.value.length);
                    strm.write(cur.value);
                }
            }
        }

        @Override
        public void dispatch() {
            this.handler.handleRemoteReply(this);
        }

        @Override
        public String toString() {
            return super.toString() + " req=" + this.reqCode + " resp=" + this.respCode + ",msg=" + this.msg;
        }

        private static final class InfoRec {
            int code = 0;
            byte[] value = null;

            InfoRec(int aCode, byte[] aValue) {
                this.code = aCode;
                this.value = aValue;
            }

            InfoRec(int aCode, byte aValue) {
                this.code = aCode;
                this.value = new byte[1];
                this.value[0] = aValue;
            }
        }
    }

    public static final class RemoteStart
    extends AppShareMessage {
        private int startMode = 0;
        private int flags = 0;
        private byte[] password = null;
        private Rectangle region = new Rectangle();
        private ArrayList appList = new ArrayList(16);

        public RemoteStart() {
            super(29, true, "remotestart");
        }

        public RemoteStart(int aMode, int aFlags) {
            this();
            if (aMode != 1 && aMode != 2 && aMode != 3 && aMode != 4 && aMode != 5) {
                throw new IllegalArgumentException("Invalid mode: " + aMode);
            }
            this.startMode = aMode;
            this.flags = aFlags;
        }

        public RemoteStart(int aMode, int aFlags, byte[] aPassword) {
            this(aMode, aFlags | 0x8000);
            if (aPassword == null) {
                throw new IllegalArgumentException("Password is null");
            }
            if (aPassword.length > 255) {
                throw new IllegalArgumentException("Invalid password length, max is 255: " + this.password.length);
            }
            this.password = aPassword;
        }

        public int getStartMode() {
            return this.startMode;
        }

        public int getFlags() {
            return this.flags;
        }

        public boolean checkFlag(int mask) {
            return (this.flags & mask) != 0;
        }

        public boolean checkAllFlags(int mask) {
            return (this.flags & mask) == mask;
        }

        public byte[] getPassword() {
            return this.password;
        }

        public void setPassword(byte[] aPassword) {
            if (aPassword == null) {
                throw new IllegalArgumentException("Password is null");
            }
            if (aPassword.length > 255) {
                throw new IllegalArgumentException("Invalid password length, max is 255: " + this.password.length);
            }
            this.flags |= 0x8000;
            this.password = aPassword;
        }

        public Rectangle getRegion() {
            if (this.region.isEmpty()) {
                return null;
            }
            return this.region;
        }

        public String[] getApps() {
            if (this.appList.size() < 1) {
                return null;
            }
            return this.appList.toArray(new String[this.appList.size()]);
        }

        public void setRegion(Rectangle r) {
            this.region.setBounds(r);
        }

        public void addApp(String appName) {
            this.appList.add(appName);
        }

        public String getModeName() {
            int ix = this.startMode - 1;
            if (ix < 0 || ix >= AppShareProtocol.REMOTE_START_MODES.length) {
                return "UNKNOWN";
            }
            return AppShareProtocol.REMOTE_START_MODES[ix];
        }

        public String getFlagNames() {
            StringBuffer result = new StringBuffer(64);
            if (this.checkFlag(1)) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append("fitToArea");
            }
            if (this.checkFlag(2)) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append("hideMenuBar");
            }
            return result.toString();
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            int len;
            this.startMode = 0;
            this.flags = 0;
            this.password = null;
            this.region.setBounds(0, 0, 0, 0);
            this.appList.clear();
            this.startMode = strm.readUnsignedByte();
            if (this.startMode == 5) {
                return;
            }
            this.flags = strm.readShort();
            if (this.checkFlag(32768) && (len = strm.readUnsignedByte()) > 0) {
                this.password = new byte[len];
                strm.readFully(this.password);
            }
            if (this.startMode == 4) {
                return;
            }
            if (this.startMode == 1) {
                return;
            }
            int x = strm.readUnsignedShort();
            int y = strm.readUnsignedShort();
            int w = strm.readUnsignedShort();
            int h = strm.readUnsignedShort();
            this.region.setBounds(x, y, w, h);
            if (this.startMode == 2) {
                return;
            }
            while (strm.available() > 0) {
                this.appList.add(strm.readUTF());
            }
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeByte(this.startMode);
            if (this.startMode == 5) {
                return;
            }
            strm.writeShort(this.flags);
            if (this.checkFlag(32768)) {
                if (this.password != null) {
                    strm.writeByte(this.password.length);
                    strm.write(this.password);
                } else {
                    strm.writeByte(0);
                }
            }
            if (this.startMode == 4) {
                return;
            }
            if (this.startMode == 1) {
                return;
            }
            strm.writeShort(this.region.x);
            strm.writeShort(this.region.y);
            strm.writeShort(this.region.width);
            strm.writeShort(this.region.height);
            if (this.startMode == 2) {
                return;
            }
            for (int ix = 0; ix < this.appList.size(); ++ix) {
                if (this.appList.get(ix) == null) continue;
                strm.writeUTF("" + this.appList.get(ix));
            }
        }

        @Override
        public void dispatch() {
            this.handler.handleRemoteStart(this);
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer(80);
            result.append(this.getClass().getName() + ",mode=" + this.getModeName() + ",flags={" + this.getFlagNames() + "}");
            if (this.password != null) {
                result.append(",pw=" + AppShareMessage.encodeHexBytes(this.password));
            }
            if (this.region != null && !this.region.isEmpty()) {
                result.append(",region=" + this.region.toString());
                if (this.appList.size() > 0) {
                    result.append(",apps=[");
                    for (int ix = 0; ix < this.appList.size(); ++ix) {
                        if (ix > 0) {
                            result.append(",");
                        }
                        result.append(this.appList.get(ix));
                    }
                }
            }
            return result.toString();
        }
    }

    public static final class ResolutionChange
    extends AppShareMessage {
        private short width = 0;
        private short height = 0;
        private short dx;
        private short dy = Short.MIN_VALUE;
        private boolean purge = false;

        public ResolutionChange() {
            super(34, false, "");
            this.dx = Short.MIN_VALUE;
        }

        public ResolutionChange(int w, int h) {
            this();
            if (w < 0 || w > 4095) {
                throw new IllegalArgumentException("Display width outside range 0..4095: " + w);
            }
            if (h < 0 || h > 4095) {
                throw new IllegalArgumentException("Display height outside range 0..4095: " + h);
            }
            this.width = (short)w;
            this.height = (short)h;
        }

        public ResolutionChange(int w, int h, int dx, int dy, boolean purge) {
            this(w, h);
            if (dx < -255 || dx > 255) {
                throw new IllegalArgumentException("Display shift X outside range -255..255: " + dx);
            }
            if (dy < -255 || dy > 255) {
                throw new IllegalArgumentException("Display shift Y outside range -255..255: " + dy);
            }
            this.dx = (short)dx;
            this.dy = (short)dy;
            this.purge = purge;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.dy = 0;
            this.dx = 0;
            this.height = 0;
            this.width = 0;
            this.purge = false;
            short[] dims = new short[2];
            ResolutionChange.parseUInt12Pair(strm, dims);
            this.width = dims[0];
            this.height = dims[1];
            if (strm.available() > 0) {
                this.dx = strm.readShort();
                this.dy = strm.readShort();
                this.purge = strm.readBoolean();
            }
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            ResolutionChange.encodeUInt12Pair(strm, this.width, this.height);
            if (this.dx > Short.MIN_VALUE && this.dy > Short.MIN_VALUE) {
                strm.writeShort(this.dx);
                strm.writeShort(this.dy);
                strm.writeBoolean(this.purge);
            }
        }

        @Override
        public void dispatch() {
            this.handler.handleResolutionChange(this);
        }

        @Override
        public String toString() {
            return super.toString() + " screen=" + this.width + "x" + this.height;
        }
    }

    public static final class Revoke
    extends AppShareMessage {
        public Revoke() {
            super(16, true, "revoke");
        }

        @Override
        public void dispatch() {
            this.handler.handleRevoke(this);
        }
    }

    public static final class ScreenData
    extends AppShareMessage {
        private byte[] tileData = null;

        public ScreenData() {
            super(11, false, "");
        }

        public ScreenData(byte[] data) {
            super(11, false, "");
            this.setTileData(data);
        }

        public ScreenData(byte[] data, int pos, int len) {
            super(11, false, "");
            this.setTileData(data, pos, len);
        }

        public byte[] getTileData() {
            return this.tileData;
        }

        @Override
        public int getWindowLength() {
            return this.tileData == null ? 0 : this.tileData.length;
        }

        public void setTileData(byte[] data) {
            this.setTileData(data, 0, data.length);
        }

        public void setTileData(byte[] data, int pos, int len) {
            this.tileData = new byte[len];
            System.arraycopy(data, pos, this.tileData, 0, len);
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.tileData = null;
            this.tileData = new byte[strm.available()];
            strm.readFully(this.tileData);
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            if (this.tileData == null) {
                return;
            }
            strm.write(this.tileData, 0, this.tileData.length);
        }

        @Override
        public void dispatch() {
            this.handler.handleScreenData(this);
        }

        @Override
        public String toString() {
            return this.getAsString(AppShareDebug.VERBOSE.show());
        }

        public String getAsString(boolean verbose) {
            StringBuffer result = new StringBuffer(48 + (this.tileData == null ? 0 : this.tileData.length * 3));
            result.append(super.toString());
            if (verbose && this.tileData != null) {
                result.append(" TileData=" + AppShareMessage.encodeHexBytes(this.tileData));
            } else if (this.tileData != null) {
                result.append(" TileData=" + this.tileData.length + "bytes");
            } else {
                result.append(" TileData=NULL");
            }
            return result.toString();
        }
    }

    public static final class ScreenDataAck
    extends AppShareMessage {
        private int bytesReceived = 0;

        public ScreenDataAck() {
            super(12, false, "");
        }

        public ScreenDataAck(int nBytes) {
            super(12, false, "");
            if (nBytes < 0 || nBytes > 65535) {
                throw new IllegalArgumentException("ACK bytes outside range 0..65535: " + nBytes);
            }
            this.bytesReceived = nBytes;
        }

        public int getBytes() {
            return this.bytesReceived;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.bytesReceived = 0;
            this.bytesReceived = strm.readUnsignedShort();
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeShort(this.bytesReceived);
        }

        @Override
        public void dispatch() {
            this.handler.handleScreenDataAck(this);
        }

        @Override
        public String toString() {
            return super.toString() + " Bytes=" + this.bytesReceived;
        }
    }

    public static final class ScrollWheel
    extends AppShareMessage {
        short distance;

        public ScrollWheel() {
            this(0);
        }

        public ScrollWheel(int dist) {
            super(32, false, "");
            if (dist < Short.MIN_VALUE || dist > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Scroll distance outside range -32768..32767: " + dist);
            }
            this.distance = (short)dist;
        }

        public int getDistance() {
            return this.distance;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.distance = 0;
            this.distance = strm.readShort();
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeShort(this.distance);
        }

        @Override
        public void dispatch() {
            this.handler.handleScrollWheel(this);
        }

        @Override
        public String toString() {
            return super.toString() + " distance=" + this.distance;
        }
    }

    public static final class Start
    extends AppShareMessage {
        private byte format = 0;
        private int hostType = 0;
        private int cacheSize = 0;
        private int windowSize = 0;
        private short width = 0;
        private short height = 0;
        private short baseColour = 0;
        private ArrayList aoiList = new ArrayList();
        private boolean fitToAOI = false;
        private I18nMessage detail = null;

        public Start() {
            super(2, true, "start");
        }

        public Start(int fmt, int type, int cacheSz, int xmitWindowSz, int w, int h, short colour, I18nMessage description) {
            super(2, true, "start");
            if (fmt < 0 || fmt > 255) {
                throw new IllegalArgumentException("Format outside range 0..255: " + fmt);
            }
            if (cacheSz < 0 || cacheSz > 65535) {
                throw new IllegalArgumentException("Cache size outside range 0..65535: " + cacheSz);
            }
            if (xmitWindowSz < 0 || xmitWindowSz > 65535) {
                throw new IllegalArgumentException("Window size outside range 0..65535: " + xmitWindowSz);
            }
            if (w < 0 || w > 4095) {
                throw new IllegalArgumentException("Width outside range 0..4095: " + w);
            }
            if (h < 0 || h > 4095) {
                throw new IllegalArgumentException("Height outside range 0..4095: " + h);
            }
            this.format = (byte)fmt;
            this.hostType = type;
            this.cacheSize = cacheSz;
            this.windowSize = xmitWindowSz;
            this.width = (short)w;
            this.height = (short)h;
            this.baseColour = (short)(colour & Short.MAX_VALUE);
            this.fitToAOI = true;
            this.detail = description;
        }

        public byte getFormat() {
            return this.format;
        }

        public int getType() {
            return this.hostType;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public short getWidth() {
            return this.width;
        }

        public short getHeight() {
            return this.height;
        }

        public short getBaseColour() {
            return this.baseColour;
        }

        public I18nMessage getDetail() {
            return this.detail;
        }

        public int getNumAOI() {
            return this.aoiList.size();
        }

        public AoiInfo getAOI(int ix) {
            return (AoiInfo)this.aoiList.get(ix);
        }

        public Iterator getAOIIterator() {
            return this.aoiList.iterator();
        }

        public void addAOI(int id, int x, int y, int w, int h) {
            if (id < 0 || id > 255) {
                throw new IllegalArgumentException("AOI ID outside range 0..255: " + id);
            }
            if (x < 0 || x > 4095) {
                throw new IllegalArgumentException("AOI X coordinate outside range 0..4095: " + x);
            }
            if (y < 0 || y > 4095) {
                throw new IllegalArgumentException("AOI Y coordinate outside range 0..4095: " + y);
            }
            if (w < 0 || w > 4095) {
                throw new IllegalArgumentException("AOI width outside range 0..4095: " + w);
            }
            if (h < 0 || h > 4095) {
                throw new IllegalArgumentException("AOI height outside range 0..4095: " + h);
            }
            Iterator it = this.aoiList.iterator();
            while (it.hasNext()) {
                if ((byte)id != ((AoiInfo)it.next()).id) continue;
                throw new IllegalArgumentException("AOI id already in list: " + id);
            }
            AoiInfo aoi = new AoiInfo((byte)id);
            aoi.x = (short)x;
            aoi.y = (short)y;
            aoi.w = (short)w;
            aoi.h = (short)h;
            this.aoiList.add(aoi);
        }

        public void addAOI(Collection list) {
            for (AoiInfo ai : list) {
                Iterator lsi = this.aoiList.iterator();
                while (lsi.hasNext()) {
                    if (ai.id != ((AoiInfo)lsi.next()).id) continue;
                    throw new IllegalArgumentException("AOI id already in list: " + ai.id);
                }
                this.aoiList.add(ai);
            }
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            byte id;
            this.format = 0;
            this.hostType = 0;
            this.cacheSize = 0;
            this.windowSize = 0;
            this.height = 0;
            this.width = 0;
            this.baseColour = 0;
            this.aoiList = new ArrayList();
            this.format = strm.readByte();
            this.hostType = strm.readByte();
            this.cacheSize = strm.readUnsignedShort();
            this.windowSize = strm.readUnsignedShort();
            short[] pair = new short[2];
            AppShareMessage.parseUInt12Pair(strm, pair);
            this.width = pair[0];
            this.height = pair[1];
            this.baseColour = (short)(strm.readShort() & Short.MAX_VALUE);
            while (strm.available() > 0 && (id = strm.readByte()) >= 0) {
                AoiInfo aoi = new AoiInfo(id);
                AppShareMessage.parseUInt12Pair(strm, pair);
                aoi.x = pair[0];
                aoi.y = pair[1];
                AppShareMessage.parseUInt12Pair(strm, pair);
                aoi.w = pair[0];
                aoi.h = pair[1];
                this.aoiList.add(aoi);
            }
            if (strm.available() > 0) {
                this.fitToAOI = strm.readBoolean();
            }
            if (strm.available() > 0) {
                this.detail = I18nMessage.read((DataInputStream)strm);
            }
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            Iterator it = this.aoiList.iterator();
            strm.writeByte(this.format);
            strm.writeByte(this.hostType);
            strm.writeShort((short)(this.cacheSize & 0xFFFF));
            strm.writeShort((short)(this.windowSize & 0xFFFF));
            AppShareMessage.encodeUInt12Pair(strm, this.width, this.height);
            strm.writeShort(this.baseColour);
            while (it.hasNext()) {
                AoiInfo aoi = (AoiInfo)it.next();
                strm.writeByte(aoi.id);
                AppShareMessage.encodeUInt12Pair(strm, aoi.x, aoi.y);
                AppShareMessage.encodeUInt12Pair(strm, aoi.w, aoi.h);
            }
            strm.writeByte(-1);
            strm.writeBoolean(this.fitToAOI);
            if (this.detail != null) {
                this.detail.write(strm);
            }
        }

        @Override
        public void dispatch() {
            this.handler.handleStart(this);
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer(this.aoiList.size() * 32);
            result.append(super.toString() + ":");
            result.append(" Fmt=" + this.format + " Type=" + this.hostType);
            result.append(" CacheSize=" + this.cacheSize + " Window=" + this.windowSize);
            result.append(" Dim=" + this.width + "x" + this.height);
            result.append(" Colour=" + (this.baseColour >> 10) + "," + (this.baseColour >> 5 & 0x1F) + "," + (this.baseColour & 0x1F));
            result.append(" fitToAOI=" + this.fitToAOI);
            result.append(" AOI=" + this.aoiList.toString());
            result.append(" detail=" + this.detail);
            return result.toString();
        }
    }

    public static final class StartAck
    extends AppShareMessage {
        private boolean granted = false;
        private int cacheSize = 0;
        private int windowSize = 0;
        private String reason = null;

        public StartAck() {
            super(3, false, "");
        }

        public StartAck(int cacheSz, int xmitSz) {
            super(3, false, "");
            if (cacheSz < 0 || cacheSz > 65535) {
                throw new IllegalArgumentException("Cache size outside range 0..65535: " + cacheSz);
            }
            this.granted = true;
            this.cacheSize = cacheSz;
            this.windowSize = xmitSz;
        }

        public StartAck(String failureReason) {
            super(3, false, "");
            this.granted = false;
            this.reason = failureReason;
        }

        public boolean isGranted() {
            return this.granted;
        }

        public int getCacheSize() {
            return this.cacheSize;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public boolean hasReason() {
            return this.reason != null && this.reason.length() > 0;
        }

        public String getReason() {
            if (this.hasReason()) {
                return this.reason;
            }
            return "";
        }

        public void setReason(String newReason) {
            this.reason = newReason;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.granted = false;
            this.cacheSize = 0;
            this.windowSize = 0;
            this.reason = null;
            this.granted = strm.readBoolean();
            this.cacheSize = strm.readUnsignedShort();
            this.windowSize = strm.readUnsignedShort();
            if (strm.available() > 0) {
                this.reason = strm.readUTF();
            }
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeBoolean(this.granted);
            strm.writeShort((short)(this.cacheSize & 0xFFFF));
            strm.writeShort((short)(this.windowSize & 0xFFFF));
            if (this.hasReason()) {
                strm.writeUTF(this.reason);
            }
        }

        @Override
        public void dispatch() {
            this.handler.handleStartAck(this);
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer(32);
            result.append(super.toString() + " Granted=" + this.granted);
            result.append(" Cache=" + this.cacheSize + " Window=" + this.windowSize);
            if (this.hasReason()) {
                result.append(" Reason=\"" + this.reason + "\"");
            }
            return result.toString();
        }
    }

    public static final class Status
    extends AppShareMessage {
        public static final int MAX_CLIENT_COUNT = 65535;
        private byte[] codes = null;
        private byte[] values = null;
        private ByteArrayOutputStream outByteStream = null;
        private DataOutputStream outDataStream = null;

        public Status() {
            super(24, false, "");
        }

        public Status(Map valueMap) {
            super(24, false, "");
            for (Number key : valueMap.keySet()) {
                Object val = valueMap.get(key);
                if (val instanceof Number) {
                    this.addValue(key.intValue(), (Number)val);
                    continue;
                }
                if (val instanceof Boolean) {
                    this.addValue(key.intValue(), (Boolean)val);
                    continue;
                }
                if (val instanceof Map) {
                    this.addValue(key.intValue(), (Map)val);
                    continue;
                }
                this.addValue(key.intValue(), val.toString());
            }
        }

        public int getNumValues() {
            if (this.codes == null) {
                return 0;
            }
            return this.codes.length;
        }

        public ValueIterator getValues() {
            return new ValueIterator();
        }

        public void addValue(int aCode, Number aValue) {
            if (!AppShareProtocol.isValidStatus(aCode)) {
                throw new IllegalArgumentException("Invalid status variable code: " + aCode);
            }
            if (AppShareProtocol.isPluralStatus(aCode)) {
                throw new IllegalArgumentException("Attempt to set singular value for plural datum: " + aCode);
            }
            int dataType = AppShareProtocol.getStatusType(aCode);
            this.codes = Status.extend(this.codes, 1);
            this.codes[this.codes.length - 1] = (byte)(aCode & 0xFF);
            this.writeValue(dataType, aValue);
        }

        public void addValue(int aCode, String aValue) {
            if (!AppShareProtocol.isValidStatus(aCode)) {
                throw new IllegalArgumentException("Invalid status variable code: " + aCode);
            }
            if (AppShareProtocol.isPluralStatus(aCode)) {
                throw new IllegalArgumentException("Attempt to set singular value for plural datum: " + aCode);
            }
            int dataType = AppShareProtocol.getStatusType(aCode);
            if (dataType != 8) {
                throw new IllegalArgumentException("Invalid STATUS type for string value: " + aCode);
            }
            this.codes = Status.extend(this.codes, 1);
            this.codes[this.codes.length - 1] = (byte)(aCode & 0xFF);
            this.writeValue(aValue);
        }

        public void addValue(int aCode, Boolean aValue) {
            this.addValue(aCode, (boolean)aValue);
        }

        public void addValue(int aCode, boolean aValue) {
            if (!AppShareProtocol.isValidStatus(aCode)) {
                throw new IllegalArgumentException("Invalid status variable code: " + aCode);
            }
            if (AppShareProtocol.isPluralStatus(aCode)) {
                throw new IllegalArgumentException("Attempt to set singular value for plural datum: " + aCode);
            }
            int dataType = AppShareProtocol.getStatusType(aCode);
            this.codes = Status.extend(this.codes, 1);
            this.codes[this.codes.length - 1] = (byte)(aCode & 0xFF);
            this.writeValue(dataType, aValue);
        }

        public void addValue(int aCode, Map aValueSet) {
            if (!AppShareProtocol.isValidStatus(aCode)) {
                throw new IllegalArgumentException("Invalid status variable code: " + aCode);
            }
            if (!AppShareProtocol.isPluralStatus(aCode)) {
                throw new IllegalArgumentException("Attempt to set plural value for singular datum: " + aCode);
            }
            if (aValueSet.size() > 65535) {
                throw new IllegalArgumentException("Plural value set too large: " + aValueSet.size() + " items for code " + aCode + " (max is " + 65535 + ")");
            }
            int dataType = AppShareProtocol.getStatusType(aCode);
            this.codes = Status.extend(this.codes, 1);
            this.codes[this.codes.length - 1] = (byte)(aCode & 0xFF);
            try {
                this.getOutStream().writeShort((short)(aValueSet.size() & 0xFFFF));
            }
            catch (IOException ex) {
                LogSupport.exception((Object)this, (String)"addValue", (Throwable)ex, (boolean)true);
                return;
            }
            for (Number key : aValueSet.keySet()) {
                Object val = aValueSet.get(key);
                this.writeValue(3, key);
                this.writeValue(dataType, val);
            }
        }

        public void addValue(int aCode, byte aValue) {
            this.addValue(aCode, AppShareMessage.makeByte(aValue));
        }

        public void addValue(int aCode, short aValue) {
            this.addValue(aCode, ShortList.get((short)aValue));
        }

        public void addValue(int aCode, int aValue) {
            this.addValue(aCode, new Integer(aValue));
        }

        public void addValue(int aCode, long aValue) {
            this.addValue(aCode, new Long(aValue));
        }

        public void addValue(int aCode, float aValue) {
            this.addValue(aCode, new Float(aValue));
        }

        public void addValue(int aCode, double aValue) {
            this.addValue(aCode, new Double(aValue));
        }

        private void writeValue(int dataType, Object aValue) {
            if (aValue instanceof Boolean) {
                this.writeValue(dataType, (Boolean)aValue);
            } else if (aValue instanceof Number) {
                this.writeValue(dataType, (Number)aValue);
            } else if (aValue instanceof String) {
                this.writeValue(dataType, (String)aValue);
            } else {
                throw new IllegalArgumentException("Invalid data type for STATUS value: " + aValue.toString() + " (" + aValue.getClass().getName() + ")");
            }
        }

        private void writeValue(int dataType, boolean aValue) {
            try {
                switch (dataType) {
                    case 1: {
                        this.getOutStream().writeBoolean(aValue);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        this.writeValue(dataType, new Integer(aValue ? 1 : 0));
                        break;
                    }
                    case 8: {
                        this.writeValue(dataType, (aValue ? Boolean.TRUE : Boolean.FALSE).toString());
                        break;
                    }
                }
            }
            catch (IOException ex) {
                LogSupport.exception((Object)this, (String)"writeValue(int,boolean)", (Throwable)ex, (boolean)true);
            }
        }

        private void writeValue(int dataType, Number aValue) {
            try {
                switch (dataType) {
                    case 1: {
                        this.getOutStream().writeBoolean(aValue.longValue() != 0L);
                        break;
                    }
                    case 2: {
                        this.getOutStream().writeByte(aValue.byteValue());
                        break;
                    }
                    case 3: {
                        this.getOutStream().writeShort(aValue.shortValue());
                        break;
                    }
                    case 4: {
                        this.getOutStream().writeInt(aValue.intValue());
                        break;
                    }
                    case 5: {
                        this.getOutStream().writeLong(aValue.longValue());
                        break;
                    }
                    case 6: {
                        this.getOutStream().writeFloat(aValue.floatValue());
                        break;
                    }
                    case 7: {
                        this.getOutStream().writeDouble(aValue.doubleValue());
                        break;
                    }
                    case 8: {
                        this.writeValue(aValue.toString());
                        break;
                    }
                }
            }
            catch (IOException ex) {
                LogSupport.exception((Object)this, (String)"writeValue(int,Number)", (Throwable)ex, (boolean)true);
            }
        }

        private void writeValue(String aValue) {
            try {
                this.getOutStream().writeUTF(aValue);
            }
            catch (IOException ex) {
                LogSupport.exception((Object)this, (String)"writeValue(String)", (Throwable)ex, (boolean)true);
            }
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.codes = null;
            this.values = null;
            this.outByteStream = null;
            this.outDataStream = null;
            int nCodes = strm.readUnsignedByte();
            if (nCodes > 0) {
                this.codes = new byte[nCodes];
                strm.readFully(this.codes);
                this.values = new byte[strm.available()];
                strm.readFully(this.values);
            }
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            this.freezeBytes();
            if (this.codes == null || this.values == null) {
                strm.writeByte(0);
                return;
            }
            strm.writeByte(this.codes.length);
            strm.write(this.codes, 0, this.codes.length);
            strm.write(this.values, 0, this.values.length);
        }

        @Override
        public int getWindowLength() {
            this.freezeBytes();
            return 1 + (this.codes != null ? this.codes.length : 0) + (this.values != null ? this.values.length : 0);
        }

        @Override
        public void dispatch() {
            this.handler.handleStatus(this);
        }

        @Override
        public String toString() {
            StringBuffer result = new StringBuffer(64);
            result.append(super.toString());
            if (this.codes == null || !AppShareDebug.VERBOSE.show()) {
                return result.toString();
            }
            int prevCode = -1;
            Element elem = new Element();
            ValueIterator vit = this.getValues();
            while (vit.hasMoreValues()) {
                vit.getNext(elem);
                if (elem.code != prevCode) {
                    result.append(" " + AppShareProtocol.getStatusString(elem.code) + "=");
                    if (AppShareProtocol.isPluralStatus(elem.code)) {
                        result.append("{");
                    }
                    prevCode = elem.code;
                }
                result.append((elem.client == -32767 ? "" : "#" + elem.client) + "=" + elem.value);
            }
            if (AppShareProtocol.isPluralStatus(prevCode)) {
                result.append("}");
            }
            return result.toString();
        }

        private void freezeBytes() {
            if (this.outByteStream != null) {
                this.values = this.outByteStream.toByteArray();
            }
        }

        private DataOutputStream getOutStream() {
            if (this.outDataStream == null) {
                this.outByteStream = new ByteArrayOutputStream(256);
                this.outDataStream = new DataOutputStream(this.outByteStream);
            }
            return this.outDataStream;
        }

        private static byte[] extend(byte[] data, int byBytes) {
            byte[] newData = null;
            int nBytes = 0;
            if (data != null) {
                nBytes = data.length;
            }
            newData = new byte[nBytes + byBytes];
            if (nBytes > 0) {
                System.arraycopy(data, 0, newData, 0, nBytes);
            }
            return newData;
        }

        public static final class Element {
            public int code = 0;
            public int dataType = -1;
            public short client = (short)-32767;
            public Object value = null;
        }

        public final class ValueIterator {
            private int codeIndex = 0;
            private int nSubValues = -1;
            private int curSubValue = 0;
            private ByteArrayInputStream valByteStream = null;
            private DataInputStream valDataStream = null;

            public ValueIterator() {
                Status.this.freezeBytes();
                if (Status.this.values == null && Status.this.codes != null) {
                    throw new RuntimeException("No data values for Status.ValueIterator");
                }
                if (Status.this.values != null) {
                    this.valByteStream = new ByteArrayInputStream(Status.this.values);
                    this.valDataStream = new DataInputStream(this.valByteStream);
                }
            }

            public final boolean hasMoreValues() {
                return this.codeIndex < Status.this.getNumValues();
            }

            public final int codesAvailable() {
                return Status.this.getNumValues() - this.codeIndex;
            }

            public void getNext(Element elem) {
                if (!this.hasMoreValues()) {
                    throw new RuntimeException("No more STATUS data elements.");
                }
                elem.code = Status.this.codes[this.codeIndex];
                elem.dataType = AppShareProtocol.getStatusType(elem.code);
                if (!AppShareProtocol.isPluralStatus(elem.code)) {
                    elem.client = (short)-32767;
                    elem.value = this.readValue(elem.dataType);
                    ++this.codeIndex;
                } else {
                    if (this.nSubValues < 0) {
                        try {
                            this.nSubValues = this.valDataStream.readUnsignedShort();
                            this.curSubValue = 0;
                        }
                        catch (IOException ex) {
                            LogSupport.exception((Object)this, (String)"getNext", (Throwable)ex, (boolean)true);
                            throw new RuntimeException("Error processing STATUS message: " + ex);
                        }
                    }
                    if (this.curSubValue < this.nSubValues) {
                        try {
                            elem.client = this.valDataStream.readShort();
                            elem.value = this.readValue(elem.dataType);
                        }
                        catch (IOException ex) {
                            LogSupport.exception((Object)this, (String)"getNext", (Throwable)ex, (boolean)true);
                            throw new RuntimeException("Error processing STATUS message: " + ex);
                        }
                        ++this.curSubValue;
                    } else {
                        elem.client = (short)-32767;
                        elem.value = null;
                    }
                    if (this.curSubValue >= this.nSubValues) {
                        ++this.codeIndex;
                        this.curSubValue = 0;
                        this.nSubValues = -1;
                    }
                }
            }

            private Object readValue(int typeCode) {
                Object result = null;
                try {
                    switch (typeCode) {
                        case 1: {
                            result = this.valDataStream.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 2: {
                            result = AppShareMessage.makeByte(this.valDataStream.readByte());
                            break;
                        }
                        case 3: {
                            result = ShortList.get((short)this.valDataStream.readShort());
                            break;
                        }
                        case 4: {
                            result = new Integer(this.valDataStream.readInt());
                            break;
                        }
                        case 5: {
                            result = new Long(this.valDataStream.readLong());
                            break;
                        }
                        case 6: {
                            result = new Float(this.valDataStream.readFloat());
                            break;
                        }
                        case 7: {
                            result = new Double(this.valDataStream.readDouble());
                            break;
                        }
                        case 8: {
                            result = this.valDataStream.readUTF();
                            break;
                        }
                        default: {
                            result = null;
                            break;
                        }
                    }
                }
                catch (IOException ex) {
                    result = null;
                    LogSupport.exception((Object)this, (String)"readValue", (Throwable)ex, (boolean)true);
                }
                return result;
            }
        }
    }

    public static final class Stop
    extends AppShareMessage {
        public Stop() {
            super(4, true, "stop");
        }

        @Override
        public void dispatch() {
            this.handler.handleStop(this);
        }
    }

    public static final class Subscribe
    extends AppShareMessage {
        private ArrayList requests = new ArrayList();

        public Subscribe() {
            super(23, false, "");
        }

        public Subscribe(Collection aRequestList) {
            this();
            this.requests.addAll(aRequestList);
        }

        public int getNumCodes() {
            return this.requests.size();
        }

        public Collection getRequestList() {
            return this.requests;
        }

        public void addRequest(Request req) {
            this.requests.add(req);
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.requests = new ArrayList();
            while (strm.available() > 0) {
                Request req = new Request();
                req.parse(strm);
                this.requests.add(req);
            }
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            ListIterator it = this.requests.listIterator();
            while (it.hasNext()) {
                ((Request)it.next()).encode(strm);
            }
        }

        @Override
        public void dispatch() {
            this.handler.handleSubscribe(this);
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.requests.toString();
        }

        public static class Request {
            protected Byte code;
            protected ArrayList args;

            public Request() {
                this.code = AppShareMessage.makeByte((byte)-1);
                this.args = null;
            }

            public Request(int aVarCode) {
                if (aVarCode < 0 || aVarCode > 127) {
                    throw new RuntimeException("Subscription variable code outside range 0..127: " + aVarCode);
                }
                this.code = AppShareMessage.makeByte((byte)aVarCode);
                this.args = new ArrayList();
            }

            protected Request(int aVarCode, Collection argList) {
                if (aVarCode < 0 || aVarCode > 127) {
                    throw new RuntimeException("Subscription variable code outside range 0..127: " + aVarCode);
                }
                if (argList.size() > 127) {
                    throw new RuntimeException("Too many subscription args: " + aVarCode);
                }
                this.code = AppShareMessage.makeByte((byte)aVarCode);
                this.args = new ArrayList(argList);
            }

            public int getCode() {
                return this.code.intValue();
            }

            public Number getCodeKey() {
                return this.code;
            }

            public Object getArg(int ix) {
                return this.args.get(ix);
            }

            public Collection getArgList() {
                return this.args;
            }

            public Iterator getArgIterator() {
                return this.args.iterator();
            }

            protected void addArg(Object anArg) {
                if (this.args.size() >= 255) {
                    throw new RuntimeException("Too many subscription args: " + this.code + " (adding " + anArg + ")");
                }
                this.args.add(anArg);
            }

            public String toString() {
                return AppShareProtocol.getStatusString(this.code.intValue()) + "(" + this.args + ")";
            }

            public final void parse(DataInputStream strm) throws IOException {
                this.code = AppShareMessage.makeByte(strm.readByte());
                this.args = new ArrayList();
                int numArgs = strm.readUnsignedByte();
                block10: for (int argi = 0; argi < numArgs; ++argi) {
                    byte typeCode = strm.readByte();
                    switch (typeCode) {
                        case 1: {
                            this.args.add(strm.readBoolean() ? Boolean.TRUE : Boolean.FALSE);
                            continue block10;
                        }
                        case 2: {
                            this.args.add(AppShareMessage.makeByte(strm.readByte()));
                            continue block10;
                        }
                        case 3: {
                            this.args.add(ShortList.get((short)strm.readShort()));
                            continue block10;
                        }
                        case 4: {
                            this.args.add(new Integer(strm.readInt()));
                            continue block10;
                        }
                        case 5: {
                            this.args.add(new Long(strm.readLong()));
                            continue block10;
                        }
                        case 6: {
                            this.args.add(new Float(strm.readFloat()));
                            continue block10;
                        }
                        case 7: {
                            this.args.add(new Double(strm.readDouble()));
                            continue block10;
                        }
                        case 8: {
                            this.args.add(strm.readUTF());
                        }
                    }
                }
            }

            public final void encode(DataOutputStream strm) throws IOException {
                if (this.args.size() > 255) {
                    throw new RuntimeException("Too many subscription args: " + this.code);
                }
                strm.writeByte(this.code.intValue());
                strm.writeByte((byte)this.args.size());
                for (Object obj : this.args) {
                    if (obj instanceof Boolean) {
                        strm.writeByte(1);
                        strm.writeBoolean((Boolean)obj);
                        continue;
                    }
                    if (obj instanceof Byte) {
                        strm.writeByte(2);
                        strm.writeByte(((Byte)obj).byteValue());
                        continue;
                    }
                    if (obj instanceof Short) {
                        strm.writeByte(3);
                        strm.writeShort(((Short)obj).shortValue());
                        continue;
                    }
                    if (obj instanceof Integer) {
                        strm.writeByte(4);
                        strm.writeInt((Integer)obj);
                        continue;
                    }
                    if (obj instanceof Long) {
                        strm.writeByte(5);
                        strm.writeLong((Long)obj);
                        continue;
                    }
                    if (obj instanceof Float) {
                        strm.writeByte(6);
                        strm.writeFloat(((Float)obj).floatValue());
                        continue;
                    }
                    if (obj instanceof Double) {
                        strm.writeByte(7);
                        strm.writeDouble((Double)obj);
                        continue;
                    }
                    if (obj instanceof String) {
                        strm.writeByte(8);
                        strm.writeUTF(obj.toString());
                        continue;
                    }
                    throw new RuntimeException("Invalid subscription argument: type=" + obj.getClass().getName() + ",value=" + obj);
                }
            }
        }
    }

    public static final class WindowChange
    extends AppShareMessage {
        private int windowSize = 0;

        public WindowChange() {
            super(25, false, "");
        }

        public WindowChange(int winSz) {
            super(25, false, "");
            if (winSz < 0 || winSz > 65535) {
                throw new IllegalArgumentException("Window size outside range 0..65535: " + winSz);
            }
            this.windowSize = winSz;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        @Override
        public void parse(DataInputStream strm) throws IOException {
            this.windowSize = strm.readUnsignedShort();
        }

        @Override
        public void encode(DataOutputStream strm) throws IOException {
            strm.writeShort(this.windowSize);
        }

        @Override
        public void dispatch() {
            this.handler.handleWindowChange(this);
        }

        @Override
        public String toString() {
            return super.toString() + " windowSize=" + this.windowSize;
        }
    }
}

