/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare;

public final class AppShareTileDefn {
    public static final int ENCODE_1COLOR_TILE = 0;
    public static final int ENCODE_2COLOR_1MAP_TILE = 1;
    public static final int ENCODE_2COLOR_2MAP_TILE = 2;
    public static final int ENCODE_2COLOR_3MAP_TILE = 3;
    public static final int ENCODE_4COLOR_1MAP_TILE = 4;
    public static final int ENCODE_4COLOR_2MAP_TILE = 5;
    public static final int ENCODE_4COLOR_3MAP_TILE = 6;
    public static final int ENCODE_16COLOR_1MAP_TILE = 7;
    public static final int ENCODE_16COLOR_2MAP_TILE = 8;
    public static final int ENCODE_16COLOR_3MAP_TILE = 9;
    public static final int ENCODE_256COLOR_1MAP_TILE = 10;
    public static final int ENCODE_256COLOR_2MAP_TILE = 11;
    public static final int ENCODE_256COLOR_3MAP_TILE = 12;
    public static final int ENCODE_BLOCK_LISTS_TILE = 13;
    public static final int ENCODE_POINT_LISTS_TILE = 14;
    public static final int ENCODE_RAW_OR_DUP_TILE = 15;
    public static final int LOCATION_FLAGS_MASK = 96;
    public static final int SAME_COL_NEXT_ROW = 96;
    public static final int SAME_ROW_NEXT_COL = 32;
    public static final int SAME_ROW_PREV_COL = 64;
    public static final int TYPE_MASK = 15;
    public static final int USE_PREV_COLORS = 16;
    public static final int COLOR_MASK = Short.MAX_VALUE;
    public static final int COMPRESSED_CLUT_FLAG = 32768;
    public static final int CLUT_DELTA_FLAG = 128;
    public static final int MAX_ENCODING_SIZE = 515;
    public byte type;
    public short[] colors;
    public byte[] pixelEnc;
    public AppShareTileDefn original;
    private static AppShareTileDefn[] unicolorCache = new AppShareTileDefn[32768];

    public static int getMaxColors(byte type) {
        int result = 0;
        switch (type) {
            case 0: {
                result = 1;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                result = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                result = 4;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                result = 16;
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                result = 256;
                break;
            }
            case 13: 
            case 14: {
                result = 256;
                break;
            }
            case 15: {
                result = 0;
            }
        }
        return result;
    }

    public static String typeName(byte type) {
        String result = "Unknown";
        switch (type) {
            case 0: {
                result = "1Colour";
                break;
            }
            case 1: {
                result = "2Col2Map";
                break;
            }
            case 2: {
                result = "2Col2Map";
                break;
            }
            case 3: {
                result = "2Col3Map";
                break;
            }
            case 4: {
                result = "4Col1Map";
                break;
            }
            case 5: {
                result = "4Col2Map";
                break;
            }
            case 6: {
                result = "4Col3Map";
                break;
            }
            case 7: {
                result = "16Col1Map";
                break;
            }
            case 8: {
                result = "16Col2Map";
                break;
            }
            case 9: {
                result = "16Col3Map";
                break;
            }
            case 10: {
                result = "256Col1Map";
                break;
            }
            case 11: {
                result = "256Col2Map";
                break;
            }
            case 12: {
                result = "256Col3Map";
                break;
            }
            case 13: {
                result = "BlockList";
                break;
            }
            case 14: {
                result = "PointList";
                break;
            }
            case 15: {
                result = "Raw/Dup";
            }
        }
        return result;
    }

    public static final AppShareTileDefn getUnicolorTileDefn(short color15) {
        int idx = color15 & Short.MAX_VALUE;
        if (unicolorCache[idx] == null) {
            AppShareTileDefn.unicolorCache[idx] = AppShareTileDefn.createUnicolorTileDefn(color15);
        }
        return unicolorCache[idx];
    }

    private static final AppShareTileDefn createUnicolorTileDefn(short color15) {
        short[] colorTable = new short[]{(short)(color15 | Short.MIN_VALUE)};
        return new AppShareTileDefn(0, colorTable, null);
    }

    public AppShareTileDefn(byte type, short[] colors, byte[] pixelEnc) {
        this.type = type;
        this.colors = colors;
        this.pixelEnc = pixelEnc;
        this.original = null;
    }

    public AppShareTileDefn(byte type, short[] colors, byte[] pixelEnc, AppShareTileDefn orig) {
        this.type = type;
        this.colors = colors;
        this.pixelEnc = pixelEnc;
        this.original = orig;
    }

    public final int getCachedLength() {
        int result = 40;
        if (this.colors != null) {
            result += this.colors.length * 2 + 4;
        }
        if (this.pixelEnc != null) {
            result += this.pixelEnc.length + 4;
        }
        return result;
    }

    public final int getMaxEncodedLength() {
        if (this.original != null) {
            return this.original.getMaxEncodedLength();
        }
        return (this.pixelEnc == null ? 0 : this.pixelEnc.length) + (this.colors == null ? 0 : this.colors.length) + 3;
    }

    public String toString() {
        int ix;
        StringBuffer result = new StringBuffer(1024);
        result.append("type=" + this.type + "=" + AppShareTileDefn.typeName(this.type));
        if (this.colors != null) {
            result.append(" nColors=" + this.colors.length + " colors={");
            for (ix = 0; ix < this.colors.length; ++ix) {
                if (ix > 0) {
                    result.append(",");
                }
                result.append(Integer.toHexString(this.colors[ix] & Short.MAX_VALUE));
            }
            result.append("}");
        }
        if (this.pixelEnc != null) {
            result.append(" pixels={");
            for (ix = 0; ix < this.pixelEnc.length; ++ix) {
                if (ix > 0) {
                    result.append(",");
                }
                result.append(Integer.toHexString(this.pixelEnc[ix] & 0xFF));
            }
            result.append("}");
        }
        if (this.original != null) {
            result.append(" orig={" + this.original.toString() + "}");
        }
        return result.toString();
    }
}

