/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.appshare;

import com.elluminate.groupware.appshare.AppShareDebug;
import com.elluminate.groupware.appshare.AppShareHistoryCache;
import com.elluminate.groupware.appshare.AppShareTileDefn;
import com.elluminate.util.log.LogSupport;

public final class AppShareTileAssembler {
    public static final int CLUT_COMPRESS_THRESHOLD = 16;
    private AppShareHistoryCache history = null;
    private int prevRow = 0;
    private int prevCol = 0;
    private short[] prevCLUT = null;
    private boolean compressColours = true;

    public AppShareTileAssembler(int userID, int cacheSize) {
        this.history = new AppShareHistoryCache(userID, cacheSize);
    }

    public void setCompressColours(boolean compressFlag) {
        this.compressColours = compressFlag;
    }

    public void flush() {
        this.history.purge();
        this.prevCol = 0;
        this.prevRow = 0;
        this.prevCLUT = null;
    }

    public AppShareHistoryCache getHistory() {
        return this.history;
    }

    public void setCacheSize(int newSize) {
        if (this.history != null) {
            this.history.setCapacity(newSize);
        }
    }

    public int getEncodingSize(AppShareTileDefn tile, int row, int col) {
        int byteCount = 1;
        byte encType = this.encodeType(tile.type, row, col, tile.colors);
        if ((encType & 0x60) == 0) {
            byteCount += 2;
        }
        if (tile.type == 15 && tile.original != null) {
            boolean isDup = this.history.isDuplicate(tile.original);
            if (isDup) {
                return byteCount + 2;
            }
            if (tile.original == null) {
                if (AppShareDebug.ENCODE.show()) {
                    LogSupport.message((Object)this, (String)"encode", (String)("Duplicate encoding w/o original: " + row + "," + col));
                }
                return 0;
            }
            while (tile.original != null) {
                tile = tile.original;
            }
            encType = this.encodeType(tile.type, row, col, tile.colors);
        }
        if (tile.type != 15 && (encType & 0x10) == 0) {
            byteCount = this.compressColours && tile.colors.length > 16 ? (byteCount += this.compressCLUT(tile.colors, null, 0, 32768)) : (byteCount += tile.colors.length * 2);
        }
        if (tile.pixelEnc != null) {
            byteCount += tile.pixelEnc.length;
        }
        return byteCount;
    }

    public int encode(AppShareTileDefn tile, int row, int col, byte[] buffer, int start, int limit) {
        int ix;
        int byteCount = 0;
        byte encType = this.encodeType(tile.type, row, col, tile.colors);
        if (start < 0 || start > limit) {
            if (AppShareDebug.ENCODE.show()) {
                LogSupport.message((Object)this, (String)"encode", (String)("Encode start out-of-bounds." + start));
            }
            return 0;
        }
        if (tile.type == 15 && tile.original != null) {
            int encodedLen = 3;
            if ((encType & 0x60) == 0) {
                encodedLen += 2;
            }
            if (start + byteCount + encodedLen - 1 > limit) {
                if (AppShareDebug.ENCODE.show()) {
                    LogSupport.message((Object)this, (String)"encode", (String)"Duplicate encoding exceeds limit");
                }
                return 0;
            }
            int origID = this.history.lookupDuplicate(tile.original);
            if (AppShareDebug.DUPLICATES.show() || AppShareDebug.ENCODE.show()) {
                LogSupport.message((Object)this, (String)"encode", (String)("Encoding duplicate of " + origID));
            }
            if (origID >= 0) {
                buffer[start + byteCount] = encType = (byte)(encType | 0x10);
                ++byteCount;
                if ((encType & 0x60) == 0) {
                    buffer[start + byteCount] = (byte)col;
                    buffer[start + byteCount + 1] = (byte)row;
                    byteCount += 2;
                }
                buffer[start + byteCount] = (byte)((short)origID >> 8 & 0xFF);
                buffer[start + byteCount + 1] = (byte)((short)origID & 0xFF);
                byteCount += 2;
                if (AppShareDebug.ENCODE.show()) {
                    StringBuffer dump = new StringBuffer(byteCount * 3 + 1);
                    for (int ix2 = 0; ix2 < byteCount; ++ix2) {
                        dump.append(" " + Integer.toHexString(buffer[start + ix2] & 0xFF));
                    }
                    LogSupport.message((Object)this, (String)"encode", (String)("Encoded " + byteCount + " bytes: " + dump));
                }
                this.prevRow = row;
                this.prevCol = col;
                this.prevCLUT = tile.colors;
                return byteCount;
            }
            while (tile.original != null) {
                tile = tile.original;
            }
            encType = this.encodeType(tile.type, row, col, tile.colors);
        }
        buffer[start + byteCount] = encType;
        ++byteCount;
        if ((encType & 0x60) == 0) {
            if (start + byteCount + 2 > limit) {
                if (AppShareDebug.ENCODE.show()) {
                    LogSupport.message((Object)this, (String)"encode", (String)"Row/Col exceeds limit");
                }
                return 0;
            }
            buffer[start + byteCount] = (byte)col;
            buffer[start + byteCount + 1] = (byte)row;
            byteCount += 2;
        }
        if (tile.type != 15 && (encType & 0x10) == 0) {
            if (this.compressColours && tile.colors.length > 16) {
                int lenCLUT = this.compressCLUT(tile.colors, buffer, start + byteCount, limit - byteCount);
                if (lenCLUT <= 0) {
                    return 0;
                }
                byteCount += lenCLUT;
            } else {
                if (start + byteCount + tile.colors.length * 2 > limit) {
                    if (AppShareDebug.ENCODE.show()) {
                        LogSupport.message((Object)this, (String)"encode", (String)"CLUT exceeds limit");
                    }
                    return 0;
                }
                for (ix = 0; ix < tile.colors.length; ++ix) {
                    if (ix < tile.colors.length - 1 || ix == 0) {
                        short temp = (short)(tile.colors[ix] & Short.MAX_VALUE);
                        buffer[start + byteCount] = (byte)(temp >> 8 & 0xFF);
                        buffer[start + byteCount + 1] = (byte)(temp & 0xFF);
                    } else {
                        short colour = (short)(tile.colors[ix] | Short.MIN_VALUE);
                        buffer[start + byteCount] = (byte)(colour >> 8 & 0xFF);
                        buffer[start + byteCount + 1] = (byte)(colour & 0xFF);
                    }
                    byteCount += 2;
                }
            }
        }
        if (tile.pixelEnc != null) {
            if (start + byteCount + tile.pixelEnc.length > limit) {
                if (AppShareDebug.ENCODE.show()) {
                    LogSupport.message((Object)this, (String)"encode", (String)"Pixel encoding exceeds limit");
                }
                return 0;
            }
            for (ix = 0; ix < tile.pixelEnc.length; ++ix) {
                buffer[start + byteCount + ix] = tile.pixelEnc[ix];
            }
            byteCount += tile.pixelEnc.length;
        }
        if (AppShareDebug.ENCODE.show()) {
            StringBuffer dump = new StringBuffer(byteCount * 3 + 1);
            for (int ix3 = 0; ix3 < byteCount; ++ix3) {
                dump.append(" " + Integer.toHexString(buffer[start + ix3] & 0xFF));
            }
            LogSupport.message((Object)this, (String)"encode", (String)("Encoded " + byteCount + " bytes: " + dump));
        }
        if (tile.type != 0) {
            this.history.insert(tile);
        }
        this.prevRow = row;
        this.prevCol = col;
        this.prevCLUT = tile.colors;
        return byteCount;
    }

    private byte encodeType(int baseType, int row, int col, short[] clut) {
        byte result = (byte)(baseType & 0xF);
        if (row == this.prevRow) {
            if (col == this.prevCol + 1) {
                result = (byte)(result | 0x20);
                if (AppShareDebug.ENCODE.show()) {
                    LogSupport.message((Object)this, (String)"encode", (String)"Same row, next col");
                }
            } else if (col == this.prevCol - 1) {
                result = (byte)(result | 0x40);
                if (AppShareDebug.ENCODE.show()) {
                    LogSupport.message((Object)this, (String)"encode", (String)"Same row, prev col");
                }
            }
        } else if (row == this.prevRow + 1 && col == this.prevCol) {
            result = (byte)(result | 0x60);
            if (AppShareDebug.ENCODE.show()) {
                LogSupport.message((Object)this, (String)"encode", (String)"Same col, next row");
            }
        }
        if (clut != null && this.prevCLUT != null && clut.length == this.prevCLUT.length) {
            int ix;
            for (ix = 0; ix < clut.length && clut[ix] == this.prevCLUT[ix]; ++ix) {
            }
            if (ix > clut.length) {
                result = (byte)(result | 0x10);
                if (AppShareDebug.ENCODE.show()) {
                    LogSupport.message((Object)this, (String)"encode", (String)"Reuse CLUT");
                }
            }
        }
        return result;
    }

    private int compressCLUT(short[] colours, byte[] buf, int start, int limit) {
        int nBytes = 0;
        if (colours.length > 256) {
            throw new RuntimeException("Invalid CLUT, too many entries: " + colours.length);
        }
        if (start + nBytes + 2 > limit) {
            if (AppShareDebug.ENCODE.show()) {
                LogSupport.message((Object)this, (String)"encode", (String)"Compressed CLUT initial sequence exceeds limit");
            }
            return 0;
        }
        short encoded = AppShareTileAssembler.muxColour(colours[0]);
        if (buf != null) {
            short temp = (short)(encoded | 0x8000);
            buf[start + nBytes] = (byte)(temp >> 8 & 0xFF);
            buf[start + nBytes + 1] = (byte)(temp & 0xFF);
        }
        nBytes += 2;
        if (buf != null) {
            buf[start + nBytes] = (byte)(colours.length - 1);
        }
        ++nBytes;
        short prevColour = encoded;
        for (int ix = 1; ix < colours.length; ++ix) {
            encoded = AppShareTileAssembler.muxColour(colours[ix]);
            int delta = encoded - prevColour;
            if (delta > 0 && delta <= 128) {
                if (start + nBytes > limit) {
                    if (AppShareDebug.ENCODE.show()) {
                        LogSupport.message((Object)this, (String)"encode", (String)"Compressed CLUT short entry exceeds limit");
                    }
                    return 0;
                }
                if (buf != null) {
                    buf[start + nBytes] = (byte)(delta - 1 | 0x80);
                }
                ++nBytes;
            } else {
                if (start + nBytes + 1 > limit) {
                    if (AppShareDebug.ENCODE.show()) {
                        LogSupport.message((Object)this, (String)"encode", (String)"Compressed CLUT long entry exceeds limit");
                    }
                    return 0;
                }
                if (buf != null) {
                    buf[start + nBytes] = (byte)(encoded >> 8 & 0xFF);
                    buf[start + nBytes + 1] = (byte)(encoded & 0xFF);
                }
                nBytes += 2;
            }
            prevColour = encoded;
        }
        return nBytes;
    }

    private static short muxColour(short origColour) {
        short result = 0;
        short red = (short)(origColour >> 10 & 0x1F);
        short grn = (short)(origColour >> 5 & 0x1F);
        short blu = (short)(origColour & 0x1F);
        for (int pos = 4; pos >= 0; --pos) {
            result = (short)(result << 1 | blu >> pos & 1);
            result = (short)(result << 1 | grn >> pos & 1);
            result = (short)(result << 1 | red >> pos & 1);
        }
        return result;
    }
}

