/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.caption.module;

import com.elluminate.groupware.caption.CaptionDebug;
import com.elluminate.groupware.caption.CaptionProtocol;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.DataOutputStream;
import java.io.IOException;

public class CaptionTerminal
implements ChannelListener,
ChannelDataListener {
    private JinxTerminal terminal;
    private Logger log;
    private ListenerRegistry<ChannelListener> clReg;
    private ListenerRegistry<ChannelDataListener> cdlReg;
    private ListenerRegistry<PropertyChangeListener> pclReg;

    @Inject
    public CaptionTerminal(JinxTerminal jt) {
        this.terminal = jt;
    }

    @Inject
    public void initListenerRegistries(ListenerRegistry<ChannelListener> cl, ListenerRegistry<ChannelDataListener> cld, ListenerRegistry<PropertyChangeListener> pcl) {
        this.clReg = cl;
        this.cdlReg = cld;
        this.pclReg = pcl;
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    public void setupCaptionTerminal() {
        ChannelListener cLst = new ChannelListener(){

            public void channelStateChanged(final ChannelEvent event) {
                CaptionTerminal.this.handleChannelStateChanged(event);
                CaptionTerminal.this.clReg.fire((FiringFunctor)new FiringFunctor<ChannelListener>(){

                    public void fire(ChannelListener listener) {
                        listener.channelStateChanged(event);
                    }
                });
            }
        };
        ChannelDataListener dLst = new ChannelDataListener(){

            public void onChannelData(final ChannelDataEvent event) {
                CaptionTerminal.this.handleChannelData(event);
                CaptionTerminal.this.cdlReg.fire((FiringFunctor)new FiringFunctor<ChannelDataListener>(){

                    public void fire(ChannelDataListener listener) {
                        listener.onChannelData(event);
                    }
                });
            }
        };
        PropertyChangeListener pLst = new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent evt) {
                CaptionTerminal.this.handlePropertyChange(evt);
                CaptionTerminal.this.pclReg.fire((FiringFunctor)new FiringFunctor<PropertyChangeListener>(){

                    public void fire(PropertyChangeListener listener) {
                        listener.propertyChange(evt);
                    }
                });
            }
        };
        this.terminal.setProtocolAndListeners((JinxProtocol)new CaptionProtocol(), cLst, dLst, pLst);
    }

    protected void handlePropertyChange(PropertyChangeEvent evt) {
    }

    protected void handleChannelData(ChannelDataEvent event) {
        if (CaptionDebug.TERMINAL.show()) {
            this.log.message("handleChannelData-event: " + event.toString());
            this.log.message("\tcontents: " + new String(event.getContents()));
        }
    }

    protected void handleChannelStateChanged(ChannelEvent event) {
    }

    public void addChannelDataListener(ChannelDataListener l) {
        this.cdlReg.add((Object)l);
    }

    public void addChannelListener(ChannelListener l) {
        this.clReg.add((Object)l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pclReg.add((Object)l);
    }

    public void sendToWire(String text) {
        block6: {
            ChannelDataEvent cde = ChannelDataEvent.getInstance((Object)this, (short)-4, (byte)1);
            DataOutputStream ostr = cde.write();
            try {
                if (CaptionDebug.TERMINAL.show()) {
                    String byteRepresentation = "";
                    for (byte b : text.getBytes()) {
                        byteRepresentation = byteRepresentation + "[" + b + "] ";
                    }
                    this.log.message("Sending caption text [byte representation] over the network: " + byteRepresentation);
                    this.log.message("  as text: " + text);
                }
                ostr.writeUTF(text);
                ostr.close();
                this.terminal.fireChannelData(cde);
            }
            catch (IOException iox) {
                this.log.exception((Object)this, "run", (Throwable)iox, true);
                try {
                    ostr.close();
                }
                catch (IOException cx) {
                    if (!CaptionDebug.TERMINAL.show()) break block6;
                    this.log.message("Error writing to jinx from CaptionTerminal: " + cx.getMessage());
                }
            }
        }
    }

    public void onChannelData(ChannelDataEvent event) {
    }

    public void channelStateChanged(ChannelEvent event) {
    }
}

