/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.caption.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.contentcapture.CaptureBacklogCallback;
import com.elluminate.contentcapture.CaptureFeedSubscription;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.ActionParameterDescriptor;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRPermission;
import com.elluminate.framework.session.CRPermissionDelegate;
import com.elluminate.framework.session.CRPermissionFactory;
import com.elluminate.framework.session.CRPermissionScope;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRPermissionChangeListener;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEvent;
import com.elluminate.framework.session.listener.event.CRPermissionChangeEventType;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.caption.module.CaptionModel;
import com.elluminate.groupware.caption.module.CaptionPermissionDelegate;
import com.elluminate.groupware.caption.module.CaptionSources;
import com.elluminate.groupware.caption.module.CaptionTerminal;
import com.elluminate.groupware.caption.module.StringsProperties;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.module.PermissionFeatureFactory;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimerFactory;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class CaptionModule
extends AbstractClientModule
implements ModulePublisherInfo,
PropertyChangeListener,
PlaybackTimeListener,
CaptureBacklogCallback {
    private Boolean isHandlingEvent = false;
    public static final String MODULE_NAME = "Captioning";
    public static final String SHOW_PROP = ".showCaptions";
    private I18n i18n;
    private Imps imps;
    private CaptionModel model;
    private Object modeLock = new Object();
    private int mode = 0;
    private ClientList clients = null;
    private boolean firstShow = true;
    private Provider<CaptionSources> captionSourcesProvider;
    private CaptionSources sources;
    private BooleanFeature showMenuFeature;
    private FeatureBroker broker;
    private ListFeature<String> captionMessageFeature;
    private ActionFeature captionInputFeature;
    private ClientProvider clientProvider;
    private BooleanFeature captionPanelFeature;
    private BooleanFeature showBtnFeature;
    private PermissionFeatureFactory permissionFeatureFactory;
    private CaptionPermissionDelegate captionPermissionDelegate;
    private CaptionTerminal terminal;
    private CRSession session;
    private BooleanFeature captionPermissionFeature;
    private BooleanFeature showMenuModeratorFeature;
    private boolean isChair;
    private List<CRParticipant> permissionCounter = new ArrayList<CRParticipant>();
    private ContentCapture contentCapture = null;
    private ContentCaptureProvider contentCaptureProvider;

    @Inject
    public CaptionModule(CaptionModel m) {
        this.model = m;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initCaptionSourcesProvider(Provider<CaptionSources> cps) {
        this.captionSourcesProvider = cps;
    }

    @Inject
    public void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    public void initCaptionTerminal(CaptionTerminal t) {
        this.terminal = t;
    }

    @Inject
    public void initI18n(I18n i18n) {
        this.i18n = i18n;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    protected void initPermissionFeatureFactory(PermissionFeatureFactory permissionFeatureFactory) {
        this.permissionFeatureFactory = permissionFeatureFactory;
    }

    @Inject
    protected void initCaptionPermissionDelegate(CaptionPermissionDelegate captionPermissionDelegate) {
        this.captionPermissionDelegate = captionPermissionDelegate;
    }

    @Inject
    protected void initSession(CRSession session) {
        this.session = session;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONMODULE_EMPTYTITLE);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon("CaptionColumn.accessIcon");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyCaptioningState(boolean captioningSelected, boolean isInputWindow) {
        if (this.isHandlingEvent.booleanValue()) {
            return;
        }
        Boolean bl = this.isHandlingEvent;
        synchronized (bl) {
            try {
                this.isHandlingEvent = true;
                if (isInputWindow) {
                    if (captioningSelected && this.clientProvider.get().isConnected()) {
                        this.changeMode(this.mode, 2);
                    } else {
                        this.changeMode(this.mode, 0);
                    }
                } else if (captioningSelected && this.clientProvider.get().isConnected()) {
                    this.changeMode(this.mode, 1);
                } else {
                    this.changeMode(this.mode, 0);
                }
                String showTip = (Boolean)this.showBtnFeature.getValue() != false ? this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONMODULE_HIDETIP) : this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONMODULE_SHOWTIP);
                this.showBtnFeature.setDescription(showTip);
            }
            finally {
                this.isHandlingEvent = false;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent pce) {
        if (this.clients == null) {
            return;
        }
        ClientInfo ci = this.clients.getMyClient();
        String pName = pce.getPropertyName();
        if (pName.equals("chair")) {
            Chair chair = ChairProtocol.getChair((ClientList)this.clients);
            this.isChair = chair.isMe();
        }
    }

    public boolean requestClose() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeMode(int from, int to) {
        Object object = this.modeLock;
        synchronized (object) {
            if (!this.captionPanelFeature.isPublished()) {
                this.broker.setFeaturePublished((Feature)this.captionPanelFeature, this.contentCaptureProvider == null || this.contentCaptureProvider.get().isEchoingData());
            }
            this.captionPanelFeature.setEnabled(to != 0);
            if (this.mode == to) {
                return;
            }
            if (this.mode == from) {
                this.model.setMode(to);
                this.updateModeProperties(to);
                this.showBtnFeature.setValue((Object)(to != 0 ? 1 : 0));
                this.showMenuFeature.setValue((Object)(to == 1 ? 1 : 0));
                this.showMenuModeratorFeature.setValue((Object)(to == 2 ? 1 : 0));
                this.mode = to;
                if (this.mode != 0 && this.firstShow) {
                    this.firstShow = false;
                }
            }
        }
    }

    private void updateModeProperties(int to) {
        CRParticipant participant = this.session.getMe();
        if (participant != null) {
            participant.getPropertyStore().setProperty("caption.viewing", to == 1);
            participant.getPropertyStore().setProperty("caption.sending", to == 2);
        }
    }

    public void start() {
    }

    private void createFeatures() {
        this.createCaptionMessagesFeature();
        this.createCaptionInputFeature();
        this.showMenuFeature = this.broker.createBooleanFeature((Object)this, "/caption/show", true, false, "caption_show", null);
        this.showMenuFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONMODULE_SHOWMENU));
        this.showMenuFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONMODULE_SHOWMENU));
        this.showMenuFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                boolean value = Boolean.parseBoolean(event.getNewValue().toString());
                CaptionModule.this.modifyCaptioningState(value, false);
            }
        });
        this.showMenuModeratorFeature = this.broker.createBooleanFeature((Object)this, "/caption/showModerator", true, false, "caption_showModerator", null);
        this.showMenuModeratorFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONMODULE_SENDMENU));
        this.showMenuModeratorFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONMODULE_SENDMENU));
        this.showMenuModeratorFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                boolean value = Boolean.parseBoolean(event.getNewValue().toString());
                CaptionModule.this.modifyCaptioningState(value, true);
            }
        });
        this.showBtnFeature = this.broker.createBooleanFeature((Object)this, "/caption/showBtn", true, false, "caption_showBtn", null);
        this.showBtnFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONMODULE_SHOWMENU));
        this.showBtnFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONMODULE_SHOWMENU));
        this.showBtnFeature.setTrueIcon(this.i18n.getImage("CaptionModule.showBtn"));
        this.showBtnFeature.setFalseIcon(this.i18n.getImage("CaptionModule.showBtn"));
        this.showBtnFeature.setPressedIcon(this.i18n.getImage("CaptionModule.showPressedBtn"));
        this.showBtnFeature.setRolloverTrueIcon(this.i18n.getImage("CaptionModule.showRolloverBtn"));
        this.showBtnFeature.setRolloverFalseIcon(this.i18n.getImage("CaptionModule.showRolloverBtn"));
        this.showBtnFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                if (CaptionModule.this.clients != null) {
                    Object prop;
                    ClientInfo ci;
                    boolean value = Boolean.parseBoolean(ev.getNewValue().toString());
                    ClientInfo clientInfo = ci = CaptionModule.this.clients == null ? null : CaptionModule.this.clients.getMyClient();
                    if (ci != null && (prop = ci.getProperty("caption.access")) instanceof Boolean) {
                        CaptionModule.this.modifyCaptioningState(value, (Boolean)prop);
                    }
                }
            }
        });
        this.captionPanelFeature = this.broker.createBooleanFeature((Object)this, "/caption/captionPanel", false, false, this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONMODULE_EMPTYTITLE), null);
        this.captionPermissionFeature = this.permissionFeatureFactory.createParticipantPermissionFeature((Object)this, "CaptionPermission", "/caption/captionPermission", this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONCOLUMN_DESC), "Caption", this.i18n);
        this.captionPermissionFeature.setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONCOLUMN_DESC_ACCESSIBLENAME));
        if (this.captionPermissionDelegate != null) {
            this.captionPermissionDelegate.setClientProvider(this.clientProvider);
            this.captionPermissionDelegate.setSession(this.session);
            CRPermissionFactory permissionFactory = new CRPermissionFactory("CaptionPermission", "CaptionPermission", CRPermissionScope.PARTICIPANT, (CRPermissionDelegate)this.captionPermissionDelegate);
            this.session.registerPermission(permissionFactory);
            this.clients.addPropertyChangeListener(this.captionPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.captionPermissionDelegate));
            this.clients.addDefaultPropertyChangeListener(this.captionPermissionDelegate.getPropertyName(), (byte)0, (PropertyChangeListener)((Object)this.captionPermissionDelegate));
        }
        this.session.addPermissionChangeListener("CaptionPermission", new CRPermissionChangeListener(){

            public void onPermissionValueChange(CRPermissionChangeEvent event) {
                CaptionModule.this.handlePermissionValueChanged(event);
            }

            public void onPermissionDefaultChange(CRPermissionChangeEvent event) {
            }
        });
        this.clients.addPropertyChangeListener((byte)0, (PropertyChangeListener)new CaptainAnnotationProvider());
        this.session.registerAnnotation("CaptionActivityAnnotation", (Object)0);
    }

    private void createCaptionInputFeature() {
        ActionParameterDescriptor paramDesc = new ActionParameterDescriptor("text", ActionParameterDescriptor.Type.STRING);
        ArrayList<ActionParameterDescriptor> params = new ArrayList<ActionParameterDescriptor>();
        params.add(paramDesc);
        this.captionInputFeature = this.broker.createActionFeature((Object)this, "/caption/input", params, this.i18n.getString((PropertiesEnum)StringsProperties.CAPTION_INPUT), null);
        this.captionInputFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent ev) {
                String text = (String)ev.getParameterAs(String.class, "text");
                if (text != null) {
                    CaptionModule.this.terminal.sendToWire(text);
                }
            }
        });
        this.model.addPropertyChangeListener("mode.change", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer toMode = (Integer)evt.getNewValue();
                CaptionModule.this.broker.setFeaturePublished((Feature)CaptionModule.this.captionInputFeature, toMode == 2);
            }
        });
    }

    private void createCaptionMessagesFeature() {
        this.captionMessageFeature = this.broker.createListFeature((Object)this, "/caption/messages", String.class, null, this.i18n.getString((PropertiesEnum)StringsProperties.CAPTION_MESSAGES), null);
        this.model.addPropertyChangeListener("mode.change", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer toMode = (Integer)evt.getNewValue();
                boolean published = toMode == 1 || toMode == 0;
                CaptionModule.this.broker.setFeaturePublished((Feature)CaptionModule.this.captionMessageFeature, published);
            }
        });
        this.model.addPropertyChangeListener("source.change", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String msg = CaptionModule.this.model.getSource() == null ? CaptionModule.this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONBEAN_NOSRCMSG) : CaptionModule.this.i18n.getString((PropertiesEnum)StringsProperties.CAPTIONBEAN_CHANGESRCMSG, new Object[]{CaptionModule.this.model.getSource().getDisplayName()});
                CaptionModule.this.sendToCaptionMessageFeature("\n" + msg + "\n");
            }
        });
    }

    public void attach() {
        this.sources = (CaptionSources)this.captionSourcesProvider.get();
        this.sources.setupSources();
        this.terminal.addChannelDataListener(new ChannelDataListener(){

            public void onChannelData(ChannelDataEvent event) {
                CaptionModule.this.handleIncommingCaptionerData(event);
            }
        });
        this.clients = this.clientProvider.get().getClientList();
        this.clients.addClientPropertyChangeListener("caption.access", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.addClientListener(new ClientListener(){

            public void onAddClient(ClientEvent e) {
                if (e.getAddress() == CaptionModule.this.clientProvider.get().getAddress()) {
                    CaptionModule.this.broker.addFeature((Feature)CaptionModule.this.showMenuFeature);
                    if (((Boolean)CaptionModule.this.showBtnFeature.getValue()).booleanValue()) {
                        CaptionModule.this.changeMode(CaptionModule.this.mode, 1);
                    }
                }
            }

            public void onRemoveClient(ClientEvent e) {
                if (e.getAddress() == CaptionModule.this.clientProvider.get().getAddress()) {
                    CaptionModule.this.broker.removeFeature((Feature)CaptionModule.this.showMenuFeature);
                    CaptionModule.this.changeMode(CaptionModule.this.mode, 0);
                }
            }
        });
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.addPlaybackTimeListener((PlaybackTimeListener)this);
        }
        this.contentCapture = this.getContentCapture();
    }

    protected void handleIncommingCaptionerData(ChannelDataEvent event) {
        if (event == null) {
            return;
        }
        String decodedContents = "";
        try {
            decodedContents = new String(this.decode(event.getContents()), "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (this.model.getSource() != null && this.model.getSource().getID() == event.getSourceAddress() && this.getContentCapture().isEchoingData()) {
            this.sendToCaptionMessageFeature(decodedContents);
        }
        this.sendMessageToContentCapture(event.getSourceAddress(), decodedContents);
    }

    private byte[] decode(byte[] contents) {
        if (contents == null || contents.length == 0) {
            return contents;
        }
        if (contents.length >= 2) {
            ByteBuffer bb = ByteBuffer.allocate(2);
            bb.put(contents[0]);
            bb.put(contents[1]);
            short sz = bb.getShort(0);
            byte[] reply = new byte[sz];
            for (short i = 0; i < sz; i = (short)(i + 1)) {
                reply[i] = contents[i + 2];
            }
            return reply;
        }
        return contents;
    }

    private void sendToCaptionMessageFeature(final String msg) {
        if (this.captionMessageFeature.isEnabled()) {
            if (this.captionMessageFeature.isPublished()) {
                this.captionMessageFeature.add((Object)msg);
            } else {
                new LightweightTimerFactory().create((byte)1, new Runnable(){

                    @Override
                    public void run() {
                        CaptionModule.this.captionMessageFeature.add((Object)msg);
                    }
                }).scheduleIn(100L);
            }
        }
    }

    public void detach() {
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.removePlaybackTimeListener((PlaybackTimeListener)this);
        }
        this.clients = null;
    }

    public void stop() {
    }

    public void setupUI() {
        this.createFeatures();
    }

    public void cleanupUI() {
    }

    public void setLinearity(PlaybackTimeListener.Linearity spd) {
    }

    public void resetSession() {
        this.changeMode(this.model.getMode(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePermissionValueChanged(CRPermissionChangeEvent event) {
        List<CRParticipant> list = this.permissionCounter;
        synchronized (list) {
            CRPermission permission = (CRPermission)event.getSource();
            CRParticipant participant = this.session.getParticipantById(permission.getID());
            boolean captioningSelected = true;
            if (event.getValueChange() == CRPermissionChangeEventType.FALSE_TO_TRUE) {
                this.permissionCounter.add(participant);
                this.broker.setFeaturePublished((Feature)this.showBtnFeature, true);
                if (participant != null && participant.isMe()) {
                    this.broker.setFeaturePublished((Feature)this.showMenuModeratorFeature, true);
                }
            } else if (event.getValueChange() == CRPermissionChangeEventType.TRUE_TO_FALSE) {
                if (participant != null && participant.isMe()) {
                    captioningSelected = false;
                }
                if (this.showBtnFeature.isPublished() && this.permissionCounter.contains(participant)) {
                    this.permissionCounter.remove(participant);
                }
                if (this.permissionCounter.size() == 0) {
                    this.broker.setFeaturePublished((Feature)this.showBtnFeature, false);
                    captioningSelected = false;
                }
                if (participant != null && participant.isMe()) {
                    this.broker.setFeaturePublished((Feature)this.showMenuModeratorFeature, false);
                }
            }
            if (this.captionPanelFeature.isPublished() && this.captionPanelFeature.isEnabled()) {
                boolean isInput = false;
                CRParticipant me = this.session.getMe();
                if (me != null) {
                    isInput = (Boolean)me.getPropertyStore().getProperty("caption.access");
                }
                this.modifyCaptioningState(captioningSelected, isInput);
            }
        }
    }

    @Inject
    public void initContentCaptureProvider(ContentCaptureProvider contentCaptureProvider) {
        this.contentCaptureProvider = contentCaptureProvider;
    }

    private void sendMessageToContentCapture(short addr, String body) {
        if (this.getContentCapture() != null && this.getContentCapture().isCapturingData()) {
            this.getContentCapture().setText(addr, body);
        }
    }

    private ContentCapture getContentCapture() {
        if (this.contentCapture == null && this.contentCaptureProvider != null) {
            this.contentCapture = this.contentCaptureProvider.get();
            if (this.contentCapture.isCapturingData()) {
                return this.contentCaptureProvider.get().registerTextModule("Caption", "Caption", (CaptureBacklogCallback)this, null, this.i18n.getIcon("CaptionBean.thinClientIcon"), (byte)4, (byte)60);
            }
        }
        return this.contentCapture;
    }

    public void captureBacklogCallback(CaptureFeedSubscription feedSubscription) {
    }

    private class CaptainAnnotationProvider
    implements PropertyChangeListener {
        private CaptainAnnotationProvider() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (CaptionModule.this.clients == null) {
                return;
            }
            String propertyName = evt.getPropertyName();
            short ownerId = CaptionModule.this.clients.getPropertyOwner(evt.getSource());
            ClientInfo ci = CaptionModule.this.clients.get(ownerId);
            if (ci == null) {
                return;
            }
            if (propertyName.equals("caption.active")) {
                boolean access = ci.getProperty("caption.access", false);
                boolean active = ci.getProperty("caption.active", false);
                if (access && active) {
                    CaptionModule.this.session.setAnnotationValue(ownerId, "CaptionActivityAnnotation", (Object)1);
                } else {
                    CaptionModule.this.session.setAnnotationValue(ownerId, "CaptionActivityAnnotation", (Object)0);
                }
            }
        }
    }
}

