/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.caption.module;

import com.elluminate.framework.session.CRParticipant;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class CaptionModel {
    public static final String PREFERRED_SOURCE_PROPERTY = "preferred.source.change";
    public static final String MODE_PROPERTY = "mode.change";
    public static final String SOURCE_PROPERTY = "source.change";
    public static final String AVAILABLE_SOURCE_CHANGE_PROPERTY = "available.source.change";
    private static final String[] SUPPORTED_PROPERTIES = new String[]{"preferred.source.change", "mode.change", "source.change"};
    public static final int MODE_NONE = 0;
    public static final int MODE_DISPLAY = 1;
    public static final int MODE_CREATE = 2;
    private static final Object lock = new Object();
    private Map<String, ListenerRegistry<PropertyChangeListener>> registryMap = new HashMap<String, ListenerRegistry<PropertyChangeListener>>();
    private int currentMode = 0;
    private CRParticipant preferredSource = null;
    private CRParticipant source = null;
    private List<String> availableSources = new ArrayList<String>();
    private Provider<ListenerRegistry<PropertyChangeListener>> registryProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public CaptionModel(Provider<ListenerRegistry<PropertyChangeListener>> lrp) {
        this.registryProvider = lrp;
        Object object = lock;
        synchronized (object) {
            for (String prop : SUPPORTED_PROPERTIES) {
                this.registryMap.put(prop, (ListenerRegistry<PropertyChangeListener>)this.registryProvider.get());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String property, PropertyChangeListener l) {
        Object object = lock;
        synchronized (object) {
            if (this.registryMap.containsKey(property) && l != null) {
                this.registryMap.get(property).add((Object)l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMode(final int mode) {
        if (this.currentMode == mode) {
            return;
        }
        final int prevMode = this.currentMode;
        this.currentMode = mode;
        ListenerRegistry<PropertyChangeListener> reg = null;
        Object object = lock;
        synchronized (object) {
            reg = this.registryMap.get(MODE_PROPERTY);
        }
        reg.fire((FiringFunctor)new FiringFunctor<PropertyChangeListener>(){

            public void fire(PropertyChangeListener listener) {
                listener.propertyChange(new PropertyChangeEvent(this, CaptionModel.MODE_PROPERTY, prevMode, mode));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferredSource(final CRParticipant preferredSrc) {
        if (this.preferredSource != null && this.preferredSource.equals(preferredSrc)) {
            return;
        }
        final CRParticipant lastPreferred = this.preferredSource;
        this.preferredSource = preferredSrc;
        ListenerRegistry<PropertyChangeListener> reg = null;
        Object object = lock;
        synchronized (object) {
            reg = this.registryMap.get(PREFERRED_SOURCE_PROPERTY);
        }
        reg.fire((FiringFunctor)new FiringFunctor<PropertyChangeListener>(){

            public void fire(PropertyChangeListener listener) {
                listener.propertyChange(new PropertyChangeEvent(this, CaptionModel.PREFERRED_SOURCE_PROPERTY, lastPreferred, preferredSrc));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSource(final CRParticipant src) {
        if (this.source == src) {
            return;
        }
        if (this.source != null && this.source.equals(src)) {
            return;
        }
        final CRParticipant lastSrc = this.source;
        this.source = src;
        ListenerRegistry<PropertyChangeListener> reg = null;
        Object object = lock;
        synchronized (object) {
            reg = this.registryMap.get(SOURCE_PROPERTY);
        }
        reg.fire((FiringFunctor)new FiringFunctor<PropertyChangeListener>(){

            public void fire(PropertyChangeListener listener) {
                listener.propertyChange(new PropertyChangeEvent(this, CaptionModel.SOURCE_PROPERTY, lastSrc, src));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailableSources(final List<String> srcs) {
        if (this.availableSources.containsAll(srcs) && srcs.containsAll(this.availableSources)) {
            return;
        }
        ListenerRegistry<PropertyChangeListener> reg = null;
        Object object = lock;
        synchronized (object) {
            reg = this.registryMap.get(AVAILABLE_SOURCE_CHANGE_PROPERTY);
            this.availableSources = Collections.unmodifiableList(srcs);
        }
        reg.fire((FiringFunctor)new FiringFunctor<PropertyChangeListener>(){

            public void fire(PropertyChangeListener listener) {
                listener.propertyChange(new PropertyChangeEvent(this, CaptionModel.AVAILABLE_SOURCE_CHANGE_PROPERTY, null, srcs));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAvailableSources() {
        Object object = lock;
        synchronized (object) {
            return Collections.unmodifiableList(this.availableSources);
        }
    }

    public CRParticipant getSource() {
        return this.source;
    }

    public CRParticipant getPreferredSource() {
        return this.preferredSource;
    }

    public int getMode() {
        return this.currentMode;
    }
}

