/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator;

import com.elluminate.groupware.calculator.CalculatorContext;
import com.elluminate.groupware.calculator.CoordPair;
import com.elluminate.groupware.calculator.CoordSpace;
import com.elluminate.groupware.calculator.Function;
import com.elluminate.groupware.calculator.FunctionData;
import com.elluminate.util.CPropertyChangeSupport;
import com.elluminate.util.Debug;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;

public class LocalCalculatorContext
implements CalculatorContext,
PropertyChangeListener {
    public static final int NFunctions = 2;
    private FunctionData[] functions = new FunctionData[2];
    private CoordSpace space = new CoordSpace(-5.0, 5.0, -5.0, 5.0);
    private double gridSpacing = 1.0;
    private CoordPair mark = null;
    private boolean dragging = false;
    private CPropertyChangeSupport changeSupport;
    private static String[] vars = new String[]{"x", "e", "pi"};
    private Object lock = new Object();

    public LocalCalculatorContext() {
        this.changeSupport = new CPropertyChangeSupport((Object)this);
        this.space.addPropertyChangeListener(this);
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i] = new FunctionData();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener lst) {
        this.changeSupport.addPropertyChangeListener(lst);
    }

    @Override
    public void addPropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.changeSupport.addPropertyChangeListener(prop, lst);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener lst) {
        this.changeSupport.removePropertyChangeListener(lst);
    }

    @Override
    public void removePropertyChangeListener(String prop, PropertyChangeListener lst) {
        this.changeSupport.removePropertyChangeListener(prop, lst);
    }

    @Override
    public CoordSpace getCoordSpace() {
        return this.space;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCoordSpace(CoordSpace spc) {
        CoordSpace from;
        Debug.lockEnter((Object)this, (String)"setCoordSpace", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            from = this.space;
            this.space.removePropertyChangeListener(this);
            this.space = spc;
            this.space.addPropertyChangeListener(this);
        }
        Debug.lockLeave((Object)this, (String)"setCoordSpace", (String)"lock", (Object)this.lock);
        this.changeSupport.firePropertyChange("coordSpace", (Object)from, (Object)this.space);
    }

    @Override
    public boolean isGridVisible() {
        return this.getGridSpacing() > 0.0;
    }

    @Override
    public double getGridSpacing() {
        return this.gridSpacing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGridSpacing(double spacing) {
        double old;
        Debug.lockEnter((Object)this, (String)"setGridSpacing", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            old = this.gridSpacing;
            this.gridSpacing = spacing;
        }
        Debug.lockLeave((Object)this, (String)"setGridSpacing", (String)"lock", (Object)this.lock);
        this.changeSupport.firePropertyChange("gridSpacing", (Object)new Double(old), (Object)new Double(this.gridSpacing));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMark(CoordPair mark) {
        CoordPair old;
        Debug.lockEnter((Object)this, (String)"setMark", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            old = this.mark;
            this.mark = mark;
        }
        Debug.lockLeave((Object)this, (String)"setMark", (String)"lock", (Object)this.lock);
        this.changeSupport.firePropertyChange("mark", (Object)old, (Object)mark);
    }

    @Override
    public CoordPair getMark() {
        return this.mark;
    }

    @Override
    public int getFunctionCount() {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function getFunction(int index) {
        Function func;
        Debug.lockEnter((Object)this, (String)"getFunction", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            func = this.functions[index].func;
        }
        Debug.lockLeave((Object)this, (String)"getFunction", (String)"lock", (Object)this.lock);
        return func;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFunctionName(int index) {
        String name;
        Debug.lockEnter((Object)this, (String)"getFunctionName", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            name = this.functions[index].name;
        }
        Debug.lockLeave((Object)this, (String)"getFunctionName", (String)"lock", (Object)this.lock);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFunctionName(int index, String name) throws ParseException {
        String old;
        Debug.lockEnter((Object)this, (String)"setFunctionName", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            old = this.functions[index].name;
            if (name == null || name.equals("")) {
                this.functions[index].name = "";
                this.functions[index].func = null;
            } else {
                Function f = new Function(name, vars);
                f.setVariable("e", Math.E);
                f.setVariable("pi", Math.PI);
                this.functions[index].name = name;
                this.functions[index].func = f;
            }
        }
        Debug.lockLeave((Object)this, (String)"setFunctionName", (String)"lock", (Object)this.lock);
        this.changeSupport.firePropertyChange("function", (Object)old, (Object)name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getFunctionColor(int index) {
        Color color;
        Debug.lockEnter((Object)this, (String)"getFunctionColor", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            color = this.functions[index].color;
        }
        Debug.lockLeave((Object)this, (String)"getFunctionColor", (String)"lock", (Object)this.lock);
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFunctionColor(int index, Color color) {
        Color old;
        Debug.lockEnter((Object)this, (String)"setFunctionColor", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            old = this.functions[index].color;
            this.functions[index].color = color;
        }
        Debug.lockLeave((Object)this, (String)"setFunctionColor", (String)"lock", (Object)this.lock);
        this.changeSupport.firePropertyChange("functionColor", (Object)old, (Object)color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFunctionVisible(int index) {
        boolean enabled;
        Debug.lockEnter((Object)this, (String)"isFunctionVisible", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            enabled = this.functions[index].enabled;
        }
        Debug.lockLeave((Object)this, (String)"isFunctionVisible", (String)"lock", (Object)this.lock);
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFunctionVisible(int index, boolean enable) {
        boolean old;
        Debug.lockEnter((Object)this, (String)"setFunctionVisible", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            old = this.functions[index].enabled;
            this.functions[index].enabled = enable;
        }
        Debug.lockLeave((Object)this, (String)"setFunctionVisible", (String)"lock", (Object)this.lock);
        this.changeSupport.firePropertyChange("functionVisible", old, enable);
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDragging(boolean state) {
        Debug.lockEnter((Object)this, (String)"setDragging", (String)"lock", (Object)this.lock);
        Object object = this.lock;
        synchronized (object) {
            this.dragging = state;
        }
        Debug.lockLeave((Object)this, (String)"setDragging", (String)"lock", (Object)this.lock);
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.changeSupport.firePropertyChange("coordSpace", null, null);
    }
}

