/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator;

import com.elluminate.groupware.calculator.BuiltinFactory;
import com.elluminate.groupware.calculator.DyadicOperatorTerm;
import com.elluminate.groupware.calculator.FunctionContext;
import com.elluminate.groupware.calculator.FunctionTokenizer;
import com.elluminate.groupware.calculator.LiteralTerm;
import com.elluminate.groupware.calculator.MonadicOperatorTerm;
import com.elluminate.groupware.calculator.PowerOperator;
import com.elluminate.groupware.calculator.StringsProperties;
import com.elluminate.groupware.calculator.Term;
import com.elluminate.groupware.calculator.VariableTerm;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;

public class Function {
    I18n i18n = I18n.create((Object)this);
    BuiltinFactory builtinFactory = null;
    HashMap vars = new HashMap();
    Term root = null;
    String formula = null;
    DecimalFormatSymbols symbols = new DecimalFormatSymbols();
    NumberFormat format = DecimalFormat.getNumberInstance();
    char decimal = this.symbols.getDecimalSeparator();

    public Function(String str, String[] variables) throws ParseException {
        this(str, variables, new BuiltinFactory());
    }

    public Function(String str, String[] variables, BuiltinFactory factory) throws ParseException {
        boolean operatorExpected = false;
        boolean signOK = true;
        boolean parenExpected = false;
        int where = 0;
        FunctionContext context = new FunctionContext();
        LinkedList<FunctionContext> stack = new LinkedList<FunctionContext>();
        this.builtinFactory = factory;
        this.formula = str;
        for (int i = 0; i < variables.length; ++i) {
            this.vars.put(variables[i], new Double(0.0));
        }
        FunctionTokenizer t = new FunctionTokenizer(str);
        while (t.hasMoreTokens()) {
            Term term;
            String token = t.nextToken();
            char first = token.charAt(0);
            switch (first) {
                case '+': {
                    if (!operatorExpected) {
                        if (!signOK) {
                            throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_UNEXPECTEDPLUS), where);
                        }
                        signOK = false;
                        term = null;
                        break;
                    }
                    term = new DyadicOperatorTerm(1){

                        @Override
                        public double eval(double l, double r) {
                            return l + r;
                        }
                    };
                    operatorExpected = false;
                    signOK = true;
                    break;
                }
                case '-': {
                    if (!operatorExpected) {
                        if (!signOK) {
                            throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_UNEXPECTEDMINUS), where);
                        }
                        term = new MonadicOperatorTerm(3){

                            @Override
                            public double eval(double arg) {
                                return -arg;
                            }
                        };
                        signOK = false;
                        break;
                    }
                    term = new DyadicOperatorTerm(1){

                        @Override
                        public double eval(double l, double r) {
                            return l - r;
                        }
                    };
                    operatorExpected = false;
                    signOK = true;
                    break;
                }
                case '*': {
                    if (!operatorExpected) {
                        throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_UNEXPECTEDTIMES), where);
                    }
                    term = new DyadicOperatorTerm(2){

                        @Override
                        public double eval(double l, double r) {
                            return l * r;
                        }
                    };
                    operatorExpected = false;
                    signOK = true;
                    break;
                }
                case '/': {
                    if (!operatorExpected) {
                        throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_UNEXPECTEDDIVIDE), where);
                    }
                    term = new DyadicOperatorTerm(2){

                        @Override
                        public double eval(double l, double r) {
                            try {
                                return l / r;
                            }
                            catch (Exception ex) {
                                return Double.NaN;
                            }
                        }
                    };
                    operatorExpected = false;
                    signOK = true;
                    break;
                }
                case '^': {
                    if (!operatorExpected) {
                        throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_UNEXPECTEDEXP), where);
                    }
                    term = new PowerOperator();
                    operatorExpected = false;
                    signOK = true;
                    break;
                }
                case '(': {
                    if (operatorExpected) {
                        context.pushOperator(new DyadicOperatorTerm(2){

                            @Override
                            public double eval(double l, double r) {
                                return l * r;
                            }
                        });
                        operatorExpected = false;
                    }
                    stack.addLast(context);
                    context = new FunctionContext();
                    term = null;
                    signOK = true;
                    parenExpected = false;
                    break;
                }
                case ')': {
                    if (parenExpected) {
                        throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_PARENREQD), where);
                    }
                    if (stack.isEmpty()) {
                        throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_MISMATCHEDPARENS), where);
                    }
                    term = context.getTree();
                    context = (FunctionContext)stack.removeLast();
                    context.pushOperand(term);
                    term = null;
                    break;
                }
                default: {
                    if (parenExpected) {
                        throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_PARENREQD), where);
                    }
                    if (Character.isDigit(first) || first == this.decimal) {
                        try {
                            double v = this.format.parse(token).doubleValue();
                            term = new LiteralTerm(v);
                        }
                        catch (Exception ex) {
                            throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_INVALIDNUMBER, new Object[]{token, str}), where);
                        }
                    } else if (Character.isLetter(first)) {
                        term = this.vars.containsKey(token) ? new VariableTerm(this.vars, token) : this.builtinFactory.createInstance(token);
                    } else {
                        throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_INVALIDCHARACTER, new Object[]{str}), where);
                    }
                    if (operatorExpected) {
                        context.pushOperator(new DyadicOperatorTerm(2){

                            @Override
                            public double eval(double l, double r) {
                                return l * r;
                            }
                        });
                    }
                    if (term.getOperandCount() > 0) {
                        parenExpected = true;
                        operatorExpected = false;
                        signOK = true;
                        break;
                    }
                    operatorExpected = true;
                    signOK = false;
                }
            }
            if (term != null) {
                if (term.getOperandCount() > 0) {
                    context.pushOperator(term);
                } else {
                    context.pushOperand(term);
                }
            }
            where += token.length();
        }
        if (!stack.isEmpty()) {
            throw new ParseException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_MISMATCHEDPARENS), where);
        }
        this.root = context.getTree();
    }

    public double setVariable(String name, double value) {
        if (!this.vars.containsKey(name)) {
            throw new IllegalArgumentException(this.i18n.getString((PropertiesEnum)StringsProperties.FUNCTION_UNDEFVARIABLE, new Object[]{name}));
        }
        this.vars.put(name, new Double(value));
        return this.eval();
    }

    public double eval() {
        double value;
        try {
            value = this.root.eval();
        }
        catch (Exception ex) {
            value = Double.NaN;
        }
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            return Double.NaN;
        }
        return value;
    }

    public String toString() {
        return this.formula;
    }
}

