/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator;

import com.elluminate.groupware.calculator.CalculatorProtocol;
import com.elluminate.groupware.calculator.StringsProperties;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class CalculatorResponder
extends DefaultProtocolResponder {
    private PropertyChangeListener markEmitter = null;
    private I18n i18n = I18n.create((Object)((Object)this));
    private I18nMessage modIcon = null;
    private I18nMessage showType = null;
    private I18nMessage hideType = null;
    private boolean showing = false;

    public CalculatorResponder() {
        super((JinxProtocol)new CalculatorProtocol());
        this.markEmitter = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                try {
                    boolean wasShowing = CalculatorResponder.this.showing;
                    boolean visible = CalculatorResponder.this.getClientList().getProperty("calculatorVisible", false);
                    boolean locked = CalculatorResponder.this.getClientList().getProperty("calculatorLocked", false);
                    if (locked) {
                        CalculatorResponder.this.showing = visible;
                    }
                    if (wasShowing != CalculatorResponder.this.showing) {
                        CalculatorResponder.this.noteVisibilityChange(CalculatorResponder.this.showing);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
    }

    public void join(Connection connection, String channel) {
        super.join(connection, channel);
        ClientList clients = this.getClientList();
        clients.addPropertyChangeListener("calculatorVisible", this.markEmitter);
        clients.addPropertyChangeListener("calculatorLocked", this.markEmitter);
    }

    public void leave(String channel) {
        ClientList clients = this.getClientList();
        clients.removePropertyChangeListener("calculatorVisible", this.markEmitter);
        clients.removePropertyChangeListener("calculatorLocked", this.markEmitter);
        super.leave(channel);
    }

    private void noteVisibilityChange(boolean vis) {
        if (this.modIcon == null) {
            this.modIcon = this.i18n.getMessage((PropertiesEnum)StringsProperties.CALCULATORRESPONDER_INDEXICON);
        }
        if (this.showType == null) {
            this.showType = this.i18n.getMessage((PropertiesEnum)StringsProperties.CALCULATORRESPONDER_SHOWINDEXTYPE);
        }
        if (this.hideType == null) {
            this.hideType = this.i18n.getMessage((PropertiesEnum)StringsProperties.CALCULATORRESPONDER_HIDEINDEXTYPE);
        }
        VCRFile.IndexEntry indexEntry = new VCRFile.IndexEntry(this.modIcon, vis ? this.showType : this.hideType, null);
        this.fireNotableEventListeners("recording.index", indexEntry);
    }
}

