/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator;

import com.elluminate.groupware.calculator.CalculatorResponder;
import com.elluminate.jinx.JinxProtocolAdapter;
import com.elluminate.jinx.ProtocolResponder;
import java.io.DataInputStream;

public class CalculatorProtocol
extends JinxProtocolAdapter {
    public static final byte SET_FUNCTION = 1;
    public static final byte SET_COORD_SPACE = 2;
    public static final byte SET_GRID = 3;
    public static final byte SET_MARK = 4;
    public static final byte CLEAR_MARK = 5;
    public static final String CHANNEL = "calculator";
    public static final byte PRIORITY = 2;
    public static final String ACCESS_PROPERTY = "calculatorAccess";
    public static final String ACTIVE_PROPERTY = "calculatorActive";
    public static final String LOCKED_PROPERTY = "calculatorLocked";
    public static final String VISIBLE_PROPERTY = "calculatorVisible";

    public CalculatorProtocol() {
        this(false);
    }

    public CalculatorProtocol(boolean dftAccess) {
        this.defineChannel(CHANNEL, (byte)2);
        this.defineProperty(ACCESS_PROPERTY, (byte)0, new Boolean(dftAccess));
        this.defineProperty(ACTIVE_PROPERTY, (byte)0, Boolean.FALSE);
        this.defineProperty(LOCKED_PROPERTY, (byte)1, Boolean.FALSE);
        this.defineProperty(VISIBLE_PROPERTY, (byte)1, Boolean.FALSE);
    }

    public String commandToString(byte cmd) {
        switch (cmd) {
            case 1: {
                return "SetFunction";
            }
            case 2: {
                return "SetCoordSpace";
            }
            case 3: {
                return "SetGrid";
            }
            case 4: {
                return "SetMark";
            }
            case 5: {
                return "ClearMark";
            }
        }
        return "Invalid calculator protocol command - " + cmd;
    }

    public String messageToString(byte cmd, DataInputStream str) {
        String command = this.commandToString(cmd);
        try {
            command = command + "(" + str.readShort() + ")";
            switch (cmd) {
                case 1: {
                    command = command + " - #" + str.readByte() + ": '" + str.readUTF() + "' " + (str.readBoolean() ? "enabled" : "disabled") + " RGB=" + str.readShort() + "," + str.readShort() + "," + str.readShort();
                    break;
                }
                case 2: {
                    command = command + " - X=" + str.readDouble() + ".." + str.readDouble() + ", Y=" + str.readDouble() + ".." + str.readDouble();
                    break;
                }
                case 3: {
                    command = command + " - " + str.readDouble();
                    break;
                }
                case 4: {
                    command = command + " - " + str.readDouble() + "," + str.readDouble();
                    break;
                }
            }
        }
        catch (Exception ex) {
            command = command + " - Exception while decoding message - " + ex;
        }
        return command;
    }

    public ProtocolResponder getResponder() {
        return new CalculatorResponder();
    }
}

