/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.StopQuizCommand;
import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.module.QuizBean;
import com.elluminate.groupware.quiz.module.QuizViewer;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class StopQuizCmd
extends AbstractCommand
implements StopQuizCommand {
    private I18n i18n = I18n.create((Object)((Object)this));
    private Provider<QuizBean> beanProvider;

    @Inject
    public void initQuizBeanProvider(Provider<QuizBean> bp) {
        this.beanProvider = bp;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        QuizBean bean = (QuizBean)this.beanProvider.get();
        if (!bean.isTesting()) {
            throw new CommandContextException("No quiz is running", this.i18n.getString((PropertiesEnum)StringsProperties.STOPQUIZCMD_BADCONTEXTNOTQUIZZING));
        }
        QuizViewer viewer = bean.getQuizViewer();
        if (viewer == null) {
            throw new CommandExecutionException("No viewer is available");
        }
        Quiz q = bean.getViewedQuiz();
        if (q != null && !q.isComplete()) {
            bean.stop(q);
        }
    }
}

