/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.groupware.quiz.Responses;
import com.elluminate.groupware.quiz.module.QuizManager;
import com.elluminate.groupware.quiz.module.QuizPanel;
import com.elluminate.groupware.quiz.module.QuizViewer_doneBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizViewer_handInBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizViewer_reviewBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizViewer_startBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizViewer_stopBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizViewer_timeBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.AccessibleToolBar;
import com.elluminate.gui.component.CToolBarButton;
import com.elluminate.gui.component.ComboBoxCellRenderer;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.ShortList;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;

public class QuizViewer
extends JPanel
implements QuizListener,
ItemListener {
    private static I18n i18n = I18n.create(QuizViewer.class);
    public static final byte VIEW_OFFLINE = 1;
    public static final byte VIEW_STUDENT = 2;
    public static final byte VIEW_INSTRUCTOR = 3;
    public static final long CHECKPOINT_INTERVAL = 10000L;
    private ImageIcon timeIcon = i18n.getIcon("QuizViewer.timeIcon");
    private ImageIcon doneIcon = i18n.getIcon("QuizViewer.doneIcon");
    private ImageIcon startIcon = i18n.getIcon("QuizViewer.startIcon");
    private ImageIcon stopIcon = i18n.getIcon("QuizViewer.stopIcon");
    private ImageIcon handInIcon = i18n.getIcon("QuizViewer.handInIcon");
    private ImageIcon reviewIcon = i18n.getIcon("QuizViewer.reviewIcon");
    private GridBagLayout toolLayout = new GridBagLayout();
    private JPanel toolPanel = new JPanel();
    private BorderLayout viewLayout = new BorderLayout();
    private CToolBarButton handInBtn = new CToolBarButton();
    private JToolBar toolbar = new AccessibleToolBar();
    private JLabel title = new JLabel();
    private CToolBarButton doneBtn = new CToolBarButton();
    private CToolBarButton timeBtn = new CToolBarButton();
    private CToolBarButton startBtn = new CToolBarButton();
    private CToolBarButton stopBtn = new CToolBarButton();
    private CToolBarButton reviewBtn = new CToolBarButton();
    private JPanel statusPanel = new JPanel();
    private JProgressBar statusCount = new JProgressBar();
    private JProgressBar statusTime = new JProgressBar();
    private GridBagLayout statusLayout = new GridBagLayout();
    private JLabel statusText = new JLabel();
    private JComboBox resultSelector = new JComboBox();
    private DefaultComboBoxModel model = new DefaultComboBoxModel();
    private QuizPanel quizPane = new QuizPanel(2);
    private String studentLabel = "students";
    private QuizManager mgr = null;
    private Quiz quiz = null;
    private byte view;
    private short state = 0;
    private String myName = null;
    private int timeLimit = -1;
    private long endTime = -1L;
    private LightweightTimer checkpoint = new LightweightTimer(new Runnable(){

        @Override
        public void run() {
            if (QuizViewer.this.quiz != null && QuizViewer.this.mgr != null && QuizViewer.this.view == 2 && QuizViewer.this.state == 2) {
                QuizViewer.this.mgr.checkpoint(QuizViewer.this.quiz);
            }
        }
    });
    private LightweightTimer countdown = new LightweightTimer(2, new Runnable(){

        @Override
        public void run() {
            QuizViewer.this.setStatusLine();
        }
    });
    private ClientList clients = null;

    protected void setClients(ClientList newClients) {
        this.clients = newClients;
    }

    public QuizViewer() {
        try {
            this.jbInit();
            this.setView((byte)1);
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"QuizViewer", (Throwable)e, (boolean)true);
        }
    }

    private void jbInit() throws Exception {
        String summary = i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_SUMMARY);
        this.model.addElement(new ClientNames(summary, summary));
        this.resultSelector.addItemListener(this);
        this.resultSelector.setModel(this.model);
        this.resultSelector.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_SELECTORTIP));
        this.resultSelector.setRenderer(new UserNameRenderer(this.resultSelector.getRenderer()));
        this.setLayout(this.viewLayout);
        this.doneBtn.setIcon((Icon)this.doneIcon);
        this.doneBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_DONETIP));
        this.doneBtn.addActionListener((ActionListener)new QuizViewer_doneBtn_actionAdapter(this));
        this.startBtn.setIcon((Icon)this.startIcon);
        this.startBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_STARTTIP));
        this.startBtn.addActionListener((ActionListener)new QuizViewer_startBtn_actionAdapter(this));
        this.stopBtn.setEnabled(false);
        this.stopBtn.setIcon((Icon)this.stopIcon);
        this.stopBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_STOPTIP));
        this.stopBtn.addActionListener((ActionListener)new QuizViewer_stopBtn_actionAdapter(this));
        this.reviewBtn.setEnabled(false);
        this.reviewBtn.setIcon((Icon)this.reviewIcon);
        this.reviewBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_REVIEWTIP, new Object[]{this.studentLabel}));
        this.reviewBtn.addActionListener((ActionListener)new QuizViewer_reviewBtn_actionAdapter(this));
        this.toolbar.setFloatable(false);
        this.statusPanel.setLayout(this.statusLayout);
        this.statusPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(2, 8, 2, 16)));
        this.statusTime.setPreferredSize(new Dimension(100, 16));
        this.statusTime.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_STATUSTIMETIP));
        this.statusCount.setPreferredSize(new Dimension(100, 16));
        this.statusCount.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_STATUSCOUNTTIP));
        this.timeBtn.setIcon((Icon)this.timeIcon);
        this.timeBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_TIMETIP));
        this.timeBtn.addActionListener((ActionListener)new QuizViewer_timeBtn_actionAdapter(this));
        this.handInBtn.setIcon((Icon)this.handInIcon);
        this.handInBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_HANDINTIP));
        this.handInBtn.addActionListener((ActionListener)new QuizViewer_handInBtn_actionAdapter(this));
        this.title.setText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_TITLE));
        this.add((Component)this.toolPanel, "North");
        this.add((Component)this.quizPane, "Center");
        this.toolbar.add((Component)this.handInBtn);
        this.toolbar.add((Component)this.doneBtn);
        this.toolbar.add((Component)this.timeBtn);
        this.toolbar.add((Component)this.startBtn);
        this.toolbar.add((Component)this.stopBtn);
        this.toolbar.add((Component)this.reviewBtn);
        this.toolPanel.setLayout(this.toolLayout);
        this.toolPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets.left = 6;
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.toolPanel.add((Component)this.title, gbc);
        gbc.gridx = 1;
        this.toolPanel.add((Component)this.toolbar, gbc);
        gbc.gridx = 2;
        gbc.weightx = 100.0;
        this.toolPanel.add((Component)this.resultSelector, gbc);
        gbc.gridx = 3;
        gbc.weightx = 1.0;
        this.toolPanel.add(Box.createHorizontalGlue(), gbc);
        this.add((Component)this.statusPanel, "South");
        this.statusPanel.add((Component)this.statusText, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.statusCount, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 6, 0, 0), 0, 0));
        this.statusPanel.add((Component)this.statusTime, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 6, 0, 0), 0, 0));
    }

    public void setManager(QuizManager manager) {
        this.mgr = manager;
    }

    public void setStudentLabel(String lbl) {
        this.reviewBtn.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_REVIEWTIP, new Object[]{lbl}));
        this.studentLabel = lbl;
    }

    public void setQuiz(Quiz q) {
        if (this.quiz != null) {
            this.quiz.removeQuizListener((QuizListener)this);
        }
        this.quiz = q;
        if (this.quiz != null) {
            this.quiz.addQuizListener((QuizListener)this);
            this.quiz.setMyName(this.myName);
        }
        this.title.setText(this.quiz != null ? this.quiz.getText() : i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_TITLE));
        if (this.view != 2) {
            this.rebuildResultBrowser();
            this.resultSelector.setSelectedIndex(0);
            this.quizPane.setMode(2);
        }
        this.quizPane.setQuiz(q);
        this.timeLimit = -1;
        this.setStatusLine();
    }

    public Quiz getQuiz() {
        return this.quiz;
    }

    public void setTimeLimit(long limit, long left) {
        this.timeLimit = (int)limit;
        this.endTime = System.currentTimeMillis() + left;
        if (this.timeLimit > 0) {
            this.countdown.scheduleEvery(1000L);
        } else {
            this.countdown.cancel();
        }
        this.setStatusLine();
    }

    public void setView(byte newView) {
        if (newView == this.view) {
            return;
        }
        this.view = newView;
        boolean student = this.view == 2;
        boolean teacher = this.view == 3;
        this.handInBtn.setVisible(student);
        this.doneBtn.setVisible(!student);
        this.timeBtn.setVisible(teacher);
        this.startBtn.setVisible(teacher);
        this.stopBtn.setVisible(teacher);
        this.reviewBtn.setVisible(teacher);
        this.resultSelector.setVisible(!student);
        this.statusCount.setVisible(this.view == 3);
        if (this.quiz != null) {
            this.quiz.setMyName(this.myName);
        }
        if (this.view != 2) {
            this.resultSelector.setSelectedIndex(0);
            this.quizPane.setMode(2);
        } else {
            this.setState(this.state);
        }
    }

    public byte getView() {
        return this.view;
    }

    public void setState(short newState) {
        if (this.state != newState) {
            if (newState == 2) {
                this.checkpoint.scheduleEvery(10000L);
            } else if (this.state == 2) {
                this.checkpoint.cancel();
                this.countdown.cancel();
            }
        }
        this.state = newState;
        this.handInBtn.setEnabled(this.state == 2);
        this.doneBtn.setEnabled(this.state != 1 && this.state != 2 && this.state != 3);
        this.timeBtn.setEnabled(this.state == 0);
        this.startBtn.setEnabled(this.state == 0);
        this.stopBtn.setEnabled(this.state == 2);
        this.reviewBtn.setEnabled(this.state == 4);
        if (this.view == 2) {
            switch (this.state) {
                case 2: {
                    this.quizPane.setMode(3);
                    break;
                }
                case 3: 
                case 4: {
                    this.quizPane.setMode(4);
                    break;
                }
                case 5: {
                    this.quizPane.setMode(5);
                    break;
                }
            }
        }
        this.setStatusLine();
    }

    public short getState() {
        return this.state;
    }

    public void setMyName(String nm) {
        this.myName = nm;
        if (this.quiz != null) {
            this.quiz.setMyName(nm);
        }
    }

    public void onQuizChange(QuizEvent e) {
        if (e.getAction() == 1) {
            if (this.view == 3) {
                this.rebuildResultBrowser();
            }
        } else if (e.getAction() == 2) {
            this.setStatusLine();
        }
    }

    private void setStatusLine() {
        if (this.quizPane.getMode() == 5 && this.quiz != null) {
            short right = this.quiz.getCorrectCount();
            short wrong = this.quiz.getIncorrectCount();
            short unmarked = this.quiz.getUnmarkedCount();
            short total = this.quiz.getQuestionCount();
            if (unmarked > 0 && right + wrong == 0) {
                this.statusText.setText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_MARKSNONE, new Object[]{ShortList.get((short)unmarked)}));
            } else if (unmarked > 0) {
                this.statusText.setText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_MARKSSOME, new Object[]{ShortList.get((short)right), new Integer(total), ShortList.get((short)unmarked)}));
            } else {
                this.statusText.setText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_MARKSALL, new Object[]{ShortList.get((short)right), new Integer(right + wrong)}));
            }
        } else {
            this.statusText.setText("");
        }
        if (this.view == 3) {
            short v = 1;
            int m = 0;
            if (this.quiz != null) {
                v = this.quiz.getCompleteCount();
                m = this.quiz.getParticipantCount();
            }
            if (m == 0) {
                this.statusCount.setMaximum(1);
                this.statusCount.setValue(0);
                this.statusCount.setStringPainted(false);
            } else {
                this.statusCount.setMaximum(m);
                this.statusCount.setValue(v);
                this.statusCount.setString(v + "/" + m);
                this.statusCount.setStringPainted(true);
            }
        }
        if (this.timeLimit > 0) {
            String lbl;
            long left = this.state == 2 ? this.endTime - System.currentTimeMillis() : (long)this.timeLimit;
            int min = (int)(left / 60000L);
            int sec = (int)((left - (long)(min * 60000)) / 1000L);
            if (left < 0L) {
                left = 0L;
                lbl = "0:00";
            } else {
                lbl = sec < 10 ? min + ":0" + sec : min + ":" + sec;
            }
            this.statusTime.setVisible(true);
            this.statusTime.setMaximum(this.timeLimit);
            this.statusTime.setValue((int)left);
            this.statusTime.setString(lbl);
            this.statusTime.setStringPainted(true);
        } else {
            this.statusTime.setVisible(false);
            this.statusTime.setMaximum(1);
            this.statusTime.setValue(0);
            this.statusTime.setStringPainted(false);
        }
    }

    private void rebuildResultBrowser() {
        int selX = this.resultSelector.getSelectedIndex();
        ClientNames selName = (ClientNames)this.resultSelector.getItemAt(selX);
        ArrayList<ClientNames> users = new ArrayList<ClientNames>();
        int newX = 0;
        if (this.quiz != null) {
            Iterator i = this.quiz.participantIterator();
            while (i.hasNext()) {
                String nm = (String)i.next();
                Responses r = this.quiz.getResponsesFor(nm);
                if (r == null || !r.isComplete()) continue;
                ClientInfo ci = null;
                if (this.clients != null) {
                    ci = this.clients.get(nm);
                }
                if (ci != null) {
                    ClientNames nms = new ClientNames(ci.getName(), ci.getDisplayName());
                    users.add(nms);
                    continue;
                }
                users.add(new ClientNames(nm, nm));
            }
        }
        Collections.sort(users, new Comparator<ClientNames>(){

            @Override
            public int compare(ClientNames obj1, ClientNames obj2) {
                return obj1.displayName.compareTo(obj2.displayName);
            }
        });
        if (selName != null) {
            for (int i = 0; i < users.size(); ++i) {
                ClientNames entryName = (ClientNames)users.get(i);
                if (entryName == null || !selName.name.equals(entryName.name)) continue;
                newX = i + 1;
            }
        }
        boolean was = this.resultSelector.isEnabled();
        this.resultSelector.setEnabled(false);
        this.resultSelector.removeItemListener(this);
        while (this.resultSelector.getItemCount() > 1) {
            this.resultSelector.removeItemAt(1);
        }
        for (ClientNames nm : users) {
            this.resultSelector.addItem(nm);
        }
        if (newX > 0 && selX > 0) {
            this.resultSelector.setSelectedIndex(newX);
        }
        this.resultSelector.addItemListener(this);
        if (newX == 0 && selX != 0) {
            this.resultSelector.setSelectedIndex(0);
        }
        this.resultSelector.setEnabled(was);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.view == 2) {
            return;
        }
        if (e.getStateChange() == 1) {
            int idx = this.resultSelector.getSelectedIndex();
            if (idx == 0) {
                if (this.quizPane.getMode() != 2) {
                    this.quizPane.setMode(2);
                }
            } else {
                if (this.quizPane.getMode() != 5) {
                    this.quizPane.setMode(5);
                }
                ClientNames nms = (ClientNames)this.resultSelector.getItemAt(idx);
                this.setMyName(nms.name);
            }
        }
        this.setStatusLine();
    }

    void doneBtn_actionPerformed(ActionEvent e) {
        this.mgr.release(this.quiz);
    }

    void timeBtn_actionPerformed(ActionEvent e) {
        QuizTimeDialog dialog = new QuizTimeDialog(this, i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_TIMEPROMPT), i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_TIMETITLE));
        dialog.setVisible(true);
        String txt = dialog.getTimeString();
        if (txt != null) {
            this.timeLimit = dialog.getMinutes() * 60000;
            this.setStatusLine();
        }
    }

    void startBtn_actionPerformed(ActionEvent e) {
        this.mgr.start(this.quiz, this.timeLimit);
    }

    void stopBtn_actionPerformed(ActionEvent e) {
        this.mgr.stop(this.quiz);
        this.stopBtn.setEnabled(false);
    }

    void handInBtn_actionPerformed(ActionEvent e) {
        this.mgr.handIn(this.quiz, false);
    }

    void reviewBtn_actionPerformed(ActionEvent e) {
        this.mgr.review(this.quiz);
    }

    private static class ClientNames {
        public String name;
        public String displayName;

        public ClientNames(String name, String displayName) {
            this.name = name;
            this.displayName = displayName;
        }
    }

    class QuizTimeDialog
    extends EasyDialog {
        private JButton cancelButton;
        private JButton okButton;
        private MultilineLabel textPane;
        private JTextField timeField;
        private String timeString;
        private int minutes;

        public QuizTimeDialog(Component owner, String text, String title) {
            super(owner, title);
            this.cancelButton = new JButton();
            this.okButton = new JButton();
            this.textPane = new MultilineLabel();
            this.timeField = new JTextField();
            this.timeString = null;
            this.minutes = -1;
            this.textPane.setText(text);
            this.cancelButton.setText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_CANCELBUTTON));
            this.okButton.setText(i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_OKBUTTON));
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QuizTimeDialog.this.timeString = null;
                    QuizTimeDialog.this.minutes = -1;
                    QuizTimeDialog.this.setVisible(false);
                }
            });
            this.okButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QuizTimeDialog.this.timeEnterAction();
                }
            });
            this.timeField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QuizTimeDialog.this.timeEnterAction();
                }
            });
            JPanel c = new JPanel(new GridBagLayout());
            c.setLayout(new GridBagLayout());
            c.add((Component)this.textPane, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            c.add((Component)this.timeField, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.setContent(c);
            this.addCancelButton(this.cancelButton);
            this.addActionButton(this.okButton, true);
        }

        public int getMinutes() {
            return this.minutes;
        }

        public String getTimeString() {
            return this.timeString;
        }

        private void timeEnterAction() {
            this.timeField.setEnabled(false);
            this.okButton.setEnabled(false);
            this.validateTime();
            this.okButton.setEnabled(true);
        }

        private void validateTime() {
            this.timeString = this.timeField.getText();
            try {
                this.minutes = Integer.parseInt(this.timeString);
                if (this.minutes < 0 || this.minutes > 600) {
                    throw new NumberFormatException(this.timeString);
                }
            }
            catch (NumberFormatException ex) {
                ModalDialog.showMessageDialog((Component)((Object)this), (Object)i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_INVALIDTIMEMSG, new Object[]{this.timeString}), (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZVIEWER_INVALIDTIMETITLE), (int)0);
                this.timeString = null;
                this.minutes = -1;
                this.timeField.setEnabled(true);
                this.timeField.grabFocus();
                return;
            }
            this.setVisible(false);
        }
    }

    private static class UserNameRenderer
    extends ComboBoxCellRenderer {
        public UserNameRenderer(ListCellRenderer defaultRenderer) {
            super(defaultRenderer);
        }

        protected void prepareComponent(Component cmp, JList list, Object value, int index, boolean selected, boolean focused) {
            if (value != null && value instanceof ClientNames && cmp instanceof JLabel) {
                ((JLabel)cmp).setText(((ClientNames)value).displayName);
            }
        }
    }
}

