/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.module.QuizSaveDialog_cancelBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.QuizSaveDialog_okBtn_actionAdapter;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.swing.CList;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringComparator;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class QuizSaveDialog
extends EasyDialog
implements ItemListener {
    private static I18n i18n = I18n.create(QuizSaveDialog.class);
    JPanel dlgPanel = new JPanel();
    BorderLayout dlgLayout = new BorderLayout();
    JScrollPane quizScroller = new JScrollPane();
    JPanel optionPanel = new JPanel();
    ButtonGroup optionGrp = new ButtonGroup();
    JRadioButton allBtn = new JRadioButton();
    JRadioButton selectedBtn = new JRadioButton();
    GridLayout optionLayout = new GridLayout();
    JButton cancelBtn = new JButton();
    JButton okBtn = new JButton();
    DefaultListModel model = new DefaultListModel();
    JList quizList = new CList((ListModel)this.model);
    ArrayList quizzes = new ArrayList();
    ArrayList selected = null;

    public QuizSaveDialog(Frame frame, String title) {
        super((Component)frame, title, true);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"QuizSaveDialog", (Throwable)ex, (boolean)true);
        }
    }

    public QuizSaveDialog() {
        this(null, "");
    }

    private void jbInit() throws Exception {
        this.dlgPanel.setLayout(this.dlgLayout);
        this.dlgLayout.setVgap(6);
        this.allBtn.setSelected(true);
        this.allBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.QUIZSAVEDIALOG_SAVEALL));
        this.allBtn.addItemListener(this);
        this.selectedBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.QUIZSAVEDIALOG_SAVESELECTED));
        this.selectedBtn.addItemListener(this);
        this.optionPanel.setLayout(this.optionLayout);
        this.optionLayout.setColumns(1);
        this.optionLayout.setRows(2);
        this.quizList.setEnabled(false);
        this.dlgPanel.add((Component)this.optionPanel, "North");
        this.dlgPanel.add((Component)this.quizScroller, "Center");
        this.optionPanel.add((Component)this.allBtn, null);
        this.optionPanel.add((Component)this.selectedBtn, null);
        this.quizScroller.setViewportView(this.quizList);
        this.quizScroller.setPreferredSize(new Dimension(250, 150));
        this.quizScroller.setVerticalScrollBarPolicy(22);
        this.quizScroller.setHorizontalScrollBarPolicy(31);
        this.optionGrp.add(this.allBtn);
        this.optionGrp.add(this.selectedBtn);
        this.cancelBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.QUIZSAVEDIALOG_CANCELBTN));
        this.cancelBtn.addActionListener(new QuizSaveDialog_cancelBtn_actionAdapter(this));
        this.okBtn.setText(i18n.getString((PropertiesEnum)StringsProperties.QUIZSAVEDIALOG_SAVEBTN));
        this.okBtn.addActionListener(new QuizSaveDialog_okBtn_actionAdapter(this));
        this.setContent(this.dlgPanel);
        this.addCancelButton(this.cancelBtn);
        this.addActionButton(this.okBtn, true);
        this.setInitialFocus(this.allBtn);
        this.quizList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (QuizSaveDialog.this.selectedBtn.isSelected()) {
                    QuizSaveDialog.this.okBtn.setEnabled(QuizSaveDialog.this.quizList.getSelectedIndices() != null && QuizSaveDialog.this.quizList.getSelectedIndices().length > 0);
                } else {
                    QuizSaveDialog.this.okBtn.setEnabled(true);
                }
            }
        });
    }

    public void setQuizzes(ArrayList q) {
        this.quizzes = (ArrayList)q.clone();
        Collections.sort(this.quizzes, new Comparator(){
            private StringComparator scmp = new StringComparator();

            public int compare(Object l, Object r) {
                return this.scmp.compare(l.toString(), r.toString());
            }
        });
        for (int i = 0; i < this.quizzes.size(); ++i) {
            this.model.addElement(this.quizzes.get(i));
        }
    }

    public ArrayList getSelected() {
        return this.selected;
    }

    void okBtn_actionPerformed(ActionEvent e) {
        if (this.allBtn.isSelected()) {
            this.selected = this.quizzes;
        } else {
            Object[] sx = this.quizList.getSelectedValues();
            if (sx != null && sx.length > 0) {
                this.selected = new ArrayList(sx.length);
                for (int i = 0; i < sx.length; ++i) {
                    this.selected.add(sx[i]);
                }
            }
        }
        this.hide();
    }

    void cancelBtn_actionPerformed(ActionEvent e) {
        this.hide();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.quizList.setEnabled(this.selectedBtn.isSelected());
        if (this.selectedBtn.isSelected()) {
            this.okBtn.setEnabled(this.quizList.getSelectedIndices() != null && this.quizList.getSelectedIndices().length > 0);
        } else {
            this.okBtn.setEnabled(true);
        }
    }

    public static ArrayList showDialog(Component parent, String title, ArrayList quizzes) {
        Frame top = null;
        top = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        QuizSaveDialog dlg = new QuizSaveDialog(top, title);
        dlg.setQuizzes(quizzes);
        dlg.show();
        return dlg.getSelected();
    }
}

