/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.engine.ConferencingEngine;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ActionFeatureEvent;
import com.elluminate.framework.feature.ActionFeatureListener;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.LoadFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.imps.DisconnectQueryAPI;
import com.elluminate.groupware.imps.DocumentHandlingAPI;
import com.elluminate.groupware.imps.QuizModelAPI;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.groupware.quiz.QuizLib;
import com.elluminate.groupware.quiz.module.LoadQuizCmd;
import com.elluminate.groupware.quiz.module.QuizBean;
import com.elluminate.groupware.quiz.module.QuizDebug;
import com.elluminate.groupware.quiz.module.QuizViewer;
import com.elluminate.groupware.quiz.module.StartQuizCmd;
import com.elluminate.groupware.quiz.module.StopQuizCmd;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class QuizModule
extends AbstractClientModule
implements ModulePublisherInfo,
PropertyChangeListener,
ConnectionListener {
    private static final String MODULE_NAME = "Quiz";
    private static I18n i18n = I18n.create(QuizModule.class);
    private ImageIcon quizIcon = i18n.getIcon("QuizModule.quizIcon");
    private ImageIcon toolIcon = i18n.getIcon("QuizModule.showTool");
    private ClientList clients = null;
    private boolean isConnected = false;
    private boolean isChair = false;
    private boolean forceShow = false;
    private boolean canSave = false;
    private Provider<QuizBean> beanProvider;
    private Imps imps;
    private FeatureBroker broker;
    private QuizBean quizBean = null;
    private ConferencingEngine confEngine;
    private Provider<LoadQuizCmd> loadQuizCmdProvider;
    private Provider<StartQuizCmd> startQuizCmdProvider;
    private Provider<StopQuizCmd> stopQuizCmdProvider;
    private ClientProvider clientProvider;
    private ChairProtocol chairProtocol;
    private ActionFeature newQuizFeature;
    private ActionFeature openQuizFeature;
    private ActionFeature saveQuizFeature;
    private BooleanFeature showMenuFeature;
    private ComponentFeature quizPanelFeature;
    private LoadFeature loadQuiz;
    private SwingRunner swingRunner;

    @Inject
    public QuizModule(ComponentRegistrar registrar, ConferencingEngine confEngine) {
        registrar.registerComponent((Object)this);
        this.confEngine = confEngine;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_TITLE);
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initQuizBeanProvider(Provider<QuizBean> beanProvider) {
        this.beanProvider = beanProvider;
    }

    @Inject
    protected void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Inject
    public void initChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    @Inject
    public void initHandCmdProviders(Provider<LoadQuizCmd> loadQuizCmdProvider, Provider<StartQuizCmd> startQuizCmdProvider, Provider<StopQuizCmd> stopQuizCmdProvider) {
        this.loadQuizCmdProvider = loadQuizCmdProvider;
        this.startQuizCmdProvider = startQuizCmdProvider;
        this.stopQuizCmdProvider = stopQuizCmdProvider;
    }

    @Inject
    public void initSwingRunner(SwingRunner swingRunner) {
        this.swingRunner = swingRunner;
    }

    public Icon getModuleIcon() {
        return i18n.getIcon("QuizModule.quizIcon");
    }

    private void setDisconnectQueryAPI() {
        DisconnectQueryAPI discQuery = new DisconnectQueryAPI(){

            public String getProvider() {
                return QuizModule.MODULE_NAME;
            }

            public byte getTier() {
                return 32;
            }

            public byte mayDisconnect() {
                if (QuizModule.this.quizBean == null) {
                    return 0;
                }
                if (QuizModule.this.isChair) {
                    if (QuizModule.this.quizBean.isTesting()) {
                        int result = ModalDialog.showConfirmDialog((Component)QuizModule.this.quizBean, (Object)i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_EXITQUIZBEINGADMINISTERED), (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_CONFIRMEXIT), (int)0, (int)3);
                        switch (result) {
                            case 0: {
                                return 0;
                            }
                            case 1: {
                                return -1;
                            }
                        }
                    }
                    QuizLib lib = QuizModule.this.quizBean.getQuizLib();
                    ArrayList quizes = lib.getQuizzes();
                    boolean hasChanged = false;
                    if (QuizModule.this.quizBean.isEditingModifiedQuiz()) {
                        hasChanged = true;
                    }
                    for (Quiz quiz : quizes) {
                        if (!quiz.needsSaving()) continue;
                        hasChanged = true;
                        break;
                    }
                    if (hasChanged) {
                        int result = ModalDialog.showConfirmDialog((Component)QuizModule.this.quizBean, (Object)i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_EXITQUIZLIBRARYNOTSAVED), (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_CONFIRMEXIT), (int)0, (int)3);
                        switch (result) {
                            case 0: {
                                return 0;
                            }
                            case 1: {
                                return -1;
                            }
                        }
                    }
                } else {
                    QuizViewer viewer = QuizModule.this.quizBean.getQuizViewer();
                    if (viewer != null && viewer.getState() == 2) {
                        int result = ModalDialog.showConfirmDialog((Component)QuizModule.this.quizBean, (Object)i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_QUIZNOTHANDEDINONEXIT), (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_CONFIRMEXIT), (int)0, (int)3);
                        switch (result) {
                            case 0: {
                                return 0;
                            }
                            case 1: {
                                return -1;
                            }
                        }
                    }
                }
                return 0;
            }
        };
        this.imps.provideAPI(DisconnectQueryAPI.class, (ImpsAPI)discQuery);
    }

    public void installHook() {
        this.updateVisibility();
    }

    private void changeState() {
        boolean state = (Boolean)this.showMenuFeature.getValue();
        QuizDebug.info(this, "changeState(" + state + ")");
        if (!state && !this.quizBean.close(true)) {
            boolean bl = state = !state;
        }
        if (state) {
            String tip = i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_HIDETIP);
        } else {
            String tip = i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_SHOWTIP);
        }
        this.updateVisibility();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String nm = e.getPropertyName();
        if (nm.equals("chair")) {
            Chair chair = this.chairProtocol.fetchChair(this.clients);
            this.isChair = chair.isMe();
            this.publishFeatures(this.isChair);
        } else if (nm.equals("locked")) {
            this.showMenuFeature.setValue((Object)this.quizBean.isTesting());
        } else if (nm.equals("quizCount")) {
            this.canSave = (Integer)e.getNewValue() > 0;
        }
        this.updateVisibility();
    }

    public void connectionStatusChanged(ConnectionEvent e) {
        this.isConnected = e.getAction() == 2;
        this.updateVisibility();
    }

    private void updateVisibility() {
        if (this.forceShow || ((Boolean)this.showMenuFeature.getValue()).booleanValue()) {
            this.broker.addFeature((Feature)this.quizPanelFeature);
        } else {
            this.broker.removeFeature((Feature)this.quizPanelFeature);
        }
    }

    public boolean requestClose() {
        if (this.showMenuFeature.isEnabled()) {
            this.showMenuFeature.setValue((Object)false);
            this.updateVisibility();
            return true;
        }
        return false;
    }

    public QuizBean getQuizBean() {
        return this.quizBean;
    }

    public void createFeatures() {
        this.newQuizFeature = this.broker.createActionFeature((Object)this, "/quiz/menu/new", i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_QUIZMENU), i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_QUIZMENU));
        this.newQuizFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                QuizModule.this.quizBean.create();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        if (!((Boolean)QuizModule.this.showMenuFeature.getValue()).booleanValue()) {
                            QuizModule.this.showMenuFeature.setValue((Object)true);
                        }
                    }
                };
                QuizModule.this.swingRunner.invokeOnEventThread(r);
            }
        });
        this.openQuizFeature = this.broker.createActionFeature((Object)this, "/quiz/menu/open", i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_QUIZMENU), i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_QUIZMENU));
        this.openQuizFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                if (QuizModule.this.quizBean.load()) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            if (!((Boolean)QuizModule.this.showMenuFeature.getValue()).booleanValue()) {
                                QuizModule.this.showMenuFeature.setValue((Object)true);
                            }
                        }
                    };
                    QuizModule.this.swingRunner.invokeOnEventThread(r);
                }
            }
        });
        this.saveQuizFeature = this.broker.createActionFeature((Object)this, "/quiz/menu/save", i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_QUIZMENU), i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_QUIZMENU));
        this.saveQuizFeature.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                QuizModule.this.quizBean.save();
            }
        });
        this.showMenuFeature = this.broker.createBooleanFeature((Object)this, "/quiz/menu/show", true, false, i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_SHOWMENU), null);
        this.showMenuFeature.setTrueText(i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_SHOWMENU));
        this.showMenuFeature.setFalseText(i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_SHOWMENU));
        this.showMenuFeature.setValue((Object)false);
        this.showMenuFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                QuizModule.this.changeState();
            }
        });
        ArrayList<String> fileTypes = new ArrayList<String>();
        fileTypes.add("vcq");
        this.loadQuiz = this.broker.createLoadFeature((Object)this, "/quiz/loadQuiz", "Load Quiz", null);
        this.loadQuiz.setFileTypes(fileTypes);
        this.loadQuiz.setDefaultIcon(i18n.getImage((PropertiesEnum)StringsProperties.QUIZMODULE_LOADFEATUREICON));
        this.loadQuiz.addActionFeatureListener(new ActionFeatureListener(){

            public void actionPerformed(ActionFeatureEvent event) {
                ArrayList files = (ArrayList)event.getParameter("files");
                if (files != null) {
                    QuizModule.this.showMenuFeature.setValue((Object)true);
                    for (File file : files) {
                        ((QuizBean)QuizModule.this.beanProvider.get()).load(file);
                    }
                }
            }
        });
        this.quizPanelFeature = this.broker.createComponentFeature((Object)this, "/quiz/quizPanel", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return QuizModule.this.quizBean;
            }
        }, i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_TITLE), i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_TITLE));
    }

    private void publishFeatures(boolean publish) {
        this.broker.setFeaturePublished((Feature)this.newQuizFeature, publish);
        this.openQuizFeature.setEnabled(publish);
        this.broker.setFeaturePublished((Feature)this.openQuizFeature, true);
        this.broker.setFeaturePublished((Feature)this.saveQuizFeature, publish);
        this.broker.setFeaturePublished((Feature)this.showMenuFeature, publish);
        this.broker.setFeaturePublished((Feature)this.loadQuiz, publish);
    }

    public void start() {
    }

    public void attach() {
        this.clients = this.clientProvider.get().getClientList();
        this.quizBean = (QuizBean)this.beanProvider.get();
        this.quizBean.configure();
        this.quizBean.addPropertyChangeListener("locked", this);
        this.quizBean.addPropertyChangeListener("quizCount", this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clientProvider.get().addConnectionListener((ConnectionListener)this);
        this.setDisconnectQueryAPI();
        this.confEngine.registerCommand(this.loadQuizCmdProvider);
        this.confEngine.registerCommand(this.startQuizCmdProvider);
        this.confEngine.registerCommand(this.stopQuizCmdProvider);
        this.imps.provideAPI(DocumentHandlingAPI.class, (ImpsAPI)new DocumentHandler());
        this.imps.provideAPI(QuizModelAPI.class, (ImpsAPI)new ModelAPI());
    }

    public void setupUI() {
        try {
            this.quizBean.initUI();
        }
        catch (Exception e) {
            LogSupport.exception((Object)this, (String)"QuizBean", (Throwable)e, (boolean)true);
        }
        this.createFeatures();
        boolean isChair = this.chairProtocol.fetchChair(this.clients).isMe();
        this.publishFeatures(isChair);
    }

    public void cleanupUI() {
    }

    public void detach() {
        if (this.clients != null) {
            this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
            this.clients = null;
        }
        this.quizBean.removePropertyChangeListener("locked", this);
        this.quizBean.removePropertyChangeListener("quizCount", this);
        this.quizBean.dispose();
        this.quizBean = null;
    }

    public void stop() {
    }

    private class DocumentHandler
    implements DocumentHandlingAPI {
        private DocumentHandler() {
        }

        public String getProvider() {
            return QuizModule.MODULE_NAME;
        }

        public byte getTier() {
            return 32;
        }

        public boolean closeDocuments() {
            if (!QuizModule.this.quizBean.close(false)) {
                return false;
            }
            QuizLib lib = QuizModule.this.quizBean.getQuizLib();
            if (!lib.isModified() || lib.size() == 0) {
                return true;
            }
            int result = ModalDialog.showConfirmDialog((Component)QuizModule.this.quizBean, (Object)i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_MODIFIEDEXIT), (String)i18n.getString((PropertiesEnum)StringsProperties.QUIZMODULE_CONFIRMEXIT), (int)1, (int)3);
            switch (result) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            return QuizModule.this.quizBean.save();
        }

        public boolean openDocument(File file) {
            return QuizModule.this.quizBean.load(file);
        }

        public void newDocument() {
            QuizModule.this.quizBean.create();
        }
    }

    private class ModelAPI
    implements QuizModelAPI {
        private ModelAPI() {
        }

        public String getProvider() {
            return QuizModule.MODULE_NAME;
        }

        public byte getTier() {
            return 32;
        }

        public com.elluminate.groupware.imps.quiz.Quiz[] readQuizLibrary(File file) throws IOException {
            return this.readQuizLibrary(file.toURL());
        }

        public com.elluminate.groupware.imps.quiz.Quiz[] readQuizLibrary(URL url) throws IOException {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(url.openStream());
                ArrayList<QuizImpl> list = new ArrayList<QuizImpl>();
                Document doc = new SAXBuilder().build((InputStream)in);
                try {
                    Element root = doc.getRootElement();
                    if (!root.getName().equals("quizzes")) {
                        throw new IOException("Not a quiz library: " + root.getName());
                    }
                    for (Element e : root.getChildren("quiz")) {
                        Quiz q = new Quiz();
                        q.readXML(url.toString(), e);
                        q.validate();
                        if (q.getDateGiven() != null) {
                            q.computeStats();
                        }
                        list.add(new QuizImpl(q));
                    }
                }
                catch (QuizException ex) {
                    throw new IOException("Bad quiz file: " + url.toString());
                }
                com.elluminate.groupware.imps.quiz.Quiz[] quizArray = list.toArray(new com.elluminate.groupware.imps.quiz.Quiz[0]);
                return quizArray;
            }
            catch (Exception ex) {
                throw new IOException(ex.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }

        private class QuizImpl
        implements com.elluminate.groupware.imps.quiz.Quiz {
            private Quiz quiz;

            public QuizImpl(Quiz quiz) {
                this.quiz = quiz;
            }

            public String getName() {
                return this.quiz.getText();
            }
        }
    }
}

