/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.module.JinxTerminal;
import com.elluminate.groupware.quiz.Quiz;
import com.elluminate.groupware.quiz.QuizException;
import com.elluminate.groupware.quiz.QuizLib;
import com.elluminate.groupware.quiz.QuizLibEvent;
import com.elluminate.groupware.quiz.QuizLibListener;
import com.elluminate.groupware.quiz.QuizMessage;
import com.elluminate.groupware.quiz.QuizProtocol;
import com.elluminate.groupware.quiz.Responses;
import com.elluminate.groupware.quiz.module.QuizDebug;
import com.elluminate.groupware.quiz.module.QuizDesigner;
import com.elluminate.groupware.quiz.module.QuizFileFilter;
import com.elluminate.groupware.quiz.module.QuizLibrary;
import com.elluminate.groupware.quiz.module.QuizManager;
import com.elluminate.groupware.quiz.module.QuizModule;
import com.elluminate.groupware.quiz.module.QuizPublisher;
import com.elluminate.groupware.quiz.module.QuizSaveDialog;
import com.elluminate.groupware.quiz.module.QuizViewer;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.CFileChooser;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.ConnectionEvent;
import com.elluminate.jinx.ConnectionListener;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

@Singleton
public class QuizBean
extends JPanel
implements QuizManager,
ConnectionListener,
ClientListener,
ChannelListener,
ChannelDataListener,
PropertyChangeListener,
QuizLibListener {
    private I18n i18n;
    private static QuizFileFilter fileFilter = new QuizFileFilter();
    private static final String LIBRARY_CARD = "library";
    private static final String DESIGN_CARD = "design";
    private static final String VIEW_CARD = "view";
    public static final String TESTING_PROP = "testing";
    public static final String LOCKED_PROP = "locked";
    public static final String QUIZ_COUNT_PROP = "quizCount";
    private QuizLib lib = new QuizLib(-1L);
    private Quiz editing = null;
    private Quiz viewing = null;
    private boolean testing = false;
    private boolean locked = false;
    private int quizCount = 0;
    private File last = null;
    private QuizPublisher msgPublisher;
    CardLayout quizLayout = new CardLayout();
    QuizLibrary libraryPanel = new QuizLibrary(this.lib);
    QuizDesigner designPanel = new QuizDesigner();
    QuizViewer viewPanel = new QuizViewer();
    private ClientList clients;
    private QuizModule quizModule;
    private ChairProtocol chairProtocol;
    protected JinxTerminal terminal;
    private ClientProvider clientProvider;
    private DialogParentProvider parentProv;

    @Inject
    public QuizBean(QuizModule quizModule, JinxTerminal terminal, I18n i18n) {
        this.quizModule = quizModule;
        this.terminal = terminal;
        terminal.setProtocol((JinxProtocol)new QuizProtocol());
        terminal.addProtocolPropertyListeners((PropertyChangeListener)this);
        terminal.createChannels((ChannelListener)this, (ChannelDataListener)this);
        this.i18n = i18n;
        this.clients = terminal.getClientList();
        this.clients.addClientListener((ClientListener)this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.viewPanel.setClients(this.clients);
    }

    void configure() {
        this.clientProvider.get().addConnectionListener((ConnectionListener)this);
        this.lib.addQuizLibListener((QuizLibListener)this);
    }

    void initUI() throws Exception {
        this.viewPanel.setManager(this);
        this.designPanel.setManager(this);
        this.libraryPanel.setManager(this);
        this.setLayout(this.quizLayout);
        this.add((Component)this.libraryPanel, LIBRARY_CARD);
        this.add((Component)this.designPanel, DESIGN_CARD);
        this.add((Component)this.viewPanel, VIEW_CARD);
        this.quizLayout.show(this, LIBRARY_CARD);
    }

    public void dispose() {
        this.terminal.removeProtocolPropertyListeners((PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        this.clients.removeClientListener((ClientListener)this);
        this.clients = null;
    }

    @Inject
    public void initQuizPublisher(QuizPublisher pub) {
        this.msgPublisher = pub;
    }

    @Inject
    public void initChairProtocol(ChairProtocol chairProtocol) {
        this.chairProtocol = chairProtocol;
    }

    @Inject
    protected void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
        QuizDebug.info("initClientProvider: " + clientProvider);
    }

    @Inject
    protected void initParentProvider(DialogParentProvider parentProv) {
        this.parentProv = parentProv;
    }

    public QuizViewer getQuizViewer() {
        return this.viewPanel;
    }

    public QuizLib getQuizLib() {
        return this.lib;
    }

    public Quiz getViewedQuiz() {
        return this.viewing;
    }

    public boolean isTesting() {
        return this.testing;
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void create() {
        if (this.testing) {
            ModalDialog.showMessageDialog((Component)this.getAppFrame(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_NEWDURINGTEST), (String)this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_UNAVAILABLE), (int)0);
            return;
        }
        if (this.editing != null && !this.designPanel.finish(true)) {
            return;
        }
        this.editing = new Quiz();
        this.designPanel.setQuiz(this.editing);
        this.quizLayout.show(this, DESIGN_CARD);
    }

    public boolean isEditingModifiedQuiz() {
        return this.editing != null && this.designPanel.isModified();
    }

    public boolean close(boolean confirm) {
        if (this.editing != null) {
            boolean result = this.designPanel.finish(confirm);
            if (result) {
                this.editing = null;
            }
            return result;
        }
        if (this.testing) {
            return false;
        }
        if (this.viewing != null) {
            this.release(this.viewing);
            return true;
        }
        return true;
    }

    @Override
    public void delete(Quiz q) {
        if (this.clientProvider.get() == null || !this.getChannel().isUp()) {
            try {
                this.lib.remove(q.getID(), (short)-32767);
            }
            catch (QuizException ex) {
                LogSupport.exception((Object)this, (String)"delete", (Throwable)ex, (boolean)true);
            }
        } else {
            QuizMessage msg = new QuizMessage();
            msg.setID(q.getID());
            this.sendMessage((byte)5, msg);
        }
    }

    @Override
    public boolean load() {
        if (this.testing) {
            ModalDialog.showMessageDialog((Component)this.getAppFrame(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_LOADDURINGTEST), (String)this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_UNAVAILABLE), (int)0);
            return false;
        }
        if (this.editing != null && !this.designPanel.finish(true)) {
            return false;
        }
        if (this.last == null) {
            this.last = new File(System.getProperty("user.home"));
        }
        CFileChooser chooser = new CFileChooser(this.last);
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        String suffix = fileFilter.getSuffix();
        chooser.setFileFilter(fileFilter);
        if (chooser.showOpenDialog(this.getAppFrame()) != 0) {
            return false;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return false;
        }
        if (!file.isDirectory() && !suffix.equalsIgnoreCase(FileSysUtils.getExtension((File)file))) {
            file = new File(file.toString() + "." + suffix);
        }
        return this.load(file);
    }

    public boolean load(File file) {
        this.last = new File(file.getParent());
        this.quizLayout.show(this, LIBRARY_CARD);
        return this.libraryPanel.load(file);
    }

    @Override
    public void loadRemotely(String fileURL) {
        QuizMessage msg = new QuizMessage();
        msg.setFileURL(fileURL);
        this.sendMessage((byte)6, msg);
    }

    @Override
    public boolean save() {
        int response;
        ArrayList quizzes = this.lib.getQuizzes();
        ArrayList selected = null;
        if (quizzes == null || quizzes.isEmpty()) {
            ModalDialog.showMessageDialog((Component)this.getAppFrame(), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_NOQUIZZESTOSAVE), (String)this.i18n.getString((PropertiesEnum)StringsProperties.QUIZSAVEDIALOG_TITLE), (int)0);
            return true;
        }
        selected = QuizSaveDialog.showDialog(this.getAppFrame(), this.i18n.getString((PropertiesEnum)StringsProperties.QUIZSAVEDIALOG_TITLE), quizzes);
        if (selected == null) {
            return false;
        }
        if (this.last == null) {
            this.last = new File(System.getProperty("user.home"));
        }
        CFileChooser chooser = new CFileChooser(this.last);
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        String suffix = "." + fileFilter.getSuffix();
        chooser.setFileFilter(fileFilter);
        if (chooser.showSaveDialog(this.getAppFrame()) != 0) {
            return false;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return false;
        }
        if (!file.isDirectory() && !file.getName().endsWith(suffix)) {
            file = new File(file.toString() + suffix);
        }
        this.last = new File(file.getParent());
        if (file.exists() && (response = JOptionPane.showConfirmDialog(this.getAppFrame(), this.i18n.getString((PropertiesEnum)StringsProperties.QUIZSAVE_OVERWRITEWARNING, new Object[]{file.getName()}), this.i18n.getString((PropertiesEnum)StringsProperties.QUIZSAVE_OVERWRITEDIALOGTITLE), 0)) == 1) {
            return this.save();
        }
        this.libraryPanel.save(selected, file);
        return true;
    }

    @Override
    public void edit(Quiz q) {
        if (q.hasDateGiven() || this.clientProvider.get() == null || !this.getChannel().isUp()) {
            this.editing = (Quiz)q.clone(false);
            if (!q.hasDateGiven()) {
                this.editing.setID(q.getID());
            }
            this.designPanel.setQuiz(this.editing);
            this.quizLayout.show(this, DESIGN_CARD);
        } else {
            QuizMessage msg = new QuizMessage();
            msg.setID(q.getID());
            this.sendMessage((byte)2, msg);
        }
    }

    @Override
    public void view(Quiz q) {
        this.viewing = q;
        this.viewPanel.setQuiz(q);
        this.viewPanel.setState((short)0);
        this.quizLayout.show(this, VIEW_CARD);
    }

    @Override
    public void release(Quiz q) {
        if (q != null) {
            if (q == this.editing) {
                if (this.clientProvider.get() != null && this.getChannel().isUp() && q.getID() > 0L) {
                    QuizMessage msg = new QuizMessage();
                    msg.setID(q.getID());
                    this.sendMessage((byte)3, msg);
                }
                this.editing = null;
            } else if (q == this.viewing) {
                if (this.testing && this.clientProvider.get() != null && this.getChannel().isUp()) {
                    QuizMessage msg = new QuizMessage();
                    msg.setID(q.getID());
                    this.sendMessage((byte)39, msg);
                }
                this.viewing = null;
            }
        }
        if (this.viewing != null) {
            this.quizLayout.show(this, VIEW_CARD);
        } else {
            this.quizLayout.show(this, LIBRARY_CARD);
        }
    }

    @Override
    public void update(Quiz q) {
        if (this.clientProvider.get() != null && this.getChannel().isUp()) {
            byte cmd;
            QuizMessage msg = new QuizMessage();
            if (q.getID() == 0L) {
                msg.setQuiz(q);
                cmd = 1;
            } else {
                msg.setQuiz(q);
                cmd = 4;
            }
            this.sendMessage(cmd, msg);
        } else {
            try {
                if (q.getID() == 0L) {
                    this.lib.add(q);
                } else {
                    if (q.getID() > 0L) {
                        long id = this.lib.getNextID();
                        this.lib.changeID(q.getID(), id);
                        q.setID(id);
                    }
                    this.lib.acquire(q.getID(), (short)-32767);
                    this.lib.update(q.getID(), (short)-32767, q);
                }
            }
            catch (QuizException ex) {
                LogSupport.exception((Object)this, (String)"update", (Throwable)ex, (boolean)true);
                return;
            }
        }
        this.editing = null;
        if (this.viewing != null) {
            this.quizLayout.show(this, VIEW_CARD);
        } else {
            this.quizLayout.show(this, LIBRARY_CARD);
        }
    }

    @Override
    public void start(Quiz q, long timeLimit) {
        if (this.clientProvider.get() != null && this.clientProvider.get().isConnected()) {
            QuizMessage msg = new QuizMessage();
            msg.setQuiz(q);
            if (timeLimit > 0L) {
                msg.setTimeLimit(timeLimit);
            }
            this.sendMessage((byte)33, msg, (short)271);
        }
    }

    @Override
    public void stop(Quiz q) {
        if (this.clientProvider.get() != null && this.clientProvider.get().isConnected()) {
            QuizMessage msg = new QuizMessage();
            msg.setQuiz(q);
            this.sendMessage((byte)35, msg, (short)1);
        }
    }

    @Override
    public void handIn(Quiz q, boolean force) {
        if (!force) {
            String msg;
            Responses resp = q.getResponsesFor(q.getMyName());
            short answered = 0;
            if (resp != null) {
                answered = resp.getResponseCount();
            }
            if (ModalDialog.showConfirmDialog((Component)this, (Object)(msg = answered < q.getQuestionCount() ? this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_PARTIALHANDINCONFIRM, new Object[]{new Integer(answered), new Integer(q.getQuestionCount())}) : this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_COMPLETEHANDINCONFIRM)), (String)this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_HANDINTITLE), (int)0, (int)3) != 0) {
                return;
            }
            String handInMsg = this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_QUIZ_HANDED_IN_MSG);
            this.msgPublisher.sendQuizHandedInMessage(handInMsg, true);
        }
        if (this.clientProvider.get() != null && this.clientProvider.get().isConnected()) {
            QuizMessage msg = new QuizMessage();
            Responses resp = q.getResponsesFor(q.getMyName());
            if (resp == null) {
                resp = new Responses(q.getMyName());
            }
            resp.setComplete(true);
            msg.setResponse(resp);
            msg.setID(q.getID());
            this.sendMessage((byte)36, msg);
            this.viewPanel.setState((short)3);
        }
    }

    @Override
    public void checkpoint(Quiz q) {
        if (this.clientProvider.get() != null && this.clientProvider.get().isConnected()) {
            QuizMessage msg = new QuizMessage();
            Responses resp = q.getResponsesFor(q.getMyName());
            if (resp == null) {
                return;
            }
            msg.setResponse(resp);
            msg.setID(q.getID());
            this.sendMessage((byte)36, msg);
        }
    }

    @Override
    public void review(Quiz q) {
        if (this.clientProvider.get() != null && this.clientProvider.get().isConnected()) {
            QuizMessage msg = new QuizMessage();
            msg.setQuiz(q);
            this.sendMessage((byte)38, msg, (short)1);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("chair")) {
            boolean now = new Chair((Connection)this.clientProvider.get(), e.getNewValue()).isMe();
            boolean was = new Chair((Connection)this.clientProvider.get(), e.getOldValue()).isMe();
            class ChairChangeUI
            implements Runnable {
                boolean was;
                boolean now;

                public ChairChangeUI(boolean was, boolean now) {
                    this.was = was;
                    this.now = now;
                }

                @Override
                public void run() {
                    try {
                        if (!this.was && this.now) {
                            QuizBean.this.viewPanel.setMyName(QuizBean.this.clients.getMyName());
                            QuizBean.this.viewPanel.setView((byte)3);
                            if (QuizBean.this.testing) {
                                if (!QuizBean.this.locked) {
                                    QuizBean.this.setLocked(true);
                                }
                                QuizBean.this.quizLayout.show(QuizBean.this, QuizBean.VIEW_CARD);
                            } else {
                                QuizBean.this.quizLayout.show(QuizBean.this, QuizBean.LIBRARY_CARD);
                            }
                        } else if (this.was && !this.now) {
                            QuizBean.this.lib.clear();
                            QuizBean.this.editing = null;
                            if (!QuizBean.this.testing) {
                                QuizBean.this.viewing = null;
                            }
                            QuizBean.this.viewPanel.setView((byte)2);
                            QuizBean.this.quizLayout.show(QuizBean.this, QuizBean.VIEW_CARD);
                        }
                        if (QuizBean.this.clientProvider.get().isPlayback()) {
                            QuizBean.this.viewPanel.setView((byte)1);
                        }
                    }
                    catch (Exception e) {
                        QuizDebug.info(this, "Quiz error: " + e.getMessage());
                        return;
                    }
                }
            }
            SwingRunnerSupport.invokeLater((Runnable)new ChairChangeUI(was, now));
        }
    }

    public void connectionStatusChanged(ConnectionEvent e) {
        boolean connected = e.getAction() == 2;
        class ConnectionStateUI
        implements Runnable {
            boolean up;

            public ConnectionStateUI(boolean isUp) {
                this.up = isUp;
            }

            @Override
            public void run() {
                QuizBean.this.editing = null;
                QuizBean.this.designPanel.setQuiz(null);
                QuizBean.this.viewing = null;
                QuizBean.this.viewPanel.setQuiz(null);
                QuizBean.this.setTesting(false);
                QuizBean.this.setLocked(false);
                QuizBean.this.lib.clear();
                if (this.up) {
                    QuizBean.this.viewPanel.setMyName(QuizBean.this.clients.getMyName());
                    if (QuizBean.this.clientProvider.get().isPlayback()) {
                        QuizBean.this.viewPanel.setView((byte)1);
                    } else {
                        QuizBean.this.viewPanel.setView((byte)2);
                    }
                    QuizBean.this.quizLayout.show(QuizBean.this, QuizBean.VIEW_CARD);
                } else {
                    QuizBean.this.viewPanel.setMyName(null);
                    QuizBean.this.viewPanel.setView((byte)1);
                    QuizBean.this.quizLayout.show(QuizBean.this, QuizBean.LIBRARY_CARD);
                }
            }
        }
        SwingRunnerSupport.invokeLater((Runnable)new ConnectionStateUI(connected));
    }

    public void onChannelData(ChannelDataEvent e) {
        class ChannelDataUI
        implements Runnable {
            ChannelDataEvent e;

            public ChannelDataUI(ChannelDataEvent e) {
                this.e = (ChannelDataEvent)e.clone();
            }

            @Override
            public void run() {
                switch (this.e.getCommand()) {
                    case 1: {
                        QuizBean.this.onLibAdd(this.e);
                        break;
                    }
                    case 5: {
                        QuizBean.this.onLibDel(this.e);
                        break;
                    }
                    case 4: {
                        QuizBean.this.onLibMod(this.e);
                        break;
                    }
                    case 33: {
                        QuizBean.this.onHandOut(this.e);
                        break;
                    }
                    case 34: {
                        QuizBean.this.onStart(this.e);
                        break;
                    }
                    case 36: {
                        QuizBean.this.onResponse(this.e);
                        break;
                    }
                    case 37: {
                        QuizBean.this.onHandIn(this.e);
                        break;
                    }
                    case 35: {
                        QuizBean.this.onStop(this.e);
                        break;
                    }
                    case 38: {
                        QuizBean.this.onReview(this.e);
                        break;
                    }
                    case 39: {
                        QuizBean.this.onClose(this.e);
                        break;
                    }
                    case 80: {
                        QuizBean.this.ack(this.e);
                        break;
                    }
                    case 96: {
                        QuizBean.this.nack(this.e);
                        break;
                    }
                    case 97: {
                        QuizBean.this.nack(this.e);
                        break;
                    }
                    case 98: {
                        QuizBean.this.nack(this.e);
                        break;
                    }
                    case 99: {
                        QuizBean.this.nack(this.e);
                        break;
                    }
                    case 100: {
                        QuizBean.this.nack(this.e);
                        break;
                    }
                    case 101: {
                        QuizBean.this.nack(this.e);
                        break;
                    }
                    case 102: {
                        QuizBean.this.nack(this.e);
                        break;
                    }
                    case 103: {
                        QuizBean.this.nack(this.e);
                    }
                }
                this.e.dispose();
            }
        }
        SwingRunnerSupport.invokeLater((Runnable)new ChannelDataUI(e));
    }

    private void onLibAdd(ChannelDataEvent e) {
        QuizMessage msg = new QuizMessage(e);
        Quiz quiz = msg.getQuiz();
        this.lib.add(quiz, msg.getID());
        if (quiz.getDateGiven() != null) {
            quiz.computeStats();
        }
        if (this.viewing != null && msg.getID() == this.viewing.getID()) {
            this.viewing = quiz;
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    QuizBean.this.viewPanel.setQuiz(QuizBean.this.viewing);
                }
            });
        }
    }

    private void onLibDel(ChannelDataEvent e) {
        QuizMessage msg = new QuizMessage(e);
        try {
            this.lib.remove(msg.getID(), (short)0);
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"onLibDel", (Throwable)ex, (boolean)true);
        }
    }

    private void onLibMod(ChannelDataEvent e) {
        QuizMessage msg = new QuizMessage(e);
        try {
            this.lib.acquire(msg.getID(), (short)0);
            this.lib.update(msg.getID(), (short)0, msg.getQuiz());
        }
        catch (QuizException ex) {
            LogSupport.exception((Object)this, (String)"onLibMod", (Throwable)ex, (boolean)true);
        }
    }

    private void onHandOut(ChannelDataEvent e) {
        QuizMessage msg = new QuizMessage(e);
        Responses resp = msg.getResponse();
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        this.viewing = msg.getQuiz();
        if (resp != null && resp.getResponseOwner().equals(this.clients.getMyName())) {
            this.viewing.setResponsesFor(resp.getResponseOwner(), resp);
        }
        this.viewPanel.setMyName(this.clients.getMyName());
        try {
            if (this.viewPanel.getView() == 3) {
                this.lib.acquire(this.viewing.getID(), (short)0);
                this.lib.update(this.viewing.getID(), (short)0, this.viewing);
            }
        }
        catch (QuizException ex) {
            LogSupport.exception((Object)this, (String)"onStart", (Throwable)ex, (boolean)true);
        }
        if (this.editing == null) {
            this.quizLayout.show(this, VIEW_CARD);
        }
        this.viewPanel.setQuiz(this.viewing);
        this.viewPanel.setState((short)1);
        this.setTesting(true);
        if (chair.isMe()) {
            this.setLocked(true);
        }
        QuizMessage reply = new QuizMessage();
        reply.setID(this.viewing.getID());
        reply.setRequest((byte)33);
        this.sendMessage((byte)80, reply);
    }

    private void onStart(ChannelDataEvent e) {
        QuizMessage msg = new QuizMessage(e);
        this.msgPublisher.sendQuizStartedMessage(this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_QUIZ_STARTED_MSG, new Object[]{msg.getDesc()}), this.chairProtocol.fetchChair(this.clients).isMe());
        this.viewPanel.setState((short)2);
        if (msg.hasTimeLimit()) {
            this.viewPanel.setTimeLimit(msg.getTimeLimit(), msg.getTimeLeft());
        }
        this.setLocked(true);
    }

    private void onResponse(ChannelDataEvent e) {
        QuizMessage msg = new QuizMessage(e);
        Responses resp = msg.getResponse();
        short src = e.getSourceAddress();
        ClientInfo ci = this.clients.get(src);
        if (e.getSourceAddress() != 0) {
            LogSupport.error((String)("Response message received from other than the server (" + (ci == null ? Short.toString(src) : ci.getDisplayName()) + ")"));
            return;
        }
        if (this.viewing != null && this.viewing.getID() == msg.getID()) {
            this.viewing.setResponsesFor(resp.getResponseOwner(), resp);
            this.viewing.computeStats();
        }
        try {
            Quiz quiz = this.lib.get(msg.getID());
            if (quiz != this.viewing) {
                quiz.setResponsesFor(resp.getResponseOwner(), resp);
                quiz.computeStats();
            }
            if (resp.isComplete()) {
                String handInMsg = this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_QUIZ_COMPLETED_MSG, new Object[]{resp.getResponseOwner(), quiz.getText()});
                this.msgPublisher.sendQuizHandedInMessage(handInMsg, true);
            }
        }
        catch (QuizException ex) {
            LogSupport.error((String)("Response message received for quiz " + msg.getID() + ", not found in the library."));
        }
    }

    private void onHandIn(ChannelDataEvent e) {
        this.handIn(this.viewPanel.getQuiz(), true);
        this.viewPanel.setTimeLimit(-1L, -1L);
    }

    private void onStop(ChannelDataEvent e) {
        if (this.viewing == null) {
            return;
        }
        this.msgPublisher.sendQuizStoppedMessage(this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_QUIZ_STOPPED_MSG), this.chairProtocol.fetchChair(this.clients).isMe());
        this.viewPanel.setState((short)4);
        this.viewPanel.setTimeLimit(-1L, -1L);
    }

    private void onReview(ChannelDataEvent e) {
        if (this.viewing == null) {
            return;
        }
        QuizMessage msg = new QuizMessage(e);
        Quiz quiz = msg.getQuiz();
        this.viewing.mergeStats(quiz);
        this.viewing.mergeCorrectResponses(quiz);
        this.viewPanel.setState((short)5);
    }

    private void onClose(ChannelDataEvent e) {
        Chair chair = this.chairProtocol.fetchChair(this.clients);
        if (chair.isMe()) {
            this.viewPanel.setState((short)0);
            this.viewing = null;
            this.release(this.viewing);
        } else {
            this.viewing = null;
        }
        this.setTesting(false);
        this.setLocked(false);
    }

    private void ack(ChannelDataEvent e) {
        QuizMessage msg = new QuizMessage(e);
        byte req = msg.getRequest();
        long id = msg.getID();
        if (req == 2) {
            try {
                this.editing = (Quiz)this.lib.get(id).clone(false);
                this.editing.setID(id);
                this.designPanel.setQuiz(this.editing);
                this.quizLayout.show(this, DESIGN_CARD);
            }
            catch (Exception ex) {
                LogSupport.exception((Object)this, (String)"ack", (Throwable)ex, (boolean)true);
            }
        }
    }

    private void nack(ChannelDataEvent e) {
        QuizMessage msg = new QuizMessage(e);
        QuizException ex = msg.getException();
        ex.setClientList(this.clients);
        ModalDialog.showMessageDialog((Component)this.getAppFrame(), (Object)ex.toString(), (String)this.i18n.getString((PropertiesEnum)StringsProperties.QUIZBEAN_OPFAILED), (int)0);
        this.viewPanel.setState(this.viewPanel.getState());
    }

    private void sendMessage(byte cmd, QuizMessage msg) {
        this.sendMessage(cmd, msg, (short)4095);
    }

    private void sendMessage(byte cmd, QuizMessage msg, short mask) {
        ChannelDataEvent dataEvent = ChannelDataEvent.getInstance((Object)this, (short)0, (byte)cmd);
        if (msg.encode(dataEvent, mask)) {
            this.terminal.fireChannelData(dataEvent);
        }
    }

    public void libraryChanged(QuizLibEvent e) {
        int old = this.quizCount;
        this.quizCount = this.lib.size();
        if (old != this.quizCount) {
            this.firePropertyChange(QUIZ_COUNT_PROP, old, this.quizCount);
        }
    }

    private void setLocked(boolean newState) {
        boolean oldState = this.locked;
        this.locked = newState;
        this.firePropertyChange(LOCKED_PROP, oldState, newState);
        this.designPanel.doneBtn.setEnabled(!this.locked);
    }

    private void setTesting(boolean newState) {
        boolean oldState = this.testing;
        this.testing = newState;
        this.firePropertyChange(TESTING_PROP, oldState, newState);
    }

    public Channel getChannel() {
        return this.terminal != null ? this.terminal.getChannel() : null;
    }

    @Override
    public Frame getAppFrame() {
        return this.parentProv.getDialogParent();
    }

    public void onAddClient(ClientEvent e) {
    }

    public void onRemoveClient(ClientEvent e) {
    }

    public void channelStateChanged(ChannelEvent event) {
    }
}

