/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Answer;
import com.elluminate.groupware.quiz.Question;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.groupware.quiz.Response;
import com.elluminate.groupware.quiz.Responses;
import com.elluminate.groupware.quiz.module.MultipleChoiceLine;
import com.elluminate.groupware.quiz.module.NoAnswerLine;
import com.elluminate.groupware.quiz.module.QuestionLine;
import com.elluminate.groupware.quiz.module.QuizLine;
import com.elluminate.groupware.quiz.module.ShortAnswerLine;
import com.elluminate.groupware.quiz.module.StringsProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class QuestionPanel
extends JPanel
implements Scrollable,
QuizListener {
    public static final int QUESTION_FOCUS = -1;
    private static I18n i18n = I18n.create(QuestionPanel.class);
    private int QUESTION_LINE = 0;
    private int SHORT_ANSWER_LINE = 1;
    private int MULTIPLE_CHOICE_START = 2;
    private int NO_ANSWER_LINE = 3;
    static ImageIcon questionIcon = i18n.getIcon("QuestionPanel.questionIcon");
    static ImageIcon wrongIcon = i18n.getIcon("QuestionPanel.wrongIcon");
    static ImageIcon rightIcon = i18n.getIcon("QuestionPanel.rightIcon");
    static ImageIcon unknownIcon = i18n.getIcon("QuestionPanel.unknownIcon");
    static ImageIcon selIcon = i18n.getIcon("QuestionPanel.selectedIcon");
    static ImageIcon unselIcon = i18n.getIcon("QuestionPanel.unselectedIcon");
    static ImageIcon blankIcon = i18n.getIcon("QuestionPanel.blankIcon");
    static ImageIcon upIcon = i18n.getIcon("QuestionPanel.upIcon");
    static ImageIcon downIcon = i18n.getIcon("QuestionPanel.downIcon");
    static ImageIcon deleteIcon = i18n.getIcon("QuestionPanel.deleteIcon");
    static String noAnswer = i18n.getString((PropertiesEnum)StringsProperties.QUESTIONPANEL_NOANSWER);
    static String newAnswer = i18n.getString((PropertiesEnum)StringsProperties.QUESTIONPANEL_NEWANSWER);
    static String yourAnswer = i18n.getString((PropertiesEnum)StringsProperties.QUESTIONPANEL_YOURANSWER);
    static String correctAnswer = i18n.getString((PropertiesEnum)StringsProperties.QUESTIONPANEL_CORRECTANSWER);
    static String upTip = i18n.getString((PropertiesEnum)StringsProperties.QUESTIONPANEL_UPTIP);
    static String downTip = i18n.getString((PropertiesEnum)StringsProperties.QUESTIONPANEL_DOWNTIP);
    static String deleteTip = i18n.getString((PropertiesEnum)StringsProperties.QUESTIONPANEL_DELETETIP);
    static String statsFmt = i18n.getString((PropertiesEnum)StringsProperties.QUESTIONPANEL_STATS);
    private int mode = 0;
    private Question question = null;
    private ArrayList lines = null;

    public QuestionPanel() {
        this(0);
    }

    public QuestionPanel(int mode) {
        super(new GridBagLayout(), true);
        this.setBackground(Color.white);
        this.setMode(mode);
    }

    public Question getQuestion() {
        return this.question;
    }

    public void setQuestion(Question q) {
        if (this.question != null) {
            this.question.removeQuizListener((QuizListener)this);
        }
        this.question = q;
        if (this.question != null) {
            this.question.addQuizListener((QuizListener)this);
        }
        this.updateLines();
    }

    public void setMode(int newMode) {
        this.mode = newMode;
        if (this.lines == null) {
            return;
        }
        for (QuizLine line : this.lines) {
            line.setMode(newMode);
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setFocus(int idx) {
        if (idx == -1) {
            this.getQuestionLine().setFocus();
        } else if (this.question.isMultipleChoice()) {
            this.getMultipleChoiceLine(idx).setFocus();
        } else {
            this.getShortAnswerLine().setFocus();
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(600, 400);
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rect, int orientation, int dir) {
        return 16;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rect, int orientation, int dir) {
        return rect.height - 16;
    }

    private void updateLines() {
        if (this.lines == null) {
            this.lines = new ArrayList(10);
            this.lines.add(new QuestionLine(this, 0, this.mode));
            this.lines.add(new ShortAnswerLine(this, 1, this.mode));
            this.lines.add(new MultipleChoiceLine(this, 2, this.mode));
            this.lines.add(new NoAnswerLine(this, 3, this.mode));
        }
        if (this.question == null) {
            this.getQuestionLine().setQuestion(null);
            this.getNoAnswerLine().setQuestion(null);
            this.getShortAnswerLine().setAnswer(null);
            for (int i = 0; i < this.getMultipleChoiceCount(); ++i) {
                this.getMultipleChoiceLine(i).setAnswer(null);
            }
        } else {
            boolean mc = this.question.isMultipleChoice();
            boolean sa = this.question.isShortAnswer();
            this.getQuestionLine().setQuestion(this.question);
            this.getNoAnswerLine().setQuestion(this.question);
            this.getShortAnswerLine().setAnswer(sa ? this.question.getAnswer((short)0) : null);
            while (this.question.getAnswerCount() > this.getMultipleChoiceCount()) {
                this.addMultipleChoiceLine();
            }
            for (short i = 0; i < this.getMultipleChoiceCount(); i = (short)((short)(i + 1))) {
                if (mc && i < this.question.getAnswerCount()) {
                    this.getMultipleChoiceLine(i).setAnswer(this.question.getAnswer(i));
                    continue;
                }
                this.getMultipleChoiceLine(i).setAnswer(null);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private QuestionLine getQuestionLine() {
        if (this.lines == null) {
            this.updateLines();
        }
        return (QuestionLine)this.lines.get(this.QUESTION_LINE);
    }

    private ShortAnswerLine getShortAnswerLine() {
        if (this.lines == null) {
            this.updateLines();
        }
        return (ShortAnswerLine)this.lines.get(this.SHORT_ANSWER_LINE);
    }

    private MultipleChoiceLine getMultipleChoiceLine(int idx) {
        if (this.lines == null) {
            this.updateLines();
        }
        return (MultipleChoiceLine)this.lines.get(idx + this.MULTIPLE_CHOICE_START);
    }

    private int getMultipleChoiceCount() {
        return this.NO_ANSWER_LINE - this.MULTIPLE_CHOICE_START;
    }

    private NoAnswerLine getNoAnswerLine() {
        if (this.lines == null) {
            this.updateLines();
        }
        return (NoAnswerLine)this.lines.get(this.NO_ANSWER_LINE);
    }

    private void addMultipleChoiceLine() {
        this.lines.add(this.NO_ANSWER_LINE, new MultipleChoiceLine(this, this.NO_ANSWER_LINE, this.mode));
        ++this.NO_ANSWER_LINE;
        this.getNoAnswerLine().setRow(this.NO_ANSWER_LINE);
    }

    public void onQuizChange(QuizEvent e) {
        if (e.getAction() != 3) {
            return;
        }
        this.updateLines();
    }

    private boolean isSelected(Responses resp, Answer answer) {
        if (resp == null) {
            return false;
        }
        Response r = resp.getResponse(answer.getParent().getIndex());
        if (r == null) {
            return false;
        }
        return r.getSelection() == answer.getIndex();
    }
}

