/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.quiz.module;

import com.elluminate.groupware.quiz.Answer;
import com.elluminate.groupware.quiz.QuizEvent;
import com.elluminate.groupware.quiz.QuizListener;
import com.elluminate.groupware.quiz.module.AnswerLine;
import com.elluminate.groupware.quiz.module.QuestionPanel;
import java.awt.event.ItemEvent;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;

class MultipleChoiceLine
extends AnswerLine {
    public MultipleChoiceLine(QuestionPanel panel, int row, int mode) {
        super(panel, row);
        this.icon = new JLabel(QuestionPanel.blankIcon);
        this.icon.setOpaque(false);
        this.box = new JCheckBox();
        this.box.setOpaque(false);
        this.box.addItemListener(this);
        this.addTextComponent(mode == 1);
        this.createAnswerEditor();
        this.createStatsComponents();
        this.addComponents(0);
        this.setMode(mode);
    }

    @Override
    public void setAnswer(Answer a) {
        super.setAnswer(a);
        this.setMode(this.mode);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.answer != null) {
            this.answer.removeQuizListener((QuizListener)this);
        }
        this.box.removeItemListener(this);
        this.disposeAnswerEditor();
        this.removeComponents();
    }

    @Override
    public void setMode(int newMode) {
        this.mode = newMode;
        if (this.answer == null) {
            this.hideAll();
            return;
        }
        switch (newMode) {
            case 1: {
                this.icon.setVisible(false);
                this.box.setVisible(true);
                this.box.setIcon(QuestionPanel.wrongIcon);
                this.box.setSelectedIcon(QuestionPanel.rightIcon);
                this.box.setEnabled(true);
                this.setTextEditable(true, true);
                this.bar.setVisible(false);
                this.counts.setVisible(false);
                this.editor.setVisible(true);
                break;
            }
            case 2: {
                this.icon.setVisible(true);
                this.box.setVisible(false);
                this.setTextEditable(false, true);
                this.bar.setVisible(true);
                this.counts.setVisible(true);
                this.editor.setVisible(false);
                break;
            }
            case 3: {
                this.icon.setVisible(false);
                this.box.setVisible(true);
                this.box.setIcon(null);
                this.box.setSelectedIcon(null);
                this.box.setEnabled(true);
                this.setTextEditable(false, true);
                this.bar.setVisible(false);
                this.counts.setVisible(false);
                this.editor.setVisible(false);
                break;
            }
            case 4: {
                this.icon.setVisible(false);
                this.box.setVisible(true);
                this.box.setEnabled(false);
                this.box.setDisabledIcon(QuestionPanel.unselIcon);
                this.box.setDisabledSelectedIcon(QuestionPanel.selIcon);
                this.box.setIcon(QuestionPanel.unselIcon);
                this.box.setSelectedIcon(QuestionPanel.selIcon);
                this.setTextEditable(false, true);
                this.bar.setVisible(false);
                this.counts.setVisible(false);
                this.editor.setVisible(false);
                break;
            }
            case 5: {
                this.icon.setVisible(true);
                this.box.setVisible(true);
                this.box.setIcon(QuestionPanel.unselIcon);
                this.box.setSelectedIcon(QuestionPanel.selIcon);
                this.box.setDisabledIcon(QuestionPanel.unselIcon);
                this.box.setDisabledSelectedIcon(QuestionPanel.selIcon);
                this.box.setEnabled(false);
                this.setTextEditable(false, true);
                this.bar.setVisible(true);
                this.counts.setVisible(true);
                this.editor.setVisible(false);
            }
        }
        this.readData();
    }

    @Override
    public void readData() {
        if (this.answer == null) {
            return;
        }
        String txtValue = null;
        boolean boxValue = false;
        ImageIcon iconValue = null;
        int countValue = -1;
        int totalValue = -1;
        switch (this.mode) {
            case 1: {
                txtValue = this.answer.getText();
                boxValue = this.answer.isCorrect();
                break;
            }
            case 2: {
                txtValue = this.answer.getText();
                if (this.answer.isCorrect()) {
                    iconValue = QuestionPanel.rightIcon;
                    this.bar.setForeground(GREEN);
                } else {
                    iconValue = QuestionPanel.blankIcon;
                    this.bar.setForeground(RED);
                }
                countValue = this.answer.getStatsCount();
                totalValue = this.answer.getStatsTotal();
                break;
            }
            case 3: {
                txtValue = this.answer.getText();
                boxValue = this.answer.isSelected();
                break;
            }
            case 4: {
                txtValue = this.answer.getText();
                boxValue = this.answer.isSelected();
                break;
            }
            case 5: {
                txtValue = this.answer.getText();
                boxValue = this.answer.isSelected();
                if (this.answer.isCorrect()) {
                    iconValue = QuestionPanel.rightIcon;
                    this.bar.setForeground(GREEN);
                } else if (this.answer.isSelected()) {
                    iconValue = QuestionPanel.wrongIcon;
                    this.bar.setForeground(RED);
                } else {
                    iconValue = QuestionPanel.blankIcon;
                    this.bar.setForeground(RED);
                }
                countValue = this.answer.getStatsCount();
                totalValue = this.answer.getStatsTotal();
            }
        }
        if (txtValue == null) {
            txtValue = "";
        }
        this.updateText(txtValue, null);
        if (this.box.isVisible() && this.box.isSelected() != boxValue) {
            this.box.setSelected(boxValue);
        }
        if (iconValue != null) {
            this.icon.setIcon(iconValue);
        }
        if (totalValue >= 0) {
            this.updateStats(countValue, totalValue);
        }
    }

    @Override
    public void writeData() {
    }

    @Override
    public void textChanged(DocumentEvent e) {
        String prev;
        if (this.answer == null) {
            return;
        }
        if (this.mode == 1 && this.isDifferent(prev = this.answer.getText())) {
            this.answer.setText(this.getText());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.answer == null) {
            return;
        }
        boolean sel = e.getStateChange() == 1;
        switch (this.mode) {
            case 1: {
                if (this.answer.isCorrect() == sel) break;
                this.answer.setCorrect(sel);
                break;
            }
            case 3: {
                if (this.answer.isSelected() == sel) break;
                this.answer.setSelected(sel);
            }
        }
    }

    @Override
    public void onQuizChange(QuizEvent e) {
        if (this.answer == null) {
            return;
        }
        super.onQuizChange(e);
        if (e.getAction() == 2) {
            this.updateStats(this.answer.getStatsCount(), this.answer.getStatsTotal());
        } else {
            this.readData();
        }
    }
}

