/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Section;
import com.lowagie.text.xml.Tags;
import java.util.Properties;

public class Tags4iText
implements Tags {
    public static final String ITEXT = "itext";
    public static final String TITLE = "title";
    public static final String SUBJECT = "subject";
    public static final String KEYWORDS = "keywords";
    public static final String AUTHOR = "author";
    public static final String CHAPTER = "chapter";
    public static final String SECTION = "section";
    public static final String DEPTH = "depth";
    public static final String INDENT = "indent";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String PHRASE = "phrase";
    public static final String PARAGRAPH = "paragraph";
    public static final String LEADING = "leading";
    public static final String ALIGN = "align";
    public static final String CHUNK = "chunk";
    public static final String FONT = "font";
    public static final String SIZE = "size";
    public static final String STYLE = "style";
    public static final String RED = "red";
    public static final String GREEN = "green";
    public static final String BLUE = "blue";

    public boolean isTag(String string) {
        return this.isChunk(string) || this.isPhrase(string) || this.isParagraph(string) || this.isSection(string) || this.isChapter(string) || this.isDocumentRoot(string);
    }

    public boolean isDocumentRoot(String string) {
        return ITEXT.equals(string);
    }

    public int getMetaType(String string) {
        if (TITLE.equals(string)) {
            return 1;
        }
        if (SUBJECT.equals(string)) {
            return 2;
        }
        if (KEYWORDS.equals(string)) {
            return 3;
        }
        if (AUTHOR.equals(string)) {
            return 4;
        }
        return 0;
    }

    public boolean isChapter(String string) {
        return CHAPTER.equals(string);
    }

    public boolean isSection(String string) {
        return SECTION.equals(string);
    }

    public void setSection(Section section, Properties properties) {
        String string = properties.getProperty(DEPTH);
        if (string != null) {
            section.setNumberDepth(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(INDENT)) != null) {
            section.setIndentation(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(LEFT)) != null) {
            section.setIndentationLeft(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(RIGHT)) != null) {
            section.setIndentationRight(Integer.parseInt(string));
        }
    }

    public boolean isTitle(String string) {
        return TITLE.equals(string);
    }

    public boolean isParagraph(String string) {
        return PARAGRAPH.equals(string);
    }

    public Paragraph getParagraph(Properties properties) {
        Paragraph paragraph = new Paragraph();
        String string = properties.getProperty(LEADING);
        if (string != null) {
            paragraph.setLeading(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(LEFT)) != null) {
            paragraph.setIndentationLeft(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(RIGHT)) != null) {
            paragraph.setIndentationRight(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(ALIGN)) != null) {
            paragraph.setAlignment(string);
        }
        return paragraph;
    }

    public boolean isPhrase(String string) {
        return PHRASE.equals(string);
    }

    public Phrase getPhrase(Properties properties) {
        if (properties.getProperty(LEADING) != null) {
            return new Phrase(Integer.parseInt(properties.getProperty(LEADING)));
        }
        return new Phrase();
    }

    public boolean isChunk(String string) {
        return CHUNK.equals(string);
    }

    public Chunk getChunk(Properties properties) {
        Font font = new Font();
        String string = properties.getProperty(FONT);
        if (string != null) {
            font.setFamily(string);
        }
        if ((string = properties.getProperty(SIZE)) != null) {
            font.setSize(Integer.parseInt(string));
        }
        if ((string = properties.getProperty(STYLE)) != null) {
            font.setStyle(string);
        }
        if (properties.getProperty(RED) != null && properties.getProperty(GREEN) != null && properties.getProperty(BLUE) != null) {
            font.setColor(Integer.parseInt(properties.getProperty(RED)), Integer.parseInt(properties.getProperty(GREEN)), Integer.parseInt(properties.getProperty(BLUE)));
        }
        return new Chunk("", font);
    }
}

