/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BadPdfFormatException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfDocument;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfFontDictionary;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfIndirectObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPages;
import com.lowagie.text.pdf.PdfResources;
import com.lowagie.text.pdf.PdfXObjectDictionary;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PdfWriter
extends DocWriter {
    private static final byte[] HEADER = "%PDF-1.2\n%\u00e0\u00e1\u00e2\u00e3\n".getBytes();
    private static final int OFFSET = HEADER.length;
    private static final int ROOT = 1;
    private static final PdfIndirectReference ROOTREFERENCE = new PdfIndirectReference(6, 1);
    protected PdfPages root = new PdfPages();
    protected PdfFontDictionary fontDictionary = new PdfFontDictionary();
    protected PdfXObjectDictionary imageDictionary = new PdfXObjectDictionary();
    protected static final int FONTNUMBERSTART = 100;
    protected int fontNumber = 100;
    protected PdfContentByte directContent;
    protected HashMap secondFonts = new HashMap();
    protected PdfDocument document;
    private PdfBody body = new PdfBody(OFFSET);
    private PdfDocument pdf;

    protected PdfWriter(PdfDocument pdfDocument, OutputStream outputStream) {
        super(pdfDocument, outputStream);
        this.pdf = pdfDocument;
        this.directContent = new PdfContentByte(this);
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public static PdfWriter getInstance(Document document, OutputStream outputStream, DocListener docListener) throws DocumentException {
        PdfDocument pdfDocument = new PdfDocument();
        pdfDocument.addDocListener(docListener);
        document.addDocListener(pdfDocument);
        PdfWriter pdfWriter = new PdfWriter(pdfDocument, outputStream);
        pdfDocument.addWriter(pdfWriter);
        return pdfWriter;
    }

    public PdfIndirectReference add(PdfPage pdfPage, PdfContents pdfContents) throws PdfException {
        if (!this.open) {
            throw new PdfException("The document isn't open.");
        }
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfContents);
        try {
            this.os.write(pdfIndirectObject.toPdf());
            this.os.flush();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        pdfPage.add(pdfIndirectObject.getIndirectReference());
        pdfPage.setParent(ROOTREFERENCE);
        PdfIndirectObject pdfIndirectObject2 = this.body.add(pdfPage);
        try {
            this.os.write(pdfIndirectObject2.toPdf());
            this.os.flush();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        this.root.add(pdfIndirectObject2.getIndirectReference());
        return pdfIndirectObject2.getIndirectReference();
    }

    public PdfIndirectReference add(PdfFont pdfFont) throws PdfException {
        if (!this.fontDictionary.contains(pdfFont)) {
            PdfIndirectObject pdfIndirectObject = this.body.add(pdfFont);
            try {
                this.os.write(pdfIndirectObject.toPdf());
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
            this.fontDictionary.put(pdfFont.getName(), pdfIndirectObject.getIndirectReference());
            return pdfIndirectObject.getIndirectReference();
        }
        return (PdfIndirectReference)this.fontDictionary.get(pdfFont.getName());
    }

    public PdfIndirectReference add(PdfImage pdfImage) throws PdfException {
        if (!this.imageDictionary.contains(pdfImage)) {
            PdfIndirectObject pdfIndirectObject = this.body.add(pdfImage);
            try {
                this.os.write(pdfIndirectObject.toPdf());
            }
            catch (IOException iOException) {
                System.err.println(iOException.getMessage());
            }
            this.imageDictionary.put(pdfImage.name(), pdfIndirectObject.getIndirectReference());
            return pdfIndirectObject.getIndirectReference();
        }
        return (PdfIndirectReference)this.imageDictionary.get(pdfImage.name());
    }

    public PdfIndirectReference getImageReference(PdfName pdfName) {
        return (PdfIndirectReference)this.imageDictionary.get(pdfName);
    }

    public PdfIndirectReference add(PdfOutline pdfOutline) throws PdfException {
        PdfIndirectObject pdfIndirectObject = this.body.add(pdfOutline);
        try {
            this.os.write(pdfIndirectObject.toPdf());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        return pdfIndirectObject.getIndirectReference();
    }

    public void open() {
        try {
            this.os.write(HEADER);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        this.pdf.close();
        try {
            PdfIndirectObject pdfIndirectObject = this.body.add(this.root);
            this.os.write(pdfIndirectObject.toPdf());
            PdfIndirectObject pdfIndirectObject2 = this.body.add(this.document.getCatalog(pdfIndirectObject.getIndirectReference()));
            this.os.write(pdfIndirectObject2.toPdf());
            PdfIndirectObject pdfIndirectObject3 = this.body.add(this.document.getInfo());
            this.os.write(pdfIndirectObject3.toPdf());
            this.os.write(this.body.getCrossReferenceTable());
            PdfTrailer pdfTrailer = new PdfTrailer(this.body.size(), this.body.offset(), pdfIndirectObject2.getIndirectReference(), pdfIndirectObject3.getIndirectReference());
            this.os.write(pdfTrailer.toPdf());
            super.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    int size() {
        return this.body.size();
    }

    public boolean fitsPage(Table table, int n) {
        return this.pdf.bottom(table) > this.pdf.indentBottom() + n;
    }

    public boolean fitsPage(Table table) {
        return this.fitsPage(table, 0);
    }

    boolean isPaused() {
        return this.pause;
    }

    public PdfContentByte getDirectContent() {
        return this.directContent;
    }

    void resetContent() {
        this.directContent.reset();
    }

    PdfName add(BaseFont baseFont) {
        Object[] objectArray = (Object[])this.secondFonts.get(baseFont);
        if (objectArray == null) {
            PdfIndirectReference pdfIndirectReference = null;
            try {
                int n = 0;
                while (n < 3) {
                    PdfObject pdfObject = baseFont.getFontInfo(pdfIndirectReference, n);
                    if (pdfObject != null) {
                        PdfIndirectObject pdfIndirectObject = this.body.add(pdfObject);
                        pdfIndirectReference = pdfIndirectObject.getIndirectReference();
                        this.os.write(pdfIndirectObject.toPdf());
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
            String string = "F" + this.fontNumber++;
            try {
                objectArray = new Object[]{new PdfName(string), pdfIndirectReference};
            }
            catch (BadPdfFormatException badPdfFormatException) {
                // empty catch block
            }
            this.secondFonts.put(baseFont, objectArray);
        }
        this.document.addFont((PdfName)objectArray[0], (PdfIndirectReference)objectArray[1]);
        return (PdfName)objectArray[0];
    }

    void setDocument(PdfDocument pdfDocument) {
        this.document = pdfDocument;
    }

    public class PdfBody {
        private int rootOffset;
        private ArrayList xrefs = new ArrayList();
        private int position;

        PdfBody(int n) {
            this.xrefs.add(new PdfCrossReference(0, 65535));
            this.xrefs.add(new PdfCrossReference(0));
            this.position = n;
        }

        final PdfIndirectObject add(PdfObject pdfObject) {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(this.size(), pdfObject);
            this.xrefs.add(new PdfCrossReference(this.position));
            this.position += pdfIndirectObject.length();
            return pdfIndirectObject;
        }

        final PdfIndirectObject add(PdfResources pdfResources) {
            return this.add(pdfResources);
        }

        final PdfIndirectObject add(PdfPages pdfPages) {
            PdfIndirectObject pdfIndirectObject = new PdfIndirectObject(1, pdfPages);
            this.rootOffset = this.position;
            this.position += pdfIndirectObject.length();
            return pdfIndirectObject;
        }

        final int offset() {
            return this.position;
        }

        final int size() {
            return this.xrefs.size();
        }

        final byte[] getCrossReferenceTable() {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write("xref\n0 ".getBytes());
                byteArrayOutputStream.write(String.valueOf(this.size()).getBytes());
                byteArrayOutputStream.write("\n".getBytes());
                this.xrefs.set(1, new PdfCrossReference(this.rootOffset));
                Iterator iterator = ((AbstractList)this.xrefs).iterator();
                while (iterator.hasNext()) {
                    PdfCrossReference pdfCrossReference = (PdfCrossReference)iterator.next();
                    byteArrayOutputStream.write(pdfCrossReference.toPdf());
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error in PdfIndirectObject::getBytes()!  Error was: " + iOException);
            }
            return byteArrayOutputStream.toByteArray();
        }

        class PdfCrossReference {
            private int offset;
            private int generation;

            PdfCrossReference(int n, int n2) {
                this.offset = n;
                this.generation = n2;
            }

            PdfCrossReference(int n) {
                this(n, 0);
            }

            final byte[] toPdf() {
                String string = "0000000000" + this.offset;
                StringBuffer stringBuffer = new StringBuffer(string.substring(string.length() - 10));
                string = "00000" + this.generation;
                StringBuffer stringBuffer2 = new StringBuffer(string.substring(string.length() - 5));
                if (this.generation == 65535) {
                    return stringBuffer.append(' ').append((Object)stringBuffer2).append(" f \n").toString().getBytes();
                }
                return stringBuffer.append(' ').append((Object)stringBuffer2).append(" n \n").toString().getBytes();
            }
        }
    }

    class PdfTrailer {
        private byte[] bytes;

        public PdfTrailer(int n, int n2, PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write("trailer\n".getBytes());
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.SIZE, new PdfNumber(n));
                pdfDictionary.put(PdfName.ROOT, pdfIndirectReference);
                if (pdfIndirectReference2 != null) {
                    pdfDictionary.put(PdfName.INFO, pdfIndirectReference2);
                }
                byteArrayOutputStream.write(pdfDictionary.toPdf());
                byteArrayOutputStream.write("\nstartxref\n".getBytes());
                byteArrayOutputStream.write(String.valueOf(n2).getBytes());
                byteArrayOutputStream.write("\n%%EOF".getBytes());
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error in PdfTrailer!  Error was: " + iOException);
            }
            this.bytes = byteArrayOutputStream.toByteArray();
        }

        final byte[] toPdf() {
            return this.bytes;
        }
    }
}

